/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version0;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class EOFileHistoryItem_V0
extends EOEncodableObject {
    public static String XML_NAME = "frame.filehistoryitem";
    private static final String ATTR_TAG_UID = "uid";
    private static final String ATTR_TAG_PROJECT_UID = "projectUID";
    private static final String ATTR_TAG_FILE_TYPE_ID = "fileTypeID";
    private static final String ATTR_TAG_VERSION_NUMBER = "versionNumber";
    private static final String ATTR_TAG_INTERNAL_VERSION_NUMBER = "internalVersionNumber";
    private static final String ATTR_TAG_EXTERNAL_VERSION_ID = "externalVersionID";
    private static final String ATTR_TAG_AUTHOR = "author";
    private static final String ATTR_TAG_CREATION_DATE = "creationDate";
    private static final String ATTR_TAG_MODIFICATION_COMMENT = "modificationComment";
    private static final String ATTR_TAG_ORIGINAL_FILENAME = "originalFilename";
    public static final String FILE_TYPE_PLAN_OLD = "planFile";
    public static final String FILE_TYPE_FILE = "file";
    private String uid;
    private String projectUID;
    private String fileTypeID;
    private int internalVersionNumber;
    private String externalVersionID;
    private String author;
    private Timestamp creationDate;
    private String modificationComment;
    private String originalFileName;
    private String newCommitUID;
    public static final int INTERNAL_VERSION_NUMBER_FLOOR_VALUE = 1;

    public static void sortFileHistoryItemListByVersionNumberOnly(List<EOFileHistoryItem_V0> list) {
        Collections.sort(list, new Comparator<EOFileHistoryItem_V0>(){

            @Override
            public int compare(EOFileHistoryItem_V0 f0, EOFileHistoryItem_V0 f1) {
                if (f0.getVersionNumber() > f1.getVersionNumber()) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public static void sortFileHistoryItemList(List<EOFileHistoryItem_V0> list) {
        Collections.sort(list, new Comparator<EOFileHistoryItem_V0>(){

            @Override
            public int compare(EOFileHistoryItem_V0 hi0, EOFileHistoryItem_V0 hi1) {
                int compareResult = 0;
                compareResult = hi0.getFileTypeID().compareTo(hi1.getFileTypeID());
                if (compareResult == 0) {
                    compareResult = hi0.getFileUID().compareTo(hi1.getFileUID());
                }
                if (compareResult == 0) {
                    compareResult = hi0.getVersionNumber() < hi1.getVersionNumber() ? -1 : 1;
                }
                return compareResult;
            }
        });
    }

    public String getNewCommitUID() {
        return this.newCommitUID;
    }

    public void setNewCommitUID(String newCommitUID) {
        this.newCommitUID = newCommitUID;
    }

    public EOFileHistoryItem_V0(String uid, String projectUID, String fileTypeID, String externalVersionID, int internalVersionNumber, String author, Timestamp creationDate, String modificationComment, String originalFilename) {
        super(XML_NAME);
        assert (uid != null) : "uid can't be null";
        assert (projectUID != null) : "projectUID can't be null";
        assert (fileTypeID != null) : "fileTypeID can't be null";
        assert (externalVersionID != null) : "externalVersionID can't be null";
        assert (author != null) : "author can't be null";
        assert (creationDate != null) : "creationDate can't be null";
        assert (modificationComment != null) : "modificationComment can't be null";
        this.uid = uid;
        this.projectUID = projectUID;
        this.fileTypeID = fileTypeID;
        this.externalVersionID = externalVersionID;
        this.internalVersionNumber = internalVersionNumber;
        this.author = author;
        this.creationDate = creationDate;
        this.modificationComment = modificationComment;
        this.originalFileName = originalFilename;
    }

    public EOFileHistoryItem_V0() {
        super(XML_NAME);
    }

    public EOFileHistoryItem_V0(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_UID, this.uid);
        this.appendAttrToXML(writeContext, ATTR_TAG_PROJECT_UID, this.projectUID);
        this.appendAttrToXML(writeContext, ATTR_TAG_FILE_TYPE_ID, this.fileTypeID);
        this.appendAttrToXML(writeContext, ATTR_TAG_EXTERNAL_VERSION_ID, this.externalVersionID);
        this.appendAttrToXML(writeContext, ATTR_TAG_INTERNAL_VERSION_NUMBER, this.internalVersionNumber);
        this.appendAttrToXML(writeContext, ATTR_TAG_AUTHOR, this.author);
        this.appendAttrToXML(writeContext, ATTR_TAG_CREATION_DATE, this.creationDate);
        this.appendAttrToXML(writeContext, ATTR_TAG_MODIFICATION_COMMENT, this.modificationComment);
        if (this.originalFileName != null) {
            this.appendAttrToXML(writeContext, ATTR_TAG_ORIGINAL_FILENAME, this.originalFileName);
        }
    }

    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals(ATTR_TAG_UID)) {
            this.uid = value;
        } else if (name.equals(ATTR_TAG_PROJECT_UID)) {
            this.projectUID = value;
        } else if (name.equals(ATTR_TAG_FILE_TYPE_ID)) {
            this.fileTypeID = value;
        } else if (name.equals(ATTR_TAG_VERSION_NUMBER)) {
            this.externalVersionID = value;
            this.internalVersionNumber = this.toInt(value);
        } else if (name.equals(ATTR_TAG_EXTERNAL_VERSION_ID)) {
            this.externalVersionID = value;
        } else if (name.equals(ATTR_TAG_INTERNAL_VERSION_NUMBER)) {
            this.internalVersionNumber = this.toInt(value);
        } else if (name.equals(ATTR_TAG_AUTHOR)) {
            this.author = value;
        } else if (name.equals(ATTR_TAG_CREATION_DATE)) {
            this.creationDate = Timestamp.valueOf(value);
        } else if (name.equals(ATTR_TAG_MODIFICATION_COMMENT)) {
            this.modificationComment = value;
        } else if (name.equals(ATTR_TAG_ORIGINAL_FILENAME)) {
            this.originalFileName = value;
        } else {
            success = false;
        }
        return success;
    }

    protected boolean hasChildren() {
        return false;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return true;
    }

    public String getFileUID() {
        return this.uid;
    }

    public void setFileUID(String uid) {
        assert (uid != null) : "uid can't be null";
        this.uid = uid;
    }

    public String getProjectUID() {
        return this.projectUID;
    }

    public void setProjectUID(String projectUID) {
        assert (projectUID != null) : "projectUID can't be null";
        this.projectUID = projectUID;
    }

    public String getFileTypeID() {
        return this.fileTypeID;
    }

    public void setFileTypeID(String fileTypeID) {
        assert (fileTypeID != null) : "fileTypeID can't be null";
        this.fileTypeID = fileTypeID;
    }

    public int getVersionNumber() {
        return this.internalVersionNumber;
    }

    public void setVersionNumber(int versionNumber) {
        this.internalVersionNumber = versionNumber;
    }

    public String getAuthor() {
        if (this.author == null) {
            this.author = "";
        }
        return this.author;
    }

    public void setAuthor(String author) {
        assert (author != null) : "author can't be null";
        this.author = author;
    }

    public Timestamp getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Timestamp creationDate) {
        assert (creationDate != null) : "creationDate can't be null";
        this.creationDate = creationDate;
    }

    public String getModificationComment() {
        if (this.modificationComment == null) {
            this.modificationComment = "";
        }
        return this.modificationComment;
    }

    public void setModificationComment(String modificationComment) {
        assert (modificationComment != null) : "modificationComment can't be null";
        this.modificationComment = modificationComment;
    }

    public String getExternalVersionID() {
        return this.externalVersionID;
    }

    public void setExternalVersionID(String externalVersionID) {
        this.externalVersionID = externalVersionID;
    }

    public String getOriginalFileName() {
        if (this.originalFileName == null) {
            this.originalFileName = "";
        }
        return this.originalFileName;
    }

    public void setOriginalFileName(String originalFileName) {
        this.originalFileName = originalFileName;
    }
}

