/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration.access_both.version0;

import com.arcway.cockpit.frame.client.project.migration.access_both.version0.EOFileID_V0;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOString;

public class EOFileDescription_V0
extends EOEncodableObjectWithRole {
    public static final String XML_NAME = "frame.filedescription";
    private static final String ROLE_ORIGINAL_FILE_NAME = "originalFileName";
    private EOFileID_V0 fileID;
    private EOString originalFilename;

    public EOFileDescription_V0() {
        super(XML_NAME);
    }

    public EOFileDescription_V0(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOFileDescription_V0(EOFileID_V0 fileID, String originalFilename) {
        super(XML_NAME);
        assert (originalFilename == null || originalFilename.length() < 256);
        this.fileID = fileID;
        if (originalFilename != null) {
            this.originalFilename = new EOString(originalFilename, ROLE_ORIGINAL_FILE_NAME);
        }
    }

    public EOFileID_V0 getFileID() {
        return this.fileID;
    }

    public String getOriginalFilename() {
        if (this.originalFilename != null) {
            return this.originalFilename.getString();
        }
        return null;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext outp, int depth) throws EXEncoderException {
        this.fileID.writeXMLBody(outp, depth);
        if (this.originalFilename != null) {
            this.originalFilename.writeXMLBody(outp, depth);
        }
        super.writeChildrenToXML(outp, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        EOString str;
        if (newChild instanceof EOFileID_V0) {
            this.fileID = (EOFileID_V0)newChild;
            return true;
        }
        if (newChild instanceof EOString && (str = (EOString)newChild).getRole().equals(ROLE_ORIGINAL_FILE_NAME)) {
            this.originalFilename = str;
        }
        return super.addChildFromXML(newChild);
    }
}

