/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.migration;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.migration.ICockpitMigrator;
import com.arcway.cockpit.frame.client.project.migration.Messages;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricProjectDumpViewProvider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpView;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.IHistoricServerDumpViewProvider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.ProjectDumpFileAccess_ForClient;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricProjectDumpView_0_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version0.HistoricServerDumpView_0_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricProjectDumpView_3_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version3.HistoricServerDumpView_3_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version4.HistoricProjectDumpView_4_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version4.HistoricServerDumpView_4_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version5.HistoricProjectDumpView_5_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version5.HistoricServerDumpView_5_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version6.HistoricProjectDumpView_6_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_dumps.version6.HistoricServerDumpView_6_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileView;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.IHistoricProjectFileViewProvider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version0.HistoricProjectFileView_0_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version3.HistoricProjectFileView_3_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version4.HistoricProjectFileView_4_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version5.HistoricProjectFileView_5_Provider;
import com.arcway.cockpit.frame.client.project.migration.access_projectfiles.version6.HistoricProjectFileView_6_Provider;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.MessageDataFactoryForUnknownEOs;
import de.plans.lib.xml.encoding.MultiplexEncodableObjectFactory;
import de.plans.psc.client.dump.ServerDumpFileAccess_ForClient;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class MigrationManager {
    private static final ILogger logger = Logger.getLogger(MigrationManager.class);
    public static final String IMPORT_MIGRATOR_EXTENSION_POINT_ID = "ImportMigrator";
    public static final String IMPORT_MIGRATOR_EXTENSION_ELEMENT = "Migrator";
    public static final String IMPORT_MIGRATOR_EXTENSION_ATTRIBUTE = "Migrator";
    private static final List<IHistoricProjectFileViewProvider> historicProjectFileViewProviders;
    private static final List<IHistoricServerDumpViewProvider> historicServerDumpViewProviders;
    private static final List<IHistoricProjectDumpViewProvider> historicProjectDumpViewProviders;
    private static MigrationManager singleton;
    private Map<Integer, List<ICockpitMigrator>> map_sourceVersion_migratorChain;
    private int highestSourceVersion;
    private SetMap<Integer, IEncodableObjectFactory> map_sourceVersion_eoFactories;

    static {
        IHistoricProjectFileViewProvider[] iHistoricProjectFileViewProviderArray = new IHistoricProjectFileViewProvider[7];
        iHistoricProjectFileViewProviderArray[0] = new HistoricProjectFileView_0_Provider();
        iHistoricProjectFileViewProviderArray[3] = new HistoricProjectFileView_3_Provider();
        iHistoricProjectFileViewProviderArray[4] = new HistoricProjectFileView_4_Provider();
        iHistoricProjectFileViewProviderArray[5] = new HistoricProjectFileView_5_Provider();
        iHistoricProjectFileViewProviderArray[6] = new HistoricProjectFileView_6_Provider();
        historicProjectFileViewProviders = Arrays.asList(iHistoricProjectFileViewProviderArray);
        IHistoricServerDumpViewProvider[] iHistoricServerDumpViewProviderArray = new IHistoricServerDumpViewProvider[7];
        iHistoricServerDumpViewProviderArray[0] = new HistoricServerDumpView_0_Provider();
        iHistoricServerDumpViewProviderArray[3] = new HistoricServerDumpView_3_Provider();
        iHistoricServerDumpViewProviderArray[4] = new HistoricServerDumpView_4_Provider();
        iHistoricServerDumpViewProviderArray[5] = new HistoricServerDumpView_5_Provider();
        iHistoricServerDumpViewProviderArray[6] = new HistoricServerDumpView_6_Provider();
        historicServerDumpViewProviders = Arrays.asList(iHistoricServerDumpViewProviderArray);
        IHistoricProjectDumpViewProvider[] iHistoricProjectDumpViewProviderArray = new IHistoricProjectDumpViewProvider[7];
        iHistoricProjectDumpViewProviderArray[0] = new HistoricProjectDumpView_0_Provider();
        iHistoricProjectDumpViewProviderArray[3] = new HistoricProjectDumpView_3_Provider();
        iHistoricProjectDumpViewProviderArray[4] = new HistoricProjectDumpView_4_Provider();
        iHistoricProjectDumpViewProviderArray[5] = new HistoricProjectDumpView_5_Provider();
        iHistoricProjectDumpViewProviderArray[6] = new HistoricProjectDumpView_6_Provider();
        historicProjectDumpViewProviders = Arrays.asList(iHistoricProjectDumpViewProviderArray);
    }

    public static MigrationManager getDefault() {
        if (singleton == null) {
            singleton = new MigrationManager();
        }
        return singleton;
    }

    private MigrationManager() {
    }

    public void migrateServerDump(ServerDumpFileAccess_ForClient serverDump) throws DumpFileAccessException, MigrationFailedException {
        try {
            int version = this.determineServerDumpVersion(serverDump);
            this.applyMigrators(version, new MigrationCallbackForServerDump(serverDump));
            File projectDumpDir = serverDump.getModuleDirectory("COCKPIT_FRAME");
            if (projectDumpDir == null) {
                throw new DumpFileAccessException("Invalid Server Dump: File does not contain the frame module directory (COCKPIT_FRAME)");
            }
            ProjectDumpFileAccess_ForClient projectDumpAccess = new ProjectDumpFileAccess_ForClient(projectDumpDir);
            this.migrateProjectDump_internal(projectDumpAccess, version);
        }
        catch (DumpFileAccessException eDFE) {
            throw eDFE;
        }
        catch (MigrationFailedException eMFE) {
            throw eMFE;
        }
        catch (Throwable t) {
            throw new MigrationFailedException(t);
        }
    }

    public void migrateProjectDump(ProjectDumpFileAccess_ForClient projectDump) throws DumpFileAccessException, MigrationFailedException {
        int version = this.determineProjectDumpVersion(projectDump);
        this.migrateProjectDump_internal(projectDump, version);
    }

    private void migrateProjectDump_internal(ProjectDumpFileAccess_ForClient projectDump, int version) throws DumpFileAccessException, MigrationFailedException {
        this.applyMigrators(version, new MigrationCallbackForProjectDump(projectDump));
    }

    public void migrateACP(ProjectFileAccess acpFile) throws ProjectFileAccess.ProjectFileAccessException, MigrationFailedException {
        int version = this.determineProjectFileVersion(acpFile);
        this.applyMigrators(version, new MigrationCallbackForACPAndACT(acpFile){

            @Override
            public void applyMigrator(ICockpitMigrator migrator) throws MigrationFailedException {
                migrator.migrateACP(this.historicView);
            }
        });
    }

    public void migrateACT(ProjectFileAccess actFile) throws ProjectFileAccess.ProjectFileAccessException, MigrationFailedException {
        int version = this.determineProjectFileVersion(actFile);
        this.applyMigrators(version, new MigrationCallbackForACPAndACT(actFile){

            @Override
            public void applyMigrator(ICockpitMigrator migrator) throws MigrationFailedException {
                migrator.migrateACT(this.historicView);
            }
        });
    }

    private int determineProjectFileVersion(ProjectFileAccess projectFile) throws ProjectFileAccess.ProjectFileAccessException {
        int version = projectFile.getVersion();
        if (version == -1) {
            version = 0;
        }
        return version;
    }

    private int determineServerDumpVersion(ServerDumpFileAccess_ForClient serverDump) throws DumpFileAccessException {
        int version = serverDump.getVersion("COCKPIT_FRAME");
        if (version == -1) {
            version = 0;
        }
        return version;
    }

    private int determineProjectDumpVersion(ProjectDumpFileAccess_ForClient projectDump) throws DumpFileAccessException {
        int version = projectDump.getVersion();
        if (version == -1) {
            version = 0;
        }
        return version;
    }

    private void applyMigrators(int sourceVersion, MigrationCallbackForACPAndACT callback) throws ProjectFileAccess.ProjectFileAccessException, MigrationFailedException {
        if (this.map_sourceVersion_migratorChain == null) {
            this.setupMigrators();
        }
        int version = sourceVersion;
        while (version <= this.highestSourceVersion) {
            callback.startingSourceVersion(version, this.map_sourceVersion_eoFactories.get((Object)version));
            List<ICockpitMigrator> migratorsForVersion = this.map_sourceVersion_migratorChain.get(version);
            if (migratorsForVersion != null) {
                for (ICockpitMigrator migrator : migratorsForVersion) {
                    try {
                        callback.applyMigrator(migrator);
                    }
                    catch (MigrationFailedException mfE) {
                        throw mfE;
                    }
                    catch (Exception e) {
                        throw new MigrationFailedException("Exception during migration", e);
                    }
                }
            }
            callback.finishedSourceVersion();
            ++version;
        }
    }

    private void applyMigrators(int sourceVersion, IMigrationCallbackForDumps callback) throws DumpFileAccessException, MigrationFailedException {
        if (this.map_sourceVersion_migratorChain == null) {
            this.setupMigrators();
        }
        int version = sourceVersion;
        while (version <= this.highestSourceVersion) {
            callback.startingSourceVersion(version);
            List<ICockpitMigrator> migratorsForVersion = this.map_sourceVersion_migratorChain.get(version);
            if (migratorsForVersion != null) {
                for (ICockpitMigrator migrator : migratorsForVersion) {
                    try {
                        callback.applyMigrator(migrator);
                    }
                    catch (MigrationFailedException mfE) {
                        throw mfE;
                    }
                    catch (Exception e) {
                        throw new MigrationFailedException("Exception during migration", e);
                    }
                }
            }
            callback.finishedSourceVersion();
            ++version;
        }
    }

    private void setupMigrators() {
        Collection<ICockpitMigrator> registeredMigrators = this.retrieveMigrators();
        HashMap<String, ICockpitMigrator> registeredMigratorsMap = new HashMap<String, ICockpitMigrator>();
        this.map_sourceVersion_eoFactories = new SetMap();
        for (ICockpitMigrator migrator : registeredMigrators) {
            registeredMigratorsMap.put(migrator.getKey(), migrator);
            IEncodableObjectFactory eoFactory = migrator.getRequiredEOFactoryForProjectFileMainData();
            if (eoFactory == null) continue;
            this.map_sourceVersion_eoFactories.add((Object)migrator.getSourceVersion(), (Object)eoFactory);
        }
        this.map_sourceVersion_migratorChain = new HashMap<Integer, List<ICockpitMigrator>>();
        this.highestSourceVersion = 0;
        for (ICockpitMigrator migrator : registeredMigrators) {
            List<ICockpitMigrator> migratorsForVersion = this.map_sourceVersion_migratorChain.get(migrator.getSourceVersion());
            if (migratorsForVersion == null) {
                migratorsForVersion = new ArrayList<ICockpitMigrator>();
                this.map_sourceVersion_migratorChain.put(migrator.getSourceVersion(), migratorsForVersion);
            }
            if (migratorsForVersion.contains(migrator)) continue;
            int nextInsertPosition = migratorsForVersion.size();
            migratorsForVersion.add(nextInsertPosition, migrator);
            boolean success = this.addRequiredPredecessors(migratorsForVersion, nextInsertPosition, migrator, registeredMigratorsMap);
            if (!success) {
                this.map_sourceVersion_migratorChain = Collections.emptyMap();
                this.highestSourceVersion = -1;
                break;
            }
            this.highestSourceVersion = Math.max(this.highestSourceVersion, migrator.getSourceVersion());
        }
    }

    private Collection<ICockpitMigrator> retrieveMigrators() {
        List<ICockpitMigrator> registeredMigrators = ExtensionMgr.getDefault().getExtension(IMPORT_MIGRATOR_EXTENSION_POINT_ID, "Migrator", "Migrator", ICockpitMigrator.class);
        ArrayList<ICockpitMigrator> sortedMigrators = new ArrayList<ICockpitMigrator>(registeredMigrators);
        Collections.sort(sortedMigrators, new Comparator<ICockpitMigrator>(){

            @Override
            public int compare(ICockpitMigrator o1, ICockpitMigrator o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        return sortedMigrators;
    }

    private boolean addRequiredPredecessors(List<ICockpitMigrator> migratorList, int currentIndex, ICockpitMigrator currentMigrator, Map<String, ICockpitMigrator> registeredMigratorsMap) {
        int nextInsertPosition = currentIndex;
        List<String> requiredPreceedingMigrators = currentMigrator.getRequiredPreceedingMigrators();
        if (requiredPreceedingMigrators != null) {
            for (String preceedingMigratorKey : requiredPreceedingMigrators) {
                ICockpitMigrator preceedingMigrator = registeredMigratorsMap.get(preceedingMigratorKey);
                if (preceedingMigrator == null) {
                    logger.error("Migrator '" + preceedingMigratorKey + "' required to preceed migrator '" + currentMigrator.getKey() + "' does not exist.");
                    return false;
                }
                if (preceedingMigrator.getSourceVersion() != currentMigrator.getSourceVersion()) {
                    logger.error("Migrator '" + preceedingMigratorKey + "' required to preceed migrator '" + currentMigrator.getKey() + "' is defined for a different source version.");
                    return false;
                }
                int preceedingMigratorsPosition = migratorList.indexOf(preceedingMigrator);
                if (preceedingMigratorsPosition >= 0 && preceedingMigratorsPosition <= nextInsertPosition) continue;
                if (preceedingMigratorsPosition > nextInsertPosition) {
                    logger.error("Migrator '" + preceedingMigratorKey + "' is contained in a migrator precedence cycle.");
                    return false;
                }
                migratorList.add(nextInsertPosition, preceedingMigrator);
                this.addRequiredPredecessors(migratorList, nextInsertPosition, preceedingMigrator, registeredMigratorsMap);
                nextInsertPosition = migratorList.indexOf(currentMigrator);
            }
        }
        return true;
    }

    public static MessageDialog startWaitDialogue(Shell shell) {
        if (shell != null) {
            MessageDialog messageDialogue = new MessageDialog(shell, Messages.getString("MigrationManager.MigrationRunning.Title"), null, Messages.getString("MigrationManager.MigrationRunning.Message"), 2, new String[0], -1){

                protected Point getInitialSize() {
                    return new Point(400, 150);
                }
            };
            messageDialogue.setBlockOnOpen(false);
            messageDialogue.open();
            return messageDialogue;
        }
        return null;
    }

    public static void stopWaitDialogue(MessageDialog messageDialogue) {
        if (messageDialogue != null) {
            messageDialogue.close();
        }
    }

    private static interface IMigrationCallbackForDumps {
        public void startingSourceVersion(int var1);

        public void applyMigrator(ICockpitMigrator var1) throws MigrationFailedException;

        public void finishedSourceVersion() throws DumpFileAccessException;
    }

    private static abstract class MigrationCallbackForACPAndACT {
        private final ProjectFileAccess projectFile;
        protected IHistoricProjectFileView historicView;

        public MigrationCallbackForACPAndACT(ProjectFileAccess projectFile) {
            this.projectFile = projectFile;
        }

        public void startingSourceVersion(int sourceVersion, Collection<IEncodableObjectFactory> eoFactories) {
            IHistoricProjectFileViewProvider historicViewProvider = (IHistoricProjectFileViewProvider)historicProjectFileViewProviders.get(sourceVersion);
            if (historicViewProvider != null) {
                this.historicView = historicViewProvider.getHistoricProjectFileView(this.projectFile, (IEncodableObjectFactory)new MultiplexEncodableObjectFactory(new IEncodableObjectFactory[]{new MultiplexEncodableObjectFactory(eoFactories), PSCPlainMessageDataFactory.getDefault(), MessageDataFactoryForUnknownEOs.getDefault()}));
            }
        }

        public abstract void applyMigrator(ICockpitMigrator var1) throws MigrationFailedException;

        public void finishedSourceVersion() throws ProjectFileAccess.ProjectFileAccessException {
            if (this.historicView != null) {
                this.historicView.closeView();
                this.historicView = null;
            }
        }
    }

    private static class MigrationCallbackForProjectDump
    implements IMigrationCallbackForDumps {
        private final ProjectDumpFileAccess_ForClient projectDump;
        protected IHistoricProjectDumpView historicView;

        public MigrationCallbackForProjectDump(ProjectDumpFileAccess_ForClient projectDump) {
            this.projectDump = projectDump;
        }

        @Override
        public void startingSourceVersion(int sourceVersion) {
            IHistoricProjectDumpViewProvider historicViewProvider = (IHistoricProjectDumpViewProvider)historicProjectDumpViewProviders.get(sourceVersion);
            if (historicViewProvider != null) {
                this.historicView = historicViewProvider.getHistoricProjectDumpView(this.projectDump);
            }
        }

        @Override
        public void applyMigrator(ICockpitMigrator migrator) throws MigrationFailedException {
            migrator.migrateProjectDump(this.historicView);
        }

        @Override
        public void finishedSourceVersion() throws DumpFileAccessException {
            if (this.historicView != null) {
                this.historicView.closeView();
                this.historicView = null;
            }
        }
    }

    private static class MigrationCallbackForServerDump
    implements IMigrationCallbackForDumps {
        private final ServerDumpFileAccess_ForClient serverDump;
        protected IHistoricServerDumpView historicView;

        public MigrationCallbackForServerDump(ServerDumpFileAccess_ForClient serverDump) {
            this.serverDump = serverDump;
        }

        @Override
        public void startingSourceVersion(int sourceVersion) {
            IHistoricServerDumpViewProvider historicViewProvider = (IHistoricServerDumpViewProvider)historicServerDumpViewProviders.get(sourceVersion);
            if (historicViewProvider != null) {
                this.historicView = historicViewProvider.getHistoricServerDumpView(this.serverDump);
            }
        }

        @Override
        public void applyMigrator(ICockpitMigrator migrator) throws MigrationFailedException {
            migrator.migrateServerDump(this.historicView);
        }

        @Override
        public void finishedSourceVersion() throws DumpFileAccessException {
            if (this.historicView != null) {
                this.historicView.closeView();
                this.historicView = null;
            }
        }
    }
}

