/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.editors;

import com.arcway.cockpit.frame.client.project.IPlanElement;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentUniqueElementManager;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.transfer.AbstractTransferAgentForMultipleObjectTransfer;
import com.arcway.lib.eclipse.transfer.ExByteArrayDecodingFailed;
import com.arcway.lib.eclipse.transfer.ExByteArrayEncodingFailed;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOTuple;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class UniqueElementOccurrenceListTransfer
extends AbstractTransferAgentForMultipleObjectTransfer {
    private static final String DNDNATIVETYPENAME = "Occurence List Transfer";
    private static UniqueElementOccurrenceListTransfer _instance;

    private UniqueElementOccurrenceListTransfer() {
        super(DNDNATIVETYPENAME);
    }

    public static synchronized UniqueElementOccurrenceListTransfer getInstance() {
        if (_instance == null) {
            _instance = new UniqueElementOccurrenceListTransfer();
        }
        return _instance;
    }

    protected byte[] javaToByteArray(Object object) throws ExByteArrayEncodingFailed {
        try {
            EOList uniqueElementList = (EOList)object;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            uniqueElementList.writeToXMLStream((OutputStream)bout, false);
            return bout.toByteArray();
        }
        catch (EXEncoderException e) {
            throw new ExByteArrayEncodingFailed("Could not serialize", (Throwable)e);
        }
    }

    protected Object byteArrayToJava(byte[] dataAsByteArray, int dataStartPos, int dataLength) throws ExByteArrayDecodingFailed {
        EOList result = null;
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(dataAsByteArray, dataStartPos, dataLength);
        XMLDecoder decoder = new XMLDecoder();
        try {
            result = (EOList)decoder.decodeXML((InputStream)byteInputStream, (IEncodableObjectFactory)new ObjectFactory(), true);
        }
        catch (EXDecoderException e) {
            throw new ExByteArrayDecodingFailed("Could not deserialise EOList<EOUniqueElement> xml.", (Throwable)e);
        }
        if (result == null) {
            result = new EOList();
        }
        return result;
    }

    public static Object createListToTransfer(List<? extends IUniqueElementOccurrence> occurenceList) {
        EOList uniqueElementList = new EOList(occurenceList.size());
        for (IUniqueElementOccurrence iUniqueElementOccurrence : occurenceList) {
            EOTuple tuple = new EOTuple(4);
            tuple.addValue(0, iUniqueElementOccurrence.getProjectUID());
            tuple.addValue(1, iUniqueElementOccurrence.getElementUID());
            tuple.addValue(2, iUniqueElementOccurrence.getPlanUID());
            tuple.addValue(3, iUniqueElementOccurrence.getPlanElementUID());
            uniqueElementList.add((EncodableObjectBase)tuple);
        }
        return uniqueElementList;
    }

    public static Object createListToTransfer(IPlanAgentProjectAgent projectAgent, List<? extends IPlanElement> planElements) {
        ArrayList<IUniqueElementOccurrence> occurenceList = new ArrayList<IUniqueElementOccurrence>(planElements.size());
        IPlanAgentUniqueElementManager uniqueElementManager = projectAgent.getPlanAgentUniqueElementManager();
        for (IPlanElement iPlanElement : planElements) {
            if (!uniqueElementManager.isAssignedToUniqueElement(iPlanElement)) continue;
            IUniqueElementOccurrence uniqueElementOccurence = uniqueElementManager.getUniqueElementOccurence(iPlanElement);
            occurenceList.add(uniqueElementOccurence);
        }
        return UniqueElementOccurrenceListTransfer.createListToTransfer(occurenceList);
    }

    public static List<? extends IUniqueElementOccurrence> getOccurenceList(Object object, IPlanAgentProjectAgent projectAgent) {
        EOList eoOccurenceList = (EOList)object;
        ArrayList<1> occurenceList = new ArrayList<1>(eoOccurenceList.size());
        for (EOTuple occurence : eoOccurenceList) {
            String[] values = occurence.getValues();
            final String projectUID = values[0];
            final String uniqueElementUID = values[1];
            final String planUID = values[2];
            final String planElementUID = values[3];
            if (!projectUID.equals(projectAgent.getProjectUID())) continue;
            IUniqueElementOccurrence uniqueElementOccurence = new IUniqueElementOccurrence(){

                public String getElementUID() {
                    return uniqueElementUID;
                }

                public String getProjectUID() {
                    return projectUID;
                }

                public String getPlanElementUID() {
                    return planElementUID;
                }

                public String getPlanUID() {
                    return planUID;
                }
            };
            occurenceList.add(uniqueElementOccurence);
        }
        return occurenceList;
    }

    private static class ObjectFactory
    implements IEncodableObjectFactory {
        private ObjectFactory() {
        }

        public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
            if ("List".equals(name)) {
                return new EOList(context);
            }
            if ("Tuple".equals(name)) {
                return new EOTuple(context);
            }
            return null;
        }
    }
}

