/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.filters.FilterProviderManager;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportPerformer;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.lib.ui.IModificationProblem;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IWorkbenchPage;

public class ReportPerformer
implements IReportPerformer {
    @Override
    public IModificationProblem canPerformReport(final IReportParameters reportParameters, final String reportFileName) {
        ModificationProblem modificationProblem;
        if (reportParameters != null) {
            try {
                String projectUID = reportParameters.getProjectUID();
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                DocGeneratorProjectAgent docGenProjectAgent = new DocGeneratorProjectAgent(projectAgent);
                FilterProviderManager.doWithFilterItemProviders(docGenProjectAgent, new FilterProviderManager.IProcessor<ReportGenerationException>(){

                    @Override
                    public void run(Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders) throws ReportGenerationException {
                        reportParameters.createReportJob(reportFileName, projectUID2filterItemProviders);
                    }
                });
                modificationProblem = null;
            }
            catch (ReportGenerationException e) {
                String humanReadableDescriptionOfCause = Messages.getString("ReportPerformer.CannotPerformReport");
                String humanReadableDescriptionOfConsequence = e.getTitle();
                int severity = 2;
                modificationProblem = new ModificationProblem(humanReadableDescriptionOfCause, humanReadableDescriptionOfConsequence, severity);
            }
        } else {
            String humanReadableDescriptionOfCause = Messages.getString("ReportPerformer.CannotPerformReport");
            String humanReadableDescriptionOfConsequence = Messages.getString("ReportPerformer.NoReportParameters");
            int severity = 2;
            modificationProblem = new ModificationProblem(humanReadableDescriptionOfCause, humanReadableDescriptionOfConsequence, severity);
        }
        return modificationProblem;
    }

    @Override
    public File performReport(final IWorkbenchPage workbenchPage, final IReportParameters reportParameters, final String reportFileName) throws ReportGenerationException {
        final File[] resultFile = new File[1];
        String projectUID = reportParameters.getProjectUID();
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        final DocGeneratorProjectAgent docGenProjectAgent = new DocGeneratorProjectAgent(projectAgent);
        FilterProviderManager.doWithFilterItemProviders(docGenProjectAgent, new FilterProviderManager.IProcessor<ReportGenerationException>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run(Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders) throws ReportGenerationException {
                ReportJob reportJob = reportParameters.createReportJob(reportFileName, projectUID2filterItemProviders);
                IReportTemplate reportTemplate = reportJob.getReportTemplate();
                if (reportTemplate == null) throw new ReportGenerationException("Report template not found.", "The corresponding report template is not available anymore.", null);
                IFrameDocGenerator generator = docGenProjectAgent.getReportGeneratorForReportType(reportJob.getReportType().getID());
                generator.executeReportJob(reportJob, workbenchPage);
                String filename = reportJob.getReportMainFileName();
                if (filename != null) {
                    File file = new File(filename);
                    if (!file.exists()) throw new ReportGenerationException("File not found", "The report processor returned a non existing file name.", null);
                    resultFile[0] = file;
                    return;
                } else {
                    resultFile[0] = null;
                }
            }
        });
        return resultFile[0];
    }
}

