/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard_FilterConfigurationPage;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard_MainPage;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReportParameters
implements IReportParameters {
    private final String projectUID;
    private final String reportTemplateUID;
    private final Map<String, Object> varArgs;
    private final DocGenConfigurationPerReport docGenConfiguration;

    public ReportParameters(ReportJob reportJob, DocGenConfigurationPerReport docGenConfiguration) {
        IReportTemplate reportTemplate = reportJob.getReportTemplate();
        this.projectUID = reportJob.getProjectAgent().getProjectUID();
        this.reportTemplateUID = reportTemplate == null ? null : reportTemplate.getUID();
        this.varArgs = reportJob.getVarArgs();
        this.docGenConfiguration = docGenConfiguration;
    }

    @Override
    public String getProjectUID() {
        return this.projectUID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReportJob createReportJob(String reportFileName, Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders) throws ReportGenerationException {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        if (projectAgent == null) throw new ReportGenerationException(Messages.getString("ReportPerformer.ProjectNotFound"), "The corresponding project is not configured anymore.", null);
        if (!projectAgent.isOpenAndNotClosing()) throw new ReportGenerationException(Messages.getString("ReportPerformer.ProjectClosed"), "The corresponding project is not open anymore.", null);
        DocGeneratorProjectAgent docGenProjectAgent = new DocGeneratorProjectAgent(projectAgent);
        ReportJob reportJob = new ReportJob(new DocGeneratorProjectAgent(projectAgent));
        IReportTemplateFolder rootReportTemplateFolder = docGenProjectAgent.getRootReportTemplateFolder();
        IReportTemplateRW reportTemplate = ReportParameters.findReportTemplate(docGenProjectAgent, rootReportTemplateFolder, this.reportTemplateUID);
        if (reportTemplate == null) throw new ReportGenerationException(Messages.getString("ReportPerformer.ReportTemplateNotFound"), "The corresponding report template is not available anymore.", null);
        reportJob.setReportTemplate(reportTemplate);
        CreateReportWizard_MainPage.setReportTypeFromConfiguration(docGenProjectAgent, this.docGenConfiguration, reportJob);
        IReportType reportType = reportJob.getReportType();
        CreateReportWizard_MainPage.setOutputTemplateFromConfiguration(docGenProjectAgent, this.docGenConfiguration, reportJob);
        Set<String> allowedFilterIDs = CreateReportWizard.calculateAllowedFilterIDs(reportType, reportTemplate);
        List<IFilterItemProvider> activeFilterItemProviders = CreateReportWizard_FilterConfigurationPage.getActiveFilterProvidersList(docGenProjectAgent, projectUID2filterItemProviders, reportTemplate, allowedFilterIDs);
        CreateReportWizard_FilterConfigurationPage.readFilterSettingsFromConfiguration(this.docGenConfiguration, activeFilterItemProviders);
        reportJob.setFilterSettings(Collections.singletonMap(this.projectUID, activeFilterItemProviders));
        reportJob.setVarArgs(this.varArgs);
        ReportResultFileType outputFileType = ReportParameters.getOutputFileType(reportJob, docGenProjectAgent);
        if (outputFileType == ReportResultFileType.NO_OUTPUT || reportType.hasDeterminedOutputFile()) return reportJob;
        if (reportFileName == null) {
            throw new ReportGenerationException(Messages.getString("ReportPerformer.OutputFileUndefined"), "The file name of the result file is not defined.", null);
        }
        reportJob.setReportFileName(reportFileName);
        return reportJob;
    }

    private static IReportTemplateRW findReportTemplate(IDocGeneratorProjectAgent projectAgent, IReportTemplateFolder reportTemplateFolder, String uidToFind) {
        IReportTemplate found = null;
        List<IReportTemplate> childReportTemplates = projectAgent.getChildReportTemplates(reportTemplateFolder);
        for (IReportTemplate childReportTemplate : childReportTemplates) {
            String uid = childReportTemplate.getUID();
            if (!uid.equals(uidToFind)) continue;
            found = childReportTemplate;
            break;
        }
        if (found == null) {
            List<IReportTemplateFolder> childReportTemplateFolders = projectAgent.getChildReportTemplateFolders(reportTemplateFolder);
            for (IReportTemplateFolder childReportTemplateFolder : childReportTemplateFolders) {
                found = ReportParameters.findReportTemplate(projectAgent, childReportTemplateFolder, uidToFind);
                if (found != null) break;
            }
        }
        return (IReportTemplateRW)found;
    }

    private static ReportResultFileType getOutputFileType(ReportJob reportJob, IDocGeneratorProjectAgent docGenProjectAgent) {
        String outputFormatID;
        IReportOutputFormat outputFormat;
        ReportResultFileType outputFileType = ReportResultFileType.NO_OUTPUT;
        IReportType reportType = reportJob.getReportType();
        if (reportType != null && (outputFormat = docGenProjectAgent.getReportOutputFormat(outputFormatID = reportType.getOutputFormat(reportJob.getReportTemplate()))) != null) {
            outputFileType = outputFormat.getOutputFileType();
        }
        return outputFileType;
    }
}

