/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.SaveDirtyEditorsDialogUtil;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportGenerationException;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ConfigurationMgr;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.filters.FilterProviderManager;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.ReportParameters;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.SkippingWizardDialog;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IResultLauncher;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.file.UrlLauncher;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.SimpleStyledTextMessageDialogue;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DocGenerationAction
extends Action {
    private static final ILogger logger = Logger.getLogger(DocGenerationAction.class);
    private final IWorkbenchPage workbenchPage;
    private final ICockpitProjectData contextItem;

    public DocGenerationAction(ICockpitProjectData contextItem, IWorkbenchPage workbenchPage) {
        this.workbenchPage = workbenchPage;
        this.contextItem = contextItem;
        this.setText(Messages.getString("DocGeneratorAction.Label"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("docgeneration.gif"));
    }

    public void run() {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.contextItem.getProjectUID());
        HashSet_<IRepositoryObjectReference> dirtyObjectReferences = projectAgent.getObjectsShownInDirtyEditors();
        if (!dirtyObjectReferences.isEmpty()) {
            SaveDirtyEditorsDialogUtil.showSaveDirtyEditorsDialog(this.workbenchPage.getWorkbenchWindow().getShell(), Messages.getString("DocGeneratorAction.Info.DirtyEditors.Title"), Messages.getString("DocGeneratorAction.Info.DirtyEditors.Message"), projectAgent, dirtyObjectReferences.asJavaSet());
            return;
        }
        final DocGeneratorProjectAgent docGenProjectAgent = new DocGeneratorProjectAgent(projectAgent);
        final ReportJob reportJob = new ReportJob(new DocGeneratorProjectAgent(projectAgent));
        try {
            FilterProviderManager.doWithFilterItemProviders(docGenProjectAgent, new FilterProviderManager.IProcessor<Exception>(){

                @Override
                public void run(Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders) throws Exception {
                    IReportTemplateRW preselectedReportTemplate = null;
                    if (DocGenerationAction.this.contextItem instanceof IReportTemplateRW) {
                        preselectedReportTemplate = (IReportTemplateRW)DocGenerationAction.this.contextItem;
                    }
                    CreateReportWizard wizard = new CreateReportWizard(docGenProjectAgent, preselectedReportTemplate, projectUID2filterItemProviders.get(docGenProjectAgent.getProjectUID()), reportJob);
                    SkippingWizardDialog dialog = new SkippingWizardDialog(DocGenerationAction.this.workbenchPage.getWorkbenchWindow().getShell(), (IWizard)wizard);
                    dialog.setPageSize(640, 400);
                    if (dialog.open() == 0) {
                        IResultLauncher resultLauncher;
                        File file;
                        String filename;
                        ReportJob.InfoMessage infoMessage;
                        ConfigurationMgr.getInstance().saveConfiguration();
                        IFrameDocGenerator generator = docGenProjectAgent.getReportGeneratorForReportType(reportJob.getReportType().getID());
                        generator.executeReportJob(reportJob, DocGenerationAction.this.workbenchPage);
                        ConfigurationMgr.getInstance().saveConfiguration();
                        List<ReportJob.WarningMessage> warningMessages = reportJob.getWarningMessages();
                        if (!warningMessages.isEmpty()) {
                            ModificationProblemsDialog.showModificationProblemsDialog(warningMessages, (String)Messages.getString("DocGeneratorAction.WarningDialogue.Title"), (String)Messages.getString("DocGeneratorAction.WarningDialogue.Message"), (Shell)DocGenerationAction.this.workbenchPage.getWorkbenchWindow().getShell(), (int)550, (int)380);
                        }
                        if ((infoMessage = reportJob.getUserInfoMessage()) != null) {
                            infoMessage.showMessage(DocGenerationAction.this.workbenchPage.getWorkbenchWindow().getShell());
                        }
                        if ((filename = reportJob.getReportMainFileName()) != null && (file = new File(filename)).exists() && (resultLauncher = reportJob.getReportType().getResultLauncher()) == null) {
                            String askUser = FramePlugin.getDefault().getPreferenceStore().getString("openReportAfterCreation");
                            int result = -1;
                            if (askUser.equals("always")) {
                                result = 2;
                            } else if (askUser.equals("never")) {
                                result = 3;
                            } else {
                                MessageDialogWithToggle askDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)DocGenerationAction.this.workbenchPage.getWorkbenchWindow().getShell(), (String)Messages.getString("ReportContext.report_created"), (String)Messages.getString("ReportContext.open_report_now"), (String)Messages.getString("ReportContext.remember_decision"), (boolean)false, (IPreferenceStore)FramePlugin.getDefault().getPreferenceStore(), (String)"openReportAfterCreation");
                                result = askDialog.getReturnCode();
                            }
                            if (result == 2) {
                                UrlLauncher.launchFile_noEx((File)file, (IWorkbenchPage)DocGenerationAction.this.workbenchPage);
                            }
                        }
                    }
                }
            });
        }
        catch (ReportGenerationException rgE) {
            IResultLauncher resultLauncher = reportJob.getReportType().getResultLauncher();
            if (resultLauncher != null) {
                IReportTemplate teportTemplate = reportJob.getReportTemplate();
                if (teportTemplate != null) {
                    DocGenConfigurationPerReport docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(teportTemplate.getUID(), projectAgent.getProjectUID());
                    ReportParameters reportParameters = new ReportParameters(reportJob, docGenConfiguration);
                    try {
                        resultLauncher.showErrorResult(this.workbenchPage, rgE, reportParameters);
                    }
                    catch (PartInitException e) {
                        DocGenerationAction.showErrorMessage(rgE.getTitle(), rgE.getMessage(), this.workbenchPage);
                        logger.error((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            } else {
                DocGenerationAction.showErrorMessage(rgE.getTitle(), rgE.getMessage(), this.workbenchPage);
            }
            logger.error(String.valueOf(rgE.getTitle()) + " - " + rgE.getMessage(), rgE.getRootCause());
        }
        catch (Exception e) {
            String title = Messages.getString("DocGenerationAction.UnknownProblem.Title");
            String message = NLS.bind((String)Messages.getString("DocGenerationAction.UnknownProblem.Message"), (Object)(String.valueOf(e.getClass().getName()) + " - " + e.getMessage()));
            DocGenerationAction.showErrorMessage(title, message, this.workbenchPage);
            logger.error("Unknown problem while creating report", (Throwable)e);
        }
    }

    private static void showErrorMessage(String title, String message, IWorkbenchPage workbenchPage) {
        SimpleStyledTextMessageDialogue dialogue = new SimpleStyledTextMessageDialogue(workbenchPage.getWorkbenchWindow().getShell(), title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialogue.open();
    }
}

