/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeUseReportTemplatesFromProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.ReportJob;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ConfigurationMgr;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.AvailableReportsContentAndLabelProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.CreateReportWizard;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.ReportResultFileType;
import com.arcway.lib.eclipse.gui.dialogs.FileChooserDialog;
import com.arcway.lib.eclipse.plugin.ARCWAYEclipseLibPlugin;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.stringtools.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateReportWizard_MainPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(CreateReportWizard_MainPage.class);
    private final IDocGeneratorProjectAgent projectAgent;
    private final IReportTemplateRW preselectedReportTemplate;
    private final ReportJob reportJob;
    private boolean isUniquePreselection = false;
    private TreeViewer reportTemplateTreeViewer;
    private Combo reportTypeCombo;
    private Combo outputtemplateCombo;
    private Text txtFileName;
    private Button btnFileChooser;
    private final ProjectTreeContentProvider projectTreeContentProvider = new ProjectTreeContentProvider(null);
    private boolean warningNoReportType = false;
    private boolean warningNoOutputTemplate = false;

    protected CreateReportWizard_MainPage(IDocGeneratorProjectAgent projectAgent, IReportTemplateRW preselectedReportTemplate, ReportJob reportJob) {
        super("main page");
        this.projectAgent = projectAgent;
        this.preselectedReportTemplate = preselectedReportTemplate;
        this.reportJob = reportJob;
        this.setTitle(Messages.getString("WPFormatConfiguration.1"));
        this.setDescription(Messages.getString("WPFormatConfiguration.2"));
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        base.setLayoutData((Object)gridData);
        base.setLayout((Layout)new GridLayout());
        this.createTreePart(base);
        this.createReportTypePart(base);
        this.createOutputtemplatePart(base);
        this.createReportFilePart(base);
        this.setControl((Control)base);
        this.preselectReportTemplate(this.preselectedReportTemplate);
    }

    private void createTreePart(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(2, true));
        Label treeLabel = new Label(base, 0);
        treeLabel.setLayoutData((Object)new GridData(768));
        treeLabel.setText(Messages.getString("WPFormatConfiguration.13"));
        Label descrLabel = new Label(base, 0);
        descrLabel.setLayoutData((Object)new GridData(768));
        descrLabel.setText(Messages.getString("CreateReportMainPage.description"));
        this.reportTemplateTreeViewer = new TreeViewer(base, 2052);
        this.reportTemplateTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        AvailableReportsContentAndLabelProvider cp = new AvailableReportsContentAndLabelProvider(this.projectAgent);
        this.reportTemplateTreeViewer.setContentProvider((IContentProvider)cp);
        this.reportTemplateTreeViewer.setLabelProvider((IBaseLabelProvider)cp);
        this.reportTemplateTreeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
        this.reportTemplateTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate || element instanceof IReportTemplateFolder;
            }
        });
        final Text description = new Text(base, 2114);
        description.setLayoutData((Object)new GridData(1808));
        this.reportTemplateTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate newTemplate = null;
                    if (sel.size() == 1) {
                        Object selectedObject = sel.getFirstElement();
                        if (selectedObject instanceof com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate) {
                            newTemplate = (com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate)selectedObject;
                            description.setText(newTemplate.getDescription());
                        } else if (selectedObject instanceof IReportTemplateFolder) {
                            IReportTemplateFolder folder = (IReportTemplateFolder)selectedObject;
                            description.setText(folder.getDescription());
                        } else {
                            description.setText("");
                        }
                    }
                    CreateReportWizard_MainPage.this.reportTemplateSelected(newTemplate);
                }
            }
        });
        Set<IReportTemplateFolder> rootElements = Collections.singleton(this.projectAgent.getRootReportTemplateFolder());
        this.reportTemplateTreeViewer.setInput(rootElements);
        if (!this.containsReportTemplates(cp.getElements(rootElements))) {
            this.setMessage(Messages.getString("CreateReportMainPage.no_report_templates_information"), 1);
        }
    }

    private boolean containsReportTemplates(Object[] elements) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] children;
            Object o = objectArray[n2];
            if (o instanceof com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate) {
                return true;
            }
            if (o instanceof IReportTemplateFolder && (children = this.projectTreeContentProvider.getChildren(o)) != null && children.length > 0 && this.containsReportTemplates(children)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void preselectReportTemplate(IReportTemplateRW preselectedReportTemplate_) {
        if (preselectedReportTemplate_ != null) {
            Collection<?> folders = this.getAllParents(preselectedReportTemplate_);
            this.reportTemplateTreeViewer.setExpandedElements(folders.toArray());
            this.reportTemplateTreeViewer.setSelection((ISelection)new StructuredSelection((Object)preselectedReportTemplate_), true);
        }
        this.reportTemplateSelected(preselectedReportTemplate_);
        if (preselectedReportTemplate_ != null) {
            this.isUniquePreselection = this.isSelectionUnique();
        }
    }

    public boolean isToBeShown() {
        return !this.isUniquePreselection;
    }

    private boolean isSelectionUnique() {
        boolean isReportTypeUnique = this.reportTypeCombo.getItemCount() == 1;
        IReportType reportType = this.reportJob.getReportType();
        boolean isOutputTemplateUnique = reportType != null ? (reportType.getRequiredOutputTemplateTypeID() != null ? this.outputtemplateCombo.getItemCount() == 1 : true) : false;
        ReportResultFileType outputFileType = this.getOutputFileType();
        boolean isOutputFileUnique = outputFileType != ReportResultFileType.NO_OUTPUT ? (reportType != null ? reportType.hasDeterminedOutputFile() : false) : true;
        boolean isSelectionUnique = isReportTypeUnique && isOutputTemplateUnique && isOutputFileUnique;
        return isSelectionUnique;
    }

    private Collection<?> getAllParents(Object element) {
        ArrayList<Object> parents = new ArrayList<Object>();
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.reportTemplateTreeViewer.getContentProvider();
        Object parent = contentProvider.getParent(element);
        while (parent != null) {
            parents.add(parent);
            parent = contentProvider.getParent(parent);
        }
        return parents;
    }

    private void createReportTypePart(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.getString("CreateReportMainPage.ReportTypeCombo.Label"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(768));
        base.setLayout((Layout)new GridLayout());
        this.reportTypeCombo = new Combo(base, 8);
        this.reportTypeCombo.setLayoutData((Object)new GridData(768));
        this.reportTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateReportWizard_MainPage.this.reportTypeSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createOutputtemplatePart(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.getString("WPFormatConfiguration.3"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(768));
        base.setLayout((Layout)new GridLayout());
        this.outputtemplateCombo = new Combo(base, 8);
        this.outputtemplateCombo.setLayoutData((Object)new GridData(768));
        this.outputtemplateCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreateReportWizard_MainPage.this.outputtemplateSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createReportFilePart(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.getString("WPFormatConfiguration.6"));
        Composite fileBase = new Composite(parent, 0);
        fileBase.setLayoutData((Object)new GridData(768));
        fileBase.setLayout((Layout)new GridLayout(2, false));
        this.txtFileName = new Text(fileBase, 2048);
        this.txtFileName.setLayoutData((Object)new GridData(768));
        this.txtFileName.setEditable(false);
        this.btnFileChooser = new Button(fileBase, 0);
        this.btnFileChooser.setLayoutData((Object)new GridData());
        this.btnFileChooser.setImage(Icons.getImageForFileFolder());
        this.btnFileChooser.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReportResultFileType outputFileType;
                String[] fileExtensions = new String[]{};
                IReportType reportType = CreateReportWizard_MainPage.this.reportJob.getReportType();
                if (reportType != null) {
                    String outputFormatID = reportType.getOutputFormat(CreateReportWizard_MainPage.this.reportJob.getReportTemplate());
                    IReportOutputFormat outputFormat = CreateReportWizard_MainPage.this.projectAgent.getReportOutputFormat(outputFormatID);
                    if (outputFormat != null && outputFormat.getReportFileExtension() != null) {
                        fileExtensions = new String[]{outputFormat.getReportFileExtension()};
                    }
                }
                if ((outputFileType = CreateReportWizard_MainPage.this.getOutputFileType()) != ReportResultFileType.NO_OUTPUT) {
                    File startDirectory = null;
                    String startFileName = null;
                    if (CreateReportWizard_MainPage.this.reportJob.getReportFilename().length() > 0) {
                        File file = new File(CreateReportWizard_MainPage.this.reportJob.getReportFilename());
                        startDirectory = file.getParentFile();
                        startFileName = file.getName();
                    }
                    FileChooserDialog dialog = null;
                    dialog = outputFileType == ReportResultFileType.DIRECTORY ? new FileChooserDialog(startDirectory, CreateReportWizard_MainPage.this.getShell()) : new FileChooserDialog(fileExtensions, startDirectory, CreateReportWizard_MainPage.this.getShell());
                    dialog.setStartFileName(startFileName);
                    boolean repeat = true;
                    while (repeat) {
                        boolean targetDirectoryIsEmpty;
                        repeat = false;
                        File file = dialog.openForSave();
                        if (file == null) continue;
                        if (outputFileType == ReportResultFileType.DIRECTORY && !(targetDirectoryIsEmpty = CreateReportWizard.checkForEmptyTargetDirectory(CreateReportWizard_MainPage.this.getShell(), file))) {
                            repeat = true;
                            continue;
                        }
                        CreateReportWizard_MainPage.this.fileNameSelected(file.getAbsolutePath());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private ReportResultFileType getOutputFileType() {
        String outputFormatID;
        IReportOutputFormat outputFormat;
        ReportResultFileType outputFileType = ReportResultFileType.NO_OUTPUT;
        IReportType reportType = this.reportJob.getReportType();
        if (reportType != null && (outputFormat = this.projectAgent.getReportOutputFormat(outputFormatID = reportType.getOutputFormat(this.reportJob.getReportTemplate()))) != null) {
            outputFileType = outputFormat.getOutputFileType();
        }
        return outputFileType;
    }

    private void setReportTypeFromConfiguration() {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate selectedReportTemplate = this.reportJob.getReportTemplate();
        if (selectedReportTemplate != null) {
            DocGenConfigurationPerReport docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(selectedReportTemplate.getUID(), this.projectAgent.getProjectUID());
            CreateReportWizard_MainPage.setReportTypeFromConfiguration(this.projectAgent, docGenConfiguration, this.reportJob);
        } else {
            this.reportJob.setReportType(null);
        }
    }

    public static void setReportTypeFromConfiguration(IDocGeneratorProjectAgent projectAgent, DocGenConfigurationPerReport docGenConfiguration, ReportJob reportJob) {
        reportJob.setReportType(null);
        String configuredReportTypeID = null;
        if (docGenConfiguration != null) {
            configuredReportTypeID = docGenConfiguration.getReportTypeID();
        }
        if ("".equals(configuredReportTypeID)) {
            configuredReportTypeID = null;
        }
        if (configuredReportTypeID != null) {
            List<IReportType> sortedReportTypes = CreateReportWizard_MainPage.getApplicableReportTypesSorted(reportJob, projectAgent);
            for (IReportType reportType : sortedReportTypes) {
                if (!reportType.getID().equals(configuredReportTypeID)) continue;
                reportJob.setReportType(reportType);
                break;
            }
        }
    }

    private void setOutputTemplateFromConfiguration() {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate selectedReportTemplate = this.reportJob.getReportTemplate();
        if (selectedReportTemplate != null) {
            DocGenConfigurationPerReport docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(selectedReportTemplate.getUID(), this.projectAgent.getProjectUID());
            CreateReportWizard_MainPage.setOutputTemplateFromConfiguration(this.projectAgent, docGenConfiguration, this.reportJob);
        } else {
            this.reportJob.setOutputTemplate(null);
        }
    }

    public static void setOutputTemplateFromConfiguration(IDocGeneratorProjectAgent projectAgent, DocGenConfigurationPerReport docGenConfiguration, ReportJob reportJob) {
        reportJob.setOutputTemplate(null);
        String configuredOutputTemplateUID = null;
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate selectedReportTemplate = reportJob.getReportTemplate();
        if (selectedReportTemplate != null) {
            if (docGenConfiguration != null) {
                configuredOutputTemplateUID = docGenConfiguration.getReportOutputTemplateUID();
            }
            if ("".equals(configuredOutputTemplateUID)) {
                configuredOutputTemplateUID = null;
            }
            if (configuredOutputTemplateUID != null) {
                List<IReportOutputTemplate> sortedOutputTemplates = CreateReportWizard_MainPage.getOutputtemplatesSorted(reportJob, projectAgent);
                for (IReportOutputTemplate outputtemplate : sortedOutputTemplates) {
                    if (!outputtemplate.getUID().equals(configuredOutputTemplateUID)) continue;
                    reportJob.setOutputTemplate(outputtemplate);
                    break;
                }
            }
        }
    }

    private void setReportFileNameFromConfiguration() {
        String selectedDestinationFileName = null;
        ReportResultFileType outputFileType = this.getOutputFileType();
        if (outputFileType != ReportResultFileType.NO_OUTPUT) {
            IReportOutputFormat reportOutputFormat;
            IReportType selectedReportType;
            String configuredFileName;
            DocGenConfigurationPerReport docGenConfiguration;
            com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate selectedReportTemplate = this.reportJob.getReportTemplate();
            if (selectedReportTemplate != null && !ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getBoolean("defaultFileSystemPath.IsEnabled") && (docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(selectedReportTemplate.getUID(), this.projectAgent.getProjectUID())) != null && (configuredFileName = docGenConfiguration.getDocumentationFilename()) != null && configuredFileName.trim().length() > 0) {
                selectedDestinationFileName = configuredFileName;
            }
            if ((selectedDestinationFileName == null || selectedDestinationFileName.trim().length() == 0) && (selectedReportType = this.reportJob.getReportType()) != null && (reportOutputFormat = this.projectAgent.getReportOutputFormat(selectedReportType.getOutputFormat(selectedReportTemplate))) != null) {
                String extension = reportOutputFormat.getReportFileExtension();
                String fileName = FileHelper.convertStringToPortableFileName((String)(String.valueOf(this.projectAgent.getProjectName()) + (extension != null ? "." + extension : "")));
                File path = new File(ARCWAYEclipseLibPlugin.getDefault().getPreferenceStore().getString("defaultFileSystemPath.Path"));
                File file = new File(path, fileName);
                selectedDestinationFileName = file.getAbsolutePath();
            }
        }
        if (selectedDestinationFileName == null) {
            selectedDestinationFileName = "";
        }
        this.reportJob.setReportFileName(selectedDestinationFileName);
    }

    public void writeSettingsToConfiguration() {
        IReportOutputTemplate outputtemplate;
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate selectedReportTemplate = this.reportJob.getReportTemplate();
        DocGenConfigurationPerReport docGenConfiguration = ConfigurationMgr.getInstance().getConfiguration(selectedReportTemplate.getUID(), this.projectAgent.getProjectUID());
        IReportType reportType = this.reportJob.getReportType();
        if (reportType != null) {
            docGenConfiguration.setReportTypeID(reportType.getID());
        }
        if ((outputtemplate = this.reportJob.getOutputTemplate()) != null) {
            docGenConfiguration.setReportOutputTemplateUID(outputtemplate.getUID());
        }
        docGenConfiguration.setDocumentationFilename(this.reportJob.getReportFilename());
    }

    private void reportTemplateSelected(com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate newTemplate) {
        if (logger.isDebugEnabled(24)) {
            logger.debug(24, "reportTemplateSelected(" + newTemplate + ")");
        }
        this.reportJob.setReportTemplate(newTemplate);
        this.setFromConfiguration();
        this.update();
    }

    private void reportTypeSelected() {
        this.readReportTypeFromCombo();
        this.update();
    }

    private void outputtemplateSelected() {
        this.readOutputTemplateFromCombo();
        this.update();
    }

    private void fileNameSelected(String fileName) {
        this.reportJob.setReportFileName(fileName);
        this.update();
    }

    private void update() {
        this.updateReportTemplate();
        this.updateReportTypeToCombo();
        this.updateOutputTemplateToCombo();
        this.updateFileChooser();
        this.updateFileExtensionOfReportFileName();
        this.updatePageCompletionStatus();
    }

    private void updateReportTemplate() {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = this.reportJob.getReportTemplate();
        ((CreateReportWizard)this.getWizard()).setReportTemplate(reportTemplate);
    }

    private void setFromConfiguration() {
        this.setReportTypeFromConfiguration();
        this.setOutputTemplateFromConfiguration();
        this.setReportFileNameFromConfiguration();
    }

    private void updateReportTypeToCombo() {
        IReportType reportType = this.reportJob.getReportType();
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = this.reportJob.getReportTemplate();
        if (reportTemplate != null) {
            List<IReportType> sortedReportTypes = this.getApplicableReportTypesSorted();
            if (sortedReportTypes.size() > 0) {
                this.reportTypeCombo.removeAll();
                int selectionIndex = 0;
                int i = 0;
                while (i < sortedReportTypes.size()) {
                    IReportType reportTypeInCombo = sortedReportTypes.get(i);
                    this.reportTypeCombo.add(reportTypeInCombo.getDisplayName(), i);
                    this.reportTypeCombo.setData(String.valueOf(i), (Object)reportTypeInCombo);
                    if (reportTypeInCombo.equals(reportType)) {
                        selectionIndex = i;
                    }
                    ++i;
                }
                this.reportTypeCombo.select(selectionIndex);
                this.warningNoReportType = false;
            } else {
                this.reportTypeCombo.removeAll();
                this.reportTypeCombo.setText("");
                this.warningNoReportType = true;
            }
            this.reportTypeCombo.setEnabled(this.reportTypeCombo.getItemCount() > 1);
        } else {
            this.reportTypeCombo.removeAll();
            this.reportTypeCombo.setText("");
            this.reportTypeCombo.setEnabled(false);
            this.warningNoReportType = false;
        }
        this.readReportTypeFromCombo();
    }

    private void updateOutputTemplateToCombo() {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = this.reportJob.getReportTemplate();
        IReportType reportType = this.reportJob.getReportType();
        IReportOutputTemplate outputTemplate = this.reportJob.getOutputTemplate();
        if (reportTemplate != null && reportType != null) {
            if (reportType.getRequiredOutputTemplateTypeID() != null) {
                List<IReportOutputTemplate> sortedOutputTemplates = CreateReportWizard_MainPage.getOutputtemplatesSorted(this.reportJob, this.projectAgent);
                if (sortedOutputTemplates.size() > 0) {
                    this.outputtemplateCombo.removeAll();
                    int selectionIndex = 0;
                    int i = 0;
                    while (i < sortedOutputTemplates.size()) {
                        IReportOutputTemplate outputTemplateInCombo = sortedOutputTemplates.get(i);
                        this.outputtemplateCombo.add(outputTemplateInCombo.getName(), i);
                        this.outputtemplateCombo.setData(String.valueOf(i), (Object)outputTemplateInCombo);
                        if (outputTemplateInCombo.equals(outputTemplate)) {
                            selectionIndex = i;
                        }
                        ++i;
                    }
                    this.outputtemplateCombo.select(selectionIndex);
                    this.warningNoOutputTemplate = false;
                } else {
                    this.outputtemplateCombo.removeAll();
                    this.outputtemplateCombo.setText("");
                    this.warningNoOutputTemplate = true;
                }
                this.outputtemplateCombo.setEnabled(this.outputtemplateCombo.getItemCount() > 1);
            } else {
                this.outputtemplateCombo.removeAll();
                this.outputtemplateCombo.setText(Messages.getString("CreateReportMainPage.NoOutputTemplateRequired"));
                this.outputtemplateCombo.setEnabled(false);
                this.warningNoOutputTemplate = false;
            }
        } else {
            this.outputtemplateCombo.removeAll();
            this.outputtemplateCombo.setText("");
            this.outputtemplateCombo.setEnabled(false);
            this.warningNoOutputTemplate = false;
        }
        this.readOutputTemplateFromCombo();
    }

    private void updateFileChooser() {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = this.reportJob.getReportTemplate();
        if (reportTemplate != null) {
            boolean hasNoOrDeterminedOutputFile;
            boolean hasOutputFile;
            ReportResultFileType outputFileType = this.getOutputFileType();
            boolean bl = hasOutputFile = outputFileType != ReportResultFileType.NO_OUTPUT;
            if (hasOutputFile) {
                IReportType reportType = this.reportJob.getReportType();
                boolean hasDeterminedOutputFile = reportType != null ? reportType.hasDeterminedOutputFile() : false;
                hasNoOrDeterminedOutputFile = hasDeterminedOutputFile;
            } else {
                hasNoOrDeterminedOutputFile = true;
            }
            if (hasNoOrDeterminedOutputFile) {
                this.txtFileName.setText("");
            }
            if (logger.isDebugEnabled(24)) {
                logger.debug(24, "updateFileChooser() - hasNoOrDeterminedOutputFile = " + hasNoOrDeterminedOutputFile);
            }
            this.txtFileName.setEnabled(!hasNoOrDeterminedOutputFile);
            this.btnFileChooser.setEnabled(!hasNoOrDeterminedOutputFile);
        } else {
            this.txtFileName.setEnabled(false);
            this.btnFileChooser.setEnabled(false);
        }
    }

    private void updateFileExtensionOfReportFileName() {
        IReportType selectedReportType = this.reportJob.getReportType();
        if (selectedReportType != null) {
            boolean hasDeterminedOutputFile = selectedReportType.hasDeterminedOutputFile();
            if (hasDeterminedOutputFile) {
                this.txtFileName.setText("");
            } else {
                IReportOutputFormat outputFormat = this.projectAgent.getReportOutputFormat(selectedReportType.getOutputFormat(this.reportJob.getReportTemplate()));
                if (outputFormat != null) {
                    String effectiveExtension;
                    String reportExtension = outputFormat.getReportFileExtension();
                    String string = effectiveExtension = reportExtension != null ? "." + reportExtension : "";
                    if (this.reportJob.getReportFilename() != null) {
                        int dotIndex = this.reportJob.getReportFilename().indexOf(".");
                        String newFileName = dotIndex > -1 ? String.valueOf(de.plans.lib.util.FileHelper.getFileNameWithoutExtension((String)this.reportJob.getReportFilename())) + effectiveExtension : String.valueOf(this.reportJob.getReportFilename()) + effectiveExtension;
                        this.reportJob.setReportFileName(newFileName);
                        this.txtFileName.setText(newFileName);
                    }
                } else {
                    this.txtFileName.setText("");
                }
            }
        } else {
            this.txtFileName.setText("");
        }
    }

    private void updatePageCompletionStatus() {
        IReportType selectedReportType = this.reportJob.getReportType();
        IReportOutputFormat outputFormat = selectedReportType == null ? null : this.projectAgent.getReportOutputFormat(selectedReportType.getOutputFormat(this.reportJob.getReportTemplate()));
        ReportResultFileType outputFileType = outputFormat == null ? null : outputFormat.getOutputFileType();
        boolean complete = outputFileType == ReportResultFileType.NO_OUTPUT || selectedReportType != null && selectedReportType.hasDeterminedOutputFile() || this.reportJob.getReportFilename() != null && this.reportJob.getReportFilename().length() > 0;
        complete = complete && this.reportJob.getReportTemplate() != null;
        complete = complete && this.reportJob.getReportType() != null;
        complete = complete && (this.reportJob.getOutputTemplate() != null || this.reportJob.getReportType().getRequiredOutputTemplateTypeID() == null);
        boolean hasLicense = false;
        IReportType reportType = this.reportJob.getReportType();
        if (reportType != null) {
            IClientFunctionLicenseType neededLicenseType = reportType.getNeededLicenseType();
            if (neededLicenseType == null || this.projectAgent.hasLicense(neededLicenseType)) {
                hasLicense = true;
            }
            if (!hasLicense) {
                this.setErrorMessage(String.valueOf(Messages.getString("CreateReportMainPage.no_format_license_found1")) + reportType.getDisplayName() + Messages.getString("CreateReportMainPage.no_format_license_found2"));
                complete = false;
            } else {
                this.setErrorMessage(null);
            }
        }
        if (complete) {
            String infoMessage = ((CreateReportWizard)this.getWizard()).getInfoMessageFromGeneratorSpecificPages();
            if (infoMessage != null) {
                this.setMessage(infoMessage, 1);
            } else {
                this.setMessage(null);
            }
        } else if (this.warningNoReportType) {
            this.setMessage(Messages.getString("CreateReportMainPage.NoReportTypeWarning"), 2);
        } else if (this.warningNoOutputTemplate) {
            this.setMessage(Messages.getString("CreateReportMainPage.NoOutputTemplateWarning"), 2);
        } else {
            this.setMessage(null);
        }
        this.setPageComplete(complete);
    }

    private List<IReportType> getApplicableReportTypesSorted() {
        return CreateReportWizard_MainPage.getApplicableReportTypesSorted(this.reportJob, this.projectAgent);
    }

    private static List<IReportType> getApplicableReportTypesSorted(ReportJob reportJob, IDocGeneratorProjectAgent projectAgent) {
        List<IReportType> sortedReportTypes;
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = reportJob.getReportTemplate();
        if (reportTemplate != null) {
            Collection<IReportType> possibleReportTypes = CreateReportWizard_MainPage.getPossibleReportTypes(reportJob, projectAgent);
            sortedReportTypes = CreateReportWizard_MainPage.sortReportTypes(possibleReportTypes);
            Iterator<IReportType> i = sortedReportTypes.iterator();
            while (i.hasNext()) {
                IReportType reportType = i.next();
                if (reportType.isApplicable(reportTemplate)) continue;
                i.remove();
            }
        } else {
            sortedReportTypes = Collections.emptyList();
        }
        return sortedReportTypes;
    }

    private static Collection<IReportType> getPossibleReportTypes(ReportJob reportJob, IDocGeneratorProjectAgent projectAgent) {
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = reportJob.getReportTemplate();
        Collection<IReportType> possibleReportTypes = reportTemplate != null ? projectAgent.getPossibleReportTypes(reportTemplate, false) : Collections.emptyList();
        return possibleReportTypes;
    }

    private static List<IReportType> sortReportTypes(Collection<IReportType> unsorted) {
        ArrayList<IReportType> sorted = new ArrayList<IReportType>(unsorted);
        Collections.sort(sorted, new Comparator<IReportType>(){

            @Override
            public int compare(IReportType arg0, IReportType arg1) {
                int result = arg0.getDisplayName().compareToIgnoreCase(arg1.getDisplayName());
                if (result == 0) {
                    result = arg0.getID().compareTo(arg1.getID());
                }
                return result;
            }
        });
        return sorted;
    }

    private static List<IReportOutputTemplate> getOutputtemplatesSorted(ReportJob reportJob, IDocGeneratorProjectAgent projectAgent) {
        Collection<? extends IReportOutputTemplate> possibleOutputTemplates = CreateReportWizard_MainPage.getPossibleOutputTemplates(reportJob, projectAgent);
        List<IReportOutputTemplate> possibleOutputTemplatesSorted = CreateReportWizard_MainPage.sortOutputtemplates(possibleOutputTemplates);
        return possibleOutputTemplatesSorted;
    }

    private static Collection<? extends IReportOutputTemplate> getPossibleOutputTemplates(ReportJob reportJob, IDocGeneratorProjectAgent projectAgent) {
        IReportOutputTemplateType outputTemplateType;
        com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate reportTemplate = reportJob.getReportTemplate();
        IReportType reportType = reportJob.getReportType();
        Collection<Object> possibleOutputTemplates = Collections.emptySet();
        if (reportTemplate != null && reportType != null && (outputTemplateType = projectAgent.getReportOutputTemplateType(reportType.getRequiredOutputTemplateTypeID())) != null) {
            IClientFunctionLicenseManager licenseManager = ((IFrameProjectAgent)projectAgent.getProjectAgent()).getServerLicenseManager();
            IReportTemplateFolder folder = licenseManager.isLicenseOperationAllowed(ClientFunctionLicenseTypeUseReportTemplatesFromProject.getInstance()) ? (reportTemplate instanceof IReportTemplate ? projectAgent.getFolder((IReportTemplate)reportTemplate) : projectAgent.getRootReportTemplateFolder()) : null;
            possibleOutputTemplates = new ArrayList<IReportOutputTemplate>(projectAgent.getAvailableOutputTemplates(reportType.getRequiredOutputTemplateTypeID(), folder, new Locale(projectAgent.getLanguageID())));
            String requiredFormatPalette = reportType.getRequiredFormatPalette(reportTemplate);
            String string = requiredFormatPalette = requiredFormatPalette == null ? null : requiredFormatPalette.toUpperCase();
            if (requiredFormatPalette != null && requiredFormatPalette.length() > 0) {
                Iterator<Object> i = possibleOutputTemplates.iterator();
                while (i.hasNext()) {
                    IReportOutputTemplate template = (IReportOutputTemplate)i.next();
                    HashSet<String> supportedFormatPalettes = new HashSet<String>();
                    String formatPalettesAsString = template.getFormatPalettes();
                    if (formatPalettesAsString != null) {
                        for (String split : StringUtil.split((String)formatPalettesAsString, (char)',')) {
                            String trimmed = split.trim();
                            if (trimmed.length() <= 0) continue;
                            supportedFormatPalettes.add(trimmed.toUpperCase());
                        }
                    }
                    if (supportedFormatPalettes.contains(requiredFormatPalette)) continue;
                    i.remove();
                }
            }
        }
        return possibleOutputTemplates;
    }

    private static List<IReportOutputTemplate> sortOutputtemplates(Collection<? extends IReportOutputTemplate> unsorted) {
        ArrayList<IReportOutputTemplate> sorted = new ArrayList<IReportOutputTemplate>(unsorted);
        Collections.sort(sorted, new Comparator<IReportOutputTemplate>(){

            @Override
            public int compare(IReportOutputTemplate arg0, IReportOutputTemplate arg1) {
                int result = arg0.getName().compareToIgnoreCase(arg1.getName());
                if (result == 0) {
                    result = arg0.getReportOutputTemplateTypeID().compareTo(arg1.getReportOutputTemplateTypeID());
                }
                return result;
            }
        });
        return sorted;
    }

    private void readReportTypeFromCombo() {
        IReportType reportType = this.getSelectedReportType();
        if (logger.isDebugEnabled(24)) {
            logger.debug(24, "readReportTypeFromCombo(" + reportType + ")");
        }
        this.reportJob.setReportType(reportType);
        ((CreateReportWizard)this.getWizard()).setReportType(reportType);
    }

    private IReportType getSelectedReportType() {
        return (IReportType)this.reportTypeCombo.getData(String.valueOf(this.reportTypeCombo.getSelectionIndex()));
    }

    private void readOutputTemplateFromCombo() {
        IReportOutputTemplate selectedOutputtemplate = this.getSelectedOutputtemplate();
        if (logger.isDebugEnabled(24)) {
            logger.debug(24, "readOutputTemplateFromCombo(" + selectedOutputtemplate + ")");
        }
        this.reportJob.setOutputTemplate(selectedOutputtemplate);
    }

    private IReportOutputTemplate getSelectedOutputtemplate() {
        return (IReportOutputTemplate)this.outputtemplateCombo.getData(String.valueOf(this.outputtemplateCombo.getSelectionIndex()));
    }

    public void allPagesCreated() {
        this.update();
    }
}

