/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.cockpitlib.client.filter.gui.FilterDialogPart;
import com.arcway.cockpit.cockpitlib.client.filter.gui.FilterItemGroup;
import com.arcway.cockpit.cockpitlib.client.filter.gui.FilterItemGroupComparator;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.Messages;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.ConfigurationMgr;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.IFilterItemProvider;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CreateReportWizard_FilterConfigurationPage
extends WizardPage {
    private FilterDialogPart filterDialog;
    private final List<IFilterItemProvider> filterItemProviders;
    private final String projectUID;
    private IReportTemplate currentReportTemplate;
    private final List<IFilterItemProvider> activeFilterItemProviders;
    private List<String> activeModules;
    private Composite rootComposite;
    private Control subControl;
    private boolean isControlCreated = false;
    private Set<String> allowedFilterIDs = Collections.singleton("--all--");

    public CreateReportWizard_FilterConfigurationPage(IDocGeneratorProjectAgent projectAgent, List<IFilterItemProvider> filterItemProviders) {
        super(Messages.getString("WPFilterConfiguration.0"));
        this.setTitle(Messages.getString("WPFilterConfiguration.1"));
        this.setDescription(Messages.getString("WPFilterConfiguration.2"));
        super.setMessage(null, 0);
        this.setPageComplete(true);
        this.projectUID = projectAgent.getProjectUID();
        this.filterItemProviders = filterItemProviders;
        this.activeModules = new ArrayList<String>();
        this.activeFilterItemProviders = new ArrayList<IFilterItemProvider>();
    }

    public void createControl(Composite parent) {
        if (!this.isControlCreated) {
            this.rootComposite = new Composite(parent, 0);
            this.rootComposite.setLayout((Layout)new GridLayout());
            GridData gd = new GridData(1808);
            gd.widthHint = 600;
            this.rootComposite.setLayoutData((Object)gd);
            this.setUpSubControl();
            this.filterDialog.refresh();
            this.isControlCreated = true;
        } else {
            this.updateGUI();
        }
        this.setControl((Control)this.rootComposite);
    }

    private void setUpSubControl() {
        ArrayList<FilterItemGroup> itemGroups = new ArrayList<FilterItemGroup>();
        for (IFilterItemProvider provider : this.activeFilterItemProviders) {
            FilterItemGroup group = new FilterItemGroup(provider.getName(), provider.isOptionalProvider() ? 1 : 0);
            for (IFilterItem item : provider.getItems()) {
                group.add(item);
            }
            itemGroups.add(group);
        }
        Collections.sort(itemGroups, new FilterItemGroupComparator());
        this.filterDialog = new FilterDialogPart();
        for (FilterItemGroup group : itemGroups) {
            this.filterDialog.addGroup(group);
        }
        this.subControl = this.filterDialog.createContent(this.rootComposite);
    }

    public String getInfoMessage() {
        if (this.getHasActiveFilters()) {
            return Messages.getString("WPFormatConfiguration.17");
        }
        return null;
    }

    public void writeSettingsToConfiguration() {
        DocGenConfigurationPerReport configuration = ConfigurationMgr.getInstance().getConfiguration(this.currentReportTemplate.getUID(), this.projectUID);
        for (IFilterItemProvider provider : this.filterItemProviders) {
            provider.writeToConfiguration(configuration);
        }
    }

    private boolean getHasActiveFilters() {
        for (IFilterItemProvider provider : this.activeFilterItemProviders) {
            if (!provider.hasActiveFilters()) continue;
            return true;
        }
        return false;
    }

    public void setReportTemplateToBeUsed(IReportTemplate reportTemplate) {
        if (this.currentReportTemplate == null || !reportTemplate.getUID().equals(this.currentReportTemplate.getUID())) {
            this.currentReportTemplate = reportTemplate;
            this.activeModules = reportTemplate.getIDsOfFilteringModules();
            this.updateActiveFilterProvidersList();
            this.readFilterSettingsFromConfiguration();
            this.setControl(null);
        }
    }

    public void setAllowedFilterIDs(Set<String> allowedFilterIDs) {
        this.allowedFilterIDs = allowedFilterIDs;
        this.updateActiveFilterProvidersList();
    }

    private void updateGUI() {
        if (this.subControl != null && !this.subControl.isDisposed()) {
            this.subControl.dispose();
            this.subControl = null;
            this.setUpSubControl();
            this.rootComposite.layout();
        }
    }

    private void readFilterSettingsFromConfiguration() {
        if (this.currentReportTemplate != null) {
            DocGenConfigurationPerReport configuration = ConfigurationMgr.getInstance().getConfiguration(this.currentReportTemplate.getUID(), this.projectUID);
            CreateReportWizard_FilterConfigurationPage.readFilterSettingsFromConfiguration(configuration, this.activeFilterItemProviders);
        }
    }

    public static void readFilterSettingsFromConfiguration(DocGenConfigurationPerReport configuration, List<IFilterItemProvider> activeFilterItemProviders) {
        for (IFilterItemProvider provider : activeFilterItemProviders) {
            provider.update(configuration);
        }
    }

    private void updateActiveFilterProvidersList() {
        CreateReportWizard_FilterConfigurationPage.updateActiveFilterProvidersList(this.allowedFilterIDs, this.activeFilterItemProviders, this.filterItemProviders, this.activeModules);
    }

    public static List<IFilterItemProvider> getActiveFilterProvidersList(IDocGeneratorProjectAgent projectAgent, Map<String, List<IFilterItemProvider>> projectUID2filterItemProviders, IReportTemplate reportTemplate, Set<String> allowedFilterIDs) {
        ArrayList<IFilterItemProvider> activeFilterItemProviders = new ArrayList<IFilterItemProvider>();
        List<IFilterItemProvider> filterItemProviders = projectUID2filterItemProviders.get(projectAgent.getProjectUID());
        if (filterItemProviders == null) {
            filterItemProviders = Collections.emptyList();
        }
        List<String> activeModules = reportTemplate.getIDsOfFilteringModules();
        CreateReportWizard_FilterConfigurationPage.updateActiveFilterProvidersList(allowedFilterIDs, activeFilterItemProviders, filterItemProviders, activeModules);
        return activeFilterItemProviders;
    }

    private static void updateActiveFilterProvidersList(Set<String> allowedFilterIDs, List<IFilterItemProvider> activeFilterItemProviders, List<IFilterItemProvider> filterItemProviders, List<String> activeModules) {
        boolean allowAllFilters = allowedFilterIDs.contains("--all--");
        activeFilterItemProviders.clear();
        for (IFilterItemProvider provider : filterItemProviders) {
            String moduleID = provider.getModuleID();
            if (!allowAllFilters && !allowedFilterIDs.contains(moduleID) || provider.isOptionalProvider() && activeModules != null && !activeModules.contains(moduleID)) continue;
            activeFilterItemProviders.add(provider);
        }
    }

    public boolean isToBeShown() {
        return !this.activeFilterItemProviders.isEmpty();
    }

    public List<IFilterItemProvider> getActiveFilterItemProviders() {
        return new ArrayList<IFilterItemProvider>(this.activeFilterItemProviders);
    }
}

