/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.gui;

import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeUseReportTemplatesFromProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class AvailableReportsContentAndLabelProvider
implements ITreeContentProvider,
ILabelProvider {
    private final IDocGeneratorProjectAgent projectAgent;
    private final ProjectTreeContentProvider projectTreeContentProvider;

    public AvailableReportsContentAndLabelProvider(IDocGeneratorProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.projectTreeContentProvider = new ProjectTreeContentProvider(null);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ICockpitProjectData) {
            return this.projectTreeContentProvider.getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof ICockpitProjectData) {
            return this.projectTreeContentProvider.getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICockpitProjectData) {
            return this.projectTreeContentProvider.hasChildren(element);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        IClientFunctionLicenseManager licenseManager = ((IFrameProjectAgent)this.projectAgent.getProjectAgent()).getServerLicenseManager();
        Object[] elementsFromProject = licenseManager.isLicenseOperationAllowed(ClientFunctionLicenseTypeUseReportTemplatesFromProject.getInstance()) ? this.projectTreeContentProvider.getElements(inputElement) : new Object[]{};
        Collection<? extends IReportTemplate> builtInTemplates = this.projectAgent.getBuiltInReportTemplates(new Locale(this.projectAgent.getLanguageID()));
        Object[] allElements = new Object[elementsFromProject.length + builtInTemplates.size()];
        System.arraycopy(elementsFromProject, 0, allElements, 0, elementsFromProject.length);
        int index = elementsFromProject.length;
        for (IReportTemplate iReportTemplate : builtInTemplates) {
            allElements[index] = iReportTemplate;
            ++index;
        }
        return allElements;
    }

    public void dispose() {
        this.projectTreeContentProvider.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.projectTreeContentProvider.inputChanged(viewer, oldInput, newInput);
    }

    public Image getImage(Object element) {
        if (element instanceof IReportTemplate) {
            return FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE).getIcon();
        }
        return this.projectTreeContentProvider.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof IReportTemplate) {
            IReportTemplate template = (IReportTemplate)element;
            return template.getName();
        }
        return this.projectTreeContentProvider.getText(element);
    }

    public void addListener(ILabelProviderListener listener) {
        this.projectTreeContentProvider.addListener(listener);
    }

    public boolean isLabelProperty(Object element, String property) {
        return this.projectTreeContentProvider.isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.projectTreeContentProvider.removeListener(listener);
    }
}

