/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator.configuration;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.ArrayList;
import java.util.List;

public class DocGenConfigurationItem
extends EOEncodableObject {
    private static final ILogger logger = Logger.getLogger(DocGenConfigurationItem.class);
    public static final String XML_NAME = "configItem";
    private static final String ATTR_ITEM_NAME = "name";
    private static final String ATTR_ITEM_DATA = "value";
    private String itemName = null;
    private String itemData = null;
    private ArrayList children = new ArrayList();

    public DocGenConfigurationItem(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public DocGenConfigurationItem(String itemName) {
        super(XML_NAME);
        this.itemName = itemName;
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_ITEM_NAME, this.itemName);
        this.appendAttrToXML(writeContext, ATTR_ITEM_DATA, this.itemData);
    }

    protected boolean setAttributeFromXML(String name, String value) {
        if (name.equals(ATTR_ITEM_NAME)) {
            this.itemName = value;
            return true;
        }
        if (name.equals(ATTR_ITEM_DATA)) {
            this.itemData = value;
            return true;
        }
        return false;
    }

    protected boolean hasChildren() {
        return this.children.size() > 0;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        for (DocGenConfigurationItem child : this.children) {
            child.writeXMLBody(writeContext, depth + 1);
        }
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        boolean success = false;
        if (XML_NAME.equals(newChild.getTag())) {
            this.addChild((DocGenConfigurationItem)newChild);
            success = true;
        }
        return success;
    }

    public String getName() {
        return this.itemName;
    }

    public boolean hasData() {
        return this.itemData != null;
    }

    @Deprecated
    public String getData() {
        return this.itemData;
    }

    @Deprecated
    public void setData(String data) {
        this.itemData = data;
    }

    public boolean getBooleanValue() {
        return Boolean.valueOf(this.itemData);
    }

    public String getStringValue() {
        return this.itemData;
    }

    public int getIntValue() {
        int result = 0;
        try {
            result = Integer.parseInt(this.itemData);
        }
        catch (NumberFormatException e) {
            logger.debug("Invalid format of number: " + this.itemData, (Throwable)e);
        }
        return result;
    }

    public double getDoubleValue() {
        double result = 0.0;
        try {
            result = Double.parseDouble(this.itemData);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public void setValue(String value) {
        this.itemData = value;
    }

    public void setValue(boolean value) {
        this.itemData = Boolean.toString(value);
    }

    public void setValue(int value) {
        this.itemData = Integer.toString(value);
    }

    public void setValue(double value) {
        this.itemData = Double.toString(value);
    }

    public boolean containsItem(String itemName) {
        for (DocGenConfigurationItem item : this.children) {
            if (!itemName.equals(item.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean addChild(DocGenConfigurationItem item) {
        if (!this.children.contains((Object)item)) {
            return this.children.add(item);
        }
        return false;
    }

    public boolean removeChild(DocGenConfigurationItem item) {
        if (this.children.contains((Object)item)) {
            return this.children.remove((Object)item);
        }
        return false;
    }

    public void removeAllChildren() {
        this.children = new ArrayList();
    }

    public DocGenConfigurationItem getChild(String childName) {
        ArrayList<DocGenConfigurationItem> itemList = new ArrayList<DocGenConfigurationItem>();
        for (DocGenConfigurationItem item : this.children) {
            if (!childName.equals(item.getName())) continue;
            itemList.add(item);
        }
        if (itemList.size() > 1) {
            logger.error("getChild() - multiple configuration items found, only the first one is returned");
        }
        if (itemList.size() > 0) {
            return (DocGenConfigurationItem)((Object)itemList.get(0));
        }
        return null;
    }

    public DocGenConfigurationItem getChild(String childName, String childData) {
        ArrayList<DocGenConfigurationItem> itemList = new ArrayList<DocGenConfigurationItem>();
        for (DocGenConfigurationItem item : this.children) {
            if (!childName.equals(item.getName()) || !childData.equals(item.getStringValue())) continue;
            itemList.add(item);
        }
        if (itemList.size() > 1) {
            logger.error("getChild() - multiple configuration items found, only the first one is returned");
        }
        if (itemList.size() > 0) {
            return (DocGenConfigurationItem)((Object)itemList.get(0));
        }
        return null;
    }

    public List getChildren(String childName) {
        ArrayList<DocGenConfigurationItem> itemList = new ArrayList<DocGenConfigurationItem>();
        for (DocGenConfigurationItem item : this.children) {
            if (!childName.equals(item.getName())) continue;
            itemList.add(item);
        }
        return itemList;
    }

    public List getAllChildren() {
        return new ArrayList(this.children);
    }
}

