/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.docgenerator;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.OpenPlanWithPlanDisplayParametersAction;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.selection.SingletonCockpitDataSelectionProvider;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.AbstractDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeFile;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipProviderManager;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorManager;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IFrameDocGenerator;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputFormat;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportOutputTemplateType;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportTemplate;
import com.arcway.cockpit.frame.client.project.docgenerator.interFace.IReportType;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.frame.client.project.planagents.IInternalPlanAgentControllerExtension;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planagents.OpenedPlan;
import com.arcway.cockpit.frame.client.project.planagents.PlanAgentManager;
import com.arcway.cockpit.frame.client.project.planagents.PlanDisplayParameters;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.planagent.controllinginterface.planagent.EXWriteAccessDeniedException;
import com.arcway.planagent.controllinginterface.planagent.FactoryInput;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentExtension;
import com.arcway.planagent.controllinginterface.planagent.PlanAgentInputExtension;
import com.arcway.repository.cockpitadapter.EOCommitCountAndCommitInformation;
import de.plans.lib.util.gui.IProgressDisplay;
import de.plans.psc.client.communication.ServerConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;

public class DocGeneratorProjectAgent
implements IDocGeneratorProjectAgent {
    private final IFrameProjectAgent projectAgent;
    private final AbstractDataTypeWithFile fileDataType;

    public DocGeneratorProjectAgent(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.fileDataType = new DataTypeFile(projectAgent);
    }

    @Override
    public ICockpitProject getProject() {
        return this.projectAgent.getProjectMetaDataManager().getProject();
    }

    @Override
    public AbstractDataTypeWithFile getFileDataType() {
        return this.fileDataType;
    }

    @Override
    public Locale getProjectLocale() {
        String projectLanguage = this.projectAgent.getLanguage();
        return new Locale(projectLanguage);
    }

    @Override
    public String getProjectUID() {
        return this.projectAgent.getUID();
    }

    @Override
    public IFMCAModule getModule(String moduleID) {
        return this.projectAgent.getModuleController().getModule(moduleID);
    }

    @Override
    public List<ISection> getAllFolders(Collection<AbstractFilter> filters) {
        Collection<? extends ISection> filteredFolders = DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getSections(), filters);
        ArrayList<ISection> sortedFilteredfolders = new ArrayList<ISection>();
        for (ISection iSection : filteredFolders) {
            if (iSection.isRootSection()) continue;
            sortedFilteredfolders.add(iSection);
        }
        Collections.sort(sortedFilteredfolders, ProjectViewSorter.getSingleton());
        return sortedFilteredfolders;
    }

    @Override
    public List<IPlan> getAllPlans(Collection<AbstractFilter> filters) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getPlans(), filters));
        Collections.sort(plans, ProjectViewSorter.getSingleton());
        return plans;
    }

    @Override
    public ISection getRootSection() {
        return this.projectAgent.getFrameSectionManager().getRootSection();
    }

    @Override
    public IPlan getPlan(String planUID) {
        return this.projectAgent.getFrameSectionManager().getPlan(planUID);
    }

    @Override
    public List<IPlan> getAllPlans(ISection parentSection, Collection<AbstractFilter> filters) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>();
        ArrayList<? extends IPlan> childPlans = new ArrayList<IPlan>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getChildPlans(parentSection), filters));
        Collections.sort(childPlans, ProjectViewSorter.getSingleton());
        plans.addAll(childPlans);
        ArrayList<? extends ISection> childSections = new ArrayList<ISection>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getChildSections(parentSection), filters));
        Collections.sort(childSections, ProjectViewSorter.getSingleton());
        for (ISection iSection : childSections) {
            plans.addAll(this.getAllPlans(iSection, filters));
        }
        return plans;
    }

    @Override
    public List<IPlan> getChildPlans(ISection parentSection, Collection<AbstractFilter> filters) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getChildPlans(parentSection), filters));
        Collections.sort(plans, ProjectViewSorter.getSingleton());
        return plans;
    }

    @Override
    public ISection getSection(String sectionUID) {
        return this.projectAgent.getFrameSectionManager().getSection(sectionUID);
    }

    @Override
    public List<ISection> getChildSections(ISection parentSection, Collection<AbstractFilter> filters) {
        ArrayList<ISection> plans = new ArrayList<ISection>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameSectionManager().getChildSections(parentSection), filters));
        Collections.sort(plans, ProjectViewSorter.getSingleton());
        return plans;
    }

    @Override
    public boolean hasLicense(IClientFunctionLicenseType licenseType) {
        return this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(licenseType);
    }

    @Override
    public List<ISection> getParentsOfPlan(IPlan plan, Collection<AbstractFilter> filters) {
        ArrayList<ISection> parents = new ArrayList<ISection>();
        ISection parentSection = this.projectAgent.getFrameSectionManager().getParentSection(plan);
        while (!parentSection.isRootSection() && !DocGeneratorProjectAgent.filter(Collections.singleton(parentSection), filters).isEmpty()) {
            parents.add(0, parentSection);
            parentSection = this.projectAgent.getFrameSectionManager().getParentSection(parentSection);
        }
        return parents;
    }

    @Override
    public Collection<? extends IUniqueElement> getAllUniqueElements(Collection<AbstractFilter> filters) {
        return DocGeneratorProjectAgent.filter(this.projectAgent.getFrameUniqueElementMgr().getUniqueElements(), filters);
    }

    @Override
    public Collection<IUniqueElement> getUEForSection(ISection section, Collection<AbstractFilter> filters) {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>();
        Collection<? extends IPlan> plansUnderSection = this.projectAgent.getFrameSectionManager().getAllPlansUnderSection(section);
        for (IPlan iPlan : plansUnderSection) {
            uniqueElements.addAll(this.projectAgent.getFrameUniqueElementMgr().getUniqueElementsOfPlan(iPlan));
        }
        return DocGeneratorProjectAgent.filter(uniqueElements, filters);
    }

    @Override
    public Collection<IUniqueElement> getUEForPlan(IPlan plan, Collection<AbstractFilter> filters) {
        return DocGeneratorProjectAgent.filter(this.projectAgent.getFrameUniqueElementMgr().getUniqueElementsOfPlan(plan), filters);
    }

    @Override
    public Map<String, String> getUnfilteredPlanElementUIDs2UEUIDForPlan(IPlan plan) {
        HashMap<String, String> planElementUIDs2UEUID = new HashMap<String, String>();
        String planUID = plan.getUID();
        OccurrenceList uniqueElementOccurrencesForPlan = this.projectAgent.getFrameUniqueElementMgr().getUniqueElementOccurrencesForPlan(planUID);
        for (EOUniqueElementOccurrence occurrence : uniqueElementOccurrencesForPlan) {
            String elementUID = occurrence.getElementUID();
            String planElementUID = occurrence.getPlanElementUID();
            planElementUIDs2UEUID.put(planElementUID, elementUID);
        }
        return planElementUIDs2UEUID;
    }

    @Override
    public List<IPlan> getPlansForUniqueElement(IUniqueElement uniqueElement, Collection<AbstractFilter> filters) {
        ArrayList<IPlan> plans = new ArrayList<IPlan>(DocGeneratorProjectAgent.filter(this.projectAgent.getFrameUniqueElementMgr().getPlansOfUniqueElement(uniqueElement), filters));
        Collections.sort(plans, ProjectViewSorter.getSingleton());
        return plans;
    }

    @Override
    public ISection getParent(IPlan plan, Collection<AbstractFilter> filters) {
        ISection parentSection = this.projectAgent.getFrameSectionManager().getParentSection(plan);
        if (!parentSection.isRootSection() && !DocGeneratorProjectAgent.filter(Collections.singleton(parentSection), filters).isEmpty()) {
            return parentSection;
        }
        return null;
    }

    @Override
    public ISection getParent(ISection section, Collection<AbstractFilter> filters) {
        ISection parentSection = this.projectAgent.getFrameSectionManager().getParentSection(section);
        if (!parentSection.isRootSection() && !DocGeneratorProjectAgent.filter(Collections.singleton(parentSection), filters).isEmpty()) {
            return parentSection;
        }
        return null;
    }

    private static <T> Collection<T> filter(Collection<? extends T> items, Collection<AbstractFilter> filters) {
        List<Object> result = new ArrayList<T>(items);
        if (filters != null) {
            for (ViewerFilter viewerFilter : filters) {
                result = Arrays.asList(viewerFilter.filter(null, null, result.toArray()));
            }
        }
        return result;
    }

    @Override
    public String getProjectName() {
        return this.projectAgent.getProjectMetaDataManager().getProject().getName();
    }

    @Override
    public IPlanAgentExtension launchPlanAgent(IPlan plan, PlanDisplayParameters planDisplayParameters, IInternalPlanAgentControllerExtension internalPlanAgentControllerExtension, FactoryInput factoryInput, PlanAgentInputExtension inputExtension, IProgressDisplay pDisplay) throws PlanAgentManager.EXPlanAgentLaunchException, EXWriteAccessDeniedException {
        PlanAgentManager planAgentManager = this.projectAgent.getPlanAgentManager();
        return planAgentManager.launchPlanAgent(plan, planDisplayParameters, "com.arcway.planagent.planexporter", internalPlanAgentControllerExtension, factoryInput, inputExtension, planAgentManager, pDisplay);
    }

    @Override
    public Collection<IExternalPlanEditorControllerExtension> openProjector(final IPlan plan, final IWorkbenchPage page, final PlanDisplayParameters planDisplayParameters) {
        final Collection[] planEditorControllerExtensions = new Collection[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Collection<IExternalPlanEditorControllerExtension> openEditors;
                SingletonCockpitDataSelectionProvider selProvider = new SingletonCockpitDataSelectionProvider((ICockpitProjectData)plan);
                String projectUID = plan.getProjectUID();
                OpenPlanWithPlanDisplayParametersAction openPlanAction = new OpenPlanWithPlanDisplayParametersAction((ISelectionProvider)selProvider, page, projectUID, planDisplayParameters);
                openPlanAction.run();
                PlanEditorManager planEditorManager = DocGeneratorProjectAgent.this.projectAgent.getPlanEditorManager();
                planEditorControllerExtensions[0] = openEditors = planEditorManager.getPlanEditorControllerExtensions(plan, page, planDisplayParameters);
            }
        });
        Collection openEditors = planEditorControllerExtensions[0];
        return openEditors;
    }

    @Override
    public String getProjectDescription() {
        return this.projectAgent.getProjectMetaDataManager().getProject().getDescription();
    }

    @Override
    public IProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public Collection<? extends IStakeholderRole> getRoles() {
        return this.projectAgent.getFrameStakeholderManager().getRoles();
    }

    @Override
    public Collection<? extends IStakeholder> getStakeholders() {
        return this.projectAgent.getFrameStakeholderManager().getStakeholders();
    }

    @Override
    public Collection<IStakeholderRole> getRolesOfStakeholder(IStakeholder stakeholder) {
        return this.projectAgent.getFrameStakeholderManager().getRolesOfStakeholder(stakeholder);
    }

    @Override
    public Collection<IStakeholder> getStakeholdersOfRole(IStakeholderRole role) {
        return this.projectAgent.getFrameStakeholderManager().getStakeholdersOfRole(role);
    }

    @Override
    public Collection<IUniqueElement> getRootElementsOfPlan(String planUID) {
        return this.getUERelationshipProviderManager().getContainmentRelationshipProvider().getFirstUniqueElementsOnPlan(planUID);
    }

    @Override
    public UniqueElementRelationshipProviderManager getUERelationshipProviderManager() {
        return this.projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager();
    }

    @Override
    public String getLanguageID() {
        return this.projectAgent.getLanguage();
    }

    @Override
    public IReportType getReportType(String reportTypeID) {
        return DocGeneratorManager.getReportType(reportTypeID);
    }

    @Override
    public IReportOutputTemplateType getReportOutputTemplateType(String reportOutputTemplateTypeID) {
        return this.projectAgent.getDocGeneratorManager().getReportOutputTemplateType(reportOutputTemplateTypeID);
    }

    @Override
    public IReportOutputFormat getReportOutputFormat(String reportOutputFormatID) {
        return DocGeneratorManager.getReportOutputFormat(reportOutputFormatID);
    }

    @Override
    public Collection<IReportType> getPossibleReportTypes(IReportTemplate reportTemplate, boolean exact) {
        return DocGeneratorManager.getPossibleReportTypes(reportTemplate, exact);
    }

    @Override
    public Collection<? extends IReportOutputTemplate> getAvailableOutputTemplates(String reportOutputTemplateTypeID, IReportTemplateFolder reportTemplateFolder, Locale locale) {
        return this.projectAgent.getDocGeneratorManager().getAvailableOutputTemplates(reportOutputTemplateTypeID, reportTemplateFolder, locale);
    }

    @Override
    public IFrameDocGenerator getReportGeneratorForReportType(String reportTypeID) {
        return this.projectAgent.getDocGeneratorManager().getReportGeneratorForReportType(reportTypeID);
    }

    @Override
    public IReportTemplateFolderRW getFolder(com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate template) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(template.getTypeID());
        return (IReportTemplateFolderRW)dataManager.getParent((IAttributeOwner)template);
    }

    @Override
    public IReportTemplateFolderRW getParentFolder(IReportTemplateFolderRW folder) {
        IFrameDataManager dataManager = this.projectAgent.getDataManager(folder.getTypeID());
        IAttributeOwner parent = dataManager.getParent(folder);
        if (parent instanceof IReportTemplateFolderRW) {
            return (IReportTemplateFolderRW)parent;
        }
        return null;
    }

    @Override
    public Collection<? extends IReportTemplate> getBuiltInReportTemplates(Locale locale) {
        return this.projectAgent.getDocGeneratorManager().getBuiltInReportTemplates(locale);
    }

    @Override
    public Collection<? extends IReportOutputTemplate> getBuiltInOutputTemplates(String reportOutputTemplateTypeID, Locale locale) {
        return this.projectAgent.getDocGeneratorManager().getBuiltInOutputTemplates(reportOutputTemplateTypeID, locale);
    }

    @Override
    public IStakeholder getStakeholderForCurrentUser() {
        return this.projectAgent.getFrameStakeholderManager().getStakeholderForCurrentUser();
    }

    @Override
    public IUniqueElement getUniqueElement(String uniqueElementUID) {
        return this.projectAgent.getFrameUniqueElementMgr().getUniqueElement(uniqueElementUID);
    }

    @Override
    public IReportTemplateFolder getRootReportTemplateFolder() {
        Collection<? extends IAttributeOwner> allRootElements = this.projectAgent.getProjectMetaDataManager().getChildren((IAttributeOwner)this.projectAgent.getProject());
        for (ICockpitProjectData iCockpitProjectData : allRootElements) {
            if (!(iCockpitProjectData instanceof IReportTemplateFolder)) continue;
            return (IReportTemplateFolder)iCockpitProjectData;
        }
        assert (false) : "No root report template folder";
        return null;
    }

    @Override
    public List<IReportTemplate> getChildReportTemplates(IReportTemplateFolder parentFolder) {
        ArrayList<IReportTemplate> list = new ArrayList<IReportTemplate>();
        IFrameDataManager dataManager = this.projectAgent.getDataManager(parentFolder.getTypeID());
        Collection<? extends IAttributeOwner> allChildElements = dataManager.getChildren((IAttributeOwner)parentFolder);
        for (ICockpitProjectData iCockpitProjectData : allChildElements) {
            if (!(iCockpitProjectData instanceof IReportTemplate)) continue;
            list.add((IReportTemplate)iCockpitProjectData);
        }
        return list;
    }

    @Override
    public List<IReportOutputTemplate> getChildReportOutputTemplates(IReportTemplateFolder parentFolder) {
        ArrayList<IReportOutputTemplate> list = new ArrayList<IReportOutputTemplate>();
        IFrameDataManager dataManager = this.projectAgent.getDataManager(parentFolder.getTypeID());
        Collection<? extends IAttributeOwner> allChildElements = dataManager.getChildren((IAttributeOwner)parentFolder);
        for (ICockpitProjectData iCockpitProjectData : allChildElements) {
            if (!(iCockpitProjectData instanceof IReportOutputTemplate)) continue;
            list.add((IReportOutputTemplate)iCockpitProjectData);
        }
        return list;
    }

    @Override
    public List<IReportTemplateFolder> getChildReportTemplateFolders(IReportTemplateFolder parentFolder) {
        ArrayList<IReportTemplateFolder> list = new ArrayList<IReportTemplateFolder>();
        IFrameDataManager dataManager = this.projectAgent.getDataManager(parentFolder.getTypeID());
        Collection<? extends IAttributeOwner> allChildElements = dataManager.getChildren((IAttributeOwner)parentFolder);
        for (ICockpitProjectData iCockpitProjectData : allChildElements) {
            if (!(iCockpitProjectData instanceof IReportTemplateFolder)) continue;
            list.add((IReportTemplateFolder)iCockpitProjectData);
        }
        return list;
    }

    @Override
    public IAttributeTypesProvider getFrameDataAttributeTypesProvider(String frameDataTypeID) {
        return this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(frameDataTypeID);
    }

    @Override
    public List<EOCommitCountAndCommitInformation> getProjectHistory() {
        List<Object> history = this.projectAgent.getFrameServerProxy().supportsVersioning() || this.projectAgent.getOfflineModeManager().isInOfflineMode() ? this.projectAgent.getCockpitController().getCommitInformations() : Collections.emptyList();
        return history;
    }

    public static IDocGeneratorProjectAgent getInstance(String serverName, String projectName) {
        IFrameProjectAgent fpa = ProjectMgr.getProjectMgr().getProjectAgent(serverName, projectName);
        if (fpa != null) {
            return new DocGeneratorProjectAgent(fpa);
        }
        return null;
    }

    public static String getUniqueServerName() {
        Collection<ServerConnection> configuredServerConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
        if (configuredServerConnections.size() == 1) {
            return configuredServerConnections.iterator().next().getServerName();
        }
        return null;
    }

    @Override
    public OpenedPlan createOpenedPlan(IPlan plan, PlanDisplayParameters planDisplayParameters) {
        OpenedPlan openedPlan = new OpenedPlan(plan, planDisplayParameters, (IPlanAgentProjectAgent)this.projectAgent);
        return openedPlan;
    }
}

