/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.wizard;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainImportWizard;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;

public class ImportAction
extends Action {
    private final ISelection selection;
    private final Shell shell;

    public ImportAction(Shell shell, ISelection selection) {
        assert (selection != null);
        assert (shell != null);
        this.selection = selection;
        this.shell = shell;
        this.setText(Messages.getString("ImportAction.Import..._1"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("import_wiz.gif"));
        this.setToolTipText(Messages.getString("ImportAction.Import_external_data_into_this_project_3"));
        this.setDescription(Messages.getString("ImportAction.Import_external_data_into_this_project_4"));
    }

    public void run() {
        ISection section = this.getImportSection();
        if (section != null) {
            MainImportWizard mainImportWizard = new MainImportWizard((ICockpitProjectData)section);
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            mainImportWizard.init(projectAgent, section.getUID());
            ArcwayWizardDialog dialog = new ArcwayWizardDialog(this.shell, (IWizard)mainImportWizard);
            dialog.setPageSize(400, 350);
            dialog.open();
        }
    }

    private ISection getImportSection() {
        IStructuredSelection sel;
        if (this.selection instanceof IStructuredSelection && (sel = (IStructuredSelection)this.selection).size() == 1) {
            if (sel.getFirstElement() instanceof ISection) {
                return (ISection)sel.getFirstElement();
            }
            if (sel.getFirstElement() instanceof IFrameProjectAgent) {
                IFrameProjectAgent pa = (IFrameProjectAgent)sel.getFirstElement();
                return pa.getFrameSectionManager().getRootSection();
            }
        }
        return null;
    }
}

