/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.plan;

import com.arcway.cockpit.frame.client.global.gui.views.project.contextmenus.GlobalSelectionTranslationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.datainterchange.plan.PlanCopyManager;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.eclipse.JFaceProgressMonitorToProgressDisplayAdapter;
import de.plans.lib.util.gui.IProgressDisplay;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class PlanCopyAction
extends Action
implements ISelectionListener {
    private static final ILogger logger = Logger.getLogger(PlanCopyAction.class);
    private boolean hasLicense = false;
    private static final Map copyActions = new HashMap();
    private static final Map cutActions = new HashMap();
    private final IWorkbenchWindow window;
    private Collection selectedPlans = new ArrayList();
    private final boolean cut;

    public static PlanCopyAction getPlanCopyAction(IWorkbenchWindow window, boolean cut) {
        Map actions = cut ? cutActions : copyActions;
        PlanCopyAction action = (PlanCopyAction)((Object)actions.get(window));
        if (action == null) {
            action = new PlanCopyAction(window, cut);
            window.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowActivated(IWorkbenchWindow w) {
                }

                public void windowDeactivated(IWorkbenchWindow w) {
                }

                public void windowClosed(IWorkbenchWindow w) {
                    copyActions.remove(w);
                    cutActions.remove(w);
                }

                public void windowOpened(IWorkbenchWindow w) {
                }
            });
            actions.put(window, action);
        }
        return action;
    }

    private PlanCopyAction(IWorkbenchWindow window, boolean cut) {
        window.getSelectionService().addSelectionListener((ISelectionListener)this);
        this.window = window;
        this.cut = cut;
    }

    public void run() {
        if (this.selectedPlans != null) {
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(this.window.getShell());
            progressDialog.setOpenOnRun(true);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    JFaceProgressMonitorToProgressDisplayAdapter monitorAdapter = new JFaceProgressMonitorToProgressDisplayAdapter(monitor);
                    PlanCopyManager copyAndPasteManager = new PlanCopyManager(PlanCopyAction.this.window.getWorkbench().getDisplay());
                    copyAndPasteManager.copy(PlanCopyAction.this.selectedPlans, (IProgressDisplay)monitorAdapter, PlanCopyAction.this.cut);
                }
            };
            try {
                progressDialog.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (InterruptedException e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selectedPlans = null;
        if (selection instanceof IStructuredSelection) {
            String projectUID = null;
            IStructuredSelection sel = (IStructuredSelection)selection;
            ArrayList<Object> selected = new ArrayList<Object>();
            for (Object o : sel) {
                GlobalSelectionTranslationManager translationManager;
                Object translatedO;
                if (o instanceof IPlan) {
                    IPlan plan = (IPlan)o;
                    if (projectUID == null || plan.getProjectUID().equals(projectUID)) {
                        selected.add(o);
                        projectUID = plan.getProjectUID();
                        continue;
                    }
                }
                if ((translatedO = (translationManager = GlobalSelectionTranslationManager.getTranslationManager()).translate(new Class[]{IPlan.class}, o)) != null) {
                    IPlan plan = (IPlan)translatedO;
                    if (projectUID == null || plan.getProjectUID().equals(projectUID)) {
                        selected.add(translatedO);
                        projectUID = plan.getProjectUID();
                        continue;
                    }
                }
                selected = null;
                break;
            }
            this.selectedPlans = selected;
        }
        this.setEnabled(this.selectedPlans != null & this.hasLicense);
    }

    public void setHasLicense(boolean hasLicense) {
        this.hasLicense = hasLicense;
        this.setEnabled(this.isEnabled() && this.hasLicense);
    }
}

