/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange.plan;

import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.lib.java.tuples.Tuple;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOBoolean;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class EOPlanDataContainerTransferContent
extends EOEncodableObject {
    public static final String XML_NAME = "planDataContainerTransferContent";
    private static final String XML_ROLE_FILENAME = "filename";
    private static final String XML_ROLE_FILE_TYPES = "filetypes";
    private static final String XML_ROLE_FILE_PATHS = "filepaths";
    private static final String XML_ROLE_FILE_NAMES = "filenames";
    private EOPlan plan;
    private EOString fileName;
    private EOList<EOString> typeIDsForAdditionalFiles;
    private EOList<EOString> tempFilePathsForAdditionalFiles;
    private EOList<EOString> originalNamesForAdditionalFiles;
    private EOBoolean forCut;

    public EOPlanDataContainerTransferContent(EOPlan plan, File planFile, Map<EOString, Tuple<EOString, EOString>> addionalFiles, boolean forCut) {
        super(XML_NAME);
        this.plan = plan;
        this.fileName = new EOString(planFile.getAbsolutePath(), XML_ROLE_FILENAME);
        this.typeIDsForAdditionalFiles = new EOList(XML_ROLE_FILE_TYPES);
        this.tempFilePathsForAdditionalFiles = new EOList(XML_ROLE_FILE_PATHS);
        this.originalNamesForAdditionalFiles = new EOList(XML_ROLE_FILE_NAMES);
        for (Map.Entry<EOString, Tuple<EOString, EOString>> entry : addionalFiles.entrySet()) {
            this.typeIDsForAdditionalFiles.add((EncodableObjectBase)entry.getKey());
            this.tempFilePathsForAdditionalFiles.add((EncodableObjectBase)((EOString)entry.getValue().getT1()));
            this.originalNamesForAdditionalFiles.add((EncodableObjectBase)((EOString)entry.getValue().getT2()));
        }
        this.forCut = new EOBoolean(Boolean.valueOf(forCut));
    }

    public EOPlanDataContainerTransferContent(XMLContext context) {
        super(XML_NAME, context);
    }

    public String getFileName() {
        return this.fileName.getString();
    }

    public Map<String, Tuple<String, String>> getAddionalFiles() {
        HashMap<String, Tuple<String, String>> map = new HashMap<String, Tuple<String, String>>();
        int i = 0;
        while (i < this.typeIDsForAdditionalFiles.size()) {
            EOString typeID = (EOString)this.typeIDsForAdditionalFiles.get(i);
            EOString path = (EOString)this.tempFilePathsForAdditionalFiles.get(i);
            EOString name = (EOString)this.originalNamesForAdditionalFiles.get(i);
            map.put(typeID.getString(), (Tuple<String, String>)new Tuple((Object)path.getString(), (Object)name.getString()));
            ++i;
        }
        return map;
    }

    public EOPlan getPlan() {
        return this.plan;
    }

    public boolean getForCut() {
        return this.forCut.getBoolean();
    }

    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
    }

    protected boolean setAttributeFromXML(String name, String value) {
        return false;
    }

    protected boolean hasChildren() {
        return true;
    }

    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        this.plan.writeXMLBody(writeContext, depth);
        this.fileName.writeXMLBody(writeContext, depth);
        this.typeIDsForAdditionalFiles.writeXMLBody(writeContext, depth);
        this.tempFilePathsForAdditionalFiles.writeXMLBody(writeContext, depth);
        this.originalNamesForAdditionalFiles.writeXMLBody(writeContext, depth);
        this.forCut.writeXMLBody(writeContext, depth);
    }

    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        EOString str;
        if (newChild instanceof EOPlan) {
            this.plan = (EOPlan)newChild;
            return true;
        }
        if (newChild instanceof EOString && (str = (EOString)newChild).getRole().equals(XML_ROLE_FILENAME)) {
            this.fileName = str;
            return true;
        }
        if (newChild instanceof EOList) {
            EOList list = (EOList)newChild;
            if (list.getRole().equals(XML_ROLE_FILE_TYPES)) {
                this.typeIDsForAdditionalFiles = list;
                return true;
            }
            if (list.getRole().equals(XML_ROLE_FILE_PATHS)) {
                this.tempFilePathsForAdditionalFiles = list;
                return true;
            }
            if (list.getRole().equals(XML_ROLE_FILE_NAMES)) {
                this.originalNamesForAdditionalFiles = list;
                return true;
            }
        }
        if (newChild instanceof EOBoolean) {
            this.forCut = (EOBoolean)newChild;
            return true;
        }
        return false;
    }
}

