/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.datainterchange;

import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.files.FilesManager;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectDataInterchangeEOFactory;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.client.project.migration.MigrationFailedException;
import com.arcway.cockpit.frame.client.project.migration.MigrationManager;
import com.arcway.cockpit.frame.shared.message.EOFileMetaInformation;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.FileResourceWithOverwrittenName;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.primitiveTypes.EOInteger;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public final class ProjectFileAccess {
    private static final ILogger logger = Logger.getLogger(ProjectFileAccess.class);
    public static final int PROJECTFILETYPE_ACT = 1;
    public static final int PROJECTFILETYPE_ACP = 2;
    private static final int STATE_ERROR = 1;
    private static final int STATE_EVERYTHING_ACCESSIBLE = 3;
    private static final int STATE_DISPOSED = 4;
    private static final String UNZIP_DIRECTORY_NAME = "cockpit_projectfile_tmp";
    private final File projectFile;
    private final int projectFileType;
    private File rootDirectoryOfUnzippedProjectFile;
    private int state;
    private int version = -2;
    private EOProject projectMetaData;
    private IStreamResource projectLogo;
    private EOList<EOList<? extends EncodableObjectBase>> mainData;
    private Map<String, EOList<? extends EncodableObjectBase>> map_tag_dataList;

    public ProjectFileAccess(File projectFile, int projectFileType, Shell shell) throws ProjectFileAccessException, ProjectFileFormatVersionIncompatibleException {
        assert (projectFile != null);
        this.projectFileType = projectFileType;
        this.projectFile = projectFile;
        MessageDialog messageDialogue = null;
        try {
            if (shell != null) {
                messageDialogue = MigrationManager.startWaitDialogue(shell);
            }
            this.createRootDirectoryOfUnzippedProjectFile();
            this.unzipProjectFile();
            VersionStatus versionStatus = this.checkVersion();
            if (versionStatus == VersionStatus.Outdated) {
                this.migrateProjectFile();
            }
        }
        finally {
            if (messageDialogue != null) {
                MigrationManager.stopWaitDialogue(messageDialogue);
            }
        }
        this.state = 3;
    }

    public String getProjectFileName() {
        return this.projectFile.getAbsolutePath();
    }

    public File getRootDirectoryOfUnzippedProjectFile() throws ProjectFileAccessException {
        this.checkState();
        return this.rootDirectoryOfUnzippedProjectFile;
    }

    public int getVersion() throws ProjectFileAccessException {
        this.checkState();
        if (this.version == -2) {
            try {
                Integer versionAsInteger;
                EOVersionFileContent versionsMap = this.readVersionFile();
                this.version = versionsMap != null ? ((versionAsInteger = versionsMap.getVersion("project-file-version")) != null ? versionAsInteger : -1) : -1;
            }
            catch (ProjectFileAccessException pfaE) {
                this.version = -1;
            }
        }
        return this.version;
    }

    public EOProject getProjectMetaData() throws ProjectFileAccessException {
        this.checkState();
        if (this.projectMetaData == null) {
            EOList<? extends EncodableObjectBase> projectMetaDataList = this.getDataList("metadata");
            if (projectMetaDataList != null && !projectMetaDataList.isEmpty() && projectMetaDataList.get(0) instanceof EOProject) {
                this.projectMetaData = (EOProject)projectMetaDataList.get(0);
            } else {
                String error = "No project meta data contained in project file.";
                logger.error(error);
                this.state = 1;
                throw new ProjectFileAccessException((Exception)((Object)new EXDecoderException(error)));
            }
        }
        return this.projectMetaData;
    }

    public IStreamResource getProjectLogo() throws ProjectFileAccessException {
        File logoFile;
        EOProject projectMetaData_;
        FileID fileID;
        this.checkState();
        if (this.projectLogo == null && (fileID = Project.getLogoFileID(projectMetaData_ = this.getProjectMetaData())) != null && (logoFile = this.getFile(fileID)) != null) {
            String originalFileName = null;
            EOList<? extends EncodableObjectBase> fileMetaInformationList = this.getDataList("fileMetaInformation");
            for (EncodableObjectBase fileMetaInformationAsObject : fileMetaInformationList) {
                EOFileMetaInformation fileMetaInformation;
                if (!(fileMetaInformationAsObject instanceof EOFileMetaInformation) || !(fileMetaInformation = (EOFileMetaInformation)fileMetaInformationAsObject).getFileUID().equals(fileID.getFileUID())) continue;
                originalFileName = fileMetaInformation.getOriginalFileName();
                break;
            }
            if (originalFileName == null) {
                originalFileName = "Logo";
            }
            this.projectLogo = new FileResourceWithOverwrittenName(logoFile, originalFileName);
        }
        return this.projectLogo;
    }

    public EOList<EOList<? extends EncodableObjectBase>> getMainData() throws ProjectFileAccessException {
        this.checkState();
        if (this.mainData == null) {
            this.readMainData();
        }
        return this.mainData;
    }

    public EOList<? extends EncodableObjectBase> getDataList(String tag) throws ProjectFileAccessException {
        this.checkState();
        if (this.mainData == null) {
            this.readMainData();
        }
        return this.map_tag_dataList.get(tag);
    }

    public File getFilesRoot() throws ProjectFileAccessException {
        this.checkState();
        File root = new File(this.rootDirectoryOfUnzippedProjectFile, "files");
        if (root.exists() && root.isDirectory()) {
            return root;
        }
        return null;
    }

    public File getFile(FileID fileID) throws ProjectFileAccessException {
        this.checkState();
        return FilesManager.getFileInExport(fileID, this.getFilesRoot());
    }

    public boolean isInProductiveState() {
        return this.state == 3;
    }

    public void dispose() {
        if (this.state != 4) {
            try {
                try {
                    FileHelper.deleteExistingFileOrDirectory((File)this.rootDirectoryOfUnzippedProjectFile);
                }
                catch (JvmExternalResourceInteractionException jeriE) {
                    logger.warn("Could not delete the unzipped project file contents during disposal (" + this.rootDirectoryOfUnzippedProjectFile.getAbsolutePath() + ").", (Throwable)jeriE);
                    this.rootDirectoryOfUnzippedProjectFile = null;
                    this.state = 4;
                }
            }
            finally {
                this.rootDirectoryOfUnzippedProjectFile = null;
                this.state = 4;
            }
        }
    }

    private void createRootDirectoryOfUnzippedProjectFile() throws ProjectFileAccessException {
        try {
            this.rootDirectoryOfUnzippedProjectFile = SessionTempDirectoryManager.createSessionTempSubDirectory((String)UNZIP_DIRECTORY_NAME);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't create a temp directory for extracting a project file.", (Throwable)jeriE);
            this.state = 1;
            throw new ProjectFileAccessException((Exception)((Object)jeriE));
        }
    }

    private void unzipProjectFile() throws ProjectFileAccessException {
        try {
            Zip.unzipFile((String)this.projectFile.getAbsolutePath(), (String)this.rootDirectoryOfUnzippedProjectFile.getAbsolutePath());
        }
        catch (IOException ioE) {
            logger.error("Can't unzip project file (" + this.projectFile.getName() + ") into temp directory (" + this.rootDirectoryOfUnzippedProjectFile.getAbsolutePath() + ").", (Throwable)ioE);
            this.state = 1;
            throw new ProjectFileAccessException(ioE);
        }
    }

    private VersionStatus checkVersion() throws ProjectFileAccessException, ProjectFileFormatVersionIncompatibleException {
        int dataFormatVersion = this.getVersion();
        if (dataFormatVersion > 7) {
            throw new ProjectFileFormatVersionIncompatibleException();
        }
        if (dataFormatVersion < 7) {
            return VersionStatus.Outdated;
        }
        return VersionStatus.Current;
    }

    private void migrateProjectFile() throws ProjectFileAccessException {
        try {
            if (this.projectFileType == 1) {
                MigrationManager.getDefault().migrateACT(this);
            } else if (this.projectFileType == 2) {
                MigrationManager.getDefault().migrateACP(this);
            } else assert (false) : "Unknown project file type";
        }
        catch (MigrationFailedException mfE) {
            throw new ProjectFileAccessException(mfE);
        }
    }

    private void readMainData() throws ProjectFileAccessException {
        try {
            File mainDataFile = new File(this.rootDirectoryOfUnzippedProjectFile, "maindata");
            XMLFileAccessor mainDataXMLFileAccessor = new XMLFileAccessor(mainDataFile, (IEncodableObjectFactory)ProjectDataInterchangeEOFactory.getDefault());
            this.mainData = (EOList)mainDataXMLFileAccessor.read();
            this.map_tag_dataList = new HashMap<String, EOList<? extends EncodableObjectBase>>();
            for (EOList list : this.mainData) {
                this.map_tag_dataList.put(list.getRole(), (EOList<? extends EncodableObjectBase>)list);
            }
        }
        catch (EXDecoderException exDE) {
            logger.error("Exception when reading main data from project file.", (Throwable)exDE);
            this.mainData = null;
            this.state = 1;
            throw new ProjectFileAccessException((Exception)((Object)exDE));
        }
        catch (IOException ioE) {
            logger.error("Exception when reading main data from project file.", (Throwable)ioE);
            this.mainData = null;
            this.state = 1;
            throw new ProjectFileAccessException(ioE);
        }
    }

    private EOVersionFileContent readVersionFile() throws ProjectFileAccessException {
        try {
            File versionFile = new File(this.rootDirectoryOfUnzippedProjectFile, "version");
            XMLFileAccessor versionXMLFileAccessor = new XMLFileAccessor(versionFile, new IEncodableObjectFactory(){

                public EncodableObjectBase createEncodableObject(String name, XMLContext context) throws EXDecoderException {
                    if (name.equals("moduleversions")) {
                        return new EOVersionFileContent(context);
                    }
                    if (name.equals("frame.datatype.integer")) {
                        return new EOInteger(context);
                    }
                    if (name.equals("frame.datatype.string")) {
                        return new EOString(context);
                    }
                    return null;
                }
            });
            return (EOVersionFileContent)versionXMLFileAccessor.read();
        }
        catch (EXDecoderException exDE) {
            logger.error("Exception when reading version from project file.", (Throwable)exDE);
            throw new ProjectFileAccessException((Exception)((Object)exDE));
        }
        catch (IOException ioE) {
            logger.error("Exception when reading version from project file.", (Throwable)ioE);
            throw new ProjectFileAccessException(ioE);
        }
    }

    private void checkState() throws ProjectFileAccessException {
        if (this.state == 1) {
            throw new ProjectFileAccessException("Calling a method on this ProjectFileAccess is not possible, because it is in an error state. At least one exception should have been thrown earlier (e.g. by the constructor).");
        }
        if (this.state == 4) {
            throw new ProjectFileAccessException("Calling this method is not possible, because this ProjectFileAccess is in the wrong state (e.g. disposed).");
        }
    }

    public static class ProjectFileAccessException
    extends Exception {
        public ProjectFileAccessException(String exceptionCause) {
            super(exceptionCause);
        }

        public ProjectFileAccessException(Exception cause) {
            super(cause);
        }
    }

    private static enum VersionStatus {
        Current,
        Outdated;

    }
}

