/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeTypesModification;
import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UserDefinedAttributeTypesModManager {
    private final IXMLDataAccessor<EOUserDefinedAttributeTypesModification> modificationFileAccessor;
    private final UserDefinedAttributeTypesManager typesManager;
    private final Collection<AttributeType> addedAttributeTypes;
    private final Collection<AttributeType> modifiedAttributeTypes;
    private final Map<IAttributeTypeID, String> deletedAttributeTypeIDs_2_humanReadableID;

    protected UserDefinedAttributeTypesModManager(UserDefinedAttributeTypesManager typesManager, IXMLDataAccessor<EOUserDefinedAttributeTypesModification> modificationFileAccessor) throws EXCorruptProjectData {
        this.typesManager = typesManager;
        this.modificationFileAccessor = modificationFileAccessor;
        this.addedAttributeTypes = new ArrayList<AttributeType>();
        this.modifiedAttributeTypes = new ArrayList<AttributeType>();
        this.deletedAttributeTypeIDs_2_humanReadableID = new HashMap<IAttributeTypeID, String>();
        try {
            this.read();
        }
        catch (Exception e) {
            throw new EXCorruptProjectData(e);
        }
    }

    private void read() throws EXDecoderException, IOException {
        EOUserDefinedAttributeTypesModification mod = (EOUserDefinedAttributeTypesModification)this.modificationFileAccessor.read();
        if (mod != null) {
            AttributeType type;
            if (mod.getAddedAttributeTypes() != null) {
                for (EOUserDefinedAttributeType eoType : mod.getAddedAttributeTypes()) {
                    type = AttributeType.createAttributeType(eoType, this.typesManager.getProjectAgent());
                    if (type == null || type.getCockpitDataType() == null) continue;
                    this.addedAttributeTypes.add(type);
                }
            }
            if (mod.getModifiedAttributeTypes() != null) {
                for (EOUserDefinedAttributeType eoType : mod.getModifiedAttributeTypes()) {
                    type = AttributeType.createAttributeType(eoType, this.typesManager.getProjectAgent());
                    if (type == null || type.getCockpitDataType() == null) continue;
                    this.modifiedAttributeTypes.add(type);
                }
            }
            if (mod.getDeletedAttributeTypeIDs() != null) {
                for (EOAttributeTypeID eo : mod.getDeletedAttributeTypeIDs()) {
                    AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eo);
                    this.deletedAttributeTypeIDs_2_humanReadableID.put(attributeTypeID, eo.getHumanreadableID());
                }
            }
        }
    }

    private void write() {
        if (this.isEmpty()) {
            this.modificationFileAccessor.write(null);
        } else {
            EOList added = new EOList();
            for (AttributeType type : this.addedAttributeTypes) {
                added.add((EncodableObjectBase)type.createEOUserDefinedAttributeType());
            }
            EOList modified = new EOList();
            for (AttributeType type : this.modifiedAttributeTypes) {
                modified.add((EncodableObjectBase)type.createEOUserDefinedAttributeType());
            }
            EOList deleted = new EOList();
            for (Map.Entry<IAttributeTypeID, String> entry : this.deletedAttributeTypeIDs_2_humanReadableID.entrySet()) {
                IAttributeTypeID attributeTypeID = entry.getKey();
                String humanReadableID = entry.getValue();
                EOAttributeTypeID eo = new EOAttributeTypeID(attributeTypeID.getUID(), humanReadableID);
                deleted.add((EncodableObjectBase)eo);
            }
            EOUserDefinedAttributeTypesModification mod = new EOUserDefinedAttributeTypesModification(added, modified, deleted);
            this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent((EOEncodableObject)mod));
        }
    }

    protected void addAddedAttributeType(AttributeType type) {
        Iterator<AttributeType> i = this.addedAttributeTypes.iterator();
        while (i.hasNext()) {
            IAttributeType contained = i.next();
            if (!type.getAttributeTypeID().equals(contained.getAttributeTypeID())) continue;
            i.remove();
        }
        this.addedAttributeTypes.add(type);
        this.write();
    }

    protected void removeAddedAttributeType(IAttributeTypeID attributeTypeID) {
        Iterator<AttributeType> i = this.addedAttributeTypes.iterator();
        while (i.hasNext()) {
            AttributeType type = i.next();
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            i.remove();
        }
        this.write();
    }

    protected Collection<AttributeType> getAddedAttributeTypes() {
        return this.addedAttributeTypes;
    }

    protected boolean isAddedAttributeType(IAttributeTypeID attributeTypeID) {
        for (AttributeType type : this.addedAttributeTypes) {
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            return true;
        }
        return false;
    }

    protected void addModifiedAttributeType(AttributeType type) {
        type.setModTime(new Timestamp(System.currentTimeMillis()));
        type.setModCount(type.getModCount() + 1);
        Iterator<AttributeType> i = this.modifiedAttributeTypes.iterator();
        while (i.hasNext()) {
            AttributeType attributeType = i.next();
            if (!attributeType.getAttributeTypeID().equals(type.getAttributeTypeID())) continue;
            i.remove();
        }
        this.modifiedAttributeTypes.add(type);
        this.write();
    }

    protected void removeModifiedAttributeType(IAttributeTypeID attributeTypeID) {
        Iterator<AttributeType> i = this.modifiedAttributeTypes.iterator();
        while (i.hasNext()) {
            AttributeType type = i.next();
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            i.remove();
        }
        this.write();
    }

    protected Collection<AttributeType> getModifiedAttributeTypes() {
        return this.modifiedAttributeTypes;
    }

    protected AttributeType getModifiedAttributeType(IAttributeTypeID attributeTypeID) {
        for (AttributeType type : this.modifiedAttributeTypes) {
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            return type;
        }
        return null;
    }

    protected boolean isModifiedAttributeType(IAttributeTypeID attributeTypeID) {
        return this.getModifiedAttributeType(attributeTypeID) != null;
    }

    protected final void addDeletedAttributeType(IAttributeTypeID id, String humanReadableID) {
        this.deletedAttributeTypeIDs_2_humanReadableID.put(id, humanReadableID);
        this.write();
    }

    protected final void removeDeletedAttributeType(IAttributeTypeID attributeTypeID) {
        this.deletedAttributeTypeIDs_2_humanReadableID.remove(attributeTypeID);
        this.write();
    }

    protected final Map<IAttributeTypeID, String> getDeletedAttributeTypeIDs() {
        return this.deletedAttributeTypeIDs_2_humanReadableID;
    }

    protected boolean isDeletedAttributeType(IAttributeTypeID attributeTypeID) {
        return this.deletedAttributeTypeIDs_2_humanReadableID.containsKey(attributeTypeID);
    }

    protected boolean isEmpty() {
        return this.addedAttributeTypes.isEmpty() && this.modifiedAttributeTypes.isEmpty() && this.deletedAttributeTypeIDs_2_humanReadableID.isEmpty();
    }

    protected void clear() {
        this.addedAttributeTypes.clear();
        this.modifiedAttributeTypes.clear();
        this.deletedAttributeTypeIDs_2_humanReadableID.clear();
        this.write();
    }
}

