/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDouble;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationSingle;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeInteger;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeURL;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeFile;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IModuleUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAttributeTypesModManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAttributeTypesServerCache;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.EOUserDefinedAttributeTypesModification;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.java.New;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class UserDefinedAttributeTypesManager
implements IFrameUserDefinedAttributeTypesManager,
IFrameDataManager,
IModuleUserDefinedAttributeTypesManager {
    private static final ILogger logger = Logger.getLogger(UserDefinedAttributeTypesManager.class);
    private Collection<IAttributeTypeDataType> availableDataTypes;
    private Map<Object, Collection<AttributeModificationPermissionTemplate>> attributePermissionsTemplates;
    private UserDefinedAttributeTypesModManager modificationManager;
    private UserDefinedAttributeTypesServerCache serverCache;
    private IFrameProjectAgent projectAgent;
    private ModificationPropagator modPropagator;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return UserDefinedAttributeTypesManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };
    private IDataLabelProvider dataLabelProvider;

    public void construct(IFrameProjectAgent newProjectAgent) {
        this.projectAgent = newProjectAgent;
        this.modPropagator = new ModificationPropagator();
    }

    protected IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public Collection<IAttributeTypeDataType> getAvailableDataTypes() {
        if (this.availableDataTypes == null) {
            this.availableDataTypes = new ArrayList<IAttributeTypeDataType>();
            this.availableDataTypes.add(DataTypeString.getInstanceString());
            this.availableDataTypes.add(DataTypeText.getInstanceText());
            this.availableDataTypes.add(DataTypeInteger.getSingleInstance());
            this.availableDataTypes.add(DataTypeBoolean.getSingleInstance());
            this.availableDataTypes.add(new DataTypeEnumerationSingle(DataTypeString.getInstanceString(), null));
            this.availableDataTypes.add(new DataTypeEnumerationSingle(DataTypeInteger.getSingleInstance(), null));
            this.availableDataTypes.add(new DataTypeEnumerationMultiple(DataTypeString.getInstanceString(), null, false));
            this.availableDataTypes.add(new DataTypeEnumerationMultiple(DataTypeInteger.getSingleInstance(), null, false));
            this.availableDataTypes.add(DataTypeDate.getSingleInstance());
            this.availableDataTypes.add(new DataTypeFile(this.projectAgent));
            this.availableDataTypes.add(new DataTypeURL());
            this.availableDataTypes.add(DataTypeDouble.getSingleInstance());
        }
        return this.availableDataTypes;
    }

    @Override
    public IAttributeTypeDataType getDataType(String dataTypeID) {
        for (IAttributeTypeDataType dataType : this.getAvailableDataTypes()) {
            if (!dataType.getID().equals(dataTypeID)) continue;
            return dataType;
        }
        return null;
    }

    @Override
    public IAttributeType addUserDefinedAttributeType(final IAttributeType type) throws EXNoPermission, EXNoLock {
        final IAttributeType[] newType = new IAttributeType[1];
        this.modPropagator.doWithRefreshHandling(new IRunnableForRefresh(){

            @Override
            public void run() throws EXNoPermission, EXNoLock {
                newType[0] = UserDefinedAttributeTypesManager.this.addUserDefinedAttributeTypeIntern(type);
            }
        });
        PropertyChanges changes = new PropertyChanges((Object)newType[0], null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
        return newType[0];
    }

    @Override
    public Collection<IAttributeType> addUserDefinedAttributeTypes(final Collection<IAttributeType> types) throws EXNoPermission, EXNoLock {
        final ArrayList<IAttributeType> newTypes = new ArrayList<IAttributeType>();
        this.modPropagator.doWithRefreshHandling(new IRunnableForRefresh(){

            @Override
            public void run() throws EXNoPermission, EXNoLock {
                for (IAttributeType type : types) {
                    IAttributeType newType = UserDefinedAttributeTypesManager.this.addUserDefinedAttributeTypeIntern(type);
                    newTypes.add(newType);
                }
            }
        });
        PropertyChanges changes = new PropertyChanges(newTypes, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
        return newTypes;
    }

    @Override
    public Collection<IAttributeTypeID> deleteUserDefinedAttributeTypes(Collection<IAttributeTypeID> attributeTypeIDs) throws EXNoPermission, EXNoLock {
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "defineAttributeTypes");
        }
        final HashMap attributeTypeIDs_2_humanReadableID = New.hashMap((int)attributeTypeIDs.size());
        ArrayList<AttributeType> attributeTypesToDelete = new ArrayList<AttributeType>();
        for (IAttributeTypeID attributeTypeID : attributeTypeIDs) {
            AttributeType type = this.getAttributeTypeInternal(attributeTypeID);
            attributeTypeIDs_2_humanReadableID.put(attributeTypeID, type.getHumanReadableID());
            if (!this.modificationManager.isAddedAttributeType(type.getAttributeTypeID())) {
                this.projectAgent.getFrameLockManager().checkIfClientAlreadyHasProjectLock();
            }
            attributeTypesToDelete.add(type);
        }
        this.modPropagator.doWithRefreshHandling(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry entry : attributeTypeIDs_2_humanReadableID.entrySet()) {
                    IAttributeTypeID attributeTypeID = (IAttributeTypeID)entry.getKey();
                    String humanReadableID = (String)entry.getValue();
                    if (UserDefinedAttributeTypesManager.this.modificationManager.isAddedAttributeType(attributeTypeID)) {
                        UserDefinedAttributeTypesManager.this.modificationManager.removeAddedAttributeType(attributeTypeID);
                        continue;
                    }
                    if (UserDefinedAttributeTypesManager.this.modificationManager.isModifiedAttributeType(attributeTypeID)) {
                        UserDefinedAttributeTypesManager.this.modificationManager.removeModifiedAttributeType(attributeTypeID);
                    }
                    UserDefinedAttributeTypesManager.this.modificationManager.addDeletedAttributeType(attributeTypeID, humanReadableID);
                }
            }
        });
        PropertyChanges propertyChanges = new PropertyChanges(null, null, attributeTypesToDelete);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)propertyChanges, IAttributeType.class);
        return attributeTypeIDs;
    }

    private IAttributeType addUserDefinedAttributeTypeIntern(IAttributeType type) throws ExInvalidAttributeType, EXNoPermission, EXNoLock {
        if (!type.isUserDefined()) {
            throw ExInvalidAttributeType.getExceptionForInvalidID((String)type.getAttributeTypeID().getUID(), (String)type.getHumanReadableID(), (String)"human readable id must start with 'custom.'");
        }
        Collection existingTypes = this.getAllUserDefinedAttributeTypes(type.getCockpitDataType().getCockpitDataTypeID());
        for (IAttributeType existing : existingTypes) {
            if (!existing.getHumanReadableID().equals(type.getHumanReadableID())) continue;
            throw ExInvalidAttributeType.getExceptionForInvalidID((String)type.getAttributeTypeID().getUID(), (String)type.getHumanReadableID(), (String)("an attribute type with the id " + type.getHumanReadableID() + " does already exist"));
        }
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "defineAttributeTypes");
        }
        this.projectAgent.getFrameLockManager().checkIfClientAlreadyHasProjectLock();
        AttributeType newType = new AttributeType(type);
        newType.setProjectUID(this.projectAgent.getProjectUID());
        this.modificationManager.addAddedAttributeType(newType);
        return newType;
    }

    @Override
    public IAttributeType setHumanReadableIDAndDisplayName(IAttributeTypeID attributeTypeID, final String newHumanReadableID, final String newDisplayName) throws ExInvalidAttributeType, EXNoPermission, EXNoLock {
        final AttributeType existingType = this.getAttributeTypeInternal(attributeTypeID);
        if (existingType == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)attributeTypeID.getUID());
        }
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "defineAttributeTypes");
        }
        this.projectAgent.getFrameLockManager().checkIfClientAlreadyHasProjectLock();
        this.modPropagator.doWithRefreshHandling(new Runnable(){

            @Override
            public void run() {
                existingType.setHumanReadableID(newHumanReadableID);
                existingType.setDisplayName(newDisplayName);
                if (UserDefinedAttributeTypesManager.this.modificationManager.isAddedAttributeType(existingType.getAttributeTypeID())) {
                    UserDefinedAttributeTypesManager.this.modificationManager.addAddedAttributeType(existingType);
                } else {
                    UserDefinedAttributeTypesManager.this.modificationManager.addModifiedAttributeType(existingType);
                }
            }
        });
        PropertyChanges changes = new PropertyChanges(null, (Object)existingType, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
        return existingType;
    }

    @Override
    public IAttributeType setSortCriterium(IAttributeTypeID attributeTypeID, IAttributeTypeSortCriterium newSortCriterium) {
        AttributeType attributeType = this.getAttributeTypeInternal(attributeTypeID);
        attributeType.setSortCriterium(newSortCriterium);
        if (!this.modificationManager.isAddedAttributeType(attributeTypeID)) {
            this.modificationManager.addModifiedAttributeType(attributeType);
        } else {
            this.modificationManager.addAddedAttributeType(attributeType);
        }
        PropertyChanges changes = new PropertyChanges(null, (Object)attributeType, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
        return attributeType;
    }

    private AttributeType getAttributeTypeInternal(IAttributeTypeID attributeTypeID) {
        for (AttributeType type : this.getAllAttributeTypesInternal_ro()) {
            if (!type.getAttributeTypeID().equals(attributeTypeID)) continue;
            return type;
        }
        return null;
    }

    private Collection<AttributeType> getAllAttributeTypesInternal_ro() {
        Collection<AttributeType> serverCacheAttributeTypes = this.serverCache.getAttributeTypes();
        Collection<AttributeType> addedAttributeTypes = this.modificationManager.getAddedAttributeTypes();
        Collection<AttributeType> modifiedAttributeTypes = this.modificationManager.getModifiedAttributeTypes();
        Set<IAttributeTypeID> deletedAttributeTypeIDs = this.modificationManager.getDeletedAttributeTypeIDs().keySet();
        if (modifiedAttributeTypes.isEmpty() && deletedAttributeTypeIDs.isEmpty()) {
            if (serverCacheAttributeTypes.isEmpty() && addedAttributeTypes.isEmpty()) {
                return Collections.emptyList();
            }
            if (addedAttributeTypes.isEmpty()) {
                return serverCacheAttributeTypes;
            }
            if (serverCacheAttributeTypes.isEmpty()) {
                return addedAttributeTypes;
            }
        }
        AbstractList allTypes = modifiedAttributeTypes.isEmpty() && deletedAttributeTypeIDs.isEmpty() ? new ArrayList(serverCacheAttributeTypes.size() + addedAttributeTypes.size()) : new LinkedList<AttributeType>();
        allTypes.addAll(serverCacheAttributeTypes);
        if (!deletedAttributeTypeIDs.isEmpty()) {
            for (IAttributeTypeID deletedID : deletedAttributeTypeIDs) {
                Iterator i = allTypes.iterator();
                while (i.hasNext()) {
                    IAttributeType attributeType = (IAttributeType)i.next();
                    if (!deletedID.equals(attributeType.getAttributeTypeID())) continue;
                    i.remove();
                }
            }
        }
        if (!modifiedAttributeTypes.isEmpty()) {
            allTypes.removeAll(modifiedAttributeTypes);
            allTypes.addAll(modifiedAttributeTypes);
        }
        if (!addedAttributeTypes.isEmpty()) {
            allTypes.addAll(addedAttributeTypes);
        }
        return allTypes;
    }

    @Override
    public IAttributeType setValueRange(IAttributeTypeID attributeTypeID, final IValueRange valueRange) throws EXNoPermission, EXNoLock {
        final AttributeType existingType = this.getAttributeTypeInternal(attributeTypeID);
        if (existingType == null) {
            throw ExInvalidAttributeType.getExceptionForNoneExistingAttributeType((String)attributeTypeID.getUID());
        }
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "defineAttributeTypes");
        }
        this.projectAgent.getFrameLockManager().checkIfClientAlreadyHasProjectLock();
        this.modPropagator.doWithRefreshHandling(new Runnable(){

            @Override
            public void run() {
                existingType.setValueRange(valueRange);
                if (UserDefinedAttributeTypesManager.this.modificationManager.isAddedAttributeType(existingType.getAttributeTypeID())) {
                    UserDefinedAttributeTypesManager.this.modificationManager.addAddedAttributeType(existingType);
                } else {
                    UserDefinedAttributeTypesManager.this.modificationManager.addModifiedAttributeType(existingType);
                }
            }
        });
        PropertyChanges changes = new PropertyChanges(null, (Object)existingType, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
        return existingType;
    }

    @Override
    public List<IAttributeType> getAllUserDefinedAttributeTypes(String cockpitTypeID) {
        ArrayList<IAttributeType> result = new ArrayList<IAttributeType>();
        for (AttributeType type : this.getAllAttributeTypesInternal_ro()) {
            ICockpitDataType cockpitDataType = type.getCockpitDataType();
            if (cockpitDataType == null || !cockpitDataType.getCockpitDataTypeID().equals(cockpitTypeID)) continue;
            result.add(type);
        }
        return result;
    }

    @Override
    public String getHighestUsedSortString(String cockpitTypeID) {
        List<IAttributeType> allSavedUserDefinedAttributeTypes = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(cockpitTypeID);
        String highestUsedPositionSortString = "zzaa";
        for (IAttributeType attributeType : allSavedUserDefinedAttributeTypes) {
            IAttributeTypeSortCriterium sortCriterion = attributeType.getSortCriterium();
            if (highestUsedPositionSortString != null && sortCriterion.compareTo(IAttributeTypeSortCriterium.CATEGORY_USERDEFINED_ATTRIBUTE, highestUsedPositionSortString) <= 0) continue;
            highestUsedPositionSortString = sortCriterion.getSortString();
        }
        return highestUsedPositionSortString;
    }

    @Override
    public Collection<AttributeType> getAllUserDefinedAttributeTypes() {
        return Collections.unmodifiableCollection(this.getAllAttributeTypesInternal_ro());
    }

    @Override
    public IAttributeType getUserDefinedAttributeType(IAttributeTypeID attributeTypeID) {
        for (AttributeType attributeType : this.getAllAttributeTypesInternal_ro()) {
            if (!attributeType.getAttributeTypeID().equals(attributeTypeID)) continue;
            return attributeType;
        }
        return null;
    }

    @Override
    public IAttributeType getUserDefinedAttributeType(String attributeTypeUID) {
        for (IAttributeType iAttributeType : this.getAllAttributeTypesInternal_ro()) {
            if (!iAttributeType.getAttributeTypeID().getUID().equals(attributeTypeUID)) continue;
            return iAttributeType;
        }
        return null;
    }

    @Override
    public EOUserDefinedAttributeTypesModification getUserDefinedAttributeTypesModification() {
        EOList added = new EOList();
        for (AttributeType type : this.modificationManager.getAddedAttributeTypes()) {
            added.add((EncodableObjectBase)type.createEOUserDefinedAttributeType());
        }
        EOList modified = new EOList();
        for (AttributeType type : this.modificationManager.getModifiedAttributeTypes()) {
            modified.add((EncodableObjectBase)type.createEOUserDefinedAttributeType());
        }
        EOList deleted = new EOList();
        for (Map.Entry<IAttributeTypeID, String> entry : this.modificationManager.getDeletedAttributeTypeIDs().entrySet()) {
            IAttributeTypeID attributeTypeID = entry.getKey();
            String humanReadableID = entry.getValue();
            EOAttributeTypeID eo = new EOAttributeTypeID(attributeTypeID.getUID(), humanReadableID);
            deleted.add((EncodableObjectBase)eo);
        }
        EOUserDefinedAttributeTypesModification mod = new EOUserDefinedAttributeTypesModification(added, modified, deleted);
        return mod;
    }

    @Override
    public void applySynchronousModifications(EOUserDefinedAttributeTypesModification modification) {
        if (modification != null) {
            EOList added;
            EOList modified;
            boolean modsToPerform = false;
            final EOList deleted = modification.getDeletedAttributeTypeIDs();
            if (deleted != null && deleted.size() > 0) {
                modsToPerform = true;
            }
            if ((modified = modification.getModifiedAttributeTypes()) != null && modified.size() > 0) {
                modsToPerform = true;
            }
            if ((added = modification.getAddedAttributeTypes()) != null && added.size() > 0) {
                modsToPerform = true;
            }
            if (modsToPerform) {
                this.modPropagator.doWithRefreshHandling(new Runnable(){

                    @Override
                    public void run() {
                        AttributeType type;
                        if (deleted != null) {
                            for (EOAttributeTypeID eo : deleted) {
                                AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eo);
                                UserDefinedAttributeTypesManager.this.modificationManager.removeDeletedAttributeType(attributeTypeID);
                                UserDefinedAttributeTypesManager.this.serverCache.deleteAttributeType(attributeTypeID);
                            }
                        }
                        if (modified != null) {
                            for (EOUserDefinedAttributeType eoType : modified) {
                                try {
                                    type = AttributeType.createAttributeType(eoType, UserDefinedAttributeTypesManager.this.projectAgent);
                                    UserDefinedAttributeTypesManager.this.modificationManager.removeModifiedAttributeType(type.getAttributeTypeID());
                                    UserDefinedAttributeTypesManager.this.serverCache.replace(type);
                                }
                                catch (ExInvalidDataType e) {
                                    logger.error("could not apply server update", (Throwable)e);
                                }
                            }
                        }
                        if (added != null) {
                            for (EOUserDefinedAttributeType eoType : added) {
                                try {
                                    type = AttributeType.createAttributeType(eoType, UserDefinedAttributeTypesManager.this.projectAgent);
                                    UserDefinedAttributeTypesManager.this.modificationManager.removeAddedAttributeType(type.getAttributeTypeID());
                                    UserDefinedAttributeTypesManager.this.serverCache.addAttributeType(type);
                                }
                                catch (ExInvalidDataType e) {
                                    logger.error("could not apply server update", (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    @Override
    public void applyAsynchronousModifications(EOUserDefinedAttributeTypesModification modification) {
        final ArrayList propDeleted = new ArrayList();
        final ArrayList propModified = new ArrayList();
        final ArrayList propAdded = new ArrayList();
        if (modification != null) {
            EOList added;
            EOList modified;
            boolean modsToPerform = false;
            final EOList deleted = modification.getDeletedAttributeTypeIDs();
            if (deleted != null && deleted.size() > 0) {
                modsToPerform = true;
            }
            if ((modified = modification.getModifiedAttributeTypes()) != null && modified.size() > 0) {
                modsToPerform = true;
            }
            if ((added = modification.getAddedAttributeTypes()) != null && added.size() > 0) {
                modsToPerform = true;
            }
            if (modsToPerform) {
                this.modPropagator.doWithRefreshHandling(new Runnable(){

                    @Override
                    public void run() {
                        AttributeType type;
                        if (deleted != null) {
                            for (EOAttributeTypeID eo : deleted) {
                                AttributeTypeID attributeTypeID = AttributeTypeID.getAttributeTypeID(eo);
                                IAttributeType typeToDelete = UserDefinedAttributeTypesManager.this.serverCache.getAttributeType(attributeTypeID);
                                if (typeToDelete == null) continue;
                                UserDefinedAttributeTypesManager.this.serverCache.deleteAttributeType(attributeTypeID);
                                propDeleted.add(typeToDelete);
                            }
                        }
                        if (modified != null) {
                            for (EOUserDefinedAttributeType eoType : modified) {
                                try {
                                    type = AttributeType.createAttributeType(eoType, UserDefinedAttributeTypesManager.this.projectAgent);
                                    if (type.getCockpitDataType() == null) continue;
                                    propModified.add(type);
                                    UserDefinedAttributeTypesManager.this.serverCache.replace(type);
                                }
                                catch (ExInvalidDataType e) {
                                    logger.error("could not apply server update", (Throwable)e);
                                }
                            }
                        }
                        if (added != null) {
                            for (EOUserDefinedAttributeType eoType : added) {
                                try {
                                    type = AttributeType.createAttributeType(eoType, UserDefinedAttributeTypesManager.this.projectAgent);
                                    if (type.getCockpitDataType() == null) continue;
                                    propAdded.add(type);
                                    UserDefinedAttributeTypesManager.this.serverCache.addAttributeType(type);
                                }
                                catch (ExInvalidDataType e) {
                                    logger.error("could not apply server update of user defined attribute types", (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        }
        PropertyChanges changes = new PropertyChanges(propAdded, propModified, propDeleted, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IAttributeType.class);
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        return null;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.modificationManager = new UserDefinedAttributeTypesModManager(this, (IXMLDataAccessor<EOUserDefinedAttributeTypesModification>)this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_CUSTOM_PROPERTIES, (IEncodableObjectFactory)MessageDataFactory.getInstance()));
        this.serverCache = new UserDefinedAttributeTypesServerCache();
        this.attributePermissionsTemplates = new HashMap<Object, Collection<AttributeModificationPermissionTemplate>>();
        Collection eoTypes = serverDataContainer.getUserDefinedAttributeTypes();
        if (eoTypes != null) {
            for (EOUserDefinedAttributeType eoType : eoTypes) {
                try {
                    AttributeType type = AttributeType.createAttributeType(eoType, administrator.getFrameProjectAgent());
                    if (type == null || type.getCockpitDataType() == null) continue;
                    this.serverCache.addAttributeType(type);
                }
                catch (ExInvalidDataType e) {
                    logger.error("could not add attribute type to server cache", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return Messages.getString("UserDefinedAttributeTypesManager.custom_properties_mgr");
    }

    @Override
    public void discardLocalModifications() {
        this.modificationManager.clear();
    }

    @Override
    public boolean hasLocalModifications() {
        return !this.modificationManager.isEmpty();
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new IDataLabelProvider(){

                public Image getImageOfType(String dataTypeID) {
                    return Icons.getImageForUserDefinedAttributeTypes();
                }

                public String getTypeDisplayName(String dataTypeID) {
                    return Messages.getString("UserDefinedAttributeTypesManager.custom_properties");
                }

                public Image getImage(Object element) {
                    return Icons.getImageForUserDefinedAttributeTypes();
                }

                public String getText(Object element) {
                    IAttributeType type = (IAttributeType)element;
                    return type.getDisplayName();
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return null;
    }

    @Override
    public IModificationProblem checkAttributeTypesModificationPermission(ICockpitDataType cockpitDataType) {
        ModificationProblem modProblem = null;
        String problemDescription = Messages.getString("UserDefinedAttributeTypesManager.custom_prop_cannot_be_mod");
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("defineAttributeTypes", null, this.operandTree)) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("defineAttributeTypes", this.projectAgent.getPermissionOperandType());
            modProblem = new ModificationProblem(template, problemDescription, this.projectAgent);
        }
        Throwable serverException = null;
        try {
            EOLock otherLock = this.projectAgent.getFrameLockManager().anotherClientHasProjectLock();
            if (otherLock != null) {
                modProblem = new ModificationProblem(otherLock, problemDescription);
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            modProblem = new ModificationProblem((Exception)serverException, problemDescription);
        }
        return modProblem;
    }

    private void requestModifyAttributeTypePermissions(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("defineAttributeTypes", null, this.operandTree);
        transactionController.addProjectLock();
    }

    @Override
    public void requestAddAttributeTypePermissions(IAttributeType attributeTypeToAdd, ILocksAndPermissionsTransactionController transactionController, IAttributeTypesModifier attributeTypesModifier) {
        this.checkValidty(attributeTypeToAdd, attributeTypesModifier, transactionController);
        this.requestModifyAttributeTypePermissions(transactionController);
    }

    @Override
    public void requestDeleteAttributeTypePermission(IAttributeTypeID attributeTypeID, ILocksAndPermissionsTransactionController transactionController) {
        this.requestModifyAttributeTypePermissions(transactionController);
    }

    @Override
    public void requestModifyAttributeTypePermissions(IAttributeType attributeTypeToModify, ILocksAndPermissionsTransactionController transactionController, IAttributeTypesModifier attributeTypesModifier) {
        this.checkValidty(attributeTypeToModify, attributeTypesModifier, transactionController);
        this.requestModifyAttributeTypePermissions(transactionController);
    }

    private void checkValidty(IAttributeType attributeTypeToCheck, IAttributeTypesModifier attributeTypesModifier, ILocksAndPermissionsTransactionController transactionController) {
        String error = this.isValidIdOrDisplayName(attributeTypeToCheck.getHumanReadableID(), true, attributeTypesModifier, attributeTypeToCheck);
        if (error != null) {
            transactionController.addLockModificationProblem(new ModificationProblem(error, NLS.bind((String)Messages.getString("UserDefinedAttributeTypesManager.CannotAddCustomProperty"), (Object)attributeTypeToCheck.getDisplayName())));
        }
        if ((error = this.isValidIdOrDisplayName(attributeTypeToCheck.getDisplayName(), false, attributeTypesModifier, attributeTypeToCheck)) != null) {
            transactionController.addLockModificationProblem(new ModificationProblem(error, NLS.bind((String)Messages.getString("UserDefinedAttributeTypesManager.CannotAddCustomProperty"), (Object)attributeTypeToCheck.getDisplayName())));
        }
    }

    @Override
    public void modificationFinished(String cockpitDataTypeID, ILocksAndPermissionsTransactionController transactionController) {
    }

    public Collection<IAttributeType> getAttributeTypesForModuleData(String cockpitTypeID) {
        return this.getAllUserDefinedAttributeTypes(cockpitTypeID);
    }

    @Override
    public boolean hasUserDefinedAttributeTypes(String cockpitDataTypeID) {
        for (IAttributeType iAttributeType : this.getAllAttributeTypesInternal_ro()) {
            if (!iAttributeType.getCockpitDataType().getCockpitDataTypeID().equals(cockpitDataTypeID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        return null;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        return null;
    }

    @Override
    public AttributeModificationPermissionTemplate getPermissionsTemplate(String attributeTypeID, IModuleDataTypeDescriptionForFrame dataType, String permissionOperandTypeID) {
        AttributeModificationPermissionTemplate template;
        Collection<AttributeModificationPermissionTemplate> templates = this.attributePermissionsTemplates.get(attributeTypeID);
        if (templates == null) {
            templates = new ArrayList<AttributeModificationPermissionTemplate>();
            this.attributePermissionsTemplates.put(attributeTypeID, templates);
        }
        if ((template = this.getTemplateFromCollection(dataType.getCockpitDataTypeID(), permissionOperandTypeID, templates)) == null) {
            template = new AttributeModificationPermissionTemplate(attributeTypeID, dataType.getCockpitDataTypeID(), permissionOperandTypeID);
            templates.add(template);
        }
        return template;
    }

    private AttributeModificationPermissionTemplate getPermissionsTemplate(IAttributeTypeID attributeTypeID, String dataTypeID, String permissionOperandTypeID) {
        AttributeModificationPermissionTemplate template;
        Collection<AttributeModificationPermissionTemplate> templates = this.attributePermissionsTemplates.get(attributeTypeID);
        if (templates == null) {
            templates = new ArrayList<AttributeModificationPermissionTemplate>();
            this.attributePermissionsTemplates.put(attributeTypeID, templates);
        }
        if ((template = this.getTemplateFromCollection(dataTypeID, permissionOperandTypeID, templates)) == null) {
            template = new AttributeModificationPermissionTemplate(attributeTypeID, dataTypeID, permissionOperandTypeID);
            templates.add(template);
        }
        return template;
    }

    @Override
    public AttributeModificationPermissionTemplate getPermissionsTemplate(IAttributeType attributeType, String permissionOperandTypeID) {
        return this.getPermissionsTemplate(attributeType.getAttributeTypeID(), attributeType.getCockpitDataType().getCockpitDataTypeID(), permissionOperandTypeID);
    }

    private AttributeModificationPermissionTemplate getTemplateFromCollection(String cockpitDataTypeID, String permissionOperandTypeID, Collection<AttributeModificationPermissionTemplate> templates) {
        for (AttributeModificationPermissionTemplate template : templates) {
            if (!template.getCockpitDataTypeID().equals(cockpitDataTypeID) || !template.getOperandType().equals(permissionOperandTypeID)) continue;
            return template;
        }
        return null;
    }

    @Override
    public List<IAttributeType> getSortedAttributeTypes(String cockpitTypeID) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>(this.getAttributeTypesForModuleData(cockpitTypeID));
        Collections.sort(attributeTypes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType type1, IAttributeType type2) {
                return type1.getSortCriterium().compareTo((Object)type2.getSortCriterium());
            }
        });
        return attributeTypes;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return false;
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String isValidIdOrDisplayName(String newText, boolean forID, IAttributeTypesModifier typesModifier, String cockpitDataTypeID) {
        return this.isValidIdOrDisplayName(newText, forID, typesModifier, cockpitDataTypeID, null);
    }

    @Override
    public String isValidIdOrDisplayName(String newText, boolean forID, IAttributeTypesModifier typesModifier, IAttributeType originalType) {
        return this.isValidIdOrDisplayName(newText, forID, typesModifier, originalType.getCockpitDataTypeID(), originalType);
    }

    private String isValidIdOrDisplayName(String newText, boolean forID, IAttributeTypesModifier typesModifier, String cockpitDataTypeID, IAttributeType originalType) {
        String fieldName;
        String string = fieldName = forID ? Messages.getString("UserDefinedAttributeTypesManager.Field.ID") : Messages.getString("UserDefinedAttributeTypesManager.Field.DisplayName");
        if (newText == null || newText.trim().equals("")) {
            return NLS.bind((String)Messages.getString("UserDefinedAttributeTypesManager.FieldNotAllowedToBeEmpty"), (Object)fieldName);
        }
        if (forID) {
            int maxLength = AttributeType.getMaximumLengthOfCustomPropertyIDWithoutPrefix();
            if (newText.length() > maxLength) {
                return NLS.bind((String)Messages.getString("UserDefinedAttributeTypesManager.FieldTooLong"), (Object)fieldName, (Object)String.valueOf(maxLength));
            }
        }
        ArrayList<Object> attributeTypes = new ArrayList<Object>();
        for (IAttributeType iAttributeType : this.getAllUserDefinedAttributeTypes(cockpitDataTypeID)) {
            if (typesModifier.isDeleted(iAttributeType.getAttributeTypeID())) continue;
            IAttributeType modified = typesModifier.getModifiedAttributeType(iAttributeType.getAttributeTypeID());
            if (modified != null) {
                attributeTypes.add(modified);
                continue;
            }
            attributeTypes.add(iAttributeType);
        }
        attributeTypes.addAll(typesModifier.getAddedAttributeTypes());
        for (IAttributeType iAttributeType : attributeTypes) {
            if (originalType != null && originalType.getAttributeTypeID().equals(iAttributeType.getAttributeTypeID())) continue;
            boolean alreadyExists = false;
            if (forID) {
                if (iAttributeType.getHumanReadableIDWithoutPrefix().equals(newText)) {
                    alreadyExists = true;
                }
            } else {
                assert (iAttributeType.getCockpitDataType().getCockpitDataTypeID().equals(cockpitDataTypeID));
                if (iAttributeType.getDisplayName().equalsIgnoreCase(newText)) {
                    alreadyExists = true;
                }
            }
            if (!alreadyExists) continue;
            return NLS.bind((String)Messages.getString("UserDefinedAttributeTypesManager.FieldAlreadyExists"), (Object)fieldName, (Object)newText);
        }
        return null;
    }

    private static interface IRunnableForRefresh {
        public void run() throws EXNoPermission, EXNoLock;
    }

    private class ModificationPropagator {
        public void doWithRefreshHandling(IRunnableForRefresh todo) throws EXNoPermission, EXNoLock {
            UserDefinedAttributeTypesManager.this.projectAgent.deactivateRepositoryInterface();
            try {
                todo.run();
            }
            finally {
                UserDefinedAttributeTypesManager.this.projectAgent.activateRepositoryInterface();
                UserDefinedAttributeTypesManager.this.projectAgent.getFrameDataAttributeTypesProviderManager().refreshAttributeTypesCache();
            }
        }

        public void doWithRefreshHandling(Runnable todo) {
            UserDefinedAttributeTypesManager.this.projectAgent.deactivateRepositoryInterface();
            try {
                todo.run();
            }
            finally {
                UserDefinedAttributeTypesManager.this.projectAgent.activateRepositoryInterface();
                UserDefinedAttributeTypesManager.this.projectAgent.getFrameDataAttributeTypesProviderManager().refreshAttributeTypesCache();
            }
        }
    }
}

