/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IAttributeTypesModifier;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameUserDefinedAttributeTypeValidator
implements IInputValidator {
    private final IModuleProjectAgent projectAgent;
    private final boolean forID;
    private final String cockpitDataTypeID;
    private IAttributeType originalType;
    private final IAttributeTypesModifier typesModifier;

    public RenameUserDefinedAttributeTypeValidator(IModuleProjectAgent projectAgent, boolean forID, String cockpitDataTypeID, IAttributeTypesModifier typesModifier) {
        this.projectAgent = projectAgent;
        this.forID = forID;
        this.cockpitDataTypeID = cockpitDataTypeID;
        this.typesModifier = typesModifier;
    }

    public RenameUserDefinedAttributeTypeValidator(IModuleProjectAgent projectAgent, boolean forID, IAttributeType originalType, IAttributeTypesModifier typesModifier) {
        this(projectAgent, forID, originalType.getCockpitDataType().getCockpitDataTypeID(), typesModifier);
        this.originalType = originalType;
    }

    public String isValid(String newText) {
        String fieldName;
        String string = fieldName = this.forID ? Messages.getString("RenameUserDefinedAttributeTypeValidator.ID_field") : Messages.getString("RenameUserDefinedAttributeTypeValidator.displayname_field");
        if (newText == null || newText.trim().equals("")) {
            return String.valueOf(Messages.getString("RenameUserDefinedAttributeTypeValidator.the")) + fieldName + Messages.getString("RenameUserDefinedAttributeTypeValidator.must_not_be_empty");
        }
        if (this.forID) {
            int maxLength = AttributeType.getMaximumLengthOfCustomPropertyIDWithoutPrefix();
            if (newText.length() > maxLength) {
                return String.valueOf(Messages.getString("RenameUserDefinedAttributeTypeValidator.id_too_long1")) + maxLength + Messages.getString("RenameUserDefinedAttributeTypeValidator.id_too_long2");
            }
        }
        ArrayList<Object> attributeTypes = new ArrayList<Object>();
        for (IAttributeType iAttributeType : this.projectAgent.getModuleUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(this.cockpitDataTypeID)) {
            if (this.typesModifier.isDeleted(iAttributeType.getAttributeTypeID())) continue;
            IAttributeType modified = this.typesModifier.getModifiedAttributeType(iAttributeType.getAttributeTypeID());
            if (modified != null) {
                attributeTypes.add(modified);
                continue;
            }
            attributeTypes.add(iAttributeType);
        }
        attributeTypes.addAll(this.typesModifier.getAddedAttributeTypes());
        for (IAttributeType iAttributeType : attributeTypes) {
            if (this.originalType != null && this.originalType.getAttributeTypeID().equals(iAttributeType.getAttributeTypeID()) || !(this.forID ? iAttributeType.getHumanReadableID().equals(newText) : iAttributeType.getCockpitDataType().getCockpitDataTypeID().equals(this.cockpitDataTypeID) && iAttributeType.getDisplayName().equalsIgnoreCase(newText))) continue;
            return String.valueOf(Messages.getString("RenameUserDefinedAttributeTypeValidator.there_is_already_a_custom_property")) + fieldName + " " + newText;
        }
        return null;
    }
}

