/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.IWizardPageModificationInProgress;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CreateDataWithUserDefinedAttributeTypesWizardPage
extends WizardPage
implements IWizardPageModificationInProgress,
IObjectTypeCategoryChangeListener {
    private static final String DEFAULT_TITLE = Messages.getString("CreateDataWithUserDefinedAttributeTypesWizardPage.custom_properties");
    private static final String DEFAULT_MESSAGE = Messages.getString("CreateDataWithUserDefinedAttributeTypesWizardPage.define_values");
    private final IFrameProjectAgent projectAgent;
    private final ICockpitDataType dataType;
    private final IParentOperandTree parentTree;
    private final Collection<IModificationProblem> problems = new ArrayList<IModificationProblem>();
    private final Map<IAttributeTypeID, Tuple<Label, IAttributeTypeDataType.ISWTControlForModification>> type_control_map = new HashMap<IAttributeTypeID, Tuple<Label, IAttributeTypeDataType.ISWTControlForModification>>();
    private final Map<IAttributeType, Object> type_currentValue_map = new HashMap<IAttributeType, Object>();
    private final Map<IAttributeType, IModificationProblem> modificationsInProgress = new HashMap<IAttributeType, IModificationProblem>();
    private boolean wereModificationsInProgress = false;
    private ScrolledComposite scrolledBase;
    private Label noAttributesToShow;

    public CreateDataWithUserDefinedAttributeTypesWizardPage(ICockpitDataType dataType, String projectUID, IParentOperandTree parentTree) {
        super("custom properties");
        this.dataType = dataType;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        this.parentTree = parentTree;
    }

    public void createControl(Composite parent) {
        this.setTitle(DEFAULT_TITLE);
        this.setMessage(DEFAULT_MESSAGE);
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        this.scrolledBase = scrolledComposite;
        final Composite base = new Composite((Composite)scrolledComposite, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(2, false));
        List<IAttributeType> attributeTypes = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes(this.dataType.getCockpitDataTypeID());
        ArrayList<IAttributeType> sortedTypes = new ArrayList<IAttributeType>(attributeTypes);
        Collections.sort(sortedTypes, new Comparator<IAttributeType>(){

            @Override
            public int compare(IAttributeType arg0, IAttributeType arg1) {
                IAttributeType t0 = arg0;
                IAttributeType t1 = arg1;
                return t0.getSortCriterium().compareTo((Object)t1.getSortCriterium());
            }
        });
        for (final IAttributeType type : sortedTypes) {
            this.type_currentValue_map.put(type, type.getDataType().getDefaultValue());
            Label label = new Label(base, 0);
            label.setText(type.getDisplayName());
            label.setLayoutData((Object)new GridData());
            IAttributeTypeDataType.ISWTControlForModification control = type.getDataType().createSWTControlForModifying(base, Collections.singleton(new ISWTControlModifiedListener(){

                public void modified(Object newValue, Object additionalInfo) {
                    CreateDataWithUserDefinedAttributeTypesWizardPage.this.type_currentValue_map.put(type, newValue);
                }

                public void setModificationInProgress(boolean modificationInProgress) {
                    if (modificationInProgress) {
                        IModificationProblem problem = CreateDataWithUserDefinedAttributeTypesWizardPage.createModificationInProgressProblem(type);
                        CreateDataWithUserDefinedAttributeTypesWizardPage.this.modificationsInProgress.put(type, problem);
                        CreateDataWithUserDefinedAttributeTypesWizardPage.this.addModificationProblem(problem);
                    } else {
                        IModificationProblem problem = (IModificationProblem)CreateDataWithUserDefinedAttributeTypesWizardPage.this.modificationsInProgress.remove(type);
                        CreateDataWithUserDefinedAttributeTypesWizardPage.this.removeModificationProblem(problem);
                    }
                    if (CreateDataWithUserDefinedAttributeTypesWizardPage.this.wereModificationsInProgress == CreateDataWithUserDefinedAttributeTypesWizardPage.this.modificationsInProgress.isEmpty()) {
                        CreateDataWithUserDefinedAttributeTypesWizardPage.this.wereModificationsInProgress = !CreateDataWithUserDefinedAttributeTypesWizardPage.this.wereModificationsInProgress;
                        CreateDataWithUserDefinedAttributeTypesWizardPage.this.setPageComplete(!CreateDataWithUserDefinedAttributeTypesWizardPage.this.wereModificationsInProgress);
                    }
                }
            }), this.type_currentValue_map.get(type), type.getValueRange());
            boolean hasAttributeModificationPermission = this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(type, this.parentTree, true);
            if (!hasAttributeModificationPermission) {
                control.getControl().setEnabled(false);
                ModificationProblem problem = new ModificationProblem(type, this.parentTree, this.projectAgent);
                this.addModificationProblem(problem);
            } else {
                control.getControl().setEnabled(true);
            }
            this.type_control_map.put(type.getAttributeTypeID(), (Tuple<Label, IAttributeTypeDataType.ISWTControlForModification>)new Tuple((Object)label, (Object)control));
            GridData gridData = new GridData(4, type.getDataType().getSWTVerticalFillHint(), true, type.getDataType().getSWTVerticalFillHint() == 4);
            gridData.heightHint = type.getDataType().getSWTHeightHint();
            control.getControl().setLayoutData((Object)gridData);
        }
        this.noAttributesToShow = new Label(base, 0);
        this.noAttributesToShow.setText(Messages.getString("CreateDataWithUserDefinedAttributeTypesWizardPage.NoAttributesToShow"));
        this.noAttributesToShow.setAlignment(0x1000000);
        this.noAttributesToShow.setVisible(false);
        GridData gd = GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create();
        gd.exclude = true;
        this.noAttributesToShow.setLayoutData((Object)gd);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setContent((Control)base);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                base.setSize(base.computeSize(r.width, -1));
                Rectangle r2 = scrolledComposite.getClientArea();
                base.setSize(base.computeSize(r2.width, -1));
            }
        });
        this.setControl((Control)scrolledComposite);
    }

    private void addModificationProblem(IModificationProblem problem) {
        this.problems.add(problem);
        this.updateMessage();
        this.updateHelpButton();
    }

    private void removeModificationProblem(IModificationProblem problem) {
        this.problems.remove(problem);
        this.updateMessage();
        this.updateHelpButton();
    }

    private void updateHelpButton() {
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog wizardDialog = (ArcwayWizardDialog)container;
            wizardDialog.setHelpEnabled(!this.problems.isEmpty());
        }
    }

    private void updateMessage() {
        int messageSeverity;
        String message = null;
        int severity = 0;
        for (IModificationProblem singleProblem : this.problems) {
            if (message != null && singleProblem.getSeverity() >= severity) continue;
            message = String.valueOf(singleProblem.getHumanReadableDescriptionOfConsequence()) + "\n" + singleProblem.getHumanReadableDescriptionOfCause();
            severity = singleProblem.getSeverity();
        }
        if (message == null) {
            message = DEFAULT_MESSAGE;
        }
        switch (severity) {
            case 2: {
                messageSeverity = 3;
                break;
            }
            case 3: {
                messageSeverity = 2;
                break;
            }
            case 4: {
                messageSeverity = 1;
                break;
            }
            default: {
                messageSeverity = 0;
            }
        }
        this.setMessage(message, messageSeverity);
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        IWizardContainer container = newWizard.getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog wizardDialog = (ArcwayWizardDialog)container;
            wizardDialog.setHelpEnabled(!this.problems.isEmpty());
        }
    }

    public void performHelp() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.problems, this.getShell());
        dialog.open();
    }

    public Collection<IAttribute> getAttributes() {
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        for (Map.Entry<IAttributeType, Object> entry : this.type_currentValue_map.entrySet()) {
            Attribute attribute = new Attribute(entry.getKey().getAttributeTypeID(), entry.getValue());
            attributes.add(attribute);
        }
        return attributes;
    }

    public void disposeResources() {
        for (Tuple<Label, IAttributeTypeDataType.ISWTControlForModification> controls : this.type_control_map.values()) {
            ((IAttributeTypeDataType.ISWTControlForModification)controls.getT2()).dispose();
        }
    }

    public boolean getModificationInProgress() {
        return !this.modificationsInProgress.isEmpty();
    }

    private static IModificationProblem createModificationInProgressProblem(final IAttributeType type) {
        return new IModificationProblem(){

            public int getSeverity() {
                return 4;
            }

            public String getHumanReadableDescriptionOfConsequence() {
                return Messages.getString("CreateDataWithUserDefinedAttributeTypesWizardPage.DialogCannotBeClosed.Reason");
            }

            public String getHumanReadableDescriptionOfCause() {
                return NLS.bind((String)Messages.getString("CreateDataWithUserDefinedAttributeTypesWizardPage.DialogCannotBeClosed.Cause"), (Object)type.getDisplayName());
            }
        };
    }

    public void setHidden(IAttributeTypeID attributeTypeID, boolean hidden) {
        Tuple<Label, IAttributeTypeDataType.ISWTControlForModification> controls = this.type_control_map.get(attributeTypeID);
        Control control = (Control)controls.getT1();
        Object layoutData = control.getLayoutData();
        if (control.getVisible() == hidden) {
            assert (layoutData instanceof GridData) : "GridData expected";
            ((GridData)layoutData).exclude = hidden;
            control.setVisible(!hidden);
            control = ((IAttributeTypeDataType.ISWTControlForModification)controls.getT2()).getControl();
            layoutData = control.getLayoutData();
            assert (layoutData instanceof GridData) : "GridData expected";
            ((GridData)layoutData).exclude = hidden;
            control.setVisible(!hidden);
            if (hidden) {
                ((IAttributeTypeDataType.ISWTControlForModification)controls.getT2()).reset();
            }
        }
    }

    public void showAttributes(Set<IAttributeTypeID> attributesToShow) {
        boolean isAtLeastOneAttributeVisible = false;
        for (Map.Entry<IAttributeTypeID, Tuple<Label, IAttributeTypeDataType.ISWTControlForModification>> singleAttribute : this.type_control_map.entrySet()) {
            this.setHidden(singleAttribute.getKey(), !attributesToShow.contains(singleAttribute.getKey()));
            isAtLeastOneAttributeVisible |= ((Label)singleAttribute.getValue().getT1()).getVisible();
        }
        this.noAttributesToShow.setVisible(!isAtLeastOneAttributeVisible);
        ((GridData)this.noAttributesToShow.getLayoutData()).exclude = isAtLeastOneAttributeVisible;
        this.scrolledBase.layout(true, true);
    }

    @Override
    public void categoryChanged(ObjectTypeCategory category) {
        if (category != null) {
            this.showAttributes(category.getAttributeList());
        } else {
            this.showAttributes(this.type_control_map.keySet());
        }
    }
}

