/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipTable;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTableData;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UniqueElementRelationshipTable
implements IUniqueElementRelationshipTable {
    private final Map<String, UniqueElementRelationshipTableData> typeToUERelationshipTableData = new HashMap<String, UniqueElementRelationshipTableData>();

    public UniqueElementRelationshipTable() {
    }

    public UniqueElementRelationshipTable(Collection<EOUniqueElementRelationship> relationships) {
        this();
        for (EOUniqueElementRelationship relationship : relationships) {
            this.addRelationship(relationship);
        }
    }

    @Override
    public void addRelationship(EOUniqueElementRelationship relationship) {
        String relationshipType = relationship.getRelationshipTypeID();
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData == null) {
            ueRelTableData = new UniqueElementRelationshipTableData();
            this.typeToUERelationshipTableData.put(relationshipType, ueRelTableData);
        }
        ueRelTableData.addData(relationship);
    }

    @Override
    public Collection<String> getNextUniqueElementsUIDs(String elementUID, String relationshipType) {
        Set<String> children;
        Set<String> foundChildren = Collections.emptySet();
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null && (children = ueRelTableData.getDirectNextElementUIDs(elementUID)) != null) {
            foundChildren = children;
        }
        return foundChildren;
    }

    @Override
    public Collection<String> getPreviousUniqueElementsUIDs(String elementUID, String relationshipType) {
        Set<String> parents;
        Set<String> foundParents = Collections.emptySet();
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null && (parents = ueRelTableData.getDirectPreviousElementUIDs(elementUID)) != null) {
            foundParents = parents;
        }
        return foundParents;
    }

    @Override
    public Collection<EOUniqueElementRelationship> getRelationshipsByType(String relationshipType) {
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            Set<Object> relationshipsOfType = ueRelTableData.getRelationships();
            if (relationshipsOfType == null) {
                relationshipsOfType = Collections.emptySet();
            }
            return relationshipsOfType;
        }
        return Collections.emptySet();
    }

    @Override
    public boolean doesRelationshipExist(String predecessorElement, String successorElement, String relationshipType) {
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            return ueRelTableData.doesRelationshipExist(predecessorElement, successorElement);
        }
        return false;
    }

    @Override
    public Collection<EOUniqueElementRelationship> getAllRelationships() {
        HashSet<EOUniqueElementRelationship> allRelationships = new HashSet<EOUniqueElementRelationship>();
        for (UniqueElementRelationshipTableData ueRelTableData : this.typeToUERelationshipTableData.values()) {
            Set<Object> relationshipsOfType = ueRelTableData.getRelationships();
            if (relationshipsOfType == null) {
                relationshipsOfType = Collections.emptySet();
            }
            allRelationships.addAll(relationshipsOfType);
        }
        return allRelationships;
    }

    @Override
    public boolean isEmpty() {
        return this.typeToUERelationshipTableData.isEmpty();
    }

    @Override
    public Collection<String> getAllNextUniqueElementUIDs(String elementUID, String relationshipType) {
        HashSet<String> setToAddAllNextElements = new HashSet<String>();
        this.addAllNextUniqueElementsUIDs(elementUID, setToAddAllNextElements, relationshipType);
        return setToAddAllNextElements;
    }

    @Override
    public Collection<String> getAllPreviousUniqueElementUIDs(String elementUID, String relationshipType) {
        HashSet<String> setToAddAllPreviousElements = new HashSet<String>();
        this.addAllPreviousUniqueElementsUIDs(elementUID, setToAddAllPreviousElements, relationshipType);
        return setToAddAllPreviousElements;
    }

    @Override
    public boolean isPartOfCycle(String elementUID, String relationshipType) {
        boolean isPartOfCycle = false;
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            isPartOfCycle = ueRelTableData.isPartOfCycle(elementUID);
        }
        return isPartOfCycle;
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(String elementUID, String relationshipType) {
        CyclicUERelationshipIdentifier.Cycle cycle = null;
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            cycle = ueRelTableData.getCycle(elementUID);
        }
        return cycle;
    }

    @Override
    public Set<CyclicUERelationshipIdentifier.Cycle> getRootCycles(String relationshipType) {
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            return ueRelTableData.getRootCycles();
        }
        return Collections.emptySet();
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(Set<String> elements, String relationshipType) {
        CyclicUERelationshipIdentifier.Cycle cycle = null;
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueRelTableData != null) {
            cycle = ueRelTableData.getCycle(elements);
        }
        return cycle;
    }

    private void addAllNextUniqueElementsUIDs(String elementUID, Set<String> setToAddAllNextElements, String relationShipType) {
        Set<String> currentElementUIDs = new HashSet<String>();
        currentElementUIDs.add(elementUID);
        while (!currentElementUIDs.isEmpty()) {
            Set<String> directNextElements = this.getDirectNextUniqueElementsUIDs(currentElementUIDs, relationShipType);
            directNextElements.removeAll(setToAddAllNextElements);
            setToAddAllNextElements.addAll(directNextElements);
            currentElementUIDs = directNextElements;
        }
    }

    private Set<String> getDirectNextUniqueElementsUIDs(Collection<String> elementUIDs, String relationshipType) {
        HashSet<String> directNextElements = new HashSet<String>();
        for (String elementUID : elementUIDs) {
            directNextElements.addAll(this.getNextUniqueElementsUIDs(elementUID, relationshipType));
        }
        return directNextElements;
    }

    private void addAllPreviousUniqueElementsUIDs(String elementUID, Set<String> setToAddAllPreviousElements, String relationshipType) {
        Set<String> currentElementUIDs = new HashSet<String>();
        currentElementUIDs.add(elementUID);
        while (!currentElementUIDs.isEmpty()) {
            Set<String> directPreviousElements = this.getDirectPreviousUniqueElementsUIDs(currentElementUIDs, relationshipType);
            directPreviousElements.removeAll(setToAddAllPreviousElements);
            setToAddAllPreviousElements.addAll(directPreviousElements);
            currentElementUIDs = directPreviousElements;
        }
    }

    private Set<String> getDirectPreviousUniqueElementsUIDs(Collection<String> elementUIDs, String relationshipType) {
        HashSet<String> directPreviousElements = new HashSet<String>();
        for (String elementUID : elementUIDs) {
            directPreviousElements.addAll(this.getPreviousUniqueElementsUIDs(elementUID, relationshipType));
        }
        return directPreviousElements;
    }

    @Override
    public Collection<String> getFirstUniqueElementUIDs_byACu(String relationshipType) {
        HashSet<String> allFirstElements = new HashSet<String>();
        HashSet<String> directFirstElements = new HashSet<String>();
        UniqueElementRelationshipTableData ueReltableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueReltableData != null) {
            Set<String> allNextElements = ueReltableData.getAllNextElementUIDs();
            for (String previousElementUID : ueReltableData.getAllPreviousElementUIDs()) {
                if (allNextElements.contains(previousElementUID)) continue;
                directFirstElements.add(previousElementUID);
            }
            this.aquireAllFirstElements(directFirstElements, allFirstElements, this.getAllElements(relationshipType), relationshipType);
        }
        return allFirstElements;
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElementUIDs(Collection<? extends IUniqueElement> allUniqueElements, String relationshipType) {
        ArrayList<IUniqueElement> firstUniqueElements = new ArrayList<IUniqueElement>(allUniqueElements);
        UniqueElementRelationshipTableData ueReltableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueReltableData != null) {
            Set<String> allNextElements = ueReltableData.getAllNextElementUIDs();
            Iterator uniqueElementIterator = firstUniqueElements.iterator();
            while (uniqueElementIterator.hasNext()) {
                IUniqueElement uniqueElement = (IUniqueElement)uniqueElementIterator.next();
                if (!allNextElements.contains(uniqueElement.getUID())) continue;
                uniqueElementIterator.remove();
            }
        }
        return firstUniqueElements;
    }

    @Override
    public Collection<String> getLastUniqueElementUIDs(String relationshipType) {
        HashSet<String> allLastElements = new HashSet<String>();
        HashSet<String> directLastElements = new HashSet<String>();
        UniqueElementRelationshipTableData ueReltableData = this.typeToUERelationshipTableData.get(relationshipType);
        if (ueReltableData != null) {
            Set<String> allPreviousElements = ueReltableData.getAllPreviousElementUIDs();
            for (String nextElementUID : ueReltableData.getAllNextElementUIDs()) {
                if (allPreviousElements.contains(nextElementUID)) continue;
                directLastElements.add(nextElementUID);
            }
            this.aquireAllLastElements(directLastElements, allLastElements, this.getAllElements(relationshipType), relationshipType);
        }
        return allLastElements;
    }

    private Set<String> getAllElements(String relationshipType) {
        UniqueElementRelationshipTableData ueRelTableData = this.typeToUERelationshipTableData.get(relationshipType);
        HashSet<String> allElements = new HashSet<String>(ueRelTableData.getAllPreviousElementUIDs());
        allElements.addAll(ueRelTableData.getAllNextElementUIDs());
        return allElements;
    }

    private void aquireAllFirstElements(Collection<String> directFirstElements, Collection<String> allFirstElements, Collection<String> notYetReachedElements, String relationshipType) {
        allFirstElements.addAll(directFirstElements);
        this.traverseToNextElement(directFirstElements, notYetReachedElements, relationshipType);
        if (!notYetReachedElements.isEmpty()) {
            String aquiredFirstElement = this.chooseElementUIDToHandle(notYetReachedElements);
            HashSet<String> currentDirectFirstElement = new HashSet<String>();
            currentDirectFirstElement.add(aquiredFirstElement);
            this.aquireAllFirstElements(currentDirectFirstElement, allFirstElements, notYetReachedElements, relationshipType);
        }
    }

    private void traverseToNextElement(Collection<String> firstElements, Collection<String> notYetReachedElements, String relationshipType) {
        for (String firstElementUID : firstElements) {
            if (!notYetReachedElements.contains(firstElementUID)) continue;
            notYetReachedElements.remove(firstElementUID);
            this.traverseToNextElement(this.getNextUniqueElementsUIDs(firstElementUID, relationshipType), notYetReachedElements, relationshipType);
        }
    }

    private void aquireAllLastElements(Collection<String> directLastElements, Collection<String> allLastElements, Collection<String> notYetReachedElements, String relationshipType) {
        allLastElements.addAll(directLastElements);
        this.traverseToPreviousElement(directLastElements, notYetReachedElements, relationshipType);
        if (!notYetReachedElements.isEmpty()) {
            String aquiredLastElement = this.chooseElementUIDToHandle(notYetReachedElements);
            HashSet<String> currentDirectLastElement = new HashSet<String>();
            currentDirectLastElement.add(aquiredLastElement);
            this.aquireAllLastElements(currentDirectLastElement, allLastElements, notYetReachedElements, relationshipType);
        }
    }

    private void traverseToPreviousElement(Collection<String> lastElements, Collection<String> notYetReachedElements, String relationshipType) {
        for (String lastElementUID : lastElements) {
            if (!notYetReachedElements.contains(lastElementUID)) continue;
            notYetReachedElements.remove(lastElementUID);
            this.traverseToPreviousElement(this.getPreviousUniqueElementsUIDs(lastElementUID, relationshipType), notYetReachedElements, relationshipType);
        }
    }

    private String chooseElementUIDToHandle(Collection<String> elementUIDs) {
        String result = null;
        for (String currentElement : elementUIDs) {
            if (result != null && currentElement.compareTo(result) >= 0) continue;
            result = currentElement;
        }
        return result;
    }
}

