/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTable;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import java.util.Collection;
import java.util.Map;

public abstract class UniqueElementRelationshipStorage {
    protected UniqueElementRelationshipStorage() {
    }

    public void cleanUp() {
        this.getRelationshipStore().clear();
    }

    public boolean isDataStored() {
        return !this.getRelationshipStore().isEmpty();
    }

    public void setRelationshipsForPlan(String planUID, Collection<EOUniqueElementRelationship> relationshipsToSet) {
        this.getRelationshipStore().put(planUID, new UniqueElementRelationshipTable(relationshipsToSet));
    }

    public void removeRelationshipsForPlan(String planUID) {
        this.getRelationshipStore().remove(planUID);
    }

    public boolean containsRelationshipForPlan(String planUID) {
        return this.getRelationshipStore().containsKey(planUID);
    }

    public Collection<EOUniqueElementRelationship> getAllRelationships(String planUID) {
        Collection<EOUniqueElementRelationship> foundRelationships = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundRelationships = this.getRelationshipStore().get(planUID).getAllRelationships();
        }
        return foundRelationships;
    }

    public Collection<EOUniqueElementRelationship> getRelationshipsByType(String planUID, String relationshipType) {
        Collection<EOUniqueElementRelationship> foundRelationships = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundRelationships = this.getRelationshipStore().get(planUID).getRelationshipsByType(relationshipType);
        }
        return foundRelationships;
    }

    public Collection<String> getNextUniqueElementsOnPlan(String planUID, String relationshipType, String elementUID) {
        Collection<String> foundNextElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundNextElements = this.getRelationshipStore().get(planUID).getNextUniqueElementsUIDs(elementUID, relationshipType);
        }
        return foundNextElements;
    }

    public Collection<String> getAllNextUniqueElementsOnPlan(String planUID, String relationshipType, String elementUID) {
        Collection<String> foundNextElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundNextElements = this.getRelationshipStore().get(planUID).getAllNextUniqueElementUIDs(elementUID, relationshipType);
        }
        return foundNextElements;
    }

    public Collection<String> getPreviousUniqueElementsOnPlan(String planUID, String relationshipType, String elementUID) {
        Collection<String> foundPreviousElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundPreviousElements = this.getRelationshipStore().get(planUID).getPreviousUniqueElementsUIDs(elementUID, relationshipType);
        }
        return foundPreviousElements;
    }

    public Collection<String> getAllPreviousUniqueElementsOnPlan(String planUID, String relationshipType, String elementUID) {
        Collection<String> foundPreviousElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundPreviousElements = this.getRelationshipStore().get(planUID).getAllPreviousUniqueElementUIDs(elementUID, relationshipType);
        }
        return foundPreviousElements;
    }

    public Collection<String> getLastUniqueElementUIDsOnPlan(String planUID, String relationshipType) {
        Collection<String> foundLastElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundLastElements = this.getRelationshipStore().get(planUID).getLastUniqueElementUIDs(relationshipType);
        }
        return foundLastElements;
    }

    public Collection<String> getFirstUniqueElementUIDsOnPlan(String planUID, String relationshipType) {
        Collection<String> foundFirstElements = null;
        if (this.containsRelationshipForPlan(planUID)) {
            foundFirstElements = this.getRelationshipStore().get(planUID).getFirstUniqueElementUIDs_byACu(relationshipType);
        }
        return foundFirstElements;
    }

    protected abstract Map<String, UniqueElementRelationshipTable> getRelationshipStore();
}

