/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipStorage;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTable;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UniqueElementRelationshipServerCache
extends UniqueElementRelationshipStorage {
    private final Map<String, UniqueElementRelationshipTable> planUIDToRelationships = new HashMap<String, UniqueElementRelationshipTable>();

    public void initialize(Collection<EOUniqueElementRelationship> relationshipsToSetup) {
        this.cleanUp();
        for (EOUniqueElementRelationship relationship : relationshipsToSetup) {
            String planUID = relationship.getPlanUID();
            UniqueElementRelationshipTable relationshipsOfPlan = this.planUIDToRelationships.get(planUID);
            if (relationshipsOfPlan == null) {
                relationshipsOfPlan = new UniqueElementRelationshipTable();
                this.planUIDToRelationships.put(planUID, relationshipsOfPlan);
            }
            relationshipsOfPlan.addRelationship(relationship);
        }
    }

    @Override
    protected Map<String, UniqueElementRelationshipTable> getRelationshipStore() {
        return this.planUIDToRelationships;
    }
}

