/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IUniqueElementRelationshipManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementOccurrenceMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipDataProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipType;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipModificationMgr;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipProviderManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipServerCache;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTable;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.UniqueElementRelationshipTypes;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationshipModification;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentStructuredPlanElement;
import de.plans.lib.xml.encoding.EOList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UniqueElementRelationshipMgr
implements IUniqueElementRelationshipManager,
IUniqueElementRelationshipDataProvider,
IFrameDataManager {
    private ProjectAgent projectAgent;
    private UniqueElementRelationshipServerCache uniqueElementRelationshipServerCache;
    private UniqueElementRelationshipModificationMgr uniqueElementRelationshipModMgr;
    private UniqueElementRelationshipProviderManager uniqueElementRelationshipProviderMgr;
    private UniqueElementRelationshipTable cachedRelationshipsOfAllPlans = null;
    private UniqueElementMgr uniqueElementMgr;
    private final Map<IUniqueElement, HashSet<IPlan>> cacheForRefiningPlans = new HashMap<IUniqueElement, HashSet<IPlan>>();

    public static Collection<EOUniqueElementRelationship> getUniqueElementRelationshipsForPlan(IUniqueElementOccurrenceMgr uniqueElementOccurenceMgr, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements) {
        return UniqueElementRelationshipMgr.getUniqueElementRelationshipsForPlan(uniqueElementOccurenceMgr, structuredPlanElements, UniqueElementRelationshipTypes.ALL_RELATIONSHIP_TYPES);
    }

    public static Collection<EOUniqueElementRelationship> getUniqueElementRelationshipsForPlan(IUniqueElementOccurrenceMgr uniqueElementOccurenceMgr, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements, Collection<IUniqueElementRelationshipType> ueRelationshipTypes) {
        HashSet<EOUniqueElementRelationship> relationships = new HashSet<EOUniqueElementRelationship>();
        for (IPlanAgentStructuredPlanElement iPlanAgentStructuredPlanElement : structuredPlanElements) {
            for (IUniqueElementRelationshipType ueRelType : ueRelationshipTypes) {
                relationships.addAll(UniqueElementRelationshipProvider.resolvePEStructureToUERelationships(iPlanAgentStructuredPlanElement, ueRelType, uniqueElementOccurenceMgr));
            }
        }
        return relationships;
    }

    public void construct(ProjectAgent newProjectAgent) {
        this.projectAgent = newProjectAgent;
        this.uniqueElementMgr = newProjectAgent.getUniqueElementMgr();
        this.uniqueElementRelationshipProviderMgr = new UniqueElementRelationshipProviderManager(this);
    }

    @Override
    public void writeUniqueElementRelationships(String planUID) {
        this.uniqueElementRelationshipModMgr.writeUniqueElementRelationships(planUID);
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.initializeUniqueElementRelationshipServerCache(serverDataContainer);
        this.uniqueElementRelationshipModMgr = new UniqueElementRelationshipModificationMgr(this.projectAgent);
        this.uniqueElementRelationshipModMgr.initialize();
        this.flushContainmentCaches();
    }

    private void initializeUniqueElementRelationshipServerCache(ServerDataContainer serverDataContainer) {
        Collection<EOUniqueElementRelationship> relationships = serverDataContainer.getUniqueElementRelationships();
        if (relationships == null) {
            relationships = Collections.emptyList();
        }
        this.uniqueElementRelationshipServerCache = new UniqueElementRelationshipServerCache();
        this.uniqueElementRelationshipServerCache.initialize(relationships);
        this.flushContainmentCaches();
    }

    private void flushContainmentCaches() {
        this.cachedRelationshipsOfAllPlans = null;
        this.cacheForRefiningPlans.clear();
    }

    @Override
    public UniqueElementRelationshipProviderManager getUERelationshipProviderManager() {
        return this.uniqueElementRelationshipProviderMgr;
    }

    @Override
    public void reloadUniqueElementRelationships(String planUID) {
        assert (planUID != null) : "planUID can't be null";
        this.uniqueElementRelationshipModMgr.loadUERelationshipsForPlan(planUID);
        this.flushContainmentCaches();
        this.projectAgent.getPlanEditorManager().updateInvalidPlanElements();
    }

    @Override
    public EOList<EOUniqueElementRelationship> getModifiedUniqueElementRelationshipsForPlan(String planUID) {
        EOList relationships = null;
        if (this.uniqueElementRelationshipModMgr.containsRelationshipForPlan(planUID)) {
            relationships = new EOList(this.uniqueElementRelationshipModMgr.getAllRelationships(planUID));
        }
        return relationships;
    }

    @Override
    public void uniqueElementOccurrencesOrPlanStructureChanged_internal(String planUID, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements) {
        this.updateUniqueElementRelationshipsForPlan(planUID, structuredPlanElements);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(), EOUniqueElementRelationship.class);
        this.projectAgent.getPlanEditorManager().updateInvalidPlanElements();
        this.projectAgent.getPlanEditorManager().updateDecorators();
    }

    private void updateUniqueElementRelationshipsForPlan(final String planUID, Collection<? extends IPlanAgentStructuredPlanElement> structuredPlanElements) {
        if (structuredPlanElements != null) {
            IUniqueElementOccurrenceMgr uniqueElementOccurenceMgr = new IUniqueElementOccurrenceMgr(){

                @Override
                public String getPlanUID() {
                    return planUID;
                }

                @Override
                public String getProjectUID() {
                    return UniqueElementRelationshipMgr.this.uniqueElementMgr.getProjectAgent().getProjectUID();
                }

                @Override
                public String getUIDOfRelatedUniqueElement(String planElementUID) {
                    IUniqueElement uniqueElement = UniqueElementRelationshipMgr.this.uniqueElementMgr.getUniqueElementOfOccurrence(planUID, planElementUID);
                    String uniqueElementUID = uniqueElement != null ? uniqueElement.getUID() : null;
                    return uniqueElementUID;
                }
            };
            Collection<EOUniqueElementRelationship> relationships = UniqueElementRelationshipMgr.getUniqueElementRelationshipsForPlan(uniqueElementOccurenceMgr, structuredPlanElements);
            this.setRelationships(planUID, relationships);
        }
    }

    private void setRelationships(String planUID, Collection<EOUniqueElementRelationship> relationships) {
        assert (planUID != null) : "planUID can't be null";
        assert (relationships != null) : "containmentList can't be null";
        if (this.uniqueElementRelationshipServerCache.containsRelationshipForPlan(planUID)) {
            Collection<EOUniqueElementRelationship> cachedList = this.uniqueElementRelationshipServerCache.getAllRelationships(planUID);
            if (!relationships.isEmpty() && cachedList.containsAll(relationships)) {
                this.uniqueElementRelationshipModMgr.removeRelationshipsForPlan(planUID);
            } else {
                this.uniqueElementRelationshipModMgr.setRelationshipsForPlan(planUID, relationships);
            }
        } else if (relationships.isEmpty()) {
            this.uniqueElementRelationshipModMgr.removeRelationshipsForPlan(planUID);
        } else {
            this.uniqueElementRelationshipModMgr.setRelationshipsForPlan(planUID, relationships);
        }
        this.flushContainmentCaches();
    }

    @Override
    public EOList<EOUniqueElementRelationship> getAllRelationshipsOfProject() {
        return new EOList(this.getUniqueElementRelationshipsOfAllPlans().getAllRelationships());
    }

    private UniqueElementRelationshipTable getUniqueElementRelationshipsOfAllPlans() {
        if (this.cachedRelationshipsOfAllPlans == null) {
            EOList relationships = new EOList();
            for (IPlan iPlan : this.projectAgent.getFrameSectionManager().getPlans()) {
                String planUID = iPlan.getUID();
                relationships.addAll(this.getAllRelationshipsOfPlan(planUID));
            }
            this.cachedRelationshipsOfAllPlans = new UniqueElementRelationshipTable((Collection<EOUniqueElementRelationship>)relationships);
        }
        return this.cachedRelationshipsOfAllPlans;
    }

    private Collection<EOUniqueElementRelationship> getAllRelationshipsOfPlan(String planUID) {
        Collection<EOUniqueElementRelationship> relationships = this.uniqueElementRelationshipModMgr.getAllRelationships(planUID);
        if (relationships == null) {
            relationships = this.uniqueElementRelationshipServerCache.getAllRelationships(planUID);
        }
        return relationships == null ? Collections.emptyList() : relationships;
    }

    @Override
    public boolean doesRelationshipExist(String predecessorElement, String successorElement, String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().doesRelationshipExist(predecessorElement, successorElement, relationshipType);
    }

    @Override
    public boolean isPartOfCycle(String uniqueElementUID, String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().isPartOfCycle(uniqueElementUID, relationshipType);
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(String uniqueElementUID, String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().getCycle(uniqueElementUID, relationshipType);
    }

    @Override
    public Set<CyclicUERelationshipIdentifier.Cycle> getRootCycles(String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().getRootCycles(relationshipType);
    }

    @Override
    public CyclicUERelationshipIdentifier.Cycle getCycle(Set<String> elements, String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().getCycle(elements, relationshipType);
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElements_byACu(String relationshipType) {
        ArrayList<IUniqueElement> firstUniqueElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getFirstUniqueElementUIDs_byACu(relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            firstUniqueElements.add(uniqueElement);
        }
        return firstUniqueElements;
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElements(String relationshipType) {
        return this.getUniqueElementRelationshipsOfAllPlans().getFirstUniqueElementUIDs(this.uniqueElementMgr.getUniqueElements(), relationshipType);
    }

    @Override
    public Collection<IUniqueElement> getLastUniqueElements(String relationshipType) {
        ArrayList<IUniqueElement> lastUniqueElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getLastUniqueElementUIDs(relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            lastUniqueElements.add(uniqueElement);
        }
        return lastUniqueElements;
    }

    @Override
    public Collection<IUniqueElement> getPreviousUniqueElements(String elementUID, String relationshipType) {
        ArrayList<IUniqueElement> previousUniqueElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getPreviousUniqueElementsUIDs(elementUID, relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            previousUniqueElements.add(uniqueElement);
        }
        return previousUniqueElements;
    }

    @Override
    public Collection<IUniqueElement> getAllPreviousUniqueElements(String elementUID, String relationshipType) {
        ArrayList<IUniqueElement> allPreviousElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getAllPreviousUniqueElementUIDs(elementUID, relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            allPreviousElements.add(uniqueElement);
        }
        return allPreviousElements;
    }

    @Override
    public Collection<IUniqueElement> getNextUniqueElements(String parentElementUID, String relationshipType) {
        ArrayList<IUniqueElement> nextUniqueElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getNextUniqueElementsUIDs(parentElementUID, relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            nextUniqueElements.add(uniqueElement);
        }
        return nextUniqueElements;
    }

    @Override
    public Collection<IUniqueElement> getAllNextUniqueElements(String elementUID, String relationshipType) {
        ArrayList<IUniqueElement> allNextElements = new ArrayList<IUniqueElement>();
        for (String uid : this.getUniqueElementRelationshipsOfAllPlans().getAllNextUniqueElementUIDs(elementUID, relationshipType)) {
            IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
            if (uniqueElement == null) continue;
            allNextElements.add(uniqueElement);
        }
        return allNextElements;
    }

    @Override
    public Collection<IUniqueElement> getFirstUniqueElementsOnPlan(String planUID, String relationshipType) {
        Collection<String> foundFirstUEUIDs = this.uniqueElementRelationshipModMgr.getFirstUniqueElementUIDsOnPlan(planUID, relationshipType);
        if (foundFirstUEUIDs == null) {
            foundFirstUEUIDs = this.uniqueElementRelationshipServerCache.getFirstUniqueElementUIDsOnPlan(planUID, relationshipType);
        }
        return this.getUniqueElementsForUIDs(foundFirstUEUIDs);
    }

    @Override
    public Collection<IUniqueElement> getLastUniqueElementsOnPlan(String planUID, String relationshipType) {
        Collection<String> foundLastUEUIDs = this.uniqueElementRelationshipModMgr.getLastUniqueElementUIDsOnPlan(planUID, relationshipType);
        if (foundLastUEUIDs == null) {
            foundLastUEUIDs = this.uniqueElementRelationshipServerCache.getLastUniqueElementUIDsOnPlan(planUID, relationshipType);
        }
        return this.getUniqueElementsForUIDs(foundLastUEUIDs);
    }

    @Override
    public Collection<IUniqueElement> getNextUniqueElementsOnPlan(String parentElementUID, String planUID, String relationshipType) {
        Collection<String> foundNextUEUIDs = this.uniqueElementRelationshipModMgr.getNextUniqueElementsOnPlan(planUID, relationshipType, parentElementUID);
        if (foundNextUEUIDs == null) {
            foundNextUEUIDs = this.uniqueElementRelationshipServerCache.getNextUniqueElementsOnPlan(planUID, relationshipType, parentElementUID);
        }
        return this.getUniqueElementsForUIDs(foundNextUEUIDs);
    }

    @Override
    public Collection<IUniqueElement> getAllNextUniqueElementsOnPlan(String parentElementUID, String planUID, String relationshipType) {
        Collection<String> foundNextUEUIDs = this.uniqueElementRelationshipModMgr.getAllNextUniqueElementsOnPlan(planUID, relationshipType, parentElementUID);
        if (foundNextUEUIDs == null) {
            foundNextUEUIDs = this.uniqueElementRelationshipServerCache.getAllNextUniqueElementsOnPlan(planUID, relationshipType, parentElementUID);
        }
        return this.getUniqueElementsForUIDs(foundNextUEUIDs);
    }

    @Override
    public Collection<IUniqueElement> getPreviousUniqueElementsOnPlan(String elementUID, String planUID, String relationshipType) {
        Collection<String> foundPreviousUEUIDs = this.uniqueElementRelationshipModMgr.getPreviousUniqueElementsOnPlan(planUID, relationshipType, elementUID);
        if (foundPreviousUEUIDs == null) {
            foundPreviousUEUIDs = this.uniqueElementRelationshipServerCache.getPreviousUniqueElementsOnPlan(planUID, relationshipType, elementUID);
        }
        return this.getUniqueElementsForUIDs(foundPreviousUEUIDs);
    }

    @Override
    public Collection<IUniqueElement> getAllPreviousUniqueElementsOnPlan(String elementUID, String planUID, String relationshipType) {
        Collection<String> foundPreviousUEUIDs = this.uniqueElementRelationshipModMgr.getAllPreviousUniqueElementsOnPlan(planUID, relationshipType, elementUID);
        if (foundPreviousUEUIDs == null) {
            foundPreviousUEUIDs = this.uniqueElementRelationshipServerCache.getAllPreviousUniqueElementsOnPlan(planUID, relationshipType, elementUID);
        }
        return this.getUniqueElementsForUIDs(foundPreviousUEUIDs);
    }

    private Collection<IUniqueElement> getUniqueElementsForUIDs(Collection<String> uids) {
        ArrayList<IUniqueElement> uniqueElements = new ArrayList<IUniqueElement>();
        if (uids != null) {
            for (String uid : uids) {
                IUniqueElement uniqueElement = this.uniqueElementMgr.getUniqueElement(uid);
                if (uniqueElement == null) continue;
                uniqueElements.add(uniqueElement);
            }
        }
        return uniqueElements;
    }

    @Override
    public void applySynchronousUniqueElementRelationshipChanges(Collection<EOUniqueElementRelationshipModification> modifications) {
        if (modifications != null) {
            for (EOUniqueElementRelationshipModification mod : modifications) {
                String planUID = mod.getPlan().getUID();
                this.uniqueElementRelationshipServerCache.setRelationshipsForPlan(planUID, (Collection<EOUniqueElementRelationship>)mod.getRelationships());
                this.uniqueElementRelationshipModMgr.removeRelationshipsForPlan(planUID);
                this.uniqueElementRelationshipModMgr.writeUniqueElementRelationships(planUID);
                this.flushContainmentCaches();
            }
        }
    }

    @Override
    public void applyAsynchronousUniqueElementRelationshipChanges(Collection<EOUniqueElementRelationshipModification> modifications) {
        for (EOUniqueElementRelationshipModification mod : modifications) {
            this.uniqueElementRelationshipServerCache.setRelationshipsForPlan(mod.getPlan().getUID(), (Collection<EOUniqueElementRelationship>)mod.getRelationships());
            this.flushContainmentCaches();
        }
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)new PropertyChanges(true), IUniqueElement.class);
    }

    @Override
    public void planDeletedOnClient(String planUID) {
        this.uniqueElementRelationshipModMgr.removeRelationshipsForPlan(planUID);
        this.uniqueElementRelationshipModMgr.writeUniqueElementRelationships(planUID);
        this.flushContainmentCaches();
    }

    @Override
    public void planDeletedOnServerAsynchronously(String planUID) {
        this.uniqueElementRelationshipServerCache.removeRelationshipsForPlan(planUID);
        this.flushContainmentCaches();
    }

    @Override
    public void planDeletedOnServerSynchronously(String planUID) {
        this.uniqueElementRelationshipServerCache.removeRelationshipsForPlan(planUID);
    }

    @Override
    public Collection<? extends IPlan> getRefiningPlans(IUniqueElement uniqueElement) {
        HashSet<IPlan> refiningPlans = this.cacheForRefiningPlans.get(uniqueElement);
        if (refiningPlans == null) {
            refiningPlans = new HashSet();
            Collection<IPlan> plansWithOccurence = this.uniqueElementMgr.getPlansOfUniqueElement(uniqueElement);
            for (IPlan plan : plansWithOccurence) {
                IUniqueElementRelationshipProvider conRelshipProvider = this.uniqueElementRelationshipProviderMgr.getContainmentRelationshipProvider();
                if (conRelshipProvider.getNextUniqueElementsOnPlan(uniqueElement.getUID(), plan.getUID()).isEmpty()) continue;
                refiningPlans.add(plan);
            }
            this.cacheForRefiningPlans.put(uniqueElement, refiningPlans);
        }
        return refiningPlans;
    }

    @Override
    public boolean isRefiningPlan(IUniqueElement element, IPlan plan) {
        return this.getRefiningPlans(element).contains(plan);
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return "Unique Element Relationship Manager";
    }

    @Override
    public void discardLocalModifications() {
        this.uniqueElementRelationshipModMgr.cleanUp();
        this.flushContainmentCaches();
    }

    @Override
    public boolean hasLocalModifications() {
        return this.uniqueElementRelationshipModMgr != null && this.uniqueElementRelationshipModMgr.isDataStored();
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        return false;
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        return null;
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> dataTypeClazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public Collection<? extends IAttributeOwner> getData() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        throw new UnsupportedOperationException();
    }
}

