/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements.detailsprovider;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ContainingPlansContentProvider
implements ITreeContentProvider {
    private static final ILogger logger = Logger.getLogger(ContainingPlansContentProvider.class);
    private static final Object[] emptyObjectArray = new Object[0];
    private static final HashMap<Object, TreeContentElementEntry> emptyTreeContent = new HashMap();
    HashMap<Object, TreeContentElementEntry> treeContent = emptyTreeContent;

    public ContainingPlansContentProvider(IUniqueElement uniqueElement) {
        this.calculateTreeContent(uniqueElement);
    }

    private void clearContent() {
        this.treeContent = emptyTreeContent;
    }

    private void calculateTreeContent(IUniqueElement uniqueElement) {
        this.clearContent();
        if (uniqueElement != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(uniqueElement.getProjectUID());
            IFrameSectionManager sectionManager = projectAgent.getFrameSectionManager();
            Collection<? extends IPlan> plansToShow = projectAgent.getFrameUniqueElementMgr().getPlansOfUniqueElement(uniqueElement);
            this.treeContent = new HashMap(plansToShow.size() * 3);
            TreeContentElementEntry rootEntry = new TreeContentElementEntry(null);
            this.treeContent.put(projectAgent, rootEntry);
            for (IPlan iPlan : plansToShow) {
                ISection section = sectionManager.getSection(iPlan.getSectionUID());
                IPermissionOperand planParent = section == null || section.isRootSection() ? projectAgent : section;
                TreeContentElementEntry planEntry = new TreeContentElementEntry(planParent);
                this.treeContent.put(iPlan, planEntry);
                while (section != null && !section.isRootSection() && !this.treeContent.containsKey(section)) {
                    ISection parentSection = sectionManager.getParentSection(section);
                    IPermissionOperand sectionParent = parentSection == null || parentSection.isRootSection() ? projectAgent : parentSection;
                    TreeContentElementEntry sectionEntry = new TreeContentElementEntry(sectionParent);
                    this.treeContent.put(section, sectionEntry);
                    section = parentSection;
                }
            }
            for (Map.Entry entry : this.treeContent.entrySet()) {
                Object entryParent = ((TreeContentElementEntry)entry.getValue()).getParent();
                if (entryParent == null) continue;
                TreeContentElementEntry parentEntry = this.treeContent.get(entryParent);
                if (parentEntry == null) {
                    parentEntry = rootEntry;
                    logger.debug("problem while calculation ContainingPlans tree viewer contents");
                }
                parentEntry.addChild(entry.getKey());
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] result = emptyObjectArray;
        TreeContentElementEntry entry = this.treeContent.get(parentElement);
        if (entry == null) {
            logger.debug("problem while calculation ContainingPlans tree viewer contents");
        } else {
            result = entry.getChildren();
        }
        return result;
    }

    public Object getParent(Object element) {
        Object result = null;
        TreeContentElementEntry entry = this.treeContent.get(element);
        if (entry == null) {
            logger.debug("problem while calculation ContainingPlans tree viewer contents");
        } else {
            result = entry.getParent();
        }
        return result;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        this.clearContent();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private static class TreeContentElementEntry {
        private final Object parent;
        private Object[] children = null;

        public TreeContentElementEntry(Object parent) {
            this.parent = parent;
        }

        public void addChild(Object childToAdd) {
            if (this.children == null) {
                this.children = new Object[1];
                this.children[0] = childToAdd;
            } else {
                Object[] oldChildren = this.children;
                this.children = new Object[oldChildren.length + 1];
                System.arraycopy(oldChildren, 0, this.children, 0, oldChildren.length);
                this.children[oldChildren.length] = childToAdd;
            }
        }

        public Object getParent() {
            return this.parent;
        }

        public Object[] getChildren() {
            if (this.children == null) {
                return emptyObjectArray;
            }
            return this.children;
        }
    }
}

