/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementOccurrence;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class UniqueElementOccurrenceCache {
    private static final ILogger logger = Logger.getLogger(UniqueElementOccurrenceCache.class);
    private final Map<String, Map<String, EOUniqueElementOccurrence>> planUIDMap = new HashMap<String, Map<String, EOUniqueElementOccurrence>>();
    private final Map<String, OccurrenceList> uniqueElementUIDMap = new HashMap<String, OccurrenceList>();
    private final UniqueElementMgr uniqueElementMgr;

    protected UniqueElementOccurrenceCache(UniqueElementMgr uniqueElementMgr) {
        this.uniqueElementMgr = uniqueElementMgr;
    }

    protected void setUpCache(Collection<EOUniqueElementOccurrence> elementOccurrences) {
        if (elementOccurrences != null) {
            for (EOUniqueElementOccurrence elementOccurance : elementOccurrences) {
                this.addUniqueElementOccurrence(elementOccurance);
            }
        }
    }

    private Map<String, EOUniqueElementOccurrence> getPlanCache(String planUID) {
        assert (planUID != null) : "planUID can't be null!";
        return this.planUIDMap.get(planUID);
    }

    protected OccurrenceList getOccurrencesForPlan(String planUID) {
        OccurrenceList result;
        assert (planUID != null) : "planUID can't be null";
        Map<String, EOUniqueElementOccurrence> planCache = this.getPlanCache(planUID);
        if (planCache == null) {
            result = new OccurrenceList(this.uniqueElementMgr);
        } else {
            result = new OccurrenceList(this.uniqueElementMgr);
            result.addAll((Collection<? extends EOUniqueElementOccurrence>)planCache.values());
        }
        return result;
    }

    private OccurrenceList getUniqueElementCache(String elementUID) {
        assert (elementUID != null) : "elementUID can't be null!";
        return this.uniqueElementUIDMap.get(elementUID);
    }

    protected OccurrenceList getOccurrencesForUniqueElement(String elementUID) {
        assert (elementUID != null) : "elementUID can't be null";
        OccurrenceList occurrences = this.getUniqueElementCache(elementUID);
        OccurrenceList returnList = occurrences != null ? new OccurrenceList(occurrences, this.uniqueElementMgr) : new OccurrenceList(this.uniqueElementMgr);
        return returnList;
    }

    protected void addUniqueElementOccurrence(EOUniqueElementOccurrence occurrence) {
        assert (occurrence != null) : "occurrence can't be null!";
        Map<String, EOUniqueElementOccurrence> planCache = this.getPlanCache(occurrence.getPlanUID());
        if (planCache == null) {
            planCache = new HashMap<String, EOUniqueElementOccurrence>();
            this.planUIDMap.put(occurrence.getPlanUID(), planCache);
        }
        planCache.put(occurrence.getPlanElementUID(), occurrence);
        OccurrenceList uniqueElementCache = this.getUniqueElementCache(occurrence.getElementUID());
        if (uniqueElementCache == null) {
            uniqueElementCache = new OccurrenceList(this.uniqueElementMgr);
            this.uniqueElementUIDMap.put(occurrence.getElementUID(), uniqueElementCache);
        }
        uniqueElementCache.add(occurrence);
    }

    protected void updateUniqueElementOccurrence(EOUniqueElementOccurrence occurrence) {
        assert (occurrence != null) : "occurrence can't be null!";
        Map<String, EOUniqueElementOccurrence> planCache = this.getPlanCache(occurrence.getPlanUID());
        if (planCache != null) {
            EOUniqueElementOccurrence existingOccurrence = planCache.get(occurrence.getPlanElementUID());
            if (existingOccurrence != null) {
                this.removeUniqueElementOccurrence(existingOccurrence);
                this.addUniqueElementOccurrence(occurrence);
            } else {
                logger.error("updateUniqueElementOccurrence() - Occurrence wasn't found in the cache!");
            }
        } else {
            logger.error("updateUniqueElementOccurrence() - Plan Cache doesn't exist!");
        }
    }

    protected void removeUniqueElementOccurrence(EOUniqueElementOccurrence occurrence) {
        OccurrenceList uniqueElementCache;
        assert (occurrence != null) : "occurrence can't be null!";
        Map<String, EOUniqueElementOccurrence> planCache = this.getPlanCache(occurrence.getPlanUID());
        if (planCache != null) {
            EOUniqueElementOccurrence removedObject = planCache.remove(occurrence.getPlanElementUID());
            if (removedObject == null) {
                logger.error("removeUniqueElementOccurrence() - Unique Element Occurence: \"" + occurrence.getElementUID() + "\" did not exist in the planCache!");
            }
            if (planCache.size() == 0) {
                this.planUIDMap.remove(occurrence.getPlanUID());
            }
        } else {
            logger.error("removeUniqueElementOccurrence() - Plan Cache doesn't exist!");
        }
        if ((uniqueElementCache = this.getUniqueElementCache(occurrence.getElementUID())) != null) {
            boolean success = uniqueElementCache.remove(occurrence.getPlanUID(), occurrence.getPlanElementUID());
            if (!success) {
                logger.error("removeUniqueElementOccurrence() - Unique Element Occurance: \"" + occurrence.getElementUID() + "\" did not exist in the Unique Element Cache!");
            }
            if (uniqueElementCache.size() == 0) {
                this.uniqueElementUIDMap.remove(occurrence.getElementUID());
            }
        } else {
            logger.error("removeUniqueElementOccurrence() - Unique Element Cache doesn't exist!");
        }
    }

    protected String getUIDOfAssignedUniqueElement(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null!";
        assert (planElementUID != null) : "planElementUID can't be null!";
        EOUniqueElementOccurrence occurrence = this.getUniqueElementOccurrence(planUID, planElementUID);
        if (occurrence != null) {
            return occurrence.getElementUID();
        }
        return null;
    }

    protected EOUniqueElementOccurrence getUniqueElementOccurrence(String planUID, String planElementUID) {
        assert (planUID != null) : "planUID can't be null!";
        assert (planElementUID != null) : "planElementUID can't be null!";
        Map<String, EOUniqueElementOccurrence> planCache = this.getPlanCache(planUID);
        if (planCache != null) {
            EOUniqueElementOccurrence occurrence = planCache.get(planElementUID);
            return occurrence;
        }
        return null;
    }
}

