/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementIdentifier;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UniqueElementModificationMgr {
    private final HashMap<String, UniqueElement> createdUniqueElement_indexUID = new HashMap();
    private final HashMap<UniqueElementIdentifier, UniqueElement> createdUniqueElement_indexNameType = new HashMap();
    private final HashMap<String, UniqueElement> modifiedUniqueElements = new HashMap();
    private final HashMap<String, UniqueElement> deletedUniqueElements = new HashMap();

    protected void intialize(UniqueElement[] newCreatedUniqueElements, UniqueElement[] newModifiedUniqueElements, UniqueElement[] newDeletedUniqueElements) {
        UniqueElement replacedUniqueElement;
        UniqueElement element;
        this.createdUniqueElement_indexUID.clear();
        this.createdUniqueElement_indexNameType.clear();
        UniqueElement[] uniqueElementArray = newCreatedUniqueElements;
        int n = newCreatedUniqueElements.length;
        int n2 = 0;
        while (n2 < n) {
            UniqueElement ue = uniqueElementArray[n2];
            UniqueElement replacedUniqueElement_indexUID = this.createdUniqueElement_indexUID.put(ue.getUID(), ue);
            assert (replacedUniqueElement_indexUID == null);
            UniqueElement replacedUniqueElement_indexNameType = this.createdUniqueElement_indexNameType.put(ue.getUniqueElementIdentifier(), ue);
            assert (replacedUniqueElement_indexNameType == null);
            ++n2;
        }
        this.modifiedUniqueElements.clear();
        uniqueElementArray = newModifiedUniqueElements;
        n = newModifiedUniqueElements.length;
        n2 = 0;
        while (n2 < n) {
            element = uniqueElementArray[n2];
            replacedUniqueElement = this.modifiedUniqueElements.put(element.getUID(), element);
            assert (replacedUniqueElement == null);
            ++n2;
        }
        this.deletedUniqueElements.clear();
        uniqueElementArray = newDeletedUniqueElements;
        n = newDeletedUniqueElements.length;
        n2 = 0;
        while (n2 < n) {
            element = uniqueElementArray[n2];
            replacedUniqueElement = this.deletedUniqueElements.put(element.getUID(), element);
            assert (replacedUniqueElement == null);
            ++n2;
        }
    }

    protected boolean isModified() {
        boolean modified = false;
        if (!this.createdUniqueElement_indexUID.isEmpty()) {
            modified = true;
        }
        if (!this.modifiedUniqueElements.isEmpty()) {
            modified = true;
        }
        if (!this.deletedUniqueElements.isEmpty()) {
            modified = true;
        }
        return modified;
    }

    protected UniqueElement getUniqueElement(String uniqueElementUID) {
        UniqueElement uniqueElement = this.getCreatedUniqueElement(uniqueElementUID);
        if (uniqueElement == null) {
            uniqueElement = this.getModifiedUniqueElement(uniqueElementUID);
        }
        return uniqueElement;
    }

    protected UniqueElement getUniqueElement(UniqueElementIdentifier uniqueElementIdentifier) {
        UniqueElement uniqueElement = this.getCreatedUniqueElement(uniqueElementIdentifier);
        if (uniqueElement == null) {
            uniqueElement = this.getModifiedUniqueElement(uniqueElementIdentifier);
        }
        return uniqueElement;
    }

    protected List<UniqueElement> getUniqueElements() {
        ArrayList<UniqueElement> uniqueElements = new ArrayList<UniqueElement>(this.createdUniqueElement_indexUID.size() + this.modifiedUniqueElements.size());
        uniqueElements.addAll(this.createdUniqueElement_indexUID.values());
        uniqueElements.addAll(this.modifiedUniqueElements.values());
        return uniqueElements;
    }

    protected boolean isUniqueElementDeleted(String uniqueElementUID) {
        return this.containsDeletedUniqueElement(uniqueElementUID);
    }

    protected boolean isUniqueElementDeleted(UniqueElementIdentifier uniqueElementIdentifier) {
        return this.getDeletedUniqueElement(uniqueElementIdentifier) != null;
    }

    protected EOList<EOUniqueElement> getCreatedUniqueElementsAsEO() {
        return this.convertUniqueElementsToEOs(this.createdUniqueElement_indexUID.values());
    }

    protected Collection<UniqueElement> getCreatedElements() {
        return this.createdUniqueElement_indexUID.values();
    }

    protected EOList<EOUniqueElement> getModifiedUniqueElementsAsEO() {
        return this.convertUniqueElementsToEOs(this.modifiedUniqueElements.values());
    }

    protected Collection<UniqueElement> getModifiedElements() {
        return this.modifiedUniqueElements.values();
    }

    protected EOList<EOUniqueElement> getDeletedUniqueElementsAsEO() {
        return this.convertUniqueElementsToEOs(this.deletedUniqueElements.values());
    }

    protected Collection<UniqueElement> getDeletedElements() {
        return this.deletedUniqueElements.values();
    }

    protected void addCreatedUniqueElement(UniqueElement uniqueElement) {
        assert (uniqueElement != null) : "uniqueElement can't be null";
        UniqueElement uniqueElementAlreadyExisted = this.createdUniqueElement_indexUID.remove(uniqueElement.getUID());
        assert (uniqueElementAlreadyExisted == null || uniqueElementAlreadyExisted.equals(uniqueElement));
        if (uniqueElementAlreadyExisted != null) {
            Iterator<Map.Entry<UniqueElementIdentifier, UniqueElement>> entryIterator = this.createdUniqueElement_indexNameType.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<UniqueElementIdentifier, UniqueElement> entry = entryIterator.next();
                if (!entry.getValue().getUID().equals(uniqueElement.getUID())) continue;
                entryIterator.remove();
            }
        }
        this.createdUniqueElement_indexUID.put(uniqueElement.getUID(), uniqueElement);
        this.createdUniqueElement_indexNameType.put(uniqueElement.getUniqueElementIdentifier(), uniqueElement);
    }

    protected void removeCreatedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        UniqueElement uniqueElement = this.createdUniqueElement_indexUID.remove(uniqueElementUID);
        if (uniqueElement != null) {
            UniqueElement removedUniqueElement = this.createdUniqueElement_indexNameType.remove(uniqueElement.getUniqueElementIdentifier());
            assert (removedUniqueElement == uniqueElement);
        }
    }

    protected UniqueElement getCreatedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        return this.createdUniqueElement_indexUID.get(uniqueElementUID);
    }

    protected UniqueElement getCreatedUniqueElement(UniqueElementIdentifier uniqueElementIdentifier) {
        assert (uniqueElementIdentifier != null) : "uniqueElementIdentifier can't be null";
        return this.createdUniqueElement_indexNameType.get(uniqueElementIdentifier);
    }

    protected boolean containsCreatedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        return this.getCreatedUniqueElement(uniqueElementUID) != null;
    }

    protected void addModifiedUniqueElement(UniqueElement uniqueElement) {
        assert (uniqueElement != null) : "uniqueElement can't be null";
        UniqueElement replacedUniqueElement = this.modifiedUniqueElements.put(uniqueElement.getUID(), uniqueElement);
        assert (replacedUniqueElement == null || replacedUniqueElement.equals(uniqueElement));
    }

    protected void removeModifiedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        UniqueElement removedUniqueElement = this.modifiedUniqueElements.remove(uniqueElementUID);
        assert (removedUniqueElement != null);
    }

    protected UniqueElement getModifiedUniqueElement(String uniqueElementUID) {
        return this.modifiedUniqueElements.get(uniqueElementUID);
    }

    protected UniqueElement getModifiedUniqueElement(UniqueElementIdentifier uniqueElementIdentifier) {
        for (UniqueElement containedUniqueElement : this.modifiedUniqueElements.values()) {
            if (!containedUniqueElement.getUniqueElementIdentifier().equals(uniqueElementIdentifier)) continue;
            return containedUniqueElement;
        }
        return null;
    }

    protected boolean containsModifiedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        return this.getModifiedUniqueElement(uniqueElementUID) != null;
    }

    protected void addDeletedUniqueElement(UniqueElement uniqueElement) {
        assert (uniqueElement != null) : "uniqueElement can't be null";
        UniqueElement replacedUniqueElement = this.deletedUniqueElements.put(uniqueElement.getUID(), uniqueElement);
        assert (replacedUniqueElement == null);
    }

    protected void removeDeletedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        UniqueElement removedUniqueElement = this.deletedUniqueElements.remove(uniqueElementUID);
        assert (removedUniqueElement != null);
    }

    protected UniqueElement getDeletedUniqueElement(String uniqueElementUID) {
        return this.deletedUniqueElements.get(uniqueElementUID);
    }

    protected UniqueElement getDeletedUniqueElement(UniqueElementIdentifier uniqueElementIdentifier) {
        for (UniqueElement containedUniqueElement : this.deletedUniqueElements.values()) {
            if (!containedUniqueElement.getUniqueElementIdentifier().equals(uniqueElementIdentifier)) continue;
            return containedUniqueElement;
        }
        return null;
    }

    protected boolean containsDeletedUniqueElement(String uniqueElementUID) {
        assert (uniqueElementUID != null) : "uniqueElementUID can't be null";
        return this.getDeletedUniqueElement(uniqueElementUID) != null;
    }

    private EOList<EOUniqueElement> convertUniqueElementsToEOs(Collection<UniqueElement> uniqueElements) {
        EOList list = new EOList();
        for (UniqueElement ue : uniqueElements) {
            list.add((EncodableObjectBase)ue.createEncodableObject());
        }
        return list;
    }
}

