/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.uniqueelements;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementIdentifier;
import com.arcway.cockpit.frame.shared.message.EOUniqueElement;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public class UniqueElement
extends AbstractFrameData
implements IUniqueElementRW {
    private static final ILogger logger = Logger.getLogger(UniqueElement.class);
    private static final String ATTR_TAG_DISPLAY_NAME = "displayname";
    private static final String ATTR_TAG_ELEMENT_TYPE = "elementtype";

    public UniqueElement(String uID, String name, String type, Collection<IAttribute> attributes, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super(uID, projectAgent.getProjectUID(), "com.arcway.cockpit.uniqueelement", attributes, modManager, projectAgent);
        Attribute nameAttr = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(nameAttr);
        Attribute typeAttr = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_ELEMENT_TYPE, type);
        this.simplySetAttribute(typeAttr);
    }

    public UniqueElement(String uID, String name, String type, ObjectTypeCategoryID categoryID, Collection<IAttribute> attributes, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        this(uID, name, type, attributes, modManager, projectAgent);
        this.simplySetCategoryID(categoryID);
    }

    public UniqueElement(EOUniqueElement eo, IAttributeModificationManager modManager, IFrameProjectAgent projectAgent) {
        super((EOFrameData)eo, "com.arcway.cockpit.uniqueelement", modManager, projectAgent);
        String elementType;
        String displayName = eo.getOldAttributeValue(ATTR_TAG_DISPLAY_NAME);
        if (displayName != null) {
            Attribute attribute = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(displayName, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((elementType = eo.getOldAttributeValue(ATTR_TAG_ELEMENT_TYPE)) != null) {
            Attribute attribute = new Attribute(UniqueElementAttributeTypesProvider.ATTRID_ELEMENT_TYPE, elementType);
            this.simplySetAttribute(attribute);
        }
    }

    @Override
    public String getElementName() {
        try {
            IAttribute attribute = this.getAttribute(UniqueElementAttributeTypesProvider.ATTRID_DISPLAY_NAME);
            return (String)attribute.getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getElementTypeID() {
        try {
            IAttribute attribute = this.getAttribute(UniqueElementAttributeTypesProvider.ATTRID_ELEMENT_TYPE);
            return (String)attribute.getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    public UniqueElementIdentifier getUniqueElementIdentifier() {
        return new UniqueElementIdentifier(this.getElementName(), this.getElementTypeID());
    }

    public EOUniqueElement createEncodableObject() {
        return new EOUniqueElement(super.createEncodableObject());
    }

    @Override
    public String getDescription() {
        try {
            IAttribute attribute = this.getAttribute(UniqueElementAttributeTypesProvider.ATTRID_DESCRIPTION);
            return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        IAttributeModificationManager mm = this.getAttributeModificationManager();
        if (mm instanceof UniqueElementAttributeModificationManager) {
            UniqueElementAttributeModificationManager modManager = (UniqueElementAttributeModificationManager)mm;
            modManager.requestAttributeModificationPermission(newAttribute, transactionController);
        }
    }
}

