/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderRoleValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRole;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;

public class StakeholderRoleAttributeModificationManager
implements IAttributeModificationManager {
    private final IFrameProjectAgent projectAgent;
    private StakeholderRole role;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return StakeholderRoleAttributeModificationManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public StakeholderRoleAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            IAttributeType type = this.role.getAttributeType(newAttribute.getAttributeTypeID());
            this.checkGeneralModificationPermissions(type, transactionController);
            transactionController.addLockToTest(this.role, "modify");
            transactionController.addLock(this.role, "modify");
        }
        if (newAttribute.getAttributeTypeID().equals(StakeholderRoleAttributeTypesProvider.ATTRID_NAME)) {
            String newName = (String)newAttribute.getAttributeValue();
            RenameStakeholderRoleValidator validator = new RenameStakeholderRoleValidator(this.projectAgent);
            validator.setRole(this.role);
            String msg = validator.isValid(newName);
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(Messages.getString("StakeholderRoleAttributeModificationManager.new_name_is_invalid"), msg);
                transactionController.addLockModificationProblem(modProblem);
            }
            transactionController.addLockToTest(this.projectAgent, this.projectAgent.getFrameStakeholderManager().getLockTypeForRenameRole(newName));
            transactionController.addLock(this.projectAgent, this.projectAgent.getFrameStakeholderManager().getLockTypeForRenameRole(newName));
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            transactionController.addLockToTest(this.role, "modify");
            transactionController.addLock(this.role, "modify");
        }
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            Throwable serverException = null;
            try {
                EOLock lock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.role, "modify");
                if (lock != null) {
                    modProblem = new ModificationProblem(lock, Messages.getString("StakeholderRoleAttributeModificationManager.cannot_modify_role"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("StakeholderRoleAttributeModificationManager.cannot_modify_role"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            transactionController.addPermission("editStakeholders", null, this.operandTree);
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.role, "modify");
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.checkConditions(true, true);
        return modProblems;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            IAttributeType attributeType = this.role.getAttributeType(newAttribute.getAttributeTypeID());
            if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, this.operandTree, false)) {
                throw new EXNoPermission("The user has no permission to modify the property " + attributeType.getDisplayName() + " of stakeholder roles.");
            }
        }
        if (newAttribute.getAttributeTypeID().equals(StakeholderRoleAttributeTypesProvider.ATTRID_NAME)) {
            this.projectAgent.getFrameStakeholderManager().roleNameModified(this.role, (String)oldAttributeValue);
        } else {
            this.projectAgent.getFrameStakeholderManager().roleModified(this.role);
        }
    }

    public void setStakeholderRole(StakeholderRole role) {
        this.role = role;
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        this.projectAgent.getFrameStakeholderManager().roleModified(this.role);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.role.getUID())) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            return transactionController.checkConditions(false, true);
        }
        return Collections.emptyList();
    }

    private void checkObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("editStakeholders", null, this.operandTree);
    }
}

