/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.AddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.DeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.stakeholders.Stakeholder;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderManager;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRole;
import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class StakeholderModificationMgr {
    private final StakeholderManager stakeholderManager;
    private final Collection<Stakeholder> addedStakeholders;
    private final Collection<Stakeholder> deletedStakeholders;
    private final Collection<Stakeholder> modifiedStakeholders;
    private final Collection<StakeholderRole> addedRoles;
    private final Collection<StakeholderRole> deletedRoles;
    private final Collection<StakeholderRole> modifiedRoles;
    private final EOList<EORoleAndStakeholder> addedConnections;
    private final EOList<EORoleAndStakeholder> deletedConnections;
    private boolean isDirty;

    protected StakeholderModificationMgr(StakeholderManager stakeholderManager) {
        this.stakeholderManager = stakeholderManager;
        this.addedStakeholders = new ArrayList<Stakeholder>();
        this.deletedStakeholders = new ArrayList<Stakeholder>();
        this.modifiedStakeholders = new ArrayList<Stakeholder>();
        this.addedRoles = new ArrayList<StakeholderRole>();
        this.deletedRoles = new ArrayList<StakeholderRole>();
        this.modifiedRoles = new ArrayList<StakeholderRole>();
        this.addedConnections = new EOList();
        this.deletedConnections = new EOList();
        this.isDirty = false;
    }

    protected StakeholderModificationMgr(boolean isDirty, Collection<Stakeholder> addedStakeholders, Collection<Stakeholder> deletedStakeholders, Collection<Stakeholder> modifiedStakeholders, Collection<StakeholderRole> addedRoles, Collection<StakeholderRole> deletedRoles, Collection<StakeholderRole> modifiedRoles, EOList<EORoleAndStakeholder> addedConnections, EOList<EORoleAndStakeholder> deletedConnections, StakeholderManager stakeholderManager) {
        this.addedStakeholders = addedStakeholders;
        this.deletedStakeholders = deletedStakeholders;
        this.modifiedStakeholders = modifiedStakeholders;
        this.addedRoles = addedRoles;
        this.deletedRoles = deletedRoles;
        this.modifiedRoles = modifiedRoles;
        this.addedConnections = addedConnections;
        this.deletedConnections = deletedConnections;
        this.stakeholderManager = stakeholderManager;
        this.isDirty = isDirty;
    }

    protected void addCreatedStakeholder(Stakeholder stakeholder) {
        this.addedStakeholders.add(stakeholder);
        this.isDirty = true;
    }

    protected void addDeletedStakeholder(Stakeholder stakeholder) {
        this.deletedStakeholders.add(stakeholder);
        this.isDirty = true;
    }

    protected void addModifiedStakeholder(Stakeholder stakeholder) {
        assert (stakeholder != null);
        Iterator<Stakeholder> i = this.modifiedStakeholders.iterator();
        while (i.hasNext()) {
            Stakeholder s = i.next();
            if (!s.getUID().equals(stakeholder.getUID())) continue;
            i.remove();
        }
        this.modifiedStakeholders.add(stakeholder);
        this.isDirty = true;
    }

    protected void addCreatedRole(StakeholderRole role) {
        assert (role != null);
        this.addedRoles.add(role);
        this.isDirty = true;
    }

    protected void addDeletedRole(StakeholderRole role) {
        assert (role != null);
        this.deletedRoles.add(role);
        this.isDirty = true;
    }

    protected void addModifiedRole(StakeholderRole role) {
        assert (role != null);
        Iterator<StakeholderRole> i = this.modifiedRoles.iterator();
        while (i.hasNext()) {
            StakeholderRole r = i.next();
            if (!r.getUID().equals(role.getUID())) continue;
            i.remove();
        }
        this.modifiedRoles.add(role);
        this.isDirty = true;
    }

    protected void addCreatedConnection(EORoleAndStakeholder connection) {
        assert (connection != null);
        this.addedConnections.add((EncodableObjectBase)connection);
        this.isDirty = true;
    }

    protected void addDeletedConnection(EORoleAndStakeholder connection) {
        assert (connection != null);
        this.deletedConnections.add((EncodableObjectBase)connection);
        this.isDirty = true;
    }

    protected void removeCreatedStakeholders(Collection stakeholders) {
        for (Stakeholder stakeholder : stakeholders) {
            this.removeCreatedStakeholder(stakeholder.getUID());
        }
    }

    protected void removeCreatedStakeholder(String stakeholderUID) {
        this.removeStakeholder(stakeholderUID, this.addedStakeholders);
    }

    protected void removeDeletedStakeholders(Collection stakeholders) {
        for (Stakeholder stakeholder : stakeholders) {
            this.removeDeletedStakeholder(stakeholder.getUID());
        }
    }

    protected void removeDeletedStakeholder(String stakeholderUID) {
        this.removeStakeholder(stakeholderUID, this.deletedStakeholders);
    }

    protected void removeModifiedStakeholders(Collection stakeholders) {
        for (Stakeholder stakeholder : stakeholders) {
            this.removeModifiedStakeholder(stakeholder.getUID());
        }
    }

    protected void removeModifiedStakeholder(String stakeholderUID) {
        this.removeStakeholder(stakeholderUID, this.modifiedStakeholders);
    }

    protected void removeCreatedRoles(Collection roles) {
        for (StakeholderRole role : roles) {
            this.removeCreatedRole(role);
        }
    }

    protected void removeCreatedRole(StakeholderRole role) {
        this.removeRole(role, this.addedRoles);
    }

    protected void removeDeletedRoles(Collection roles) {
        for (StakeholderRole role : roles) {
            this.removeDeletedRole(role);
        }
    }

    protected void removeDeletedRole(StakeholderRole role) {
        this.removeRole(role, this.deletedRoles);
    }

    protected void removeModfiedRoles(Collection roles) {
        for (StakeholderRole role : roles) {
            this.removeModifiedRole(role);
        }
    }

    protected void removeModifiedRole(StakeholderRole role) {
        this.removeRole(role, this.modifiedRoles);
    }

    private void removeRole(StakeholderRole role, Collection<StakeholderRole> list) {
        Iterator<StakeholderRole> i = list.iterator();
        while (i.hasNext()) {
            StakeholderRole r = i.next();
            if (!r.getUID().equals(role.getUID())) continue;
            i.remove();
        }
    }

    private void removeStakeholder(String stakeholderUID, Collection<Stakeholder> list) {
        Iterator<Stakeholder> i = list.iterator();
        while (i.hasNext()) {
            Stakeholder listStakeholder = i.next();
            if (!listStakeholder.getUID().equals(stakeholderUID)) continue;
            i.remove();
        }
    }

    protected void removeCreatedConnections(List connections) {
        for (EORoleAndStakeholder rs : connections) {
            this.removeCreatedConnection(rs);
        }
    }

    protected void removeCreatedConnection(EORoleAndStakeholder connection) {
        Iterator i = this.addedConnections.iterator();
        while (i.hasNext()) {
            EORoleAndStakeholder rs = (EORoleAndStakeholder)i.next();
            if (!rs.getRoleUID().equals(connection.getRoleUID()) || !rs.getStakeholderUID().equals(connection.getStakeholderUID())) continue;
            i.remove();
        }
    }

    protected void removeDeletedConnections(List connections) {
        for (EORoleAndStakeholder rs : connections) {
            this.removeDeletedConnection(rs);
        }
    }

    protected void removeDeletedConnection(EORoleAndStakeholder connection) {
        Iterator i = this.deletedConnections.iterator();
        while (i.hasNext()) {
            EORoleAndStakeholder rs = (EORoleAndStakeholder)i.next();
            if (!rs.getRoleUID().equals(connection.getRoleUID()) || !rs.getStakeholderUID().equals(connection.getStakeholderUID())) continue;
            i.remove();
        }
    }

    protected boolean containsAddedStakeholder(String stakeholderUID) {
        for (Stakeholder added : this.addedStakeholders) {
            if (!added.getUID().equals(stakeholderUID)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsAddedStakeholders() {
        return !this.addedStakeholders.isEmpty();
    }

    protected boolean containsModifiedStakeholders() {
        return !this.modifiedStakeholders.isEmpty();
    }

    protected boolean containesDeletedStakeholders() {
        return !this.deletedStakeholders.isEmpty();
    }

    protected boolean containsAddedRoles() {
        return !this.addedRoles.isEmpty();
    }

    protected boolean containsModifiedRoles() {
        return !this.modifiedRoles.isEmpty();
    }

    protected boolean containsDeletedRoles() {
        return !this.deletedRoles.isEmpty();
    }

    protected boolean containsAddedRole(String roleUID) {
        for (StakeholderRole added : this.addedRoles) {
            if (!added.getUID().equals(roleUID)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsModifiedRole(String roleUID) {
        for (StakeholderRole mod : this.modifiedRoles) {
            if (!mod.getUID().equals(roleUID)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsModifiedStakeholder(String stakeholderUID) {
        for (Stakeholder mod : this.modifiedStakeholders) {
            if (!mod.getUID().equals(stakeholderUID)) continue;
            return true;
        }
        return false;
    }

    protected boolean containsAddedConnection(EORoleAndStakeholder rs) {
        for (EORoleAndStakeholder old : this.addedConnections) {
            if (!old.getRoleUID().equals(rs.getRoleUID()) || !old.getStakeholderUID().equals(rs.getStakeholderUID())) continue;
            return true;
        }
        return false;
    }

    protected boolean containsAddedConnections() {
        return !this.addedConnections.isEmpty();
    }

    protected boolean containsDeletedConnections() {
        return !this.deletedConnections.isEmpty();
    }

    protected boolean containsDeletedConnection(EORoleAndStakeholder connection) {
        for (EORoleAndStakeholder rs : this.deletedConnections) {
            if (!rs.getRoleUID().equals(connection.getRoleUID()) || !rs.getStakeholderUID().equals(connection.getStakeholderUID())) continue;
            return true;
        }
        return false;
    }

    protected boolean hasModifications() {
        return !this.addedStakeholders.isEmpty() || !this.deletedStakeholders.isEmpty() || !this.modifiedStakeholders.isEmpty() || !this.addedRoles.isEmpty() || !this.deletedRoles.isEmpty() || !this.modifiedRoles.isEmpty() || !this.addedConnections.isEmpty() || !this.deletedConnections.isEmpty();
    }

    protected boolean hasModificationsForStakeholder() {
        return !this.addedStakeholders.isEmpty() || !this.deletedStakeholders.isEmpty() || !this.modifiedStakeholders.isEmpty() || !this.addedConnections.isEmpty() || !this.deletedConnections.isEmpty();
    }

    protected boolean hasModificationsForRoles() {
        return !this.addedRoles.isEmpty() || !this.deletedRoles.isEmpty() || !this.modifiedRoles.isEmpty() || !this.addedConnections.isEmpty() || !this.deletedConnections.isEmpty();
    }

    protected Collection<Stakeholder> getAddedStakeholders() {
        return this.addedStakeholders;
    }

    protected Collection<Stakeholder> getDeletedStakeholders() {
        return this.deletedStakeholders;
    }

    protected Collection<Stakeholder> getModifiedStakeholders() {
        return this.modifiedStakeholders;
    }

    protected Collection<StakeholderRole> getAddedRoles() {
        return this.addedRoles;
    }

    protected Collection<StakeholderRole> getDeletedRoles() {
        return this.deletedRoles;
    }

    protected Collection<StakeholderRole> getModifiedRoles() {
        return this.modifiedRoles;
    }

    protected EOList<EORoleAndStakeholder> getAddedConnections() {
        return this.addedConnections;
    }

    protected EOList<EORoleAndStakeholder> getDeletedConections() {
        return this.deletedConnections;
    }

    protected IAddedItem[] getAddedItems(String dataTypeID) {
        ArrayList<AbstractFrameData> addedItems = new ArrayList<AbstractFrameData>();
        if (dataTypeID.equals("com.arcway.cockpit.stakeholder") && this.addedStakeholders != null) {
            addedItems.addAll(this.addedStakeholders);
        } else if (dataTypeID.equals("com.arcway.cockpit.stakeholderrole") && this.addedRoles != null) {
            addedItems.addAll(this.addedRoles);
        }
        if (!addedItems.isEmpty()) {
            IAddedItem[] items = new IAddedItem[addedItems.size()];
            int nr = 0;
            Iterator iterator = addedItems.iterator();
            while (iterator.hasNext()) {
                AbstractFrameData abstractFrameData;
                AbstractFrameData data = abstractFrameData = (AbstractFrameData)iterator.next();
                AddedItem addedItem = new AddedItem((Object)data);
                items[nr++] = addedItem;
            }
            return items;
        }
        return null;
    }

    protected IModifiedItem[] getModifiedItems(String dataTypeID) {
        IRoleAndStakeholder ras;
        ArrayList<Object> modifiedItems = new ArrayList<Object>();
        if (dataTypeID.equals("com.arcway.cockpit.stakeholder") && this.modifiedStakeholders != null) {
            IStakeholder stakeholder;
            modifiedItems.addAll(this.modifiedStakeholders);
            for (Object element : this.getAddedConnections()) {
                ras = (IRoleAndStakeholder)element;
                stakeholder = this.stakeholderManager.getStakeholderByUID(ras.getStakeholderUID());
                if (modifiedItems.contains(stakeholder)) continue;
                modifiedItems.add(stakeholder);
            }
            for (EORoleAndStakeholder eoRoleAndStakeholder : this.getDeletedConections()) {
                ras = eoRoleAndStakeholder;
                if (ras == null || this.stakeholderManager == null || (stakeholder = this.stakeholderManager.getStakeholderByUID(ras.getStakeholderUID())) == null || modifiedItems.contains(stakeholder)) continue;
                modifiedItems.add(stakeholder);
            }
        } else if (dataTypeID.equals("com.arcway.cockpit.stakeholderrole") && this.modifiedRoles != null) {
            IStakeholderRole role;
            modifiedItems.addAll(this.modifiedRoles);
            for (Object element : this.getAddedConnections()) {
                ras = (IRoleAndStakeholder)element;
                if (ras == null || this.stakeholderManager == null || modifiedItems.contains(role = this.stakeholderManager.getRoleByUID(ras.getRoleUID()))) continue;
                modifiedItems.add(role);
            }
            for (EORoleAndStakeholder eoRoleAndStakeholder : this.getDeletedConections()) {
                ras = eoRoleAndStakeholder;
                if (ras == null || this.stakeholderManager == null || (role = this.stakeholderManager.getRoleByUID(ras.getRoleUID())) == null || modifiedItems.contains(role)) continue;
                modifiedItems.add(role);
            }
        }
        if (!modifiedItems.isEmpty()) {
            IModifiedItem[] items = new IModifiedItem[modifiedItems.size()];
            int nr = 0;
            Iterator iterator = modifiedItems.iterator();
            while (iterator.hasNext()) {
                IAttributeOwner iAttributeOwner;
                IAttributeOwner data = iAttributeOwner = (IAttributeOwner)iterator.next();
                ModifiedItem modifiedItem = new ModifiedItem((Object)data);
                items[nr++] = modifiedItem;
            }
            return items;
        }
        return null;
    }

    protected IDeletedItem[] getDeletedItems(String dataTypeID) {
        ArrayList<AbstractFrameData> deletedItems = new ArrayList<AbstractFrameData>();
        if (dataTypeID.equals("com.arcway.cockpit.stakeholder") && this.deletedStakeholders != null) {
            deletedItems.addAll(this.deletedStakeholders);
        } else if (dataTypeID.equals("com.arcway.cockpit.stakeholderrole") && this.deletedRoles != null) {
            deletedItems.addAll(this.deletedRoles);
        }
        if (!deletedItems.isEmpty()) {
            IDeletedItem[] items = new IDeletedItem[deletedItems.size()];
            int nr = 0;
            Iterator iterator = deletedItems.iterator();
            while (iterator.hasNext()) {
                AbstractFrameData abstractFrameData;
                AbstractFrameData data = abstractFrameData = (AbstractFrameData)iterator.next();
                DeletedItem deletedItem = new DeletedItem((Object)data);
                items[nr++] = deletedItem;
            }
            return items;
        }
        return null;
    }

    public boolean isDirty() {
        return this.isDirty || this.hasModifications();
    }

    public void resetDirtyFlag() {
        this.isDirty = false;
    }
}

