/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IModuleStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.IXMLDataAccessor;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderRoleValidator;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderValidator;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IDataAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.FrameDataTransactionListener;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.ProjectPermissionModificationModel;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderExporter;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleConnectionAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.RoleList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.Stakeholder;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderCache;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderModificationMgr;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRole;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderRoleAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.UserDefinedAtributeDataManagementFacade;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOCockpitProjectData;
import com.arcway.cockpit.frame.shared.message.EOFrameDataModification;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.EORoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholder;
import com.arcway.cockpit.frame.shared.message.EOStakeholderModification;
import com.arcway.cockpit.frame.shared.message.EOStakeholderRole;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.interFace.ILock;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.message.EOUser;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.IPermissionOwner;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class StakeholderManager
implements IFrameStakeholderManager,
IModuleStakeholderManager,
IProjectCloseListener {
    private static final ILogger logger = Logger.getLogger(StakeholderManager.class);
    private IFrameProjectAgent projectAgent;
    private StakeholderCache cache;
    private StakeholderModificationMgr modificationMgr;
    private StakeholderList stakeholderList;
    private RoleList roleList;
    private IDataLabelProvider dataLabelProvider;
    private ILOLinkAccessFacade stakeholderLinkFacade;
    private ILOLinkAccessFacade stakeholderRoleLinkFacade;
    private final Exporter exporter = new Exporter();
    private IXMLDataAccessor<EOStakeholderModification> modificationFileAccessor;
    private final Map<IDataAddID, Object> addableData = new HashMap<IDataAddID, Object>();
    private final Map<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>> approvedDataDeletions = new HashMap<ILocksAndPermissionsTransactionController, Collection<FrameDataTransactionListener>>();
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return StakeholderManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public void construct(IFrameProjectAgent newProjectAgent) {
        assert (newProjectAgent != null);
        this.projectAgent = newProjectAgent;
        this.stakeholderList = new StakeholderList(this);
        this.roleList = new RoleList(this);
        this.modificationFileAccessor = this.projectAgent.getAtomicModificationDataAccessor().getXMLFileAccessor(ProjectDirectoryLayout.FILEKEY_STAKEHOLDER, (IEncodableObjectFactory)MessageDataFactory.getInstance());
    }

    @Override
    public ILOLinkAccessFacade getStakeholderLinkFacade() {
        return this.stakeholderLinkFacade;
    }

    @Override
    public ILOLinkAccessFacade getStakeholderRoleLinkFacade() {
        return this.stakeholderRoleLinkFacade;
    }

    @Override
    public void initializeBeforePermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        this.loadStakeholderCache(serverDataContainer);
        EOStakeholderModification savedModifications = this.readStakeholderModification();
        if (savedModifications == null) {
            this.modificationMgr = new StakeholderModificationMgr(this);
        } else {
            Collection<Stakeholder> addedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)savedModifications.getAddedStakeholders());
            Collection<Stakeholder> deletedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)savedModifications.getDeletedStakeholders());
            Collection<Stakeholder> modifiedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)savedModifications.getModifiedStakeholders());
            Collection<StakeholderRole> addedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)savedModifications.getAddedRoles());
            Collection<StakeholderRole> deletedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)savedModifications.getDeletedRoles());
            Collection<StakeholderRole> modifiedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)savedModifications.getModfiedRoles());
            EOList addedConnections = savedModifications.getAddedConnections();
            EOList deletedConnections = savedModifications.getDeletedConnections();
            this.modificationMgr = new StakeholderModificationMgr(savedModifications.isDirty(), addedStakeholders, deletedStakeholders, modifiedStakeholders, addedRoles, deletedRoles, modifiedRoles, (EOList<EORoleAndStakeholder>)addedConnections, (EOList<EORoleAndStakeholder>)deletedConnections, this);
        }
    }

    private EOStakeholderModification readStakeholderModification() throws EXCorruptProjectData {
        try {
            return (EOStakeholderModification)this.modificationFileAccessor.read();
        }
        catch (Exception e) {
            throw new EXCorruptProjectData(e);
        }
    }

    private void saveStakeholderModifications() {
        this.modificationFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOStakeholderModification>(){

            public EOStakeholderModification getFileContent() {
                if (!StakeholderManager.this.hasLocalModifications()) {
                    return null;
                }
                return StakeholderManager.this.getModification(true);
            }
        });
    }

    public void applySynchronousUpdates(EOStakeholderModification modification) {
        if (modification != null) {
            Collection<Stakeholder> addedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)modification.getAddedStakeholders());
            Collection<Stakeholder> modifiedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)modification.getModifiedStakeholders());
            Collection<Stakeholder> deletedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)modification.getDeletedStakeholders());
            Collection<StakeholderRole> addedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)modification.getAddedRoles());
            Collection<StakeholderRole> modifiedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)modification.getModfiedRoles());
            Collection<StakeholderRole> deletedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)modification.getDeletedRoles());
            EOList addedConnections = modification.getAddedConnections();
            EOList deletedConnections = modification.getDeletedConnections();
            this.modificationMgr.removeCreatedStakeholders(addedStakeholders);
            this.modificationMgr.removeDeletedStakeholders(deletedStakeholders);
            this.modificationMgr.removeModifiedStakeholders(modifiedStakeholders);
            this.modificationMgr.removeCreatedRoles(addedRoles);
            this.modificationMgr.removeDeletedRoles(deletedRoles);
            this.modificationMgr.removeModfiedRoles(modifiedRoles);
            this.modificationMgr.removeCreatedConnections((List)addedConnections);
            this.modificationMgr.removeDeletedConnections((List)deletedConnections);
            this.saveStakeholderModifications();
            this.cache.addStakeholders(addedStakeholders);
            this.cache.addRoles(addedRoles);
            this.cache.addRolesAndStakeholders((List<EORoleAndStakeholder>)addedConnections);
            this.cache.deleteStakeholders(modifiedStakeholders);
            this.cache.addStakeholders(modifiedStakeholders);
            this.cache.deleteRoles(modifiedRoles);
            this.cache.addRoles(modifiedRoles);
            this.cache.deleteStakeholders(deletedStakeholders);
            this.cache.deleteRoles(deletedRoles);
            this.cache.deleteRolesAndStakeholders((List)deletedConnections);
            ProjectPermissionModificationModel pm = this.projectAgent.getProjectPermissionModificationModel();
            for (StakeholderRole role : deletedRoles) {
                pm.permissionOwnerDeleted((IPermissionOwner)role);
            }
            try {
                pm.commit();
            }
            catch (Throwable ta) {
                logger.error("could not remove permissions of removed stakeholder roles", ta);
            }
        }
        this.modificationMgr.resetDirtyFlag();
        this.saveStakeholderModifications();
    }

    public void applyAsynchronousStakeholderModifications(EOStakeholderModification mod) {
        Collection<Stakeholder> addedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)mod.getAddedStakeholders());
        this.cache.addStakeholders(addedStakeholders);
        Collection<StakeholderRole> addedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)mod.getAddedRoles());
        this.cache.addRoles(addedRoles);
        this.cache.addRolesAndStakeholders((List<EORoleAndStakeholder>)mod.getAddedConnections());
        Collection<Stakeholder> modifiedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)mod.getModifiedStakeholders());
        this.cache.deleteStakeholders(modifiedStakeholders);
        this.cache.addStakeholders(modifiedStakeholders);
        Collection<StakeholderRole> modifiedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)mod.getModfiedRoles());
        this.cache.deleteRoles(modifiedRoles);
        this.cache.addRoles(modifiedRoles);
        PropertyChanges stakeholderChanges = new PropertyChanges(addedStakeholders, modifiedStakeholders, null, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)stakeholderChanges, IStakeholder.class);
        PropertyChanges roleChanges = new PropertyChanges(addedRoles, modifiedRoles, null, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)roleChanges, IStakeholderRole.class);
        PropertyChanges linkChanges = new PropertyChanges((Collection)mod.getAddedConnections(), null, null, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)linkChanges, IRoleAndStakeholder.class);
    }

    public void applyAsynchronousStakeholderDeletions(EOStakeholderModification mod) {
        Collection<Stakeholder> deletedStakeholders = this.convertEOsToStakeholder((EOList<EOStakeholder>)mod.getDeletedStakeholders());
        Collection<StakeholderRole> deletedRoles = this.convertEOsToRoles((EOList<EOStakeholderRole>)mod.getDeletedRoles());
        this.cache.deleteStakeholders(deletedStakeholders);
        this.cache.deleteRoles(deletedRoles);
        this.cache.deleteRolesAndStakeholders((List)mod.getDeletedConnections());
        PropertyChanges stakeholderChanges = new PropertyChanges(null, null, deletedStakeholders, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)stakeholderChanges, IStakeholder.class);
        PropertyChanges roleChanges = new PropertyChanges(null, null, deletedRoles, true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)roleChanges, IStakeholderRole.class);
        PropertyChanges linkChanges = new PropertyChanges((Collection)mod.getAddedConnections(), null, (Collection)mod.getDeletedConnections(), true);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)linkChanges, IRoleAndStakeholder.class);
    }

    private void loadStakeholderCache(ServerDataContainer serverDataContainer) {
        this.cache = new StakeholderCache();
        EOStakeholder[] eoStakeholders = serverDataContainer.getStakeholders();
        EOStakeholderRole[] eoRoles = serverDataContainer.getStakeholderRoles();
        Collection<EORoleAndStakeholder> rolesAndStakeholders = serverDataContainer.getStakeholderRoleConnections();
        ArrayList<Stakeholder> stakeholders = new ArrayList<Stakeholder>();
        EOStakeholder[] eOStakeholderArray = eoStakeholders;
        int n = eoStakeholders.length;
        int n2 = 0;
        while (n2 < n) {
            EOStakeholder element = eOStakeholderArray[n2];
            stakeholders.add(this.createStakeholder(element));
            ++n2;
        }
        ArrayList<StakeholderRole> roles = new ArrayList<StakeholderRole>();
        EOStakeholderRole[] eOStakeholderRoleArray = eoRoles;
        int n3 = eoRoles.length;
        n = 0;
        while (n < n3) {
            EOStakeholderRole element = eOStakeholderRoleArray[n];
            roles.add(this.createStakeholderRole(element));
            ++n;
        }
        this.cache.setupCache(stakeholders, roles, rolesAndStakeholders);
    }

    private Collection<Stakeholder> convertEOsToStakeholder(EOList<EOStakeholder> eos) {
        ArrayList<Stakeholder> stakeholders = new ArrayList<Stakeholder>();
        for (EOStakeholder eo : eos) {
            stakeholders.add(this.createStakeholder(eo));
        }
        return stakeholders;
    }

    private Collection<StakeholderRole> convertEOsToRoles(EOList<EOStakeholderRole> eos) {
        ArrayList<StakeholderRole> roles = new ArrayList<StakeholderRole>();
        for (EOStakeholderRole eo : eos) {
            roles.add(this.createStakeholderRole(eo));
        }
        return roles;
    }

    private Stakeholder createStakeholder(EOStakeholder eo) {
        StakeholderAttributeModificationManager modManager = new StakeholderAttributeModificationManager(this.projectAgent);
        Stakeholder stakeholder = new Stakeholder(eo, modManager, this.projectAgent);
        modManager.setStakeholder(stakeholder);
        return stakeholder;
    }

    private StakeholderRole createStakeholderRole(EOStakeholderRole eo) {
        StakeholderRoleAttributeModificationManager modManager = new StakeholderRoleAttributeModificationManager(this.projectAgent);
        StakeholderRole role = new StakeholderRole(eo, modManager, this.projectAgent);
        modManager.setStakeholderRole(role);
        return role;
    }

    @Override
    public boolean hasLocalModifications() {
        return this.modificationMgr.isDirty();
    }

    public EOStakeholderModification getModification(boolean isForLocalSaving) {
        EOStakeholderModification mod = new EOStakeholderModification(isForLocalSaving);
        mod.setIsDirty(this.modificationMgr.isDirty());
        EOList addedStakeholders = new EOList();
        for (Stakeholder stakeholder : this.modificationMgr.getAddedStakeholders()) {
            addedStakeholders.add((EncodableObjectBase)stakeholder.createEncodableObject());
        }
        mod.setAddedStakeholders(addedStakeholders);
        EOList modifiedStakeholders = new EOList();
        for (Stakeholder stakeholder : this.modificationMgr.getModifiedStakeholders()) {
            modifiedStakeholders.add((EncodableObjectBase)stakeholder.createEncodableObject());
        }
        mod.setModifiedStakeholders(modifiedStakeholders);
        EOList deletedStakeholders = new EOList();
        for (Stakeholder stakeholder : this.modificationMgr.getDeletedStakeholders()) {
            deletedStakeholders.add((EncodableObjectBase)stakeholder.createEncodableObject());
        }
        mod.setDeletedStakeholders(deletedStakeholders);
        EOList addedRoles = new EOList();
        for (StakeholderRole role : this.modificationMgr.getAddedRoles()) {
            addedRoles.add((EncodableObjectBase)role.createEncodableObject());
        }
        mod.setAddedRoles(addedRoles);
        EOList modifiedRoles = new EOList();
        for (StakeholderRole role : this.modificationMgr.getModifiedRoles()) {
            modifiedRoles.add((EncodableObjectBase)role.createEncodableObject());
        }
        mod.setModifiedRoles(modifiedRoles);
        EOList deletedRoles = new EOList();
        for (StakeholderRole role : this.modificationMgr.getDeletedRoles()) {
            deletedRoles.add((EncodableObjectBase)role.createEncodableObject());
        }
        mod.setDeletedRoles(deletedRoles);
        mod.setAddedConnections(this.modificationMgr.getAddedConnections());
        mod.setDeletedConnections(this.modificationMgr.getDeletedConections());
        return mod;
    }

    public Collection<? extends IStakeholder> getStakeholders() {
        return this.getStakeholdersInternal().values();
    }

    @Override
    public IStakeholder getStakeholder(String name) {
        for (Stakeholder stakeholder : this.getStakeholdersInternal().values()) {
            if (!stakeholder.getStakeholderName().equals(name)) continue;
            return stakeholder;
        }
        return null;
    }

    @Override
    public IStakeholder getStakeholderByUID(String uID) {
        return this.getStakeholderByUIDInternal(uID);
    }

    private Stakeholder getStakeholderByUIDInternal(String uID) {
        return this.getStakeholdersInternal().get(uID);
    }

    @Override
    public IStakeholder getStakeholderForCurrentUser() {
        EOUserAndGroupAndPermissions ugp;
        if (this.projectAgent != null && (ugp = this.projectAgent.getUserData(true)) != null) {
            EOUser user = ugp.getUser();
            for (Stakeholder s : this.getStakeholdersInternal().values()) {
                if (!s.getUsername().equals(user.getUserName())) continue;
                return s;
            }
        }
        return null;
    }

    private HashMap<String, Stakeholder> getStakeholdersInternal() {
        Collection<Stakeholder> cachedStakeholders = this.cache.getStakeholders();
        Collection<Stakeholder> addedStakeholders = this.modificationMgr.getAddedStakeholders();
        HashMap<String, Stakeholder> stakeholders = new HashMap<String, Stakeholder>(2 * (cachedStakeholders.size() + addedStakeholders.size()));
        for (Stakeholder cachedStakeholder : cachedStakeholders) {
            stakeholders.put(cachedStakeholder.getUID(), cachedStakeholder);
        }
        Collection<Stakeholder> removedStakeholders = this.modificationMgr.getDeletedStakeholders();
        for (Stakeholder removedStakeholder : removedStakeholders) {
            stakeholders.remove(removedStakeholder.getUID());
        }
        Collection<Stakeholder> modifiedStakeholders = this.modificationMgr.getModifiedStakeholders();
        for (Stakeholder modifiedStakeholder : modifiedStakeholders) {
            stakeholders.put(modifiedStakeholder.getUID(), modifiedStakeholder);
        }
        for (Stakeholder addedStakeholder : addedStakeholders) {
            stakeholders.put(addedStakeholder.getUID(), addedStakeholder);
        }
        return stakeholders;
    }

    @Override
    public Collection<? extends IStakeholderRole> getRoles() {
        return this.getRolesInternal();
    }

    @Override
    public IStakeholderRole getRoleByUID(String uID) {
        return this.getRoleByUIDInternal(uID);
    }

    private StakeholderRole getRoleByUIDInternal(String uID) {
        for (StakeholderRole r : this.getRolesInternal()) {
            if (!r.getUID().equals(uID)) continue;
            return r;
        }
        return null;
    }

    @Override
    public IStakeholderRole getRole(String name) {
        for (IStakeholderRole iStakeholderRole : this.getRolesInternal()) {
            if (!iStakeholderRole.getName().equals(name)) continue;
            return iStakeholderRole;
        }
        return null;
    }

    private Collection<StakeholderRole> getRolesInternal() {
        ArrayList<StakeholderRole> roles = new ArrayList<StakeholderRole>(this.cache.getRoles());
        Collection<StakeholderRole> removedRoles = this.modificationMgr.getDeletedRoles();
        block0: for (StakeholderRole removedRole : removedRoles) {
            Iterator k = roles.iterator();
            while (k.hasNext()) {
                StakeholderRole existingRole = (StakeholderRole)k.next();
                if (!existingRole.getUID().equals(removedRole.getUID())) continue;
                k.remove();
                continue block0;
            }
        }
        Collection<StakeholderRole> modifiedRoles = this.modificationMgr.getModifiedRoles();
        block2: for (StakeholderRole newRole : modifiedRoles) {
            Iterator k = roles.iterator();
            while (k.hasNext()) {
                StakeholderRole oldRole = (StakeholderRole)k.next();
                if (!oldRole.getUID().equals(newRole.getUID())) continue;
                k.remove();
                continue block2;
            }
        }
        roles.addAll(modifiedRoles);
        Collection<StakeholderRole> addedRoles = this.modificationMgr.getAddedRoles();
        roles.addAll(addedRoles);
        return roles;
    }

    @Override
    public Collection<IStakeholder> addStakeholders(Collection<IStakeholderAddID> addIDs) throws EXNoPermission {
        ArrayList<IStakeholder> addedStakeholders = new ArrayList<IStakeholder>();
        for (IStakeholderAddID addID : addIDs) {
            Stakeholder addedStakeholder = this.addStakeholderWithoutNotification(addID);
            addedStakeholders.add(addedStakeholder);
        }
        this.saveStakeholderModifications();
        PropertyChanges changes = new PropertyChanges(addedStakeholders, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholder.class);
        return addedStakeholders;
    }

    @Override
    public IStakeholder addStakeholder(IStakeholderAddID dataAddID) throws EXNoPermission {
        Stakeholder stakeholder = this.addStakeholderWithoutNotification(dataAddID);
        UserDefinedAtributeDataManagementFacade.attributeOwnerCreated(stakeholder);
        this.saveStakeholderModifications();
        PropertyChanges changes = new PropertyChanges((Object)stakeholder, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholder.class);
        return stakeholder;
    }

    private Stakeholder addStakeholderWithoutNotification(IStakeholderAddID dataAddID) throws EXNoPermission {
        Stakeholder stakeholder = (Stakeholder)this.getAddableData(dataAddID);
        if (stakeholder == null) {
            throw new EXNoPermission("add stakeholder permission was not granted or not requested before!");
        }
        StakeholderAttributeModificationManager modManager = new StakeholderAttributeModificationManager(this.projectAgent);
        modManager.setStakeholder(stakeholder);
        stakeholder.setAttributeModificationManager(modManager);
        this.modificationMgr.addCreatedStakeholder(stakeholder);
        return stakeholder;
    }

    private Object getAddableData(IDataAddID addID) {
        Object data = this.addableData.get(addID);
        this.addableData.remove(addID);
        return data;
    }

    @Override
    public IStakeholderRole addRole(IStakeholderRoleAddID dataAddID) throws EXNoPermission {
        StakeholderRole role = (StakeholderRole)this.getAddableData(dataAddID);
        if (role == null) {
            throw new EXNoPermission("role add permission was not granted or not requested");
        }
        UserDefinedAtributeDataManagementFacade.attributeOwnerCreated(role);
        StakeholderRoleAttributeModificationManager modManager = new StakeholderRoleAttributeModificationManager(this.projectAgent);
        modManager.setStakeholderRole(role);
        role.setAttributeModificationManager(modManager);
        this.modificationMgr.addCreatedRole(role);
        PropertyChanges changes = new PropertyChanges((Object)role, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholderRole.class);
        this.saveStakeholderModifications();
        return role;
    }

    @Override
    public void addStakeholderRoleConnection(IStakeholderRoleConnectionAddID dataAddID) throws EXNoPermission {
        EORoleAndStakeholder connection = (EORoleAndStakeholder)this.getAddableData(dataAddID);
        if (connection == null) {
            throw new EXNoPermission("stakeholder and role connection add permission not granted or not requested.");
        }
        if (this.modificationMgr.containsDeletedConnection(connection)) {
            this.modificationMgr.removeDeletedConnection(connection);
        } else {
            this.modificationMgr.addCreatedConnection(connection);
        }
        this.saveStakeholderModifications();
        PropertyChanges connectionChanges = new PropertyChanges((Object)connection, null, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)connectionChanges, IRoleAndStakeholder.class);
        PropertyChanges stakeholderChanges = new PropertyChanges(null, (Object)this.getStakeholderByUID(connection.getStakeholderUID()), null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)stakeholderChanges, IStakeholder.class);
        PropertyChanges roleChanges = new PropertyChanges(null, (Object)this.getRoleByUID(connection.getRoleUID()), null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)roleChanges, IStakeholderRole.class);
    }

    private void deleteConnection(EORoleAndStakeholder connection) throws EXNoLock, EXNoPermission {
        assert (connection != null);
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "editStakeholders");
        }
        if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role")) {
            throw new EXNoLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
        }
        if (this.modificationMgr.containsAddedConnection(connection)) {
            this.modificationMgr.removeCreatedConnection(connection);
        } else {
            this.modificationMgr.addDeletedConnection(connection);
        }
        PropertyChanges changes = new PropertyChanges(null, null, (Object)connection);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IRoleAndStakeholder.class);
        this.saveStakeholderModifications();
    }

    @Override
    public void deleteStakeholder(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<FrameDataTransactionListener> listeners = this.approvedDataDeletions.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("the permission for deleting this stakeholder was not granted");
        }
        listeners = new ArrayList<FrameDataTransactionListener>(listeners);
        ArrayList<Stakeholder> deletedStakeholders = new ArrayList<Stakeholder>();
        for (FrameDataTransactionListener listener : listeners) {
            IFrameDataRW data = listener.getData();
            if (!(data instanceof Stakeholder)) continue;
            Stakeholder stakeholder = (Stakeholder)data;
            if (this.modificationMgr.containsAddedStakeholder(stakeholder.getUID())) {
                this.modificationMgr.removeCreatedStakeholder(stakeholder.getUID());
            } else {
                if (this.modificationMgr.containsModifiedStakeholder(stakeholder.getUID())) {
                    this.modificationMgr.removeModifiedStakeholder(stakeholder.getUID());
                }
                this.modificationMgr.addDeletedStakeholder(stakeholder);
            }
            UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted(stakeholder);
            this.projectAgent.getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.stakeholder").linkableObjectDeleted((ICockpitProjectData)data);
            Collection<EORoleAndStakeholder> allConnections = this.getAllConnections();
            this.deleteConnections(allConnections, stakeholder);
            deletedStakeholders.add(stakeholder);
            listener.kill();
        }
        PropertyChanges changes = new PropertyChanges(null, null, deletedStakeholders);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholder.class);
        this.saveStakeholderModifications();
    }

    private void deleteConnections(Collection<EORoleAndStakeholder> connections, Stakeholder stakeholder) {
        for (EORoleAndStakeholder rs : connections) {
            if (!rs.getStakeholderUID().equals(stakeholder.getUID())) continue;
            try {
                this.deleteConnection(rs);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    private void deleteConnections(Collection<EORoleAndStakeholder> connections, StakeholderRole role) {
        for (EORoleAndStakeholder rs : connections) {
            if (!rs.getRoleUID().equals(role.getUID())) continue;
            try {
                this.deleteConnection(rs);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteRole(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        Collection<FrameDataTransactionListener> listeners = this.approvedDataDeletions.get(transactionController);
        if (listeners == null) {
            throw new EXNoPermission("permission for deleting this role was not granted");
        }
        listeners = new ArrayList<FrameDataTransactionListener>(listeners);
        ArrayList<StakeholderRole> deletedRoles = new ArrayList<StakeholderRole>();
        for (FrameDataTransactionListener listener : listeners) {
            IFrameDataRW data = listener.getData();
            if (!(data instanceof StakeholderRole)) continue;
            StakeholderRole role = (StakeholderRole)data;
            if (this.modificationMgr.containsAddedRole(role.getUID())) {
                ProjectPermissionModificationModel pm = this.projectAgent.getProjectPermissionModificationModel();
                pm.permissionOwnerDeleted((IPermissionOwner)role);
                try {
                    pm.commit();
                }
                catch (Throwable ta) {
                    logger.error("could not delete permissions of role", ta);
                }
                this.modificationMgr.removeCreatedRole(role);
            } else {
                if (this.modificationMgr.containsModifiedRole(role.getUID())) {
                    this.modificationMgr.removeModifiedRole(role);
                }
                this.modificationMgr.addDeletedRole(role);
            }
            UserDefinedAtributeDataManagementFacade.attributeOwnerDeleted(role);
            this.projectAgent.getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.stakeholderrole").linkableObjectDeleted((ICockpitProjectData)data);
            Collection<EORoleAndStakeholder> allConnections = this.getAllConnections();
            this.deleteConnections(allConnections, role);
            deletedRoles.add(role);
            listener.kill();
        }
        PropertyChanges changes = new PropertyChanges(null, null, deletedRoles);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholderRole.class);
        this.saveStakeholderModifications();
    }

    public boolean containsConnection(EORoleAndStakeholder rs) {
        Collection<EORoleAndStakeholder> allConnections = this.getAllConnections();
        for (EORoleAndStakeholder existing : allConnections) {
            if (!existing.getRoleUID().equals(rs.getRoleUID()) || !existing.getStakeholderUID().equals(rs.getStakeholderUID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<EORoleAndStakeholder> getAllConnections() {
        EOList<EORoleAndStakeholder> addedConnections;
        ArrayList<EORoleAndStakeholder> connections = new ArrayList<EORoleAndStakeholder>(this.cache.getRolesAndStakeholders());
        EOList<EORoleAndStakeholder> deleted = this.modificationMgr.getDeletedConections();
        if (deleted != null) {
            block0: for (EORoleAndStakeholder del : deleted) {
                Iterator k = connections.iterator();
                while (k.hasNext()) {
                    EORoleAndStakeholder old = (EORoleAndStakeholder)k.next();
                    if (!old.getStakeholderUID().equals(del.getStakeholderUID()) || !old.getRoleUID().equals(del.getRoleUID())) continue;
                    k.remove();
                    continue block0;
                }
            }
        }
        if ((addedConnections = this.modificationMgr.getAddedConnections()) != null) {
            connections.addAll((Collection<EORoleAndStakeholder>)this.modificationMgr.getAddedConnections());
        }
        return connections;
    }

    public Collection<IStakeholderRole> getRolesOfStakeholder(IStakeholder stakeholder) {
        ArrayList<IStakeholderRole> roles = new ArrayList<IStakeholderRole>();
        for (EORoleAndStakeholder rs : this.getAllConnections()) {
            if (!rs.getStakeholderUID().equals(stakeholder.getUID())) continue;
            IStakeholderRole role = this.getRoleByUID(rs.getRoleUID());
            if (role != null) {
                roles.add(role);
                continue;
            }
            logger.warn("role " + rs.getRoleUID() + " does not exist.");
        }
        return roles;
    }

    @Override
    public Collection<IStakeholder> getStakeholdersOfRole(IStakeholderRole role) {
        ArrayList<IStakeholder> stakeholdersOfRole = new ArrayList<IStakeholder>();
        for (EORoleAndStakeholder rs : this.getAllConnections()) {
            IStakeholder stakeholder;
            if (!rs.getRoleUID().equals(role.getUID()) || (stakeholder = (IStakeholder)this.getStakeholdersInternal().get(rs.getStakeholderUID())) == null) continue;
            stakeholdersOfRole.add(stakeholder);
        }
        return stakeholdersOfRole;
    }

    public EORoleAndStakeholder getConnection(IStakeholderRole role, IStakeholder stakeholder) {
        for (EORoleAndStakeholder rs : this.getAllConnections()) {
            if (!rs.getRoleUID().equals(role.getUID()) || !rs.getStakeholderUID().equals(stakeholder.getUID())) continue;
            return rs;
        }
        return null;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    @Override
    public void deleteStakeholderRoleConnection(IStakeholder stakeholder, IStakeholderRole role) throws EXNoLock, EXNoPermission {
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "editStakeholders");
        }
        if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role")) {
            throw new EXNoLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
        }
        EORoleAndStakeholder c = this.getConnection(role, stakeholder);
        if (c != null) {
            this.deleteConnection(c);
        }
        PropertyChanges roleChanges = new PropertyChanges(null, (Object)role, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)roleChanges, IStakeholderRole.class);
        PropertyChanges stakeholderChanges = new PropertyChanges(null, (Object)stakeholder, null);
        this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)stakeholderChanges, IStakeholder.class);
    }

    @Override
    public boolean containsStakeholderRoleConnection(IStakeholder stakeholder, IStakeholderRole role) {
        Stakeholder s = this.getStakeholderByUIDInternal(stakeholder.getUID());
        StakeholderRole r = this.getRoleByUIDInternal(role.getUID());
        if (s != null && r != null) {
            EORoleAndStakeholder rs = this.getConnection(r, s);
            return rs != null;
        }
        return false;
    }

    @Override
    public IFrameProjectAgent getFrameProjectAgent() {
        return this.projectAgent;
    }

    public String getProjectUID() {
        return this.projectAgent.getUID();
    }

    @Override
    public IStakeholderExporter getExportManager() {
        return this.exporter;
    }

    @Override
    public IStakeholder[] getStakeholdersArray() {
        return this.getStakeholders().toArray(new IStakeholder[this.getStakeholders().size()]);
    }

    @Override
    public IStakeholderRole[] getRolesArray() {
        return this.getRoles().toArray(new IStakeholderRole[this.getRoles().size()]);
    }

    @Override
    public StakeholderList getStakeholderList() {
        return this.stakeholderList;
    }

    @Override
    public RoleList getRoleList() {
        return this.roleList;
    }

    @Override
    public boolean containsStakeholders() {
        return this.cache.containsStakeholders() || this.modificationMgr.containsAddedStakeholders();
    }

    @Override
    public boolean containsRoles() {
        return this.cache.containsRoles() || this.modificationMgr.containsAddedRoles();
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        administrator.getFrameProjectAgent().addProjectCloseListener(this);
        this.stakeholderLinkFacade = this.projectAgent.getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.stakeholder");
        this.stakeholderRoleLinkFacade = this.projectAgent.getLinkManager().getLOLinkAccessFacade("com.arcway.cockpit.stakeholderrole");
    }

    @Override
    public void finishInitialization(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) {
    }

    @Override
    public String getLocalizedManagerName() {
        return "Stakeholder Manager";
    }

    @Override
    public void discardLocalModifications() {
        this.modificationMgr = new StakeholderModificationMgr(this);
        this.saveStakeholderModifications();
    }

    @Override
    public void closeProject(IFrameProjectAgent pa) {
        this.stakeholderRoleLinkFacade = null;
        this.stakeholderLinkFacade = null;
    }

    @Override
    public boolean handlesDataType(String cockpitDataTypeID) {
        if (cockpitDataTypeID.equals("com.arcway.cockpit.stakeholder")) {
            return true;
        }
        return cockpitDataTypeID.equals("com.arcway.cockpit.stakeholderrole");
    }

    @Override
    public boolean itemExistsOnServer(String cockpitDataUID) {
        return StakeholderManager.collectionContainsItem(cockpitDataUID, this.cache.getRoles()) || StakeholderManager.collectionContainsItem(cockpitDataUID, this.cache.getStakeholders());
    }

    private static boolean collectionContainsItem(String cockpitDataUID, Collection<? extends ICockpitProjectData> collection) {
        for (ICockpitProjectData iCockpitProjectData : collection) {
            if (!iCockpitProjectData.getUID().equals(cockpitDataUID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ICockpitProjectData getCockpitProjectData(String cockpitDataUID) {
        IStakeholder iStakeholder = this.getStakeholdersInternal().get(cockpitDataUID);
        if (iStakeholder != null) {
            return iStakeholder;
        }
        for (IStakeholderRole iStakeholderRole : this.getRolesInternal()) {
            if (!iStakeholderRole.getUID().equals(cockpitDataUID)) continue;
            return iStakeholderRole;
        }
        return null;
    }

    @Override
    public IDataLabelProvider getDataLabelProvider() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new IDataLabelProvider(){

                public Image getImageOfType(String dataTypeID) {
                    return FrameDataTypes.getDataType(dataTypeID).getIcon();
                }

                public String getTypeDisplayName(String dataTypeID) {
                    return FrameDataTypes.getDataType(dataTypeID).getDisplayName();
                }

                public Image getImage(Object element) {
                    if (element instanceof IStakeholder) {
                        return Icons.getImageForStakeholder();
                    }
                    if (element instanceof IStakeholderRole) {
                        return Icons.getImageForStakeholderRole();
                    }
                    return null;
                }

                public String getText(Object element) {
                    if (element instanceof IStakeholder) {
                        IStakeholder stakeholder = (IStakeholder)element;
                        return stakeholder.getStakeholderName();
                    }
                    if (element instanceof IStakeholderRole) {
                        IStakeholderRole role = (IStakeholderRole)element;
                        return role.getName();
                    }
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            };
        }
        return this.dataLabelProvider;
    }

    @Override
    public ILocalModificationContainer[] getLocalModifications(boolean displayableOnly) {
        ArrayList<ICockpitDataType> dataTypes = new ArrayList<ICockpitDataType>();
        if (this.modificationMgr.hasModificationsForStakeholder()) {
            dataTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder"));
        }
        if (this.modificationMgr.hasModificationsForRoles()) {
            dataTypes.add(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole"));
        }
        ILocalModificationContainer[] modItems = new ILocalModificationContainer[dataTypes.size()];
        int i = 0;
        while (i < dataTypes.size()) {
            ILocalModificationContainer item;
            final ICockpitDataType dataType = (ICockpitDataType)dataTypes.get(i);
            modItems[i] = item = new ILocalModificationContainer(){

                public IDataLabelProvider getDataLabelProvider() {
                    return StakeholderManager.this.getDataLabelProvider();
                }

                public boolean isEmpty() {
                    if (dataType.equals(FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder"))) {
                        return !StakeholderManager.this.modificationMgr.hasModificationsForStakeholder();
                    }
                    return !StakeholderManager.this.modificationMgr.hasModificationsForRoles();
                }

                public IAddedItem[] getAddedItems() {
                    return StakeholderManager.this.modificationMgr.getAddedItems(dataType.getCockpitDataTypeID());
                }

                public IModifiedItem[] getModifiedItems() {
                    return StakeholderManager.this.modificationMgr.getModifiedItems(dataType.getCockpitDataTypeID());
                }

                public IDeletedItem[] getDeletedItems() {
                    return StakeholderManager.this.modificationMgr.getDeletedItems(dataType.getCockpitDataTypeID());
                }

                public Image getGeneralImage() {
                    return dataType.getIcon();
                }

                public String getGeneralDescription() {
                    return dataType.getDisplayName();
                }

                public String getTypeIDOfContainedData() {
                    return dataType.getCockpitDataTypeID();
                }
            };
            ++i;
        }
        return modItems;
    }

    @Override
    public void stakeholderNameModified(Stakeholder stakeholder, String oldName) throws EXNoPermission, EXNoLock {
        Collection<EOLock> locksToRelease;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "editStakeholders");
        }
        for (IStakeholder iStakeholder : this.getStakeholders()) {
            if (!stakeholder.getStakeholderName().equalsIgnoreCase(iStakeholder.getStakeholderName()) || stakeholder.getUID().equals(stakeholder.getUID())) continue;
            throw new EXNoPermission("Cannot have two stakeholders with the same name (" + stakeholder.getStakeholderName() + ")");
        }
        IFrameLockManager iFrameLockManager = this.projectAgent.getFrameLockManager();
        if (!iFrameLockManager.clientAlreadyHasLock(this.projectAgent, this.getLockTypeForRenameStakeholder(stakeholder.getStakeholderName()))) {
            throw new EXNoLock(this.projectAgent, this.getLockTypeForRenameStakeholder(stakeholder.getStakeholderName()));
        }
        if (!stakeholder.getStakeholderName().equalsIgnoreCase(oldName) && (locksToRelease = iFrameLockManager.findClientLocksByILockable(this.projectAgent, this.getLockTypeForRenameStakeholder(oldName))) != null) {
            iFrameLockManager.releaseLocks(locksToRelease);
        }
        this.stakeholderModified(stakeholder);
    }

    @Override
    public void stakeholderModified(Stakeholder stakeholder) throws EXNoPermission, EXNoLock {
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "editStakeholders");
        }
        if (!this.modificationMgr.containsAddedStakeholder(stakeholder.getUID()) && !this.projectAgent.getFrameLockManager().clientAlreadyHasLock(stakeholder, "modify")) {
            throw new EXNoLock(stakeholder, "modify");
        }
        this.dataModified(stakeholder);
    }

    private IModificationProblem getLockForRenameStakeholder(String newName) {
        ModificationProblem modProblem = null;
        IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
        EOLock uniqueNameLock = new LockRequest(this.projectAgent, this.getLockTypeForRenameStakeholder(newName)).createEOLock();
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        locksToBeChecked.add(uniqueNameLock);
        locksToBeSet.add(uniqueNameLock);
        LockResult lockResult = lockMgr.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
        if (!lockResult.wasSuccessful()) {
            if (!conflictingLocks.isEmpty()) {
                EOLock conflictingLock = conflictingLocks.iterator().next();
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("StakeholderManager.StakeholderCannotBeAdded"));
            } else if (lockResult.getPossibleServerException() != null) {
                modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("StakeholderManager.StakeholderCannotBeAdded.ServerException"));
            }
        }
        return modProblem;
    }

    @Override
    public String getLockTypeForRenameStakeholder(String newName) {
        return "uniqueName_com.arcway.cockpit.stakeholder_" + newName.toLowerCase();
    }

    private IModificationProblem getLockForRenameRole(String newName) {
        ModificationProblem modProblem = null;
        IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
        EOLock uniqueNameLock = new LockRequest(this.projectAgent, this.getLockTypeForRenameRole(newName)).createEOLock();
        ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
        ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
        locksToBeChecked.add(uniqueNameLock);
        locksToBeSet.add(uniqueNameLock);
        LockResult lockResult = lockMgr.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
        Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
        if (!lockResult.wasSuccessful()) {
            if (!conflictingLocks.isEmpty()) {
                EOLock conflictingLock = conflictingLocks.iterator().next();
                modProblem = new ModificationProblem(conflictingLock, Messages.getString("StakeholderManager.RoleCannotBeAdded"));
            } else if (lockResult.getPossibleServerException() != null) {
                modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("StakeholderManager.RoleCannotBeAdded.ServerException"));
            }
        }
        return modProblem;
    }

    @Override
    public String getLockTypeForRenameRole(String newName) {
        return "uniqueName_com.arcway.cockpit.stakeholderrole_" + newName.toLowerCase();
    }

    @Override
    public IStakeholderAddID requestStakeholderAddPermission(String stakeholderUID, String stakeholderName, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        Stakeholder stakeholder = new Stakeholder(stakeholderUID, stakeholderName, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        stakeholder.setCategoryID(objectTypeCategoryID);
        return this.requestStakeholderAddPermissionInternal(stakeholder);
    }

    @Override
    public IStakeholderAddID requestStakeholderAddPermission(String stakeholderName, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        Stakeholder stakeholder = new Stakeholder(UUIDGenerator.getUniqueID(), stakeholderName, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        stakeholder.setCategoryID(objectTypeCategoryID);
        return this.requestStakeholderAddPermissionInternal(stakeholder);
    }

    @Override
    public IStakeholderAddID requestStakeholderImportPermission(EOStakeholder eoStakeholder) {
        Stakeholder stakeholder = new Stakeholder(eoStakeholder, IAttributeModificationManager.DUMMY, this.projectAgent);
        return this.requestStakeholderAddPermissionInternal(stakeholder);
    }

    private IStakeholderAddID requestStakeholderAddPermissionInternal(IStakeholder stakeholder) {
        RenameStakeholderValidator validator;
        String msg;
        String problem = Messages.getString("StakeholderManager.StakeholderCannotBeAdded");
        IModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("editStakeholders", this.projectAgent.getPermissionOperandType());
            modProblem = new ModificationProblem(template, problem, this.projectAgent);
        }
        String stakeholderName = stakeholder.getStakeholderName();
        if (modProblem == null && (msg = (validator = new RenameStakeholderValidator(this.projectAgent)).isValid(stakeholderName)) != null) {
            modProblem = new ModificationProblem(String.valueOf(Messages.getString("StakeholderManager.stakeholder_exists1")) + stakeholderName + Messages.getString("StakeholderManager.stakeholder_exists2"), problem, 4);
        }
        if (modProblem == null) {
            modProblem = this.getLockForRenameStakeholder(stakeholderName);
        }
        final IModificationProblem mp = modProblem;
        IStakeholderAddID addID = new IStakeholderAddID(){

            @Override
            public IModificationProblem getModificationProblem() {
                return mp;
            }

            @Override
            public boolean permissionGranted() {
                return mp == null;
            }
        };
        if (mp == null) {
            this.addableData.put(addID, stakeholder);
        }
        return addID;
    }

    @Override
    public IModificationProblem checkStakeholderAddPermission() {
        CockpitPermissionTemplate template = new CockpitPermissionTemplate("editStakeholders", this.projectAgent.getPermissionOperandType());
        if (!this.projectAgent.getFramePermissionChecker().hasPermission(template, this.projectAgent)) {
            return new ModificationProblem(template, Messages.getString("StakeholderManager.may_not_add_stakeholders"), this.projectAgent);
        }
        return null;
    }

    @Override
    public IModificationProblem checkStakeholderRoleConnectionChangePermission() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("editStakeholders", this.projectAgent.getPermissionOperandType());
            modProblem = new ModificationProblem(template, Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged.NoPermission"), this.projectAgent);
        }
        Throwable serverException = null;
        try {
            EOLock lockOfOther = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            if (lockOfOther != null) {
                modProblem = new ModificationProblem(lockOfOther, Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged"));
            }
        }
        catch (ServerNotAvailableException e) {
            serverException = e;
        }
        catch (LoginCanceledException e) {
            serverException = e;
        }
        catch (EXServerException e) {
            serverException = e;
        }
        catch (UnknownServerException e) {
            serverException = e;
        }
        if (serverException != null) {
            modProblem = new ModificationProblem((Exception)serverException, Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged"));
        }
        return modProblem;
    }

    @Override
    public IStakeholderRoleConnectionAddID requestStakeholderRoleConnectionAddPermission(IStakeholder stakeholder, IStakeholderRole stakeholderRole) {
        final IFrameStakeholderManager.ILockReference lockReference = new IFrameStakeholderManager.ILockReference();
        IModificationProblem problem = this.requestStakeholderRoleConnectionChangePermission(lockReference);
        EORoleAndStakeholder roleAndStakeholder = null;
        if (problem == null) {
            roleAndStakeholder = new EORoleAndStakeholder();
            roleAndStakeholder.setProjectUID(this.projectAgent.getProjectUID());
            roleAndStakeholder.setRoleUID(stakeholderRole.getUID());
            roleAndStakeholder.setStakeholderUID(stakeholder.getUID());
            if (this.containsConnection(roleAndStakeholder)) {
                problem = new ModificationProblem(Messages.getString("StakeholderManager.belongs_aready_to_role"), Messages.getString("StakeholderManager.cannot_put_into_role"));
            }
        }
        final IModificationProblem mp = problem;
        IStakeholderRoleConnectionAddID addID = new IStakeholderRoleConnectionAddID(){

            @Override
            public IModificationProblem getModificationProblem() {
                return mp;
            }

            @Override
            public boolean permissionGranted() {
                return mp == null;
            }

            @Override
            public void releaseLocks() {
                lockReference.lock.release();
            }
        };
        if (mp == null) {
            this.addableData.put(addID, roleAndStakeholder);
        }
        return addID;
    }

    @Override
    public IModificationProblem requestStakeholderRoleConnectionDeletePermission(IFrameStakeholderManager.ILockReference lockReference) {
        return this.requestStakeholderRoleConnectionChangePermission(lockReference);
    }

    private IModificationProblem requestStakeholderRoleConnectionChangePermission(IFrameStakeholderManager.ILockReference lockReference) {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("editStakeholders", this.projectAgent.getPermissionOperandType());
            modProblem = new ModificationProblem(template, Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged.NoPermission"), this.projectAgent);
        }
        if (modProblem == null) {
            IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
            EOLock changeStakeholderRoleConnection = new LockRequest(this.projectAgent, "link_lock_stakeholder_stakeholder_role").createEOLock();
            ArrayList<EOLock> locksToBeChecked = new ArrayList<EOLock>();
            ArrayList<EOLock> locksToBeSet = new ArrayList<EOLock>();
            locksToBeChecked.add(changeStakeholderRoleConnection);
            locksToBeSet.add(changeStakeholderRoleConnection);
            final LockResult lockResult = lockMgr.atomicCheckAndSetLocks(locksToBeChecked, locksToBeSet, false);
            Collection<EOLock> conflictingLocks = lockResult.getConflictingLocks();
            if (!lockResult.wasSuccessful()) {
                if (!conflictingLocks.isEmpty()) {
                    EOLock conflictingLock = conflictingLocks.iterator().next();
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged"));
                } else if (lockResult.getPossibleServerException() != null) {
                    modProblem = new ModificationProblem(lockResult.getPossibleServerException(), Messages.getString("StakeholderManager.StakeholderRoleConnectionCannotBeChanged.ServerException"));
                }
            }
            lockReference.lock = new ILock(){

                @Override
                public void release() {
                    StakeholderManager.this.projectAgent.getFrameLockManager().releaseLocks(lockResult.getNewlyAddedLocks());
                }
            };
        }
        return modProblem;
    }

    @Override
    public IStakeholderRoleAddID requestStakeholderRoleAddPermission(String stakeholderRoleUID, String newName, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        StakeholderRole stakholderRole = new StakeholderRole(stakeholderRoleUID, newName, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        stakholderRole.setCategoryID(objectTypeCategoryID);
        return this.requestStakeholderRoleAddPermissionInternal(stakholderRole);
    }

    @Override
    public IStakeholderRoleAddID requestStakeholderRoleAddPermission(String newName, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes) {
        StakeholderRole stakholderRole = new StakeholderRole(UUIDGenerator.getUniqueID(), newName, attributes, IAttributeModificationManager.DUMMY, this.projectAgent);
        stakholderRole.setCategoryID(objectTypeCategoryID);
        return this.requestStakeholderRoleAddPermissionInternal(stakholderRole);
    }

    @Override
    public IStakeholderRoleAddID requestStakeholderRoleImportPermission(EOStakeholderRole eoStakeholderRole) {
        StakeholderRole stakholderRole = new StakeholderRole(eoStakeholderRole, IAttributeModificationManager.DUMMY, this.projectAgent);
        return this.requestStakeholderRoleAddPermissionInternal(stakholderRole);
    }

    private IStakeholderRoleAddID requestStakeholderRoleAddPermissionInternal(IStakeholderRole stakeholderRole) {
        RenameStakeholderRoleValidator validator;
        String msg;
        String problem = Messages.getString("StakeholderManager.role_cannot_be_added");
        IModificationProblem modProblem = null;
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            CockpitPermissionTemplate template = new CockpitPermissionTemplate("editStakeholders", this.projectAgent.getPermissionOperandType());
            modProblem = new ModificationProblem(template, problem, this.projectAgent);
        }
        String stakeholderRoleName = stakeholderRole.getName();
        if (modProblem == null && (msg = (validator = new RenameStakeholderRoleValidator(this.projectAgent)).isValid(stakeholderRoleName)) != null) {
            modProblem = new ModificationProblem(msg, problem);
        }
        if (modProblem == null) {
            modProblem = this.getLockForRenameRole(stakeholderRoleName);
        }
        final IModificationProblem mp = modProblem;
        IStakeholderRoleAddID addID = new IStakeholderRoleAddID(){

            @Override
            public IModificationProblem getModificationProblem() {
                return mp;
            }

            @Override
            public boolean permissionGranted() {
                return mp == null;
            }
        };
        if (mp == null) {
            this.addableData.put(addID, stakeholderRole);
        }
        return addID;
    }

    @Override
    public void requestStakeholderRoleDeletePermission(String roleUID, ILocksAndPermissionsTransactionController transactionController) {
        List<ICockpitProjectData> linkedModuleData = this.stakeholderRoleLinkFacade.getCrossLinkedModuleData(roleUID, ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("StakeholderManager.stakeholderrole_is_linked"), Messages.getString("StakeholderManager.could_not_delete_stakeholderrole")));
        }
        transactionController.addPermission("editStakeholders", null, this.operandTree);
        StakeholderRole role = this.getRoleByUIDInternal(roleUID);
        if (!this.modificationMgr.containsAddedRole(roleUID)) {
            transactionController.addLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            transactionController.addLock(role, "delete");
            transactionController.addLock(role, "modify");
            transactionController.addLockToTest(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            transactionController.addLockToTest(role, "add");
            transactionController.addLockToTest(role, "delete");
            transactionController.addLockToTest(role, "modify");
        }
        new FrameDataTransactionListener(role, this.approvedDataDeletions, transactionController);
    }

    @Override
    public void requestStakeholderDeletePermission(String stakeholderUID, ILocksAndPermissionsTransactionController transactionController) {
        List<ICockpitProjectData> linkedModuleData = this.stakeholderLinkFacade.getCrossLinkedModuleData(stakeholderUID, ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("StakeholderManager.stakeholder_is_linked"), Messages.getString("StakeholderManager.could_not_delete_stakeholder")));
        }
        transactionController.addPermission("editStakeholders", null, this.operandTree);
        Stakeholder stakeholder = this.getStakeholderByUIDInternal(stakeholderUID);
        if (!this.modificationMgr.containsAddedStakeholder(stakeholderUID)) {
            transactionController.addLock(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            transactionController.addLock(stakeholder, "delete");
            transactionController.addLock(stakeholder, "modify");
            transactionController.addLockToTest(this.projectAgent, "link_lock_stakeholder_stakeholder_role");
            transactionController.addLockToTest(stakeholder, "add");
            transactionController.addLockToTest(stakeholder, "delete");
            transactionController.addLockToTest(stakeholder, "modify");
        }
        new FrameDataTransactionListener(stakeholder, this.approvedDataDeletions, transactionController);
    }

    @Override
    public void roleNameModified(StakeholderRole role, String oldName) throws EXNoPermission, EXNoLock {
        for (StakeholderRole existing : this.getRolesInternal()) {
            if (!existing.getName().equalsIgnoreCase(role.getName()) || existing.getUID().equals(role.getUID())) continue;
            throw new EXNoPermission("Can not have two stakeholder roles with the same name.");
        }
        if (!this.projectAgent.getFrameLockManager().clientAlreadyHasLock(this.projectAgent, this.getLockTypeForRenameRole(role.getName()))) {
            throw new EXNoLock(this.projectAgent, this.getLockTypeForRenameRole(role.getName()));
        }
        IFrameLockManager lockMgr = this.projectAgent.getFrameLockManager();
        Collection<EOLock> locksToRelease = lockMgr.findClientLocksByILockable(this.projectAgent, this.getLockTypeForRenameRole(oldName));
        if (locksToRelease != null) {
            lockMgr.releaseLocks(locksToRelease);
        }
        this.roleModified(role);
    }

    @Override
    public void roleModified(StakeholderRole role) throws EXNoPermission, EXNoLock {
        if (!this.projectAgent.getFramePermissionChecker().hasPermission("editStakeholders", (String)null, this.projectAgent)) {
            throw new EXNoPermission((IPermissionOperand)this.projectAgent, "editStakeholders");
        }
        if (!this.modificationMgr.containsAddedRole(role.getUID()) && !this.projectAgent.getFrameLockManager().clientAlreadyHasLock(role, "modify")) {
            throw new EXNoLock(role, "modify");
        }
        this.dataModified(role);
    }

    @Override
    public boolean hasLocalModificationsForStakeholders() {
        return this.modificationMgr.containsAddedStakeholders() || this.modificationMgr.containsModifiedStakeholders() || this.modificationMgr.containesDeletedStakeholders() || this.modificationMgr.containsAddedConnections() || this.modificationMgr.containsDeletedConnections();
    }

    @Override
    public boolean hasLocalModificationsForRoles() {
        return this.modificationMgr.containsAddedRoles() || this.modificationMgr.containsModifiedRoles() || this.modificationMgr.containsDeletedRoles() || this.modificationMgr.containsAddedConnections() || this.modificationMgr.containsDeletedConnections();
    }

    @Override
    public Map<IAttributeTypeDataType, Collection<IAttribute>> getAllAttributesOfType(Class<? extends IAttributeTypeDataType> clazz) {
        ArrayList<AbstractFrameData> rolesAndStakeholders = new ArrayList<AbstractFrameData>((this.getStakeholdersInternal().values().size() + this.getRolesInternal().size()) * 2);
        rolesAndStakeholders.addAll(this.getStakeholdersInternal().values());
        rolesAndStakeholders.addAll(this.getRolesInternal());
        Map<IAttributeTypeDataType, Collection<IAttribute>> attributes = this.projectAgent.getAllAttributesOfType(rolesAndStakeholders, clazz);
        return attributes;
    }

    @Override
    public Collection<IAttributeType> getAllAttributeTypes(Class<? extends IAttributeTypeDataType> dataTypeClass) {
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        IAttributeTypesProvider forStakeholders = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholder");
        IAttributeTypesProvider forRoles = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.stakeholderrole");
        attributeTypes.addAll(forStakeholders.getAttributeTypes());
        attributeTypes.addAll(forRoles.getAttributeTypes());
        Iterator i = attributeTypes.iterator();
        while (i.hasNext()) {
            IAttributeType type = (IAttributeType)i.next();
            if (dataTypeClass.isAssignableFrom(type.getDataType().getClass())) continue;
            i.remove();
        }
        return attributeTypes;
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        if (data instanceof IStakeholder) {
            this.requestStakeholderDeletePermission(data.getUID(), transactionController);
        } else if (data instanceof IStakeholderRole) {
            this.requestStakeholderRoleDeletePermission(data.getUID(), transactionController);
        }
    }

    @Override
    public void deleteData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        this.deleteStakeholder(transactionController);
        this.deleteRole(transactionController);
    }

    @Override
    public void applySynchronousModification(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    @Override
    public void applyAsynchronousModifications(EOFrameDataModification<? extends EOCockpitProjectData> frameDataModification) {
    }

    public Collection<IFrameDataRW> getData() {
        Collection<Stakeholder> stakeholders = this.getStakeholdersInternal().values();
        Collection<StakeholderRole> roles = this.getRolesInternal();
        ArrayList<IFrameDataRW> data = new ArrayList<IFrameDataRW>((stakeholders.size() + roles.size()) * 2);
        data.addAll(stakeholders);
        data.addAll(roles);
        return data;
    }

    @Override
    public void visitAllAttributeOwnerRWs(IAttributeOwnerRW.IVisitor visitor) {
        IAttributeOwnerRW.Visitor.visitAllAttributeOwnerRWs(this.getData(), visitor);
    }

    @Override
    public IAttributeOwner getParent(IAttributeOwner child) {
        assert (child instanceof IStakeholder || child instanceof IStakeholderRole);
        return this.projectAgent.getProjectMetaDataManager().getProject();
    }

    @Override
    public Collection<? extends IAttributeOwner> getChildren(IAttributeOwner parent) {
        assert (parent instanceof IStakeholder || parent instanceof IStakeholderRole);
        return Collections.emptyList();
    }

    @Override
    public void requestAddPermission(String name, ObjectTypeCategoryID objectTypeCategoryID, Collection<IAttribute> attributes, IAttributeOwner parent, boolean forImport, ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addLockModificationProblem(new ModificationProblem("Functionality is not implemented.", "Can not add data."));
    }

    @Override
    public Collection<? extends IAttributeOwner> addData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Permission was not requested!");
    }

    @Override
    public boolean managesChildrenForType(String dataTypeID) {
        return dataTypeID.equals("frame.project");
    }

    @Override
    public void requestMovePermission(IAttributeOwner dataToMove, IAttributeOwner newParent, ILocksAndPermissionsTransactionController transactionController) {
        String msg = Messages.getString("StakeholderManager.a");
        if (dataToMove instanceof IStakeholder) {
            msg = String.valueOf(msg) + FrameDataTypes.getDataType("com.arcway.cockpit.stakeholder").getDisplayName();
        } else if (dataToMove instanceof IStakeholderRole) {
            msg = String.valueOf(msg) + FrameDataTypes.getDataType("com.arcway.cockpit.stakeholderrole").getDisplayName();
        }
        msg = String.valueOf(msg) + Messages.getString("StakeholderManager.cannot_be_moved");
        transactionController.addLockModificationProblem(new ModificationProblem(msg, Messages.getString("StakeholderManager.cannot_move_data")));
    }

    @Override
    public void moveData(ILocksAndPermissionsTransactionController transactionController) throws EXNoPermission {
        throw new EXNoPermission("Stakeholders and stakeholder roles can not be moved.");
    }

    @Override
    public void dataModified(IAttributeOwner modifiedData) {
        if (modifiedData instanceof Stakeholder) {
            Stakeholder modifiedStakeholder = (Stakeholder)modifiedData;
            if (this.modificationMgr.containsAddedStakeholder(modifiedStakeholder.getUID())) {
                this.modificationMgr.removeCreatedStakeholder(modifiedStakeholder.getUID());
                this.modificationMgr.addCreatedStakeholder(modifiedStakeholder);
            } else if (this.modificationMgr.containsModifiedStakeholder(modifiedStakeholder.getUID())) {
                this.modificationMgr.removeModifiedStakeholder(modifiedStakeholder.getUID());
                this.modificationMgr.addModifiedStakeholder(modifiedStakeholder);
            } else {
                this.modificationMgr.addModifiedStakeholder(modifiedStakeholder);
            }
            PropertyChanges changes = new PropertyChanges(null, (Object)modifiedStakeholder, null);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholder.class);
            this.saveStakeholderModifications();
        } else if (modifiedData instanceof StakeholderRole) {
            StakeholderRole modifiedRole = (StakeholderRole)modifiedData;
            if (!this.modificationMgr.containsAddedRole(modifiedRole.getUID()) && !this.modificationMgr.containsModifiedRole(modifiedRole.getUID())) {
                this.modificationMgr.addModifiedRole(modifiedRole);
            }
            PropertyChanges changes = new PropertyChanges(null, (Object)modifiedRole, null);
            this.projectAgent.getPropertyChangesProviderManager().modelRefreshed((IPropertyChanges)changes, IStakeholderRole.class);
            this.saveStakeholderModifications();
        } else assert (false);
    }

    @Override
    public List<IFrameDataRW> importDataFromEO(List<EOFrameData> eos) {
        return null;
    }

    @Override
    public boolean isLocallyModified(String dataUID) {
        for (EORoleAndStakeholder connection : this.modificationMgr.getAddedConnections()) {
            if (!connection.getStakeholderUID().equals(dataUID) && !connection.getRoleUID().equals(dataUID)) continue;
            return true;
        }
        for (EORoleAndStakeholder connection : this.modificationMgr.getDeletedConections()) {
            if (!connection.getStakeholderUID().equals(dataUID) && !connection.getRoleUID().equals(dataUID)) continue;
            return true;
        }
        return this.modificationMgr.containsModifiedStakeholder(dataUID) || this.modificationMgr.containsModifiedRole(dataUID);
    }

    @Override
    public boolean isLocallyAdded(String dataUID) {
        return this.modificationMgr.containsAddedStakeholder(dataUID) || this.modificationMgr.containsAddedRole(dataUID);
    }

    @Override
    public IFrameDataFactory getDataFactory() {
        return null;
    }

    @Override
    public IAttributeOwner getServerState(String dataUID) {
        return null;
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return null;
    }

    private class Exporter
    implements IStakeholderExporter {
        private Exporter() {
        }

        @Override
        public Collection<EOStakeholder> getEOStakeholders() {
            Collection stakeholders = StakeholderManager.this.getStakeholdersInternal().values();
            ArrayList<EOStakeholder> eos = new ArrayList<EOStakeholder>(stakeholders.size() * 2);
            for (Stakeholder stakeholder : stakeholders) {
                eos.add((EOStakeholder)stakeholder.createEncodableObject());
            }
            return eos;
        }

        @Override
        public Collection<EOStakeholderRole> getEORoles() {
            Collection roles = StakeholderManager.this.getRolesInternal();
            ArrayList<EOStakeholderRole> eos = new ArrayList<EOStakeholderRole>(roles.size() * 2);
            for (StakeholderRole role : roles) {
                eos.add((EOStakeholderRole)role.createEncodableObject());
            }
            return eos;
        }

        @Override
        public Collection<EORoleAndStakeholder> getConnections(Collection<EOStakeholder> eoStakeholders, Collection<EOStakeholderRole> eoRoles) {
            ArrayList<EORoleAndStakeholder> connections = new ArrayList<EORoleAndStakeholder>();
            for (EOStakeholder stakeholder : eoStakeholders) {
                connections.addAll(this.getConnections(stakeholder, eoRoles));
            }
            return connections;
        }

        private Collection<EORoleAndStakeholder> getConnections(EOStakeholder stakeholder, Collection<EOStakeholderRole> eoRoles) {
            ArrayList<EORoleAndStakeholder> connections = new ArrayList<EORoleAndStakeholder>(eoRoles.size() * 2);
            for (EOStakeholderRole role : eoRoles) {
                EORoleAndStakeholder ras = this.getConnection(stakeholder, role);
                if (ras == null) continue;
                connections.add(ras);
            }
            return connections;
        }

        private EORoleAndStakeholder getConnection(EOStakeholder stakeholder, EOStakeholderRole role) {
            for (EORoleAndStakeholder ras : StakeholderManager.this.getAllConnections()) {
                if (!ras.getStakeholderUID().equals(stakeholder.getUID()) || !ras.getRoleUID().equals(role.getUID())) continue;
                return ras;
            }
            return null;
        }
    }
}

