/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.stakeholders;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.Stakeholder;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;

public class StakeholderAttributeModificationManager
implements IAttributeModificationManager {
    private Stakeholder stakeholder;
    private final IFrameProjectAgent projectAgent;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return StakeholderAttributeModificationManager.this.projectAgent;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return null;
        }
    };

    public StakeholderAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            IAttributeType type = this.stakeholder.getAttributeType(newAttribute.getAttributeTypeID());
            this.checkGeneralModificationPermissions(type, transactionController);
            transactionController.addLockToTest(this.stakeholder, "modify");
            transactionController.addLock(this.stakeholder, "modify");
        }
        if (newAttribute.getAttributeTypeID().equals(StakeholderAttributeTypesProvider.ATTRID_NAME)) {
            String newName;
            RenameStakeholderValidator validator = new RenameStakeholderValidator(this.projectAgent, this.stakeholder.getUID());
            String msg = validator.isValid(newName = (String)newAttribute.getAttributeValue());
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(msg, Messages.getString("StakeholderAttributeModificationManager.new_name_is_invalid"));
                transactionController.addLockModificationProblem(modProblem);
            }
            transactionController.addLockToTest(this.projectAgent, this.projectAgent.getFrameStakeholderManager().getLockTypeForRenameStakeholder(newName));
            transactionController.addLock(this.projectAgent, this.projectAgent.getFrameStakeholderManager().getLockTypeForRenameStakeholder(newName));
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            transactionController.addLockToTest(this.stakeholder, "modify");
            transactionController.addLock(this.stakeholder, "modify");
        }
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            Throwable serverException = null;
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.stakeholder, "modify");
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("StakeholderAttributeModificationManager.cannot_modify_stakeholder"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("StakeholderAttributeModificationManager.cannot_modify_stakeholder"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            transactionController.addPermission("editStakeholders", null, this.operandTree);
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.stakeholder, "modify");
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.checkConditions(true, true);
        return modProblems;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            IAttributeType type = this.stakeholder.getAttributeType(newAttribute.getAttributeTypeID());
            if (!this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(type, this.operandTree, false)) {
                throw new EXNoPermission("no permission for modifying attribute of type " + type.getDisplayName());
            }
        }
        if (newAttribute.getAttributeTypeID().equals(StakeholderAttributeTypesProvider.ATTRID_NAME)) {
            this.projectAgent.getFrameStakeholderManager().stakeholderNameModified(this.stakeholder, (String)oldAttributeValue);
        } else {
            this.projectAgent.getFrameStakeholderManager().stakeholderModified(this.stakeholder);
        }
    }

    public void setStakeholder(Stakeholder stakeholder) {
        this.stakeholder = stakeholder;
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        this.projectAgent.getFrameStakeholderManager().stakeholderModified(this.stakeholder);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        if (!this.projectAgent.getFrameStakeholderManager().isLocallyAdded(this.stakeholder.getUID())) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            return transactionController.checkConditions(false, true);
        }
        return Collections.emptyList();
    }

    private void checkObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("editStakeholders", null, this.operandTree);
    }
}

