/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections;

import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class SectionImportHelper {
    private final HashMap<String, EOSection> sectionUID2EOSection;
    private final List<String> alreadyImportedSections = new ArrayList<String>();

    public SectionImportHelper(Collection<EOSection> eoSections) {
        this.sectionUID2EOSection = new HashMap();
        for (EOSection eoSection : eoSections) {
            this.sectionUID2EOSection.put(eoSection.getUID(), eoSection);
        }
    }

    public EOSection getParentFromSectionsToImport(String parentUID) {
        return this.sectionUID2EOSection.get(parentUID);
    }

    public String getParentUIDFromEO(EOSection eoSection) {
        EOAttribute parentUIDAttribute = this.getParentUIDAttribute(eoSection);
        String parentUID = ((EOString)parentUIDAttribute.getValueAsEO()).getString();
        return parentUID;
    }

    public void setParentUIDForEO(String newParentUID, EOSection eoSection) {
        EOAttribute parentUIDAttribute = this.getParentUIDAttribute(eoSection);
        EOString parentUID = new EOString(newParentUID);
        parentUIDAttribute.setValueAsEO((EOEncodableObject)parentUID);
    }

    private EOAttribute getParentUIDAttribute(EOSection eoSection) {
        EOAttribute parentUIDAttribute = null;
        for (EOAttribute eoAttribute : eoSection.getAttributes()) {
            if (!eoAttribute.getAttributeTypeUID().getEOAttributeTypeID().equals(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID.getUID())) continue;
            parentUIDAttribute = eoAttribute;
            break;
        }
        assert (parentUIDAttribute != null);
        return parentUIDAttribute;
    }

    public void addImportedSectionUID(String sectionUID) {
        this.alreadyImportedSections.add(sectionUID);
    }

    public boolean isSectionAlreadyImported(String sectionUID) {
        return this.alreadyImportedSections.contains(sectionUID);
    }
}

