/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISectionRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public class Section
extends AbstractFrameData
implements ISectionRW {
    private static final ILogger logger = Logger.getLogger(Section.class);
    private static final String ATTR_TAG_PARENT_UID = "parentuid";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private String tempParentUID;

    public Section(String uID, String name, String parentUID, Collection<IAttribute> attributes, IFrameProjectAgent projectAgent, IAttributeModificationManager modificationManager) {
        super(uID, projectAgent.getUID(), "com.arcway.cockpit.section", attributes, modificationManager, projectAgent);
        Attribute nameAttr = new Attribute(SectionAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(nameAttr);
        Attribute parentUIDAttr = new Attribute(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID, parentUID);
        this.simplySetAttribute(parentUIDAttr);
    }

    public Section(EOSection eoSection, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super((EOFrameData)eoSection, "com.arcway.cockpit.section", modManager, projectAgent);
        Attribute attribute;
        String description;
        String name;
        String parentUID = eoSection.getOldAttributeValue(ATTR_TAG_PARENT_UID);
        if (parentUID != null) {
            Attribute attribute2 = new Attribute(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID, parentUID);
            this.simplySetAttribute(attribute2);
        }
        if ((name = eoSection.getOldAttributeValue(ATTR_TAG_NAME)) != null) {
            Attribute attribute3 = new Attribute(SectionAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
            this.simplySetAttribute(attribute3);
        }
        if ((description = eoSection.getOldAttributeValue(ATTR_TAG_DESCRIPTION)) != null) {
            attribute = new Attribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.simplySetAttribute(attribute);
        }
        if (this.getParentUID() == null || this.getParentUID().equals("") || this.getParentUID().equals(this.getProjectUID()) || eoSection.getOldProjectUID() != null && this.getParentUID().equals(eoSection.getOldProjectUID())) {
            attribute = new Attribute(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID, "rootSection");
            this.simplySetAttribute(attribute);
        }
    }

    public Section(ISection section, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super(section.getUID(), section.getProjectUID(), "com.arcway.cockpit.section", (Collection<IAttribute>)section.getAllAttributes(), modManager, projectAgent);
    }

    @Override
    public String getSectionName() {
        if (!this.isRootSection()) {
            IAttribute attribute = this.getAttribute(SectionAttributeTypesProvider.ATTRID_NAME);
            return (String)attribute.getAttributeValue();
        }
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.getProjectUID());
        return projectAgent.getProjectName();
    }

    @Override
    public String getDescription() {
        try {
            IAttribute attribute = this.getAttribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION);
            return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getParentUID() {
        if (this.tempParentUID == null) {
            try {
                IAttribute attribute = this.getAttribute(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID);
                return (String)attribute.getAttributeValue();
            }
            catch (ExInvalidAttributeType e) {
                logger.error("could not execute", (Throwable)e);
            }
        } else {
            return this.tempParentUID;
        }
        return null;
    }

    @Override
    public boolean isRootSection() {
        String parentUID = this.getParentUID();
        return parentUID.equals("rootSection");
    }

    public String getPermissionOperandType() {
        return "section";
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getSectionName();
    }

    @Override
    public void setName(String newName) throws EXNoPermission, EXNoLock {
        Attribute attribute = new Attribute(SectionAttributeTypesProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(newName, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public void setDescription(String newDescription) throws EXNoPermission, EXNoLock {
        Attribute attribute = new Attribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(newDescription, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    @Override
    public void setParentUID(String newSectionUID) throws EXNoPermission, EXNoLock {
        this.setTemporaryParentUID(null);
        Attribute attribute = new Attribute(SectionAttributeTypesProvider.ATTRID_PARENT_SECTION_UID, newSectionUID);
        try {
            this.setAttributeWithoutMetaAttributeRefresh(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not execute", (Throwable)e);
        }
    }

    public void setTemporaryParentUID(String tempParentUID) {
        this.tempParentUID = tempParentUID;
    }

    public EOSection createEncodableObject() {
        EOSection eoSection = new EOSection(super.createEncodableObject());
        return eoSection;
    }
}

