/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.files.FileID;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.shared.message.EOPlan;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.shared.message.EOUser;
import java.util.Collection;

public class Plan
extends AbstractFrameData
implements IPlanRW {
    private static final ILogger logger = Logger.getLogger(Plan.class);
    private static final String ATTR_TAG_SECTION_UID = "sectionuid";
    private static final String ATTR_TAG_NAME = "name";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private static final String ATTR_TAG_PLAN_TYPE = "plantype";
    private static final String ATTR_TAG_CREATION_DATE = "creationDate";
    private static final String ATTR_TAG_LAST_EDIT_DATE = "lastEditDate";
    private static final String LIST_ROLE_CREATOR = "creator";
    private static final String LIST_ROLE_EDITOR = "editor";
    private String tempParentUID;
    private boolean isHistoricItem = false;

    public Plan(String name, String uID, String planTypeID, String sectionUID, Collection<IAttribute> attributes, IAttributeModificationManager attributeModificationManager, IFrameProjectAgent projectAgent) {
        super(uID, projectAgent.getUID(), "com.arcway.cockpit.plan", attributes, attributeModificationManager, projectAgent);
        Attribute attributeName = new Attribute(PlanAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        this.simplySetAttribute(attributeName);
        Attribute attributeSection = new Attribute(PlanAttributeTypeProvider.ATTRID_SECTION_UID, sectionUID);
        this.simplySetAttribute(attributeSection);
        Attribute attributePlanType = new Attribute(PlanAttributeTypeProvider.ATTRID_PLAN_TYPE_UID, planTypeID);
        this.simplySetAttribute(attributePlanType);
    }

    public Plan(EOFrameData eo, IAttributeModificationManager attributeModificationManager, IFrameProjectAgent projectAgent) {
        super(eo, "com.arcway.cockpit.plan", attributeModificationManager, projectAgent);
        String lastEditDate;
        String creationDate;
        String planType;
        String description;
        String name;
        String sectionUID = eo.getOldAttributeValue(ATTR_TAG_SECTION_UID);
        if (sectionUID != null) {
            Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_SECTION_UID, sectionUID);
            this.simplySetAttribute(attribute);
        }
        if ((name = eo.getOldAttributeValue(ATTR_TAG_NAME)) != null) {
            Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((description = eo.getOldAttributeValue(ATTR_TAG_DESCRIPTION)) != null) {
            Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.simplySetAttribute(attribute);
        }
        if ((planType = eo.getOldAttributeValue(ATTR_TAG_PLAN_TYPE)) != null) {
            Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_PLAN_TYPE_UID, planType);
            this.simplySetAttribute(attribute);
        }
        if ((creationDate = eo.getOldAttributeValue(ATTR_TAG_CREATION_DATE)) != null) {
            Attribute attribute = new Attribute(AbstractAttributeTypesProvider.ATTRID_CREATION_DATE, creationDate);
            this.simplySetAttribute(attribute);
        }
        if ((lastEditDate = eo.getOldAttributeValue(ATTR_TAG_LAST_EDIT_DATE)) != null) {
            Attribute attribute = new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE, lastEditDate);
            this.simplySetAttribute(attribute);
        }
        for (Object o : eo.getOldChildren()) {
            Attribute attribute;
            EOUser eoUser;
            if (!(o instanceof EOList)) continue;
            EOList list = (EOList)o;
            if (list.getRole().equals(LIST_ROLE_CREATOR)) {
                if (list.size() <= 0) continue;
                eoUser = (EOUser)list.get(0);
                attribute = new Attribute(AbstractAttributeTypesProvider.ATTRID_CREATOR, DataTypeString.getInstanceString().getAttributeValueFromString(eoUser.getDisplayName(), null, null));
                this.simplySetAttribute(attribute);
                continue;
            }
            if (!list.getRole().equals(LIST_ROLE_EDITOR) || list.size() <= 0) continue;
            eoUser = (EOUser)list.get(0);
            attribute = new Attribute(AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR, DataTypeString.getInstanceString().getAttributeValueFromString(eoUser.getDisplayName(), null, null));
            this.simplySetAttribute(attribute);
        }
        this.isHistoricItem = eo.isHistoricItem();
    }

    @Override
    public String getPlanName() {
        try {
            return (String)this.getAttribute(PlanAttributeTypeProvider.ATTRID_NAME).getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get plan name", (Throwable)e);
            return null;
        }
    }

    @Override
    public FileID getPlanFileID() {
        try {
            return (FileID)this.getAttribute(PlanAttributeTypeProvider.ATTRID_PLAN_FILE_DESCRIPTION).getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get plan file version", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        try {
            return DataTypeText.getInstanceText().getValueAsMultiLineString(this.getAttribute(PlanAttributeTypeProvider.ATTRID_DESCRIPTION).getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get plan description", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getPlantypeUID() {
        try {
            return (String)this.getAttribute(PlanAttributeTypeProvider.ATTRID_PLAN_TYPE_UID).getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not get plan type uid", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getSectionUID() {
        if (this.tempParentUID == null) {
            try {
                return (String)this.getAttribute(PlanAttributeTypeProvider.ATTRID_SECTION_UID).getAttributeValue();
            }
            catch (ExInvalidAttributeType e) {
                logger.error("could not get plan section id", (Throwable)e);
            }
        } else {
            return this.tempParentUID;
        }
        return null;
    }

    @Override
    public void setName(String name) throws EXNoPermission, EXNoLock {
        Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        try {
            this.setAttribute(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not set name", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not set name", (Throwable)e);
        }
    }

    public void setPlanTypeUID(String planTypeUID) {
        Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_PLAN_TYPE_UID, planTypeUID);
        this.simplySetAttribute(attribute);
    }

    @Override
    public void setDescription(String description) throws EXNoPermission, EXNoLock {
        if (description != null) {
            Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
            this.setAttribute(attribute);
        } else {
            IAttributeType attributeType = this.getAttributeType(PlanAttributeTypeProvider.ATTRID_DESCRIPTION);
            Attribute attribute = new Attribute(attributeType.getAttributeTypeID(), attributeType.getDataType().getDefaultValue());
            this.setAttribute(attribute);
        }
    }

    @Override
    public void setSectionUID(String sectionUID) throws EXNoPermission, EXNoLock {
        this.setTempParentUID(null);
        Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_SECTION_UID, sectionUID);
        try {
            this.setAttributeWithoutMetaAttributeRefresh(attribute);
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not set section uid", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("could not set section uid", (Throwable)e);
        }
    }

    @Override
    public void setPlanFileID(FileID fileID, boolean refreshMetaAttributes) throws EXNoPermission, EXNoLock {
        Attribute attribute = new Attribute(PlanAttributeTypeProvider.ATTRID_PLAN_FILE_DESCRIPTION, fileID);
        try {
            if (refreshMetaAttributes) {
                this.setAttribute(attribute);
            } else {
                this.setAttributeWithoutMetaAttributeRefresh(attribute);
            }
        }
        catch (ExInvalidAttributeType e) {
            logger.error("Could not set file description", (Throwable)e);
        }
        catch (ExInvalidDataType e) {
            logger.error("Could not set file description", (Throwable)e);
        }
    }

    public void setTempParentUID(String tempParentUID) {
        this.tempParentUID = tempParentUID;
    }

    public EOPlan createEncodableObject() {
        EOFrameData frameData = super.createEncodableObject();
        EOPlan eoPlan = new EOPlan(frameData);
        return eoPlan;
    }

    public boolean isHistoricItem() {
        return this.isHistoricItem;
    }
}

