/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.PlanAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.SectionManager;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.Section;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeModificationManager;
import com.arcway.cockpit.frame.shared.message.EOSection;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SectionServerCache {
    private final Map<String, Section> sections = new HashMap<String, Section>();
    private final Map<String, Plan> plans = new HashMap<String, Plan>();
    private final IFrameProjectAgent projectAgent;

    protected SectionServerCache(SectionManager sectionManager) {
        this.projectAgent = sectionManager.getProjectAgent();
    }

    protected void setupCache(EOSection[] sectionsOnServer, EOFrameData[] plansOnServer) {
        IAttributeModificationManager modManager;
        EOSection element;
        int n;
        int n2;
        EOSection[] eOSectionArray;
        if (sectionsOnServer != null) {
            eOSectionArray = sectionsOnServer;
            n2 = sectionsOnServer.length;
            n = 0;
            while (n < n2) {
                element = eOSectionArray[n];
                modManager = new SectionAttributeModificationManager(this.projectAgent);
                Section section = new Section(element, this.projectAgent, modManager);
                ((SectionAttributeModificationManager)modManager).setSection(section);
                this.sections.put(section.getUID(), section);
                ++n;
            }
        }
        if (plansOnServer != null) {
            eOSectionArray = plansOnServer;
            n2 = plansOnServer.length;
            n = 0;
            while (n < n2) {
                element = eOSectionArray[n];
                modManager = new PlanAttributeModificationManager(this.projectAgent);
                Plan plan = new Plan((EOFrameData)element, modManager, this.projectAgent);
                ((PlanAttributeModificationManager)modManager).setPlan(plan);
                this.plans.put(plan.getUID(), plan);
                ++n;
            }
        }
    }

    protected Section getSection(String sectionUID) {
        return this.sections.get(sectionUID);
    }

    protected Collection<Section> getSections() {
        return this.sections.values();
    }

    protected Collection<Plan> getPlans() {
        return this.plans.values();
    }

    protected Plan getPlan(String planUID) {
        return this.plans.get(planUID);
    }

    protected void addPlan(Plan plan) {
        this.plans.put(plan.getUID(), plan);
    }

    protected void removePlan(Plan plan) {
        this.plans.remove(plan.getUID());
    }

    protected void addSection(Section section) {
        this.sections.put(section.getUID(), section);
    }

    protected void removeSection(Section section) {
        this.sections.remove(section.getUID());
    }
}

