/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.sectionsandplans;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.validators.RenamePlanValidator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.Plan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.Collection;
import java.util.Collections;

public class PlanAttributeModificationManager
implements IAttributeModificationManager {
    private Plan plan;
    private final IFrameSectionManager sectionManager;
    private final IFrameProjectAgent projectAgent;
    private final IAttributeTypesProvider attributeTypeProvider;
    private final IParentOperandTree operandTree;

    public PlanAttributeModificationManager(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
        this.sectionManager = projectAgent.getFrameSectionManager();
        this.attributeTypeProvider = projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.plan");
        this.operandTree = new IParentOperandTree(){

            @Override
            public IPermissionOperand getBaseOperand() {
                return PlanAttributeModificationManager.this.sectionManager.getParentSection(PlanAttributeModificationManager.this.plan);
            }

            @Override
            public IPermissionOperand getParent(IPermissionOperand childOperand) {
                ISection section = (ISection)childOperand;
                return PlanAttributeModificationManager.this.sectionManager.getParentSection(section);
            }
        };
    }

    public void setPlan(Plan plan) {
        this.plan = plan;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        IAttributeType type = this.attributeTypeProvider.getAttributeType(newAttribute.getAttributeTypeID());
        if (!this.sectionManager.isLocallyAdded(this.plan) && !this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(type, this.operandTree, false)) {
            throw new EXNoPermission(new ModificationProblem(type, this.operandTree, this.projectAgent).getHumanReadableDescriptionOfCause());
        }
        if (PlanAttributeTypeProvider.ATTRID_SECTION_UID.equals(newAttribute.getAttributeTypeID())) {
            ISection oldParentSection = this.sectionManager.getSection((String)oldAttributeValue);
            this.sectionManager.planMoved(this.plan, oldParentSection);
        } else if (PlanAttributeTypeProvider.ATTRID_NAME.equals(newAttribute.getAttributeTypeID())) {
            this.sectionManager.planNameUpdated(this.plan);
        } else {
            this.sectionManager.planUpdated(this.plan);
        }
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(this.plan)) {
            Throwable serverException = null;
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.plan, "modify");
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("PlanAttributeModificationManager.the_plan_cannot_be_modified"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("PlanAttributeModificationManager.the_plan_cannot_be_modified"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        ISection oldParentSection;
        if (!this.sectionManager.isLocallyAdded(this.plan)) {
            transactionController.addPermission("editPlan", null, this.operandTree);
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.plan, "modify");
        }
        if (attributeType.getAttributeTypeID().equals(PlanAttributeTypeProvider.ATTRID_SECTION_UID) && !this.sectionManager.isLocallyAdded(oldParentSection = this.sectionManager.getParentSection(this.plan))) {
            transactionController.addPermission("modifyFolders", null, this.sectionManager.getOperandTree(oldParentSection));
            transactionController.addLockToTest(oldParentSection, "add");
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        Collection<IModificationProblem> modProblems = transactionController.checkConditions(true, true);
        return modProblems;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.sectionManager.isLocallyAdded(this.plan)) {
            transactionController.addLockToTest(this.plan, "modify");
            transactionController.addLock(this.plan, "modify");
            transactionController.addPermission("editPlan", null, this.operandTree);
        }
        if (newAttribute.getAttributeTypeID().equals(PlanAttributeTypeProvider.ATTRID_SECTION_UID)) {
            ISection newParentSection = this.sectionManager.getSection((String)newAttribute.getAttributeValue());
            RenamePlanValidator validator = new RenamePlanValidator(this.projectAgent, newParentSection.getUID());
            String validatorMsg = validator.isValid(this.plan.getPlanName());
            if (validatorMsg != null) {
                ModificationProblem modProblem = new ModificationProblem(Messages.getString("PlanAttributeModificationManager.new_name_is_invalid"), validatorMsg);
                transactionController.addLockModificationProblem(modProblem);
            }
            IParentOperandTree operandTreeNewSection = this.sectionManager.getOperandTree(newParentSection);
            for (IAttribute attribute : this.plan.getAllAttributes()) {
                IAttributeType attributeType = this.plan.getAttributeType(attribute.getAttributeTypeID());
                if (!attributeType.restrictedAccessOnCreation() || attribute.getAttributeValue().equals(attributeType.getDataType().getDefaultValue())) continue;
                transactionController.addAttributeModificationPermission(attributeType, operandTreeNewSection);
            }
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(newParentSection)) {
                transactionController.addPermission("modifyFolders", null, operandTreeNewSection);
                transactionController.addLock(newParentSection, "add");
            }
            ISection oldParentSection = this.sectionManager.getParentSection(this.plan);
            if (!this.projectAgent.getFrameSectionManager().isLocallyAdded(oldParentSection)) {
                transactionController.addPermission("modifyFolders", null, this.sectionManager.getOperandTree(oldParentSection));
                transactionController.addLock(oldParentSection, "add");
            }
        }
        if (newAttribute.getAttributeTypeID().equals(PlanAttributeTypeProvider.ATTRID_NAME)) {
            ISection parentSection = this.sectionManager.getParentSection(this.plan);
            RenamePlanValidator validator = new RenamePlanValidator(this.plan);
            String newName = (String)newAttribute.getAttributeValue();
            String msg = validator.isValid(newName);
            if (msg != null) {
                ModificationProblem modProblem = new ModificationProblem(Messages.getString("PlanAttributeModificationManager.new_name_is_invalid"), msg);
                transactionController.addLockModificationProblem(modProblem);
            }
            transactionController.addLockToTest(parentSection, "uniqueName_" + this.plan.getTypeID() + "_" + newName.toLowerCase());
            transactionController.addLock(parentSection, "uniqueName_" + this.plan.getTypeID() + "_" + newName.toLowerCase());
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        if (!this.sectionManager.isLocallyAdded(this.plan)) {
            transactionController.addLockToTest(this.plan, "modify");
            transactionController.addLock(this.plan, "modify");
            this.checkObjectTypeCategoryModificationPermission(transactionController);
        }
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
        this.sectionManager.planUpdated(this.plan);
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        if (!this.sectionManager.isLocallyAdded(this.plan)) {
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.checkObjectTypeCategoryModificationPermission(transactionController);
            return transactionController.checkConditions(false, true);
        }
        return Collections.emptyList();
    }

    private void checkObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        transactionController.addPermission("editPlan", null, this.operandTree);
    }
}

