/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.ProjectDirectoryLayout;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameDataManagerAdministrator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameReportTemplateFolderManager;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.IFrameDataFactory;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.links.linkableobjects.ILOLinkAccessFacade;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.FrameDataAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFolderAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.serverproxy.ServerDataContainer;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReportTemplateFoldersManager
extends DataManager
implements IFrameReportTemplateFolderManager,
IProjectCloseListener {
    private static final ILogger logger = Logger.getLogger(ReportTemplateFoldersManager.class);
    private static final Collection<ICockpitDataType> parentTypes = new ArrayList<ICockpitDataType>();
    private ILOLinkAccessFacade linkFacade;

    static {
        parentTypes.add(FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER));
        parentTypes.add(FrameDataTypes.getDataType("frame.project"));
    }

    private static IFrameDataFactory createDataFactory(final IFrameProjectAgent projectAgent) {
        return new IFrameDataFactory(){

            @Override
            public IFrameDataRW createFrameData(EOFrameData eo) {
                return new ReportTemplateFolder(eo, projectAgent, IAttributeModificationManager.DUMMY);
            }

            @Override
            public IFrameDataRW createFrameData(Collection<IAttribute> attributes) {
                return new ReportTemplateFolder(UUIDGenerator.getUniqueID(), attributes, projectAgent, IAttributeModificationManager.DUMMY);
            }

            @Override
            public void setAttributeModificationManager(IFrameDataRW frameData) {
                FrameDataAttributeModificationManager modManager = ReportTemplateFoldersManager.createAttributeModificationManager(projectAgent);
                ReportTemplateFolder folder = (ReportTemplateFolder)frameData;
                folder.setAttributeModificationManager(modManager);
                modManager.setFrameData(folder);
            }

            @Override
            public void setAttributeModificationManager(IFrameDataRW frameData, IAttributeModificationManager modManager) {
                ReportTemplateFolder folder = (ReportTemplateFolder)frameData;
                folder.setAttributeModificationManager(modManager);
            }
        };
    }

    public ReportTemplateFoldersManager(IFrameProjectAgent projectAgent) {
        super(ProjectDirectoryLayout.FILEKEY_REPORTTEMPLATEFOLDERS, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER), ReportTemplateFoldersManager.createDataFactory(projectAgent), projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER), IReportTemplateFolderRW.class, projectAgent.getLinkManager(), parentTypes);
    }

    @Override
    public void initializeAfterPermissionsCheck(IFrameDataManagerAdministrator administrator, ServerDataContainer serverDataContainer) throws EXCorruptProjectData {
        super.initializeAfterPermissionsCheck(administrator, serverDataContainer);
        administrator.getFrameProjectAgent().addProjectCloseListener(this);
        this.linkFacade = this.getProjectAgent().getLinkManager().getLOLinkAccessFacade(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER);
    }

    @Override
    public void closeProject(IFrameProjectAgent pa) {
        this.linkFacade = null;
    }

    @Override
    public ILOLinkAccessFacade getReportTemplateFolderLinkFacade() {
        return this.linkFacade;
    }

    public static void createRootFolder(IFrameProjectAgent projectAgent) {
        IFrameDataManager dataManager = projectAgent.getDataManager(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER);
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(projectAgent);
        String name = Messages.getString("ProjectTreeContentProvider.report_templates");
        String description = Messages.getString("ReportTemplateFoldersManager.root_folder_description");
        Attribute nameAttribute = new Attribute(ReportTemplateFolderAttributeTypesProvider.ATTR_ID_NAME, DataTypeString.getInstanceString().getAttributeValueFromString(name, null, null));
        Attribute descrAttribute = new Attribute(ReportTemplateFolderAttributeTypesProvider.ATTR_ID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null));
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        attributes.add(nameAttribute);
        attributes.add(descrAttribute);
        dataManager.requestAddPermission(name, null, attributes, (IAttributeOwner)projectAgent.getProject(), true, transactionController);
        Collection<IModificationProblem> problems = transactionController.execute();
        Collection<Object> createdFolders = Collections.emptyList();
        if (problems.isEmpty()) {
            try {
                createdFolders = dataManager.addData(transactionController);
                if (createdFolders.isEmpty()) {
                    logger.error("Report template root folder could not be created.");
                }
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        } else {
            IModificationProblem problem = problems.iterator().next();
            logger.error("can not create root report template folder. " + problem.getHumanReadableDescriptionOfCause());
        }
    }

    @Override
    public void requestDataDeletePermission(IAttributeOwner data, ILocksAndPermissionsTransactionController transactionController) {
        IAttributeOwner parent;
        List<ICockpitProjectData> linkedModuleData = this.linkFacade.getCrossLinkedModuleData(data.getUID(), ILinkContentProvider.NO_LINK_TYPE_FILTER);
        if (!linkedModuleData.isEmpty()) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("ReportTemplatesFoldersManager.reporttemplatefolder_is_linked"), Messages.getString("ReportTemplatesFoldersManager.could_not_delete_reporttemplatefolder")));
        }
        if ((parent = this.getParent(data)).equals(this.getProjectAgent().getProject())) {
            transactionController.addLockModificationProblem(new ModificationProblem(Messages.getString("ReportTemplateFoldersManager.cannot_delete_root"), Messages.getString("ReportTemplateFoldersManager.cannot_delete_folder")));
        } else {
            super.requestDataDeletePermission(data, transactionController);
        }
    }

    @Override
    public void discardLocalModifications() {
        super.discardLocalModifications();
    }

    @Override
    public Collection<IClientFunctionLicenseType> getNeededLicenseTypesForAdd() {
        return Collections.emptyList();
    }

    @Override
    public Collection<IClientFunctionLicenseType> getNeededLicenseTypesForDelete() {
        return this.getNeededLicenseTypesForAdd();
    }

    @Override
    public IAttributeTypesProvider getAttributeTypesProvider() {
        return this.getProjectAgent().getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER);
    }

    public static FrameDataAttributeModificationManager createAttributeModificationManager(IFrameProjectAgent projectAgent) {
        FrameDataAttributeModificationManager modManager = new FrameDataAttributeModificationManager(projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER), projectAgent);
        return modManager;
    }

    @Override
    public void checkAttributeOnCreation(IAttribute attribute, ILocksAndPermissionsTransactionController transactionController) {
    }
}

