/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateFolderAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Collection;

public class ReportTemplateFolder
extends AbstractFrameData
implements IReportTemplateFolderRW {
    private static final ILogger logger = Logger.getLogger(ReportTemplateFolder.class);

    public ReportTemplateFolder(String uID, Collection<IAttribute> attributes, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super(uID, projectAgent.getProjectUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, attributes, modManager, projectAgent);
    }

    public ReportTemplateFolder(EOFrameData eo, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super(eo, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, modManager, projectAgent);
    }

    @Override
    public String getName() {
        try {
            IAttribute attribute = this.getAttribute(ReportTemplateFolderAttributeTypesProvider.ATTR_ID_NAME);
            return (String)attribute.getAttributeValue();
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    @Override
    public String getDescription() {
        try {
            IAttribute attribute = this.getAttribute(ReportTemplateFolderAttributeTypesProvider.ATTR_ID_DESCRIPTION);
            return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }

    public String getPermissionOperandType() {
        return this.getTypeID();
    }

    public String getPermissionOperandUID() {
        return this.getUID();
    }

    public String getPermissionOperandDisplayName() {
        return this.getName();
    }
}

