/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeSortCriterium;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.AttributeTypeID;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeType;
import com.arcway.cockpit.frame.client.project.core.framedata.AttributeTypeSortCriterium;
import com.arcway.cockpit.frame.client.project.core.framedata.ValueRangeEnumeration;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeBoolean;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeEnumerationMultiple;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.DataTypeFile;
import com.arcway.cockpit.frame.client.project.docgenerator.filters.FilterProviderManager;
import com.arcway.cockpit.frame.client.project.modules.ModuleInformation;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.repository.cockpit.interFace.declaration.frame.reporttemplate.COTIDsReportTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class ReportTemplateAttributeTypesProvider
extends AbstractAttributeTypesProvider {
    public static final String ATTRHRID_NAME = "name";
    public static final IAttributeTypeID ATTRID_NAME = AttributeTypeID.getAttributeTypeID(COTIDsReportTemplate.PROPERTY_NAME_ID.toCanonicalString());
    public static final String ATTRHRID_DESCRIPTION = "description";
    public static final IAttributeTypeID ATTRID_DESCRIPTION = AttributeTypeID.getAttributeTypeID(COTIDsReportTemplate.PROPERTY_DESCRIPTION_ID.toCanonicalString());
    public static final String ATTRHRID_FILE = "file";
    public static final IAttributeTypeID ATTRID_FILE = AttributeTypeID.getAttributeTypeID(COTIDsReportTemplate.PROPERTY_FILE_ID.toCanonicalString());
    public static final String ATTRHRID_FILTER_FRAME = "suppressFrameFilter";
    public static final IAttributeTypeID ATTRID_FILTER_FRAME = AttributeTypeID.getAttributeTypeID(COTIDsReportTemplate.PROPERTY_FILTERING_FRAME.toCanonicalString());
    public static final String ATTRHRID_FILTER_MODULES = "filteringModules";
    public static final IAttributeTypeID ATTRID_FILTER_MODULES = AttributeTypeID.getAttributeTypeID(COTIDsReportTemplate.PROPERTY_FILTERING_MODULES_ID.toCanonicalString());

    public ReportTemplateAttributeTypesProvider(String projectUID) {
        super(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, projectUID);
    }

    @Override
    protected Collection<IAttributeType> getDataTypeSpecificFixAttributeTypes() {
        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.projectUID);
        ArrayList<IAttributeType> attributeTypes = new ArrayList<IAttributeType>();
        AttributeType nameType = new AttributeType(this.projectUID, ATTRID_NAME, ATTRHRID_NAME, Messages.getString("ReportTemplateAttributeTypesProvider.Name"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(0, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeString.getInstanceString(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, null, true, true, false, true, false);
        AttributeType descrType = new AttributeType(this.projectUID, ATTRID_DESCRIPTION, ATTRHRID_DESCRIPTION, Messages.getString("ReportTemplateAttributeTypesProvider.Description"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(2, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeText.getInstanceText(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, null, true, true, false, true, true);
        AttributeType fileType = new AttributeType(this.projectUID, ATTRID_FILE, ATTRHRID_FILE, Messages.getString("ReportTemplateAttributeTypesProvider.template_file"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(1, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)new DataTypeFile(projectAgent), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, null, true, true, false, true, false);
        AttributeType filteringFrameType = new AttributeType(this.projectUID, ATTRID_FILTER_FRAME, ATTRHRID_FILTER_FRAME, Messages.getString("ReportTemplateAttributeTypesProvider.filtering_frame"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(3, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)DataTypeBoolean.getSingleInstance(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, null, true, true, false, true, false);
        AttributeType filteringModulesType = new AttributeType(this.projectUID, ATTRID_FILTER_MODULES, ATTRHRID_FILTER_MODULES, Messages.getString("ReportTemplateAttributeTypesProvider.filtering_modules"), (IAttributeTypeSortCriterium)new AttributeTypeSortCriterium(4, IAttributeTypeSortCriterium.CATEGORY_FIXED_ATTRIBUTE), (IAttributeTypeDataType)new DataTypeEnumerationMultiple(DataTypeString.getInstanceString(), null, true), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, (IValueRange)new ModuleIDsValueRange(projectAgent), true, true, false, true, false);
        attributeTypes.add(nameType);
        attributeTypes.add(descrType);
        attributeTypes.add(fileType);
        attributeTypes.add(filteringFrameType);
        attributeTypes.add(filteringModulesType);
        return attributeTypes;
    }

    @Override
    public IAttributeTypeID getNameAttributeTypeID() {
        return ATTRID_NAME;
    }

    private static class ModuleIDsValueRange
    implements IValueRange {
        private final IFrameProjectAgent projectAgent;
        private ValueRangeEnumeration valueRange;

        ModuleIDsValueRange(IFrameProjectAgent projectAgent) {
            this.projectAgent = projectAgent;
        }

        private ValueRangeEnumeration getValueRange_int() {
            if (this.valueRange == null) {
                ArrayList<EnumerationEntry> moduleIDs = new ArrayList<EnumerationEntry>();
                for (ModuleInformation mi : this.projectAgent.getModuleController().getAllModuleInformation()) {
                    if (!FilterProviderManager.hasFilterItemProviderForModule(mi.getModuleID())) continue;
                    EnumerationEntry entry = new EnumerationEntry(mi.getModuleID(), (Object)mi.getModuleName());
                    moduleIDs.add(entry);
                }
                this.valueRange = new ValueRangeEnumeration(moduleIDs);
            }
            return this.valueRange;
        }

        public List<? extends EnumerationEntry> getValueRange() {
            return this.getValueRange_int().getValueRange();
        }

        public LinkedHashMap<EnumerationEntry, Tuple<Integer, EnumerationEntry>> getValueRange_opt() {
            return this.getValueRange_int().getValueRange_opt();
        }
    }
}

