/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EnumerationEntry;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filemanager.IDataTypeWithFile;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateRW;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.ReportTemplateAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOFrameData;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportTemplate
extends AbstractFrameData
implements IReportTemplateRW {
    private static final ILogger logger = Logger.getLogger(ReportTemplate.class);

    public ReportTemplate(EOFrameData eo, IFrameProjectAgent projectAgent, IAttributeModificationManager modManager) {
        super(eo, FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, modManager, projectAgent);
    }

    public ReportTemplate(String uID, IFrameProjectAgent projectAgent, Collection<IAttribute> attributes, IAttributeModificationManager modManager) {
        super(uID, projectAgent.getUID(), FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE, attributes, modManager, projectAgent);
    }

    @Override
    public String getName() {
        IAttribute attribute = this.getAttribute(ReportTemplateAttributeTypesProvider.ATTRID_NAME);
        return (String)attribute.getAttributeValue();
    }

    @Override
    public String getDescription() {
        IAttribute attribute = this.getAttribute(ReportTemplateAttributeTypesProvider.ATTRID_DESCRIPTION);
        return DataTypeText.getInstanceText().getValueAsMultiLineString(attribute.getAttributeValue());
    }

    @Override
    public File getReportFile() {
        File result = null;
        IAttributeType attributeType = this.getAttributeType(ReportTemplateAttributeTypesProvider.ATTRID_FILE);
        IDataTypeWithFile dataType = (IDataTypeWithFile)attributeType.getDataType();
        try {
            IAttribute attribute = this.getAttribute(attributeType.getAttributeTypeID());
            result = dataType.getFileCopy(attribute.getAttributeValue());
        }
        catch (ServerNotAvailableException e) {
            logger.error("Could not get report template file", (Throwable)e);
        }
        catch (EXServerException e) {
            logger.error("Could not get report template file", (Throwable)e);
        }
        catch (LoginCanceledException e) {
            logger.error("Could not get report template file", (Throwable)e);
        }
        catch (UnknownServerException e) {
            logger.error("Could not get report template file", (Throwable)e);
        }
        catch (ExPrematureEndOfTransfer e) {
            logger.error("Could not get report template file", (Throwable)e);
        }
        return result;
    }

    @Override
    public List<String> getIDsOfFilteringModules() {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            IAttribute attribute = this.getAttribute(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_FRAME);
            Boolean value = (Boolean)attribute.getAttributeValue();
            if (value == null || !value.booleanValue()) {
                ids.add("com.arcway.cockpit.frame.sections_and_plans");
            }
            attribute = this.getAttribute(ReportTemplateAttributeTypesProvider.ATTRID_FILTER_MODULES);
            List entries = (List)attribute.getAttributeValue();
            for (EnumerationEntry entry : entries) {
                ids.add(entry.getID());
            }
            return ids;
        }
        catch (ExInvalidAttributeType e) {
            logger.error("could not execute", (Throwable)e);
            return null;
        }
    }
}

