/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.reporttemplates;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.RenameDataValidator;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class FrameDataAttributeModificationManager
implements IAttributeModificationManager {
    private IFrameDataRW frameData;
    private IFrameDataManager frameDataManager;
    private final IAttributeTypesProvider attributeTypesProvider;
    private final IFrameProjectAgent projectAgent;
    private IParentOperandTree operandTree;

    public FrameDataAttributeModificationManager(IAttributeTypesProvider attributeTypesProvider, IFrameProjectAgent projectAgent) {
        this.attributeTypesProvider = attributeTypesProvider;
        this.projectAgent = projectAgent;
    }

    public void setFrameData(IFrameDataRW frameData) {
        this.frameData = frameData;
        this.frameDataManager = this.projectAgent.getDataManager(frameData.getTypeID());
        this.operandTree = DataManager.getParentOperandTree(frameData, this.projectAgent);
    }

    public IFrameDataRW getFrameData() {
        return this.frameData;
    }

    @Override
    public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
        if (newAttribute.getAttributeTypeID().equals(this.attributeTypesProvider.getNameAttributeTypeID())) {
            RenameDataValidator renameDataValidator = new RenameDataValidator(this.frameData, this.projectAgent);
            String newName = (String)newAttribute.getAttributeValue();
            String msg = renameDataValidator.isValid(newName);
            if (msg != null) {
                transactionController.addLockModificationProblem(new ModificationProblem(msg, Messages.getString("FrameDataAttributeModificationManager.can_not_rename")));
            }
            IAttributeOwner parent = this.frameDataManager.getParent(this.frameData);
            String lockTypeIDUniqueNameLock = DataManager.getLockTypeForUniqueNameLock(this.frameData, newName);
            transactionController.addLockToTest((ILockable)parent, lockTypeIDUniqueNameLock);
            transactionController.addLock((ILockable)parent, lockTypeIDUniqueNameLock);
        }
        if (!this.frameDataManager.isLocallyAdded(this.frameData.getUID())) {
            IAttributeType attributeType = this.frameData.getAttributeType(newAttribute.getAttributeTypeID());
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree);
            transactionController.addLockToTest(this.frameData, "modify");
            transactionController.addLock(this.frameData, "modify");
        }
        for (IClientFunctionLicenseType clientLicenseType : this.getNeededClientLicenseTypes()) {
            transactionController.addClientLicenseType(clientLicenseType);
        }
    }

    @Override
    public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public IModificationProblem checkLocks() {
        ModificationProblem modProblem = null;
        if (!this.frameDataManager.isLocallyAdded(this.frameData.getUID())) {
            Throwable serverException = null;
            try {
                EOLock conflictingLock = this.projectAgent.getFrameLockManager().anotherClientHasLock(this.frameData, "modify");
                if (conflictingLock != null) {
                    modProblem = new ModificationProblem(conflictingLock, Messages.getString("FrameDataAttributeModificationManager.data_connot_be_modified"));
                }
            }
            catch (ServerNotAvailableException e) {
                serverException = e;
            }
            catch (LoginCanceledException e) {
                serverException = e;
            }
            catch (EXServerException e) {
                serverException = e;
            }
            catch (UnknownServerException e) {
                serverException = e;
            }
            if (serverException != null) {
                modProblem = new ModificationProblem((Exception)serverException, Messages.getString("FrameDataAttributeModificationManager.data_connot_be_modified"));
            }
        }
        return modProblem;
    }

    public void checkGeneralModificationPermissions(IAttributeType attributeType, ILocksAndPermissionsTransactionController transactionController) {
        if (!this.frameDataManager.isLocallyAdded(this.frameData.getUID())) {
            transactionController.addAttributeModificationPermission(attributeType, this.operandTree, false);
            transactionController.addLockToTest(this.frameData, "modify");
        }
    }

    @Override
    public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        for (IClientFunctionLicenseType clientLicenseType : this.getNeededClientLicenseTypes()) {
            if (this.projectAgent.getServerLicenseManager().isLicenseOperationAllowed(clientLicenseType)) continue;
            modProblems.add(new ModificationProblem(clientLicenseType, String.valueOf(Messages.getString("FrameDataAttributeModificationManager.cannot_mod_prop1")) + attributeType.getDisplayName() + Messages.getString("FrameDataAttributeModificationManager.cannot_mod_prop2")));
        }
        LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
        this.checkGeneralModificationPermissions(attributeType, transactionController);
        modProblems.addAll(transactionController.checkConditions(true, true));
        return modProblems;
    }

    @Override
    public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        this.frameDataManager.dataModified(this.frameData);
    }

    protected final Collection<IClientFunctionLicenseType> getNeededClientLicenseTypes() {
        return Collections.emptyList();
    }

    @Override
    public void modifyCategoryID() throws EXNoPermission, EXNoLock {
    }

    @Override
    public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
        throw new UnsupportedOperationException();
    }
}

