/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.permissions;

import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.IPermissionOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PermissionModificationCache {
    private Map map_owner_permissions;
    private Map map_operandID_permissions;
    private Map map_operandID_ownerID_permissions;
    private Collection allPermissions;

    protected void setAllPermissions(Collection allPermissions) {
        this.map_owner_permissions = new HashMap();
        this.map_operandID_permissions = new HashMap();
        this.map_operandID_ownerID_permissions = new HashMap();
        this.allPermissions = new ArrayList(allPermissions.size());
        for (EOPermission permission : allPermissions) {
            this.addPermission(permission);
        }
    }

    protected void addPermission(EOPermission permissionToAdd) {
        Collection<EOPermission> list = (ArrayList<EOPermission>)this.map_owner_permissions.get(permissionToAdd.getOwnerID());
        if (list == null) {
            list = new ArrayList<EOPermission>();
            this.map_owner_permissions.put(permissionToAdd.getOwnerID(), list);
        }
        list.add(permissionToAdd);
        list = (Collection)this.map_operandID_permissions.get(permissionToAdd.getOperandUID());
        if (list == null) {
            list = new ArrayList();
            this.map_operandID_permissions.put(permissionToAdd.getOperandUID(), list);
        }
        list.add(permissionToAdd);
        HashMap<String, Collection<EOPermission>> ownerID_permissions = (HashMap<String, Collection<EOPermission>>)this.map_operandID_ownerID_permissions.get(permissionToAdd.getOperandUID());
        if (ownerID_permissions == null) {
            ownerID_permissions = new HashMap<String, Collection<EOPermission>>();
            this.map_operandID_ownerID_permissions.put(permissionToAdd.getOperandUID(), ownerID_permissions);
        }
        if ((list = (Collection)ownerID_permissions.get(permissionToAdd.getOwnerID())) == null) {
            list = new ArrayList();
            ownerID_permissions.put(permissionToAdd.getOwnerID(), list);
        }
        list.add(permissionToAdd);
        this.allPermissions.add(permissionToAdd);
    }

    protected void removePermission(EOPermission permissionToRemove) {
        this.removePermission(permissionToRemove, this.map_owner_permissions, permissionToRemove.getOwnerID());
        this.removePermission(permissionToRemove, this.map_operandID_permissions, permissionToRemove.getOperandUID());
        Map ownerID_permissions = (Map)this.map_operandID_ownerID_permissions.get(permissionToRemove.getOperandUID());
        if (ownerID_permissions != null) {
            this.removePermission(permissionToRemove, ownerID_permissions, permissionToRemove.getOwnerID());
        }
        this.removePermission(permissionToRemove, this.allPermissions);
    }

    private void removePermission(EOPermission permissionToRemove, Map containingMap, String key) {
        Collection list = (Collection)containingMap.get(key);
        if (list != null) {
            this.removePermission(permissionToRemove, list);
        }
    }

    private void removePermission(EOPermission permissionToRemove, Collection containingList) {
        Iterator i = containingList.iterator();
        while (i.hasNext()) {
            EOPermission existing = (EOPermission)i.next();
            if (!existing.isEqual(permissionToRemove)) continue;
            i.remove();
            break;
        }
    }

    protected EOPermission getExistingPermission(EOPermission permission) {
        Collection permissions = (Collection)this.map_operandID_permissions.get(permission.getOperandUID());
        if (permissions != null) {
            for (EOPermission existing : permissions) {
                if (!existing.isEqual(permission)) continue;
                return existing;
            }
        }
        return null;
    }

    protected EOPermission getPermission(IPermissionOwner owner, IPermissionOperand operand, String operation, String operation2) {
        Collection permissions;
        Map ownerID_permissions = (Map)this.map_operandID_ownerID_permissions.get(operand.getPermissionOperandUID());
        if (ownerID_permissions != null && (permissions = (Collection)ownerID_permissions.get(owner.getPermissionOwnerID())) != null) {
            for (EOPermission permission : permissions) {
                if (permission.getOwnerType() != owner.getPermissionOwnerType() || !permission.getOwnerID().equals(owner.getPermissionOwnerID()) || !permission.getOperandType().equals(operand.getPermissionOperandType()) || !permission.getOperation().equals(operation) || !this.equals(permission.getOperation2(), operation2)) continue;
                return permission;
            }
        }
        return null;
    }

    protected Collection getAllPermissionsOfOperand(String operandTypeID, String operandUID) {
        ArrayList permissions = (ArrayList)this.map_operandID_permissions.get(operandUID);
        if (permissions != null) {
            permissions = new ArrayList(permissions);
            Iterator i = permissions.iterator();
            while (i.hasNext()) {
                EOPermission permission = (EOPermission)i.next();
                if (permission.getOperandType().equals(operandTypeID)) continue;
                i.remove();
            }
        }
        return permissions;
    }

    protected Collection getAllPermissionsOfOwner(int ownerType, String ownerUID) {
        ArrayList permissions = (ArrayList)this.map_owner_permissions.get(ownerUID);
        if (permissions != null) {
            permissions = new ArrayList(permissions);
            Iterator i = permissions.iterator();
            while (i.hasNext()) {
                EOPermission permission = (EOPermission)i.next();
                if (permission.getOwnerType() == ownerType) continue;
                i.remove();
            }
        }
        return permissions;
    }

    protected boolean hasPermissionOfTemplate(IPermissionOwner owner, IPermissionOperand operand, Collection templates) {
        Collection permissions;
        Map ownerID_permissions = (Map)this.map_operandID_ownerID_permissions.get(operand.getPermissionOperandUID());
        if (ownerID_permissions != null && (permissions = (Collection)ownerID_permissions.get(owner.getPermissionOwnerID())) != null) {
            for (EOPermission permission : permissions) {
                if (permission.getOwnerType() != owner.getPermissionOwnerType() || !permission.getOperandType().equals(operand.getPermissionOperandType()) || !this.isOfOneTemplate(permission, templates)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isOfOneTemplate(EOPermission permission, Collection templates) {
        for (CockpitPermissionTemplate template : templates) {
            if (!template.isOfTemplate(permission)) continue;
            return true;
        }
        return false;
    }

    protected Collection getAllPermissions() {
        return this.allPermissions;
    }

    private boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }
}

