/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.permissions;

import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.FramePermissionDefinitions;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.psc.shared.PermissionTemplate;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.IPermissionOwner;

public class CockpitPermissionTemplate
extends PermissionTemplate {
    private final String operation;
    private final String operation2;
    private final String operandType;
    private boolean grantByDefault = true;
    private IPermissionOperand defaultOperand = null;
    private CockpitPermissionTemplate superordinatedTemplate = null;

    public CockpitPermissionTemplate(String operation, String operandType) {
        this(operation, operandType, true);
    }

    public CockpitPermissionTemplate(String operation, String operandType, IPermissionOperand defaultOperand) {
        this(operation, operandType, true, defaultOperand, null);
    }

    public CockpitPermissionTemplate(String operation, String operandType, boolean grantByDefault) {
        this(operation, operandType, grantByDefault, null, null);
    }

    public CockpitPermissionTemplate(String operation, String operandType, boolean grantByDefault, IPermissionOperand defaultOperand, CockpitPermissionTemplate superordinatedTemplate) {
        this(operation, null, operandType, grantByDefault, defaultOperand, superordinatedTemplate);
    }

    public CockpitPermissionTemplate(String operation, String operation2, String operandType) {
        this(operation, operation2, operandType, true);
    }

    public CockpitPermissionTemplate(String operation, String operation2, String operandType, boolean grantByDefault) {
        this(operation, operation2, operandType, grantByDefault, null, null);
    }

    public CockpitPermissionTemplate(String operation, String operation2, String operandType, boolean grantByDefault, IPermissionOperand defaultOperand, CockpitPermissionTemplate superordinatedTemplate) {
        super("PROJECT");
        this.operation = operation;
        this.operation2 = operation2;
        this.operandType = operandType;
        this.grantByDefault = grantByDefault;
        this.defaultOperand = defaultOperand;
        this.superordinatedTemplate = superordinatedTemplate;
    }

    public String getOperandType() {
        return this.operandType;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getOperation2() {
        return this.operation2;
    }

    public boolean isOfTemplate(EOPermission permission) {
        return permission.getOperation().equals(this.getOperation()) && StringUtil.equals((String)permission.getOperation2(), (String)this.getOperation2()) && permission.getOperandType().equals(this.getOperandType()) && super.isOfTemplate(permission);
    }

    public boolean grantByDefault() {
        return this.grantByDefault;
    }

    public void setGrantByDefault(boolean value) {
        this.grantByDefault = value;
    }

    public IPermissionOperand getDefaultOperand() {
        return this.defaultOperand;
    }

    public String getPermissionName() {
        return FramePermissionDefinitions.getPermissionName(this);
    }

    public CockpitPermissionTemplate getSuperordinatedPermissionTemplate() {
        return this.superordinatedTemplate;
    }

    public EOPermission createPermission(IPermissionOperand operand, IPermissionOwner owner, String projectUID) {
        EOPermission p = super.createPermission(projectUID);
        p.setOperandType(this.getOperandType());
        p.setOperation(this.getOperation());
        p.setOperation2(this.operation2);
        p.setOperandUID(operand.getPermissionOperandUID());
        p.setOwnerType(owner.getPermissionOwnerType());
        p.setOwnerID(owner.getPermissionOwnerID());
        return p;
    }

    public EOPermission createPermissionForNewProject(IProjectAgent projectAgent, IPermissionOwner projectCreator) {
        EOPermission permission = null;
        if (this.defaultOperand != null) {
            permission = this.createPermission(this.defaultOperand, projectCreator, projectAgent.getUID());
        } else if (this.operandType.equals("project")) {
            permission = this.createPermission(projectAgent, projectCreator, projectAgent.getUID());
        }
        return permission;
    }

    public boolean equals(Object obj) {
        if (obj != this) {
            CockpitPermissionTemplate template;
            return obj instanceof CockpitPermissionTemplate && (template = (CockpitPermissionTemplate)((Object)obj)).getOperandType().equals(this.getOperandType()) && template.getOperation().equals(this.getOperation()) && StringUtil.equals((String)template.getOperation2(), (String)this.getOperation2());
        }
        return true;
    }

    public int hashCode() {
        int hc = this.getOperandType().hashCode() + 31 * this.getOperation().hashCode();
        if (this.getOperation2() != null) {
            hc += 961 * this.getOperation2().hashCode();
        }
        return hc;
    }
}

