/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.frame.shared.message.EOLock;
import java.util.ArrayList;
import java.util.Collection;

public class LockResult {
    private final boolean successful;
    private final Collection<EOLock> conflictingLocks;
    private final Collection<EOLock> newlyAddedLocks;
    private final Collection<EOLock> locksClientAlreadyHave;
    private final Exception possibleServerException;

    public LockResult(boolean successful, Collection<EOLock> conflictingLocks, Collection<EOLock> newlyAddedLocks, Collection<EOLock> locksClientAlreadyHave, Exception possibleServerException) {
        this.successful = successful;
        this.conflictingLocks = conflictingLocks;
        this.newlyAddedLocks = newlyAddedLocks;
        this.possibleServerException = possibleServerException;
        this.locksClientAlreadyHave = locksClientAlreadyHave;
    }

    public boolean wasSuccessful() {
        return this.successful;
    }

    public Collection<EOLock> getConflictingLocks() {
        return this.conflictingLocks;
    }

    public boolean isExclusiveProjectLockConflicting() {
        for (EOLock lock : this.conflictingLocks) {
            if (!lock.getLockTypeID().equals("project_lock_exclusive")) continue;
            return true;
        }
        return false;
    }

    public Collection<EOLock> getNewlyAddedLocks() {
        return this.newlyAddedLocks;
    }

    public Collection<EOLock> getLocksClientAlreadyHave() {
        return this.locksClientAlreadyHave;
    }

    public Collection<EOLock> getAllRequestedLocks() {
        ArrayList<EOLock> allRequestedLocks = new ArrayList<EOLock>();
        allRequestedLocks.addAll(this.newlyAddedLocks);
        allRequestedLocks.addAll(this.locksClientAlreadyHave);
        return allRequestedLocks;
    }

    public Exception getPossibleServerException() {
        return this.possibleServerException;
    }
}

