/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.UUIDGenerator;
import java.sql.Timestamp;

public class LockRequest {
    private final ILockable lockable;
    private final String operation;

    public LockRequest(ILockable lockable, String operation) {
        this.lockable = lockable;
        this.operation = operation;
    }

    public ILockable getLockable() {
        return this.lockable;
    }

    public String getOperation() {
        return this.operation;
    }

    public EOLock createEOLock() {
        EOLock lock = new EOLock(UUIDGenerator.getUniqueID(), this.getLockable().getProjectUID(), this.getOperation(), this.getLockable().getUID(), this.getLockable().getTypeID(), "", "", new Timestamp(System.currentTimeMillis()));
        return lock;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof LockRequest) {
                LockRequest lr = (LockRequest)obj;
                return lr.getLockable().equals(this.getLockable()) && lr.getOperation().equals(this.getOperation());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getLockable().hashCode() ^ this.getOperation().hashCode();
    }
}

