/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.EXCorruptProjectData;
import com.arcway.cockpit.cockpitlib.client.files.atomic.FileSetTransactionAbortedException;
import com.arcway.cockpit.frame.client.project.IFrameLockManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Messages;
import com.arcway.cockpit.frame.client.project.core.locking.ClientLockStateOutOfSyncException;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.locking.ILockAllocator;
import com.arcway.cockpit.frame.client.project.core.locking.ILockOperationProvider;
import com.arcway.cockpit.frame.client.project.core.locking.IProjectLockFetcher;
import com.arcway.cockpit.frame.client.project.core.locking.LockAllocationTable;
import com.arcway.cockpit.frame.client.project.core.locking.LockRequest;
import com.arcway.cockpit.frame.client.project.core.locking.LockResult;
import com.arcway.cockpit.frame.client.project.core.locking.LockTypeDescriptionProvider;
import com.arcway.cockpit.frame.client.project.core.locking.ProjectLockFetcher;
import com.arcway.cockpit.frame.client.project.core.locking.SplittedLockSet;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IFrameServerProxy;
import com.arcway.cockpit.frame.client.project.modules.IModuleLockManager;
import com.arcway.cockpit.frame.shared.ILockable;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;

public class LockMgr
implements IFrameLockManager,
IModuleLockManager,
ILockOperationProvider {
    static final ILogger logger = Logger.getLogger(LockMgr.class);
    private IFrameProjectAgent projectAgent;
    private LockAllocationTable lockAllocationTable;
    private ILockAllocator lockAllocator;
    private IProjectLockFetcher projectLockFetcher;

    public void setup(IFrameProjectAgent projectAgent, IFrameServerProxy serverProxy) throws EXCorruptProjectData {
        assert (projectAgent != null) : "projectAgent can't be null";
        assert (serverProxy != null) : "serverProxy can't be null";
        this.projectAgent = projectAgent;
        this.lockAllocationTable = new LockAllocationTable(projectAgent);
        this.projectLockFetcher = new ProjectLockFetcher(projectAgent, this);
        try {
            this.tryToReleaseUnacknowledgedLocks();
        }
        catch (Exception e) {
            logger.error("Problem while releasing unused locks that could not be released during the last session.", (Throwable)e);
        }
    }

    @Override
    public void setupInternal(ILockAllocator lockAllocator) {
        this.lockAllocator = lockAllocator;
    }

    public void tryToReleaseUnacknowledgedLocks() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException, FileSetTransactionAbortedException {
        Collection<EOLock> unacknowledgedServerLocks = this.lockAllocationTable.getUnacknowledgedLocks();
        if (!unacknowledgedServerLocks.isEmpty()) {
            this.lockAllocator.releaseLocks(unacknowledgedServerLocks);
            this.lockAllocationTable.successfullyReleasedUnacknowledgedLocks();
            logger.debug("Successfully released unacknowledged Server Locks.");
        }
    }

    @Override
    public LockResult atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> locksToBeSet, boolean showErrorMessage) {
        LockResult lockResult;
        block26: {
            boolean isCommitLockRequest = LockMgr.isCommitLockRequest(locksToBeChecked, locksToBeSet);
            if (locksToBeSet.isEmpty() || this.clientAlreadyHasProjectLock() && !isCommitLockRequest) {
                lockResult = new LockResult(true, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null);
            } else {
                if (!isCommitLockRequest) {
                    locksToBeSet.add(this.projectLockFetcher.generateProjectLock("project_lock_shared"));
                    locksToBeChecked.add(this.projectLockFetcher.generateProjectLock("project_lock_exclusive"));
                }
                try {
                    Collection<EOLock> realLocksToBeSet = this.lockAllocationTable.prepareRequestOfLocks(locksToBeSet);
                    ArrayList<EOLock> locksClientAlreadyHas = new ArrayList<EOLock>(locksToBeSet);
                    locksClientAlreadyHas.removeAll(realLocksToBeSet);
                    List<Collection<EOLock>> response = null;
                    Throwable serverException = null;
                    if (!realLocksToBeSet.isEmpty()) {
                        Collection<EOLock> clientLocksNeededByServer = this.lockAllocationTable.getLocksClientAlreadyOwnsMatchingThisLocks(locksToBeChecked);
                        try {
                            response = this.lockAllocator.atomicCheckAndSetLocks(locksToBeChecked, clientLocksNeededByServer, realLocksToBeSet);
                        }
                        catch (ServerNotAvailableException e) {
                            serverException = e;
                        }
                        catch (UnknownServerException e) {
                            serverException = e;
                        }
                        catch (LoginCanceledException e) {
                            serverException = e;
                        }
                        catch (EXServerException e) {
                            serverException = e;
                        }
                        if (serverException != null) {
                            try {
                                this.lockAllocationTable.finishRequestOfLocks(LockAllocationTable.LockRequestFinishMode.REQUEST_RESPONSE_CYCLE_INTERRUPTED, null);
                            }
                            catch (FileSetTransactionAbortedException e) {
                                logger.warn("Problem during cleanup of unsuccessful Request of Locks. The clients stable lock storage area (disk) is either full or not accessible.", (Throwable)e);
                            }
                            lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Exception)serverException);
                            break block26;
                        }
                        assert (response != null);
                        Collection<EOLock> conflictingLocks = response.get(0);
                        Collection<EOLock> addedLocks = response.get(1);
                        if (conflictingLocks.size() > 0) {
                            try {
                                this.lockAllocationTable.finishRequestOfLocks(LockAllocationTable.LockRequestFinishMode.SERVER_DENIED_LOCKS, null);
                            }
                            catch (FileSetTransactionAbortedException e) {
                                logger.warn("Problem during cleanup of unsuccessful Request of Locks. The clients stable lock storage area (disk) is either full or not accessible.", (Throwable)e);
                            }
                            lockResult = new LockResult(false, conflictingLocks, addedLocks, locksClientAlreadyHas, null);
                            logger.debug(22, "Locks couldn't be set. Atomic check and set failed. [LockMgr]");
                            break block26;
                        }
                        try {
                            this.lockAllocationTable.finishRequestOfLocks(LockAllocationTable.LockRequestFinishMode.SERVER_GRANTED_LOCKS, locksToBeSet);
                            lockResult = new LockResult(true, conflictingLocks, addedLocks, locksClientAlreadyHas, null);
                            logger.debug(22, "Locks were set by atomic check and set. [LockMgr]");
                        }
                        catch (FileSetTransactionAbortedException e) {
                            lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Exception)((Object)e));
                            logger.warn("Problem while processing response of successful lock request. The set of granted locks could not be saved to the clients stable storage. The clients stable lock storage area (disk) is either full or not accessible. Hence the locks can not be taken for granted.", (Throwable)e);
                        }
                        break block26;
                    }
                    try {
                        this.lockAllocationTable.finishRequestOfLocks(LockAllocationTable.LockRequestFinishMode.NO_SERVER_REQUEST_NEEDED, locksToBeSet);
                        lockResult = new LockResult(true, Collections.emptyList(), Collections.emptyList(), locksClientAlreadyHas, null);
                    }
                    catch (FileSetTransactionAbortedException e) {
                        lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Exception)((Object)e));
                        logger.warn("Lock Request would have been successful, but the set of granted locks could not be saved to the clients stable storage. The clients stable lock storage area (disk) is either full or not accessible. Hence the locks can not be taken for granted.", (Throwable)e);
                    }
                }
                catch (ClientLockStateOutOfSyncException e) {
                    lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), e);
                    logger.warn("Lock Request was marked unsuccessful, because of problems on client side: " + e.getLocalizedMessage(), (Throwable)e);
                }
                catch (FileSetTransactionAbortedException e) {
                    lockResult = new LockResult(false, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), (Exception)((Object)e));
                    logger.warn("Lock Request was marked unsuccessful, because of problems on client side: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        if (!lockResult.wasSuccessful() && showErrorMessage) {
            String dialogMessage;
            String dialogTitle;
            if (lockResult.getPossibleServerException() != null) {
                dialogTitle = Messages.getString("LockMgr.ServerError");
                dialogMessage = lockResult.getPossibleServerException().getLocalizedMessage();
            } else {
                dialogTitle = Messages.getString("LockMgr.Item_locked_14");
                dialogMessage = LockMgr.generateErrorMessage(lockResult.getConflictingLocks());
            }
            MessageDialog errorDialog = new MessageDialog(EclipseSWTHelper.getShell(), dialogTitle, null, dialogMessage, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            errorDialog.open();
        }
        return lockResult;
    }

    @Override
    public boolean releaseAllLocks() {
        boolean success;
        try {
            this.tryToReleaseUnacknowledgedLocks();
        }
        catch (Exception e) {
            logger.error("Problem occured while trying to release unacknowledged locks.", (Throwable)e);
        }
        try {
            Collection<EOLock> allServerLocks = this.lockAllocationTable.prepareReleaseOfAllLocks();
            boolean successfullyReleasedLocksOnServerSide = false;
            if (!allServerLocks.isEmpty()) {
                try {
                    this.lockAllocator.releaseLocks(allServerLocks);
                    successfullyReleasedLocksOnServerSide = true;
                    logger.debug(22, "Locks were released. [LockMgr]");
                }
                catch (ServerNotAvailableException e) {
                    logger.error("Could not release lock due to server exception (ServerNotAvailableException). [LockMgr]", (Throwable)e);
                }
                catch (UnknownServerException e) {
                    logger.error("Could not release lock due to server exception (UnknownServerException). [LockMgr]", (Throwable)e);
                }
                catch (LoginCanceledException e) {
                    logger.error("Could not release lock due to server exception (LoginCanceledException). [LockMgr]", (Throwable)e);
                }
                catch (EXServerException e) {
                    logger.error("Could not release lock due to server exception (EXServerException). [LockMgr]", (Throwable)e);
                }
            } else {
                successfullyReleasedLocksOnServerSide = true;
            }
            if (successfullyReleasedLocksOnServerSide) {
                this.lockAllocationTable.finishReleaseOfLocks(allServerLocks);
            } else {
                this.lockAllocationTable.finishReleaseOfLocks(null);
            }
            success = true;
        }
        catch (FileSetTransactionAbortedException e) {
            logger.error("Problem occured while trying to release all Locks allocated on server.", (Throwable)e);
            success = false;
        }
        catch (ClientLockStateOutOfSyncException e) {
            logger.debug("Problem occured while trying to release all Locks allocated on server.", (Throwable)e);
            success = false;
        }
        return success;
    }

    @Override
    public Collection<EOLock> getAllLocksCurrentlyAllocatedOnServer() {
        return this.projectLockFetcher.getLocksCurrentlyAllocatedOnServer();
    }

    @Override
    public ISet_<EOLock> getLocksCurrentlyAllocatedByLockAllocator() {
        return this.lockAllocationTable.getLocksCurrentlyAllocatedByLockAllocator();
    }

    private EOLock anotherClientHasLock(EOLock eoLock) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        if (this.clientAlreadyHasProjectLock()) {
            return null;
        }
        if (!this.clientAlreadyHasLock(eoLock)) {
            EOList locksToBeCheckedASEOLocks = new EOList();
            locksToBeCheckedASEOLocks.add(eoLock);
            List<Collection<EOLock>> response = this.lockAllocator.atomicCheckAndSetLocks((Collection<EOLock>)locksToBeCheckedASEOLocks, (Collection<EOLock>)new EOList(0), (Collection<EOLock>)new EOList(0));
            Collection<EOLock> locksOnServer = response.get(0);
            if (locksOnServer.size() > 0) {
                return locksOnServer.iterator().next();
            }
        }
        return null;
    }

    @Override
    public EOLock anotherClientHasLock(ILockable lockable, String lockType) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        assert (lockable != null);
        assert (lockType != null);
        assert (!lockType.trim().equals(""));
        return this.anotherClientHasLock(new EOLock(UUIDGenerator.getUniqueID(), lockable.getProjectUID(), lockType, lockable.getUID(), lockable.getTypeID(), "", "", new Timestamp(System.currentTimeMillis())));
    }

    @Override
    public EOLock anotherClientHasProjectLock() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        return this.anotherClientHasLock(this.projectLockFetcher.generateProjectLock("project_lock_exclusive"));
    }

    @Override
    public boolean clientAlreadyHasLock(ILockable lockable, String lockTypeID) {
        assert (lockable != null);
        assert (lockTypeID != null);
        assert (!lockTypeID.trim().equals(""));
        EOLock lock = new EOLock(UUIDGenerator.getUniqueID(), lockable.getProjectUID(), lockTypeID, lockable.getUID(), lockable.getTypeID(), "", "", new Timestamp(System.currentTimeMillis()));
        return this.clientAlreadyHasLock(lock);
    }

    private boolean clientAlreadyHasLock(EOLock lock) {
        if (this.clientAlreadyHasProjectLock()) {
            return true;
        }
        return this.lockAllocationTable.clientAlreadyHasLock(lock);
    }

    @Override
    public void checkIfClientAlreadyHasProjectLock() throws EXNoLock {
        if (!this.clientAlreadyHasProjectLock()) {
            throw new EXNoLock(this.projectAgent.getProjectUID(), "frame.project", "project_lock_exclusive");
        }
    }

    private boolean clientAlreadyHasProjectLock() {
        return this.lockAllocationTable.clientAlreadyHasLock(this.projectLockFetcher.generateProjectLock("project_lock_exclusive"));
    }

    private static boolean isCommitLockRequest(Collection<EOLock> locksToBeChecked, Collection<EOLock> locksToBeSet) {
        SplittedLockSet splittedLocksToBeSet = new SplittedLockSet(locksToBeSet);
        SplittedLockSet splittedLocksToBeChecked = new SplittedLockSet(locksToBeChecked);
        assert (splittedLocksToBeSet.getCommitLocks().isEmpty() || splittedLocksToBeSet.getOtherLocks().isEmpty() && splittedLocksToBeChecked.getOtherLocks().isEmpty());
        assert (splittedLocksToBeChecked.getCommitLocks().isEmpty() || !splittedLocksToBeSet.getCommitLocks().isEmpty());
        return splittedLocksToBeChecked.getOtherLocks().isEmpty() && splittedLocksToBeSet.getOtherLocks().isEmpty() && !splittedLocksToBeSet.getCommitLocks().isEmpty();
    }

    @Override
    public LockResult setLock(LockRequest lockRequest, boolean isExclusive) throws ServerNotAvailableException, UnknownServerException, LoginCanceledException, EXServerException {
        LockResult lockResult;
        Exception possibleServerException;
        assert (lockRequest != null);
        EOLock lock = lockRequest.createEOLock();
        EOList locksToBeSet = new EOList();
        locksToBeSet.add(lock);
        EOList locksToBeChecked = new EOList();
        if (isExclusive) {
            locksToBeChecked.add(lock);
        }
        if ((possibleServerException = (lockResult = this.atomicCheckAndSetLocks((Collection<EOLock>)locksToBeChecked, (Collection<EOLock>)locksToBeSet, false)).getPossibleServerException()) != null) {
            if (possibleServerException instanceof ServerNotAvailableException) {
                throw (ServerNotAvailableException)((Object)possibleServerException);
            }
            if (possibleServerException instanceof UnknownServerException) {
                throw (UnknownServerException)((Object)possibleServerException);
            }
            if (possibleServerException instanceof LoginCanceledException) {
                throw (LoginCanceledException)((Object)possibleServerException);
            }
            if (possibleServerException instanceof EXServerException) {
                throw (EXServerException)((Object)possibleServerException);
            }
            throw new EXServerException("frame.locks", "NotFound", "A Problem occured while requesting locks. The problem may be caused either by problems on client or server server side. See causing Exception for details: " + possibleServerException.getLocalizedMessage(), possibleServerException);
        }
        return lockResult;
    }

    @Override
    public Collection<EOLock> getConflictingLocks(Collection<LockRequest> lockRequests) throws Exception {
        if (this.clientAlreadyHasProjectLock()) {
            return Collections.emptyList();
        }
        EOList locks = new EOList();
        for (LockRequest request : lockRequests) {
            EOLock lock = request.createEOLock();
            if (this.lockAllocationTable.clientAlreadyHasLock(lock)) continue;
            locks.add(lock);
        }
        try {
            List<Collection<EOLock>> response = this.lockAllocator.atomicCheckAndSetLocks((Collection<EOLock>)locks, (Collection<EOLock>)new EOList(0), (Collection<EOLock>)new EOList(0));
            Collection<EOLock> conflictingLocks = response.get(0);
            return conflictingLocks;
        }
        catch (ServerNotAvailableException e) {
            logger.error("Could not get conflicting locks due to server exception (ServerNotAvailableException). [LockMgr]", (Throwable)e);
            throw e;
        }
        catch (LoginCanceledException e) {
            logger.error("Could not get conflicting locks due to server exception (LoginCanceledException). [LockMgr]", (Throwable)e);
            throw e;
        }
        catch (EXServerException e) {
            logger.error("Could not get conflicting locks due to server exception (EXServerException). [LockMgr]", (Throwable)e);
            throw e;
        }
        catch (UnknownServerException e) {
            logger.error("Could not get conflicting locks due to server exception (UnknownServerException). [LockMgr]", (Throwable)e);
            throw e;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void releaseLocks(Collection<EOLock> locksToBeReleased) {
        block16: {
            if (!LockMgr.$assertionsDisabled && locksToBeReleased == null) {
                throw new AssertionError();
            }
            try {
                realServerLockToRelease = this.lockAllocationTable.prepareReleaseOfLocks(locksToBeReleased);
                successfullyReleasedServerLocks = false;
                if (!realServerLockToRelease.isEmpty()) {
                    try {
                        this.lockAllocator.releaseLocks(realServerLockToRelease);
                        successfullyReleasedServerLocks = true;
                        LockMgr.logger.debug(22, "Locks were released. [LockMgr]");
                    }
                    catch (ServerNotAvailableException e) {
                        LockMgr.logger.error("Could not release lock due to server exception (ServerNotAvailableException). [LockMgr]", (Throwable)e);
                    }
                    catch (UnknownServerException e) {
                        LockMgr.logger.error("Could not release lock due to server exception (UnknownServerException). [LockMgr]", (Throwable)e);
                    }
                    catch (LoginCanceledException e) {
                        LockMgr.logger.error("Could not release lock due to server exception (LoginCanceledException). [LockMgr]", (Throwable)e);
                    }
                    catch (EXServerException e) {
                        LockMgr.logger.error("Could not release lock due to server exception (EXServerException). [LockMgr]", (Throwable)e);
                    }
                } else {
                    successfullyReleasedServerLocks = true;
                }
                if (successfullyReleasedServerLocks) {
                    this.lockAllocationTable.finishReleaseOfLocks(realServerLockToRelease);
                } else {
                    this.lockAllocationTable.finishReleaseOfLocks(null);
                }
            }
            catch (FileSetTransactionAbortedException e) {
                msgb = new StringBuilder("Problem occured during Release of Locks: ");
                first = true;
                ** for (lock : locksToBeReleased)
            }
lbl-1000:
            // 1 sources

            {
                if (first) {
                    first = false;
                } else {
                    msgb.append(", ");
                }
                msgb.append(lock.getUID());
                continue;
            }
lbl42:
            // 1 sources

            LockMgr.logger.error(msgb.toString(), (Throwable)e);
            break block16;
            catch (ClientLockStateOutOfSyncException e) {
                LockMgr.logger.debug("Problem occured during Release of Locks: ", (Throwable)e);
            }
        }
    }

    @Override
    public void releaseCommitLocks(Collection<EOLock> commitLocksToBeReleased) {
        ArrayList<EOLock> clientCommitLocks = new ArrayList<EOLock>(commitLocksToBeReleased.size());
        for (EOLock lock : commitLocksToBeReleased) {
            assert ("commit".equals(lock.getLockTypeID()));
            Collection<EOLock> clientLocksByLockData = this.lockAllocationTable.findClientLocksByLockData("commit", lock.getLockedItemType(), lock.getLockedItemUID(), this.projectAgent);
            assert (clientLocksByLockData.size() == 1);
            clientCommitLocks.addAll(clientLocksByLockData);
        }
        assert (clientCommitLocks.size() == commitLocksToBeReleased.size());
        this.releaseLocks(clientCommitLocks);
    }

    private static String generateErrorMessage(Collection<EOLock> conflictingLocks) {
        HashSet<String> conflictingUsers = new HashSet<String>();
        for (EOLock conflictingLock : conflictingLocks) {
            String clientAndUser = String.valueOf(Messages.getString("LockMgr.User")) + conflictingLock.getUserName() + "  " + Messages.getString("LockMgr.Client") + conflictingLock.getClientName();
            conflictingUsers.add(clientAndUser);
        }
        String errorMsg = String.valueOf(Messages.getString("LockMgr.itemAlreadyLockedByUsers")) + "\n";
        for (String conflictingUser : conflictingUsers) {
            errorMsg = String.valueOf(errorMsg) + "\n" + conflictingUser;
        }
        return errorMsg;
    }

    @Override
    public Collection<EOLock> findClientLocksByILockable(ILockable lockable, String lockTypeID) {
        return this.lockAllocationTable.findClientLocksByLockData(lockTypeID, lockable.getTypeID(), lockable.getUID(), this.projectAgent);
    }

    @Override
    public Collection<EOLock> findClientLocksByLockData(String lockTypeID, String lockedItemTypeID, String lockedItemUID) {
        return this.lockAllocationTable.findClientLocksByLockData(lockTypeID, lockedItemTypeID, lockedItemUID, this.projectAgent);
    }

    @Override
    public String getLocalizedLockTypeDescription(String lockTypeID) {
        return LockTypeDescriptionProvider.getLocalizedLockTypeDescription(lockTypeID);
    }

    @Override
    public LockResult setExclusiveProjectLock() {
        return this.projectLockFetcher.setExclusiveProjectLock();
    }

    @Override
    public LockResult setBlockingProjectLock() {
        Collection<EOLock> projectLocksClientAlreadyOwns = this.lockAllocationTable.getLocksClientAlreadyOwnsMatchingThisLock(this.projectLockFetcher.generateProjectLock("project_lock_exclusive"));
        return this.projectLockFetcher.setBlockingProjectLock(projectLocksClientAlreadyOwns);
    }

    @Override
    public void releaseBlockingProjectLock() throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        this.projectLockFetcher.releaseBlockingProjectLock();
    }

    @Override
    @Deprecated
    public boolean doWithBlockOfflineModeProjectLock(Runnable todo) {
        return this.projectLockFetcher.doWithBlockOfflineModeProjectLock(todo);
    }

    public void destruct() {
        try {
            this.lockAllocationTable.destruct();
        }
        catch (Exception e) {
            logger.error("Problem during LockMgr shutdown for Project " + this.projectAgent.getProjectUID() + ": " + e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

