/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.locking;

import com.arcway.cockpit.cockpitlib.client.files.FileContentProviderForXMLFilesWithFixContent;
import com.arcway.cockpit.cockpitlib.client.files.IFileContentProviderForXMLFiles;
import com.arcway.cockpit.cockpitlib.client.files.XMLFileAccessor;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.locking.IForeignLockChecker;
import com.arcway.cockpit.frame.client.project.core.locking.ILockAllocator;
import com.arcway.cockpit.frame.client.project.core.locking.lockhasher.LockHasherByLockData;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineModeManager;
import com.arcway.cockpit.frame.shared.message.EOLock;
import com.arcway.cockpit.frame.shared.message.MessageDataFactory;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ForeignLockChecker
implements IForeignLockChecker,
ILockAllocator {
    private static final ILogger logger = Logger.getLogger(ForeignLockChecker.class);
    private static final String LOCK_CHECKER_DATA_FILE_NAME = "foreignlocks.data";
    private IMapRW_<EOLock, IListRW_<EOLock>> foreignLocks = null;
    private final XMLFileAccessor<EOList<EOLock>> foreignLocksFileAccessor;
    private final ILockAllocator lockRequestSupressor;

    private static XMLFileAccessor<EOList<EOLock>> createForeignLocksFileAccessor(File projectRootDirectory) {
        File foreignLockFile = OfflineModeManager.getOfflineDataRelatedFile(LOCK_CHECKER_DATA_FILE_NAME, projectRootDirectory);
        XMLFileAccessor xmlFileAccessor = new XMLFileAccessor(foreignLockFile, (IEncodableObjectFactory)MessageDataFactory.getInstance());
        return xmlFileAccessor;
    }

    public static void cleanUp(File projectRootDirectory) {
        XMLFileAccessor<EOList<EOLock>> xmlFileAccessor = ForeignLockChecker.createForeignLocksFileAccessor(projectRootDirectory);
        xmlFileAccessor.write((IFileContentProviderForXMLFiles)new FileContentProviderForXMLFilesWithFixContent(null));
    }

    public ForeignLockChecker(IFrameProjectAgent projectAgent, ILockAllocator lockRequestSupressor) {
        this.foreignLocksFileAccessor = ForeignLockChecker.createForeignLocksFileAccessor(projectAgent.getProjectRoot());
        try {
            this.readForeignLocks();
        }
        catch (Exception e) {
            logger.error("Unable to read foreign lock data from file.", (Throwable)e);
        }
        this.lockRequestSupressor = lockRequestSupressor;
    }

    @Override
    public List<Collection<EOLock>> atomicCheckAndSetLocks(Collection<EOLock> locksToBeChecked, Collection<EOLock> clientLocksNeededByServer, Collection<EOLock> locksToBeSet) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        ArrayList<Collection<EOLock>> response = new ArrayList<EOList>();
        Collection<EOLock> conflictingLocks = this.checkForConflictingLocks(locksToBeChecked);
        if (conflictingLocks.isEmpty()) {
            response = this.lockRequestSupressor.atomicCheckAndSetLocks(locksToBeChecked, clientLocksNeededByServer, locksToBeSet);
        } else {
            response.add((Collection<EOLock>)new EOList(conflictingLocks));
            response.add((Collection<EOLock>)new EOList());
        }
        return response;
    }

    private Collection<EOLock> checkForConflictingLocks(Collection<EOLock> locksToBeChecked) {
        ArrayList<EOLock> conflictingLocks = new ArrayList<EOLock>();
        if (this.foreignLocks != null) {
            for (EOLock lockToBeChecked : locksToBeChecked) {
                IListRW_ locksOfType = (IListRW_)this.foreignLocks.getByKey((Object)lockToBeChecked);
                if (locksOfType == null) continue;
                conflictingLocks.addAll(locksOfType.asJavaList());
            }
        }
        return conflictingLocks;
    }

    @Override
    public void releaseLocks(Collection<EOLock> locksToBeReleased) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        this.lockRequestSupressor.releaseLocks(locksToBeReleased);
    }

    @Override
    public List<EOLock> getForeignLocks(Collection<EOLock> clientLocksNeededByServer, boolean considerCommitVersion) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        ArrayList<EOLock> currentForeignLocks;
        if (this.foreignLocks == null) {
            currentForeignLocks = this.lockRequestSupressor.getForeignLocks(clientLocksNeededByServer, considerCommitVersion);
        } else {
            currentForeignLocks = new ArrayList();
            for (EOLock lock : this.foreignLocks.keySet()) {
                currentForeignLocks.addAll(((IListRW_)this.foreignLocks.getByKey((Object)lock)).asJavaList());
            }
        }
        return currentForeignLocks;
    }

    @Override
    public void populateForeignLocks(Collection<EOLock> clientLocksNeededByServer) throws ServerNotAvailableException, LoginCanceledException, EXServerException, UnknownServerException {
        List<EOLock> foreignLocksFromServer = this.lockRequestSupressor.getForeignLocks(clientLocksNeededByServer, false);
        this.fillForeignLocks(foreignLocksFromServer);
        this.writeForeignLocks();
    }

    private void readForeignLocks() throws Exception {
        EOList initialLocks = (EOList)this.foreignLocksFileAccessor.read();
        this.fillForeignLocks((List<EOLock>)initialLocks);
    }

    private void fillForeignLocks(List<EOLock> locks) {
        this.foreignLocks = new HashMap_(LockHasherByLockData.INSTANCE);
        if (locks == null) {
            this.foreignLocks = null;
        } else {
            for (EOLock initialLock : locks) {
                IListRW_ locksOfSameType = (IListRW_)this.foreignLocks.getByKey((Object)initialLock);
                if (locksOfSameType == null) {
                    locksOfSameType = new ArrayList_();
                    this.foreignLocks.put((Object)initialLock, (Object)locksOfSameType);
                }
                locksOfSameType.add((Object)initialLock);
            }
        }
    }

    private void writeForeignLocks() {
        this.foreignLocksFileAccessor.write((IFileContentProviderForXMLFiles)new IFileContentProviderForXMLFiles<EOList<EOLock>>(){

            public EOList<EOLock> getFileContent() {
                EOList allLocks;
                if (ForeignLockChecker.this.foreignLocks != null) {
                    allLocks = new EOList();
                    for (IList_ locks : ForeignLockChecker.this.foreignLocks.values()) {
                        allLocks.addAll((Collection)locks.asJavaList());
                    }
                } else {
                    allLocks = null;
                }
                return allLocks;
            }
        });
    }

    @Override
    public void cleanUp() {
        this.foreignLocks = null;
        this.writeForeignLocks();
    }
}

