/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.client.base.datamanager.AtomicModificationDataAccessor;
import com.arcway.cockpit.frame.client.project.core.links.DifferentialLinkModLogAccessManager;
import com.arcway.cockpit.frame.client.project.core.links.LinkTypeRegistry;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.EOLinkModificationContainer;
import com.arcway.cockpit.frame.shared.message.EOLinkedItemDeletion;
import com.arcway.lib.java.collectionmaps.SetMap;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ModificationLog {
    private final SetMap<String, EOLink> mapLinkType_linkAdditions;
    private final SetMap<String, EOLink> mapLinkType_linkDeletions;
    private final DifferentialLinkModLogAccessManager.ManagedSet<EOLink> linkAdditions;
    private final DifferentialLinkModLogAccessManager.ManagedSet<EOLink> linkDeletions;
    private final Map<String, Collection<EOLink>> dataUIDsWithModifiedLinks;
    private final DifferentialLinkModLogAccessManager.ManagedSet<EOLinkedItemDeletion> deletedLinkedItems;
    protected final String projectUID;
    private final LinkTypeRegistry registry;
    private final DifferentialLinkModLogAccessManager linkModLogAccessManager;

    public ModificationLog(String projectUID, LinkTypeRegistry registry, AtomicModificationDataAccessor atomicModificationDataAccessor) {
        assert (projectUID != null) : "projectUID must not be null";
        this.linkModLogAccessManager = new DifferentialLinkModLogAccessManager(atomicModificationDataAccessor);
        this.mapLinkType_linkAdditions = new SetMap();
        this.mapLinkType_linkDeletions = new SetMap();
        this.linkAdditions = this.linkModLogAccessManager.linkAdditions;
        this.dataUIDsWithModifiedLinks = new HashMap<String, Collection<EOLink>>();
        this.linkDeletions = this.linkModLogAccessManager.linkDeletions;
        this.projectUID = projectUID;
        this.deletedLinkedItems = this.linkModLogAccessManager.deletedLinkedItems;
        this.registry = registry;
    }

    public void addLink(EOLink link) {
        assert (link != null) : "link must not be null";
        assert (this.checkLinkType(link.getLinkTypeID())) : "Link type not registered";
        boolean wasContainedInLinkDeletions = this.linkDeletions.remove(link);
        if (wasContainedInLinkDeletions) {
            this.removeFromModifiedDataMap(link.getLinkableObjectUID(), link);
            this.removeFromModifiedDataMap(link.getModuleDataUID(), link);
            this.mapLinkType_linkDeletions.remove((Object)link.getLinkTypeID(), (Object)link);
        } else {
            this.linkAdditions.add(link);
            this.addToModifiedDataMap(link.getLinkableObjectUID(), link);
            this.addToModifiedDataMap(link.getModuleDataUID(), link);
            this.mapLinkType_linkAdditions.add((Object)link.getLinkTypeID(), (Object)link);
        }
    }

    private void addToModifiedDataMap(String dataUID, EOLink link) {
        Collection<EOLink> links = this.dataUIDsWithModifiedLinks.get(dataUID);
        if (links == null) {
            links = new ArrayList<EOLink>();
            this.dataUIDsWithModifiedLinks.put(dataUID, links);
        }
        links.add(link);
    }

    public boolean hasModifiedLink(String dataUID) {
        return this.dataUIDsWithModifiedLinks.containsKey(dataUID);
    }

    public boolean hasModifiedLinks(String linkTypeID) {
        return !this.mapLinkType_linkAdditions.get((Object)linkTypeID).isEmpty() || !this.mapLinkType_linkDeletions.get((Object)linkTypeID).isEmpty();
    }

    public void deleteLink(EOLink link) {
        assert (link != null) : "link must not be null";
        boolean wasContainedInLinkAdditions = this.linkAdditions.remove(link);
        if (wasContainedInLinkAdditions) {
            this.removeFromModifiedDataMap(link.getLinkableObjectUID(), link);
            this.removeFromModifiedDataMap(link.getModuleDataUID(), link);
            this.mapLinkType_linkAdditions.remove((Object)link.getLinkTypeID(), (Object)link);
        } else {
            this.linkDeletions.add(link);
            this.addToModifiedDataMap(link.getLinkableObjectUID(), link);
            this.addToModifiedDataMap(link.getModuleDataUID(), link);
            this.mapLinkType_linkDeletions.add((Object)link.getLinkTypeID(), (Object)link);
        }
    }

    private void removeFromModifiedDataMap(String dataUID, EOLink link) {
        Collection<EOLink> list = this.dataUIDsWithModifiedLinks.get(dataUID);
        if (list != null) {
            list.remove(link);
            if (list.isEmpty()) {
                this.dataUIDsWithModifiedLinks.remove(dataUID);
            }
        }
    }

    public void removeAddition(EOLink link) {
        this.linkAdditions.remove(link);
        this.removeFromModifiedDataMap(link.getLinkableObjectUID(), link);
        this.removeFromModifiedDataMap(link.getModuleDataUID(), link);
        this.mapLinkType_linkAdditions.remove((Object)link.getLinkTypeID(), (Object)link);
    }

    public void removeDeletion(EOLink link) {
        this.linkDeletions.remove(link);
        this.removeFromModifiedDataMap(link.getLinkableObjectUID(), link);
        this.removeFromModifiedDataMap(link.getModuleDataUID(), link);
        this.mapLinkType_linkDeletions.remove((Object)link.getLinkTypeID(), (Object)link);
    }

    public void setModificationsFromContainer(EOLinkModificationContainer container) {
        assert (container != null) : "Container must not be null.";
        this.clear();
        this.addModificationsFromContainer(container);
    }

    public EOLinkModificationContainer addModificationsFromContainer(EOLinkModificationContainer container) {
        assert (container != null) : "Container must not be null.";
        for (EOLink link : container.getInsertLinks()) {
            this.addLink(link);
        }
        for (EOLink link : container.getDeleteLinks()) {
            this.deleteLink(link);
        }
        for (EOLinkedItemDeletion deletion : container.getDeletedLinkedItems()) {
            this.deletedLinkedItems.add(deletion);
        }
        EOLinkModificationContainer newModifications = new EOLinkModificationContainer(this.projectUID);
        newModifications.setInsertLinks((Collection)new EOList(this.getLinkAdditions()));
        newModifications.setDeleteLinks((Collection)new EOList(this.getLinkDeletions()));
        newModifications.setDeletedLinkedItems(this.deletedLinkedItems.getReadonlyView());
        return newModifications;
    }

    public boolean isEmpty() {
        return this.linkAdditions.isEmpty() && this.linkDeletions.isEmpty() && this.deletedLinkedItems.isEmpty();
    }

    public void clear() {
        this.linkAdditions.clear();
        this.dataUIDsWithModifiedLinks.clear();
        this.linkDeletions.clear();
        this.deletedLinkedItems.clear();
        this.mapLinkType_linkAdditions.clear();
        this.mapLinkType_linkDeletions.clear();
    }

    public Set<EOLink> getLinkAdditions() {
        return this.linkAdditions.getReadonlyView();
    }

    public Set<EOLink> getLinkDeletions() {
        return this.linkDeletions.getReadonlyView();
    }

    public EOLinkModificationContainer getModificationContainer() {
        EOLinkModificationContainer container = new EOLinkModificationContainer(this.projectUID);
        container.setInsertLinks(this.getLinkAdditions());
        container.setDeleteLinks(this.getLinkDeletions());
        container.setDeletedLinkedItems(this.deletedLinkedItems.getReadonlyView());
        return container;
    }

    public boolean isLinkedItemDeleted(String linkableObjectUID) {
        EOLinkedItemDeletion deletion = new EOLinkedItemDeletion(this.projectUID, linkableObjectUID, null, new ArrayList(), new ArrayList());
        return this.deletedLinkedItems.contains(deletion);
    }

    public void linkedItemDeleted(String linkedItemUID, String linkedItemTypeID, Collection<String> LOLinkTypeIDs, Collection<String> MDLinkTypeIDs) {
        assert (linkedItemUID != null) : "linkableObjectUID must not be null";
        assert (LOLinkTypeIDs != null) : "LOLinkTypeIDs must not be null";
        assert (MDLinkTypeIDs != null) : "MDLinkTypeIDs must not be null";
        EOLinkedItemDeletion deletion = new EOLinkedItemDeletion(this.projectUID, linkedItemUID, linkedItemTypeID, LOLinkTypeIDs, MDLinkTypeIDs);
        this.deletedLinkedItems.add(deletion);
    }

    public EOLinkModificationContainer getLinkModificationContainerForLinkType(String linkTypeID) {
        assert (linkTypeID != null) : "Link type must not be null.";
        assert (this.checkLinkType(linkTypeID)) : "Link type is not registered.";
        EOLinkModificationContainer modifications = new EOLinkModificationContainer(this.projectUID);
        modifications.setInsertLinks((Collection)new EOList((Collection)this.mapLinkType_linkAdditions.get((Object)linkTypeID)));
        modifications.setDeleteLinks((Collection)new EOList((Collection)this.mapLinkType_linkDeletions.get((Object)linkTypeID)));
        return modifications;
    }

    public boolean isEmpty(String linkTypeID) {
        return this.mapLinkType_linkAdditions.isEmpty((Object)linkTypeID) && this.mapLinkType_linkDeletions.isEmpty((Object)linkTypeID);
    }

    private boolean checkLinkType(String linkTypeID) {
        return this.registry.containsUID(linkTypeID);
    }

    public EOLinkModificationContainer readSavedModifications(IEncodableObjectFactory messageDataFactory) throws AtomicModificationDataAccessor.ModificationBootstrapFailure {
        return this.linkModLogAccessManager.readSavedModifications(this.projectUID, messageDataFactory);
    }

    public void deleteSavedModifications() {
        this.linkModLogAccessManager.deleteSavedModifications();
    }
}

