/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.project.core.links;

import com.arcway.cockpit.frame.client.project.core.links.linktypes.ILinkType;
import com.arcway.lib.java.collectionmaps.SetMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class LinkTypeRegistry {
    Map<String, ILinkType> mapLinkTypeUID_linkType = new HashMap<String, ILinkType>();
    SetMap<String, ILinkType> mapModuleID_linkType = new SetMap();
    SetMap<String, ILinkType> mapLODataTypeID_linkType = new SetMap();
    SetMap<String, ILinkType> mapMDDataTypeID_linkType = new SetMap();
    SetMap<String, String> map_realTypeID_virtualTypeID = new SetMap();

    public ILinkType getCorrespondingLinkType(ILinkType linkType) {
        assert (linkType != null) : "linkType must not be null";
        ILinkType correspondingLinkType = this.mapLinkTypeUID_linkType.get(linkType.getCorrespondingLinkTypeID());
        return correspondingLinkType;
    }

    public void addLinkType(ILinkType type) {
        assert (type != null) : "type must not be null";
        this.mapLinkTypeUID_linkType.put(type.getUID(), type);
        this.mapModuleID_linkType.add((Object)type.getModuleID(), (Object)type);
        this.mapLODataTypeID_linkType.add((Object)type.getLinkableObjectTypeID(), (Object)type);
        this.mapMDDataTypeID_linkType.add((Object)type.getModuleDataTypeID(), (Object)type);
    }

    public void addTypeTranslationMapping(String virtualTypeID, Collection<String> realTypeIDs) {
        for (String realTypeID : realTypeIDs) {
            this.map_realTypeID_virtualTypeID.add((Object)realTypeID, (Object)virtualTypeID);
        }
    }

    public ILinkType getLinkTypeByUID(String UID) {
        assert (UID != null) : "UID must not be null";
        return this.mapLinkTypeUID_linkType.get(UID);
    }

    public Set<ILinkType> getLinkTypesByModuleID(String moduleID) {
        assert (moduleID != null) : "moduleID must not be null";
        return this.mapModuleID_linkType.get((Object)moduleID);
    }

    public Set<ILinkType> getLinkTypesByModuleDataTypeID(String moduleDataTypeID) {
        assert (moduleDataTypeID != null) : "moduleDataTypeID must not be null";
        HashSet<ILinkType> linkTypes = new HashSet<ILinkType>();
        linkTypes.addAll(this.mapMDDataTypeID_linkType.get((Object)moduleDataTypeID));
        for (String virtualTypeID : this.map_realTypeID_virtualTypeID.get((Object)moduleDataTypeID)) {
            linkTypes.addAll(this.mapMDDataTypeID_linkType.get((Object)virtualTypeID));
        }
        return linkTypes;
    }

    public Set<ILinkType> getLinkTypesByLinkableObjectTypeID(String linkableObjectTypeID) {
        assert (linkableObjectTypeID != null) : "linkableObjectTypeID must not be null";
        HashSet<ILinkType> linkTypes = new HashSet<ILinkType>();
        linkTypes.addAll(this.mapLODataTypeID_linkType.get((Object)linkableObjectTypeID));
        for (String virtualTypeID : this.map_realTypeID_virtualTypeID.get((Object)linkableObjectTypeID)) {
            linkTypes.addAll(this.mapLODataTypeID_linkType.get((Object)virtualTypeID));
        }
        return linkTypes;
    }

    public Set<ILinkType> getLinkTypes(String linkableObjectTypeID, String moduleDataTypeID) {
        HashSet<ILinkType> linkTypes = new HashSet<ILinkType>(this.getLinkTypesByLinkableObjectTypeID(linkableObjectTypeID));
        linkTypes.retainAll(this.getLinkTypesByModuleDataTypeID(moduleDataTypeID));
        return linkTypes;
    }

    public boolean containsUID(String linkTypeID) {
        assert (linkTypeID != null) : "linkTypeID must not be null";
        return this.mapLinkTypeUID_linkType.containsKey(linkTypeID);
    }

    public boolean containsModuleID(String moduleID) {
        assert (moduleID != null) : "moduleID must not be null";
        return this.mapModuleID_linkType.containsKey((Object)moduleID);
    }

    public Set<ILinkType> getLinkTypes() {
        return new HashSet<ILinkType>(this.mapLinkTypeUID_linkType.values());
    }

    public void removeLinkType(ILinkType linkType) {
        this.mapLinkTypeUID_linkType.remove(linkType.getUID());
        this.mapLODataTypeID_linkType.remove((Object)linkType.getLinkableObjectTypeID(), (Object)linkType);
        this.mapMDDataTypeID_linkType.remove((Object)linkType.getModuleDataTypeID(), (Object)linkType);
        this.mapModuleID_linkType.remove((Object)linkType.getModuleID(), (Object)linkType);
    }
}

